/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import pcgen.core.SystemCollections;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.LstLineFileLoader;

public class TraitLoader
extends LstLineFileLoader {
    private int traitType = -1;

    public void loadLstFile(URI uRI) throws PersistenceLayerException {
        this.traitType = -1;
        super.loadLstFile(uRI);
    }

    public void parseLine(String string, URI uRI) {
        if (string.charAt(0) != '[') {
            switch (this.traitType) {
                case 0: {
                    SystemCollections.addToTraitList(string, this.gameMode);
                    break;
                }
                case 1: {
                    SystemCollections.addToSpeechList(string, this.gameMode);
                    break;
                }
                case 2: {
                    SystemCollections.addToPhraseList(string, this.gameMode);
                    break;
                }
                case 3: {
                    SystemCollections.addToPhobiaList(string, this.gameMode);
                    break;
                }
                case 4: {
                    SystemCollections.addToInterestsList(string, this.gameMode);
                    break;
                }
                case 5: {
                    SystemCollections.addToHairStyleList(string, this.gameMode);
                    break;
                }
            }
        } else {
            this.traitType = string.startsWith("[TRAIT]") ? 0 : (string.startsWith("[SPEECH]") ? 1 : (string.startsWith("[PHRASE]") ? 2 : (string.startsWith("[PHOBIA]") ? 3 : (string.startsWith("[INTERESTS]") ? 4 : (string.startsWith("[HAIRSTYLE]") ? 5 : -1)))));
        }
    }
}

