/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import java.util.List;
import java.util.Map;
import pcgen.core.PCStat;
import pcgen.core.SettingsHandler;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.StatsAndChecksLstToken;
import pcgen.persistence.lst.TokenStore;
import pcgen.util.Logging;

public class StatsAndChecksLoader
extends LstLineFileLoader {
    public void loadLstFile(URI uRI) throws PersistenceLayerException {
        SettingsHandler.getGame().setAttribLong(null);
        SettingsHandler.getGame().setAttribShort(null);
        SettingsHandler.getGame().clearCheckList();
        SettingsHandler.getGame().clearAlignmentList();
        SettingsHandler.getGame().clearStatList();
        super.loadLstFile(uRI);
        List<PCStat> list = SettingsHandler.getGame().getUnmodifiableStatList();
        int n = list.size();
        SettingsHandler.getGame().setAttribLong(new String[n]);
        SettingsHandler.getGame().setAttribShort(new String[n]);
        for (int i = 0; i < n; ++i) {
            PCStat pCStat = list.get(i);
            SettingsHandler.getGame().setAttribLong(i, pCStat.getDisplayName());
            SettingsHandler.getGame().setAttribShort(i, pCStat.getAbb());
        }
    }

    public void parseLine(String string, URI uRI) {
        int n = string.indexOf(58);
        if (n < 0) {
            return;
        }
        String string2 = string.substring(0, n);
        Map<String, LstToken> map = TokenStore.inst().getTokenMap(StatsAndChecksLstToken.class);
        StatsAndChecksLstToken statsAndChecksLstToken = (StatsAndChecksLstToken)map.get(string2);
        if (statsAndChecksLstToken != null) {
            LstUtils.deprecationCheck(statsAndChecksLstToken, string2, uRI, string);
            if (!statsAndChecksLstToken.parse(string, uRI)) {
                Logging.errorPrint("Error parsing StatsAndChecks object: " + string + '/' + uRI.toString());
            }
        } else {
            Logging.errorPrint("Illegal StatsAndChecks object: " + string + '/' + uRI.toString());
        }
    }
}

