/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.SubClass;
import pcgen.core.SubstitutionClass;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.LstObjectFileLoader;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.PCClassLstToken;
import pcgen.persistence.lst.PObjectLoader;
import pcgen.persistence.lst.SubClassLoader;
import pcgen.persistence.lst.SubstitutionClassLoader;
import pcgen.persistence.lst.TokenStore;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PCClassLoader
extends LstObjectFileLoader<PCClass> {
    @Override
    public PCClass parseLine(PCClass pCClass, String string, CampaignSourceEntry campaignSourceEntry) throws PersistenceLayerException {
        PCClass pCClass2 = pCClass;
        if (pCClass2 == null) {
            pCClass2 = new PCClass();
        }
        if (string.startsWith("SUBCLASS:") || string.startsWith("SUBCLASSLEVEL:")) {
            SubClass subClass = null;
            if (string.startsWith("SUBCLASS:")) {
                String string2;
                if (string.indexOf("\t") == -1) {
                    Logging.errorPrint("Expected SUBCLASS to have additional Tags in " + campaignSourceEntry.getURI() + " (e.g. COST is a required Tag in a SUBCLASS)");
                }
                if ((subClass = pCClass2.getSubClassKeyed(string2 = string.substring(9, string.indexOf("\t")))) == null) {
                    subClass = new SubClass();
                    subClass.setSourceCampaign(campaignSourceEntry.getCampaign());
                    subClass.setSourceURI(campaignSourceEntry.getURI());
                    pCClass2.addSubClass(subClass);
                }
            } else if (pCClass2.getSubClassList() != null && !pCClass2.getSubClassList().isEmpty()) {
                subClass = pCClass2.getSubClassList().get(pCClass2.getSubClassList().size() - 1);
                subClass.addToLevelArray(string.substring(14));
                return pCClass2;
            }
            if (subClass != null) {
                SubClassLoader.parseLine(subClass, string, campaignSourceEntry);
            }
            return pCClass2;
        }
        if (string.startsWith("SUBSTITUTIONCLASS:") || string.startsWith("SUBSTITUTIONLEVEL:")) {
            SubstitutionClass substitutionClass = null;
            if (string.startsWith("SUBSTITUTIONCLASS:")) {
                substitutionClass = string.indexOf("\t") > 0 ? pCClass2.getSubstitutionClassKeyed(string.substring(18, string.indexOf("\t"))) : pCClass2.getSubstitutionClassKeyed(string.substring(18));
                if (substitutionClass == null) {
                    substitutionClass = new SubstitutionClass();
                    substitutionClass.setSourceCampaign(campaignSourceEntry.getCampaign());
                    substitutionClass.setSourceURI(campaignSourceEntry.getURI());
                    pCClass2.addSubstitutionClass(substitutionClass);
                }
            } else if (pCClass2.getSubstitutionClassList() != null && !pCClass2.getSubstitutionClassList().isEmpty()) {
                substitutionClass = (SubstitutionClass)pCClass2.getSubstitutionClassList().get(pCClass2.getSubstitutionClassList().size() - 1);
                substitutionClass.addToLevelArray(string.substring(18));
                return pCClass2;
            }
            if (substitutionClass != null) {
                SubstitutionClassLoader.parseLine(substitutionClass, string, campaignSourceEntry);
            }
            return pCClass2;
        }
        return this.parseClassLine(string, campaignSourceEntry, pCClass2, false);
    }

    private PCClass parseClassLine(String string, CampaignSourceEntry campaignSourceEntry, PCClass pCClass, boolean bl) throws PersistenceLayerException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        int n = 0;
        boolean bl2 = true;
        String string2 = null;
        Map<String, LstToken> map = TokenStore.inst().getTokenMap(PCClassLstToken.class);
        while (stringTokenizer.hasMoreTokens()) {
            String string3;
            String string4 = stringTokenizer.nextToken().trim();
            int n2 = string4.indexOf(58);
            String string5 = "";
            try {
                string5 = string4.substring(0, n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            PCClassLstToken pCClassLstToken = (PCClassLstToken)map.get(string5);
            if (string4.startsWith("CLASS:")) {
                bl2 = false;
                string3 = string4.substring(6);
                if (!string3.equals(pCClass.getKeyName()) && string3.indexOf(".MOD") < 0) {
                    this.completeObject(campaignSourceEntry, pCClass);
                    pCClass = new PCClass();
                    pCClass.setName(string3);
                    pCClass.setSourceURI(campaignSourceEntry.getURI());
                    pCClass.setSourceCampaign(campaignSourceEntry.getCampaign());
                } else if (string3.endsWith(".MOD")) {
                    pCClass = Globals.getClassKeyed(string3.substring(0, string3.length() - 4));
                }
            } else {
                if (!(pCClass instanceof SubClass) && !(pCClass instanceof SubstitutionClass) && bl2) {
                    try {
                        n = Integer.parseInt(string4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        Logging.errorPrint("Expected a level value, but got '" + string4 + "' instead in " + campaignSourceEntry.getURI(), numberFormatException);
                    }
                    bl2 = false;
                    continue;
                }
                if (string4.startsWith("CHECK")) continue;
                if (string4.equals("HASSUBCLASS")) {
                    pCClass.setHasSubClass(true);
                } else if (string4.equals("HASSUBSTITUTIONLEVEL")) {
                    pCClass.setHasSubstitutionClass(true);
                } else if (string4.startsWith("MULTIPREREQS")) {
                    Logging.errorPrint("In: " + pCClass.getDisplayName() + ':' + campaignSourceEntry.getURI() + ':' + string4 + ", The MULTIPREREQS tag has been deprecated.  " + "Use PREMULT with !PRECLASS:1,Any instead. " + "(e.g. PREMULT:1,[PRECLASS:1,Noble=1],[!PRECLASS:1,Any] )");
                    pCClass.setMultiPreReqs(true);
                } else if (string4.startsWith("REPEATLEVEL:")) {
                    if (!bl) {
                        string2 = string4.substring(12);
                    }
                } else if (pCClassLstToken != null) {
                    string3 = string4.substring(n2 + 1).trim();
                    LstUtils.deprecationCheck(pCClassLstToken, pCClass, string3);
                    if (!pCClassLstToken.parse(pCClass, string3, n)) {
                        Logging.errorPrint("Error parsing ability " + pCClass.getDisplayName() + ':' + campaignSourceEntry.getURI() + ':' + string4 + "\"");
                    }
                } else {
                    if (PObjectLoader.parseTagLevel(pCClass, string4, n)) continue;
                    if (!(pCClass instanceof SubClass) && !(pCClass instanceof SubstitutionClass)) {
                        Logging.errorPrint("Illegal class info tag '" + string4 + "' in " + campaignSourceEntry.getURI());
                    }
                }
            }
            bl2 = false;
        }
        if (string2 != null && n > 0) {
            this.parseRepeatClassLevel(string, campaignSourceEntry, pCClass, n, string2);
        }
        return pCClass;
    }

    private void parseRepeatClassLevel(String string, CampaignSourceEntry campaignSourceEntry, PCClass pCClass, int n, String string2) throws PersistenceLayerException {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
        int n2 = stringTokenizer.countTokens();
        int n3 = 1000;
        int n4 = 0;
        int n5 = 100;
        if (pCClass.hasMaxLevel()) {
            n5 = pCClass.getMaxLevel();
        }
        if (n2 > 0) {
            try {
                n3 = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                Logging.errorPrint("Non-Numeric Level Increment info '" + string2 + "' in " + campaignSourceEntry.getURI(), numberFormatException);
            }
        }
        if (n2 > 1) {
            try {
                n4 = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                Logging.errorPrint("Non-Numeric Consecutive Level info '" + string2 + "' in " + campaignSourceEntry.getURI(), numberFormatException);
            }
        }
        if (n2 > 2) {
            try {
                n5 = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                Logging.errorPrint("Non-Numeric Max Level info '" + string2 + "' in " + campaignSourceEntry.getURI(), numberFormatException);
            }
        }
        int n6 = string.indexOf("\t");
        int n7 = n4 - 1;
        for (int i = n + n3; i <= n5; i += n3) {
            if (n4 == 0 || n7 != 0) {
                this.parseClassLine(Integer.toString(i) + string.substring(n6), campaignSourceEntry, pCClass, true);
            }
            if (n4 == 0) continue;
            if (n7 == 0) {
                n7 = n4;
                continue;
            }
            --n7;
        }
    }

    @Override
    protected PCClass getObjectKeyed(String string) {
        return Globals.getClassKeyed(string.startsWith("CLASS:") ? string.substring(6) : string);
    }

    @Override
    protected void finishObject(PObject pObject) {
        List<Prerequisite> list = pObject.getPreReqList();
        if (list != null) {
            for (Prerequisite prerequisite : list) {
                if (!"VAR".equalsIgnoreCase(prerequisite.getKind())) continue;
                prerequisite.setSubKey("CLASS:" + pObject.getKeyName());
            }
        }
    }

    @Override
    protected void performForget(PCClass pCClass) {
        Globals.getClassList().remove(pCClass);
    }

    public static String fixParameter(int n, String string) {
        return new StringBuffer().append(n).append("|").append(string).toString();
    }

    @Override
    protected void addGlobalObject(PObject pObject) {
        Globals.getClassList().add((PCClass)pObject);
    }
}

