/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.core.Campaign;
import pcgen.core.Constants;
import pcgen.core.CustomData;
import pcgen.core.Deity;
import pcgen.core.Description;
import pcgen.core.Equipment;
import pcgen.core.EquipmentList;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.LevelInfo;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.SourceEntry;
import pcgen.core.SystemCollections;
import pcgen.core.spell.Spell;
import pcgen.core.utils.CoreUtility;
import pcgen.gui.pcGenGUI;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.SystemLoader;
import pcgen.persistence.lst.AbilityLoader;
import pcgen.persistence.lst.BioSetLoader;
import pcgen.persistence.lst.CampaignLoader;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.CompanionModLoader;
import pcgen.persistence.lst.DeityLoader;
import pcgen.persistence.lst.DomainLoader;
import pcgen.persistence.lst.EquipSlotLoader;
import pcgen.persistence.lst.EquipmentLoader;
import pcgen.persistence.lst.EquipmentModifierLoader;
import pcgen.persistence.lst.FeatLoader;
import pcgen.persistence.lst.GameModeLoader;
import pcgen.persistence.lst.KitLoader;
import pcgen.persistence.lst.LanguageLoader;
import pcgen.persistence.lst.LevelLoader;
import pcgen.persistence.lst.LoadInfoLoader;
import pcgen.persistence.lst.LocationLoader;
import pcgen.persistence.lst.LstFileLoader;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.persistence.lst.PCClassLoader;
import pcgen.persistence.lst.PCTemplateLoader;
import pcgen.persistence.lst.PObjectLoader;
import pcgen.persistence.lst.PaperInfoLoader;
import pcgen.persistence.lst.PointBuyLoader;
import pcgen.persistence.lst.RaceLoader;
import pcgen.persistence.lst.RuleCheckLoader;
import pcgen.persistence.lst.SizeAdjustmentLoader;
import pcgen.persistence.lst.SkillLoader;
import pcgen.persistence.lst.SourceLoader;
import pcgen.persistence.lst.SpellLoader;
import pcgen.persistence.lst.SponsorLoader;
import pcgen.persistence.lst.StatsAndChecksLoader;
import pcgen.persistence.lst.TraitLoader;
import pcgen.persistence.lst.UnitSetLoader;
import pcgen.persistence.lst.WeaponProfLoader;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;
import pcgen.util.UnreachableError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LstSystemLoader
extends Observable
implements SystemLoader,
Observer {
    private static final List<PObject> pList = new ArrayList<PObject>();
    private static final int[] loadOrder = new int[]{14, 15};
    private static final int MODE_EXCLUDE = -1;
    private static final int MODE_DEFAULT = 0;
    private static final int MODE_INCLUDE = 1;
    private static final FilenameFilter gameModeFileFilter = new FilenameFilter(){

        public boolean accept(File file, String string) {
            try {
                File file2 = new File(file, string);
                if (file2.isDirectory()) {
                    File file3 = new File(file2, "statsandchecks.lst");
                    if (file3.exists()) {
                        file3 = new File(file2, "miscinfo.lst");
                        return file3.exists();
                    }
                    return false;
                }
            }
            catch (SecurityException securityException) {
                Logging.errorPrint("GameModes.listGameFiles", securityException);
            }
            return false;
        }
    };
    private static int lineNum = 0;
    private BioSetLoader bioLoader = new BioSetLoader();
    private CampaignLoader campaignLoader = new CampaignLoader();
    private final CampaignSourceEntry globalCampaign;
    private DeityLoader deityLoader = new DeityLoader();
    private DomainLoader domainLoader = new DomainLoader();
    private AbilityLoader abilityLoader = new AbilityLoader();
    private FeatLoader featLoader = new FeatLoader();
    private final FilenameFilter pccFileFilter = new FilenameFilter(){

        public boolean accept(File file, String string) {
            try {
                Comparable<URI> comparable;
                if (".pcc".regionMatches(true, 0, string, string.length() - 4, 4) && Globals.getCampaignByURI((URI)(comparable = new File(file, string).toURI()), false) == null) {
                    LstSystemLoader.this.campaignLoader.loadLstFile((URI)comparable);
                }
                if (!".svn".equals(string) && !".lst".regionMatches(true, 0, string, string.length() - 4, 4) && ((File)(comparable = new File(file, string))).isDirectory()) {
                    LstSystemLoader.this.loadPCCFilesInDirectory(comparable);
                }
            }
            catch (PersistenceLayerException persistenceLayerException) {
                LstSystemLoader.this.logError("PersistanceLayer", persistenceLayerException);
            }
            return false;
        }
    };
    private LanguageLoader languageLoader = new LanguageLoader();
    private LoadInfoLoader loadInfoLoader = new LoadInfoLoader();
    private UnitSetLoader unitSetLoader = new UnitSetLoader();
    private EquipSlotLoader eqSlotLoader = new EquipSlotLoader();
    private final List<CampaignSourceEntry> bioSetFileList = new ArrayList<CampaignSourceEntry>();
    private final List<URI> chosenCampaignSourcefiles = new ArrayList<URI>();
    private final List<CampaignSourceEntry> classFileList = new ArrayList<CampaignSourceEntry>();
    private final List<CampaignSourceEntry> classSkillFileList = new ArrayList<CampaignSourceEntry>();
    private final List<CampaignSourceEntry> classSpellFileList = new ArrayList<CampaignSourceEntry>();
    private final List<CampaignSourceEntry> companionmodFileList = new ArrayList<CampaignSourceEntry>();
    private final List<CampaignSourceEntry> deityFileList = new ArrayList<CampaignSourceEntry>();
    private final List<CampaignSourceEntry> domainFileList = new ArrayList<CampaignSourceEntry>();
    private final List<CampaignSourceEntry> equipmentFileList = new ArrayList<CampaignSourceEntry>();
    private final List<CampaignSourceEntry> equipmodFileList = new ArrayList<CampaignSourceEntry>();
    private final List<CampaignSourceEntry> abilityFileList = new ArrayList<CampaignSourceEntry>();
    private final List<CampaignSourceEntry> featFileList = new ArrayList<CampaignSourceEntry>();
    private final List<CampaignSourceEntry> kitFileList = new ArrayList<CampaignSourceEntry>();
    private final List<CampaignSourceEntry> languageFileList = new ArrayList<CampaignSourceEntry>();
    private List<URI> licenseFiles = new ArrayList<URI>();
    private final List<CampaignSourceEntry> lstExcludeFiles = new ArrayList<CampaignSourceEntry>();
    private final List<CampaignSourceEntry> raceFileList = new ArrayList<CampaignSourceEntry>();
    private final List<String> reqSkillFileList = new ArrayList<String>();
    private final List<CampaignSourceEntry> skillFileList = new ArrayList<CampaignSourceEntry>();
    private final List<CampaignSourceEntry> spellFileList = new ArrayList<CampaignSourceEntry>();
    private final List<CampaignSourceEntry> templateFileList = new ArrayList<CampaignSourceEntry>();
    private final List<CampaignSourceEntry> weaponProfFileList = new ArrayList<CampaignSourceEntry>();
    private LocationLoader locationLoader = new LocationLoader();
    private final Set<URI> loadedFiles = new HashSet<URI>();
    private PCClassLoader classLoader = new PCClassLoader();
    private PCTemplateLoader templateLoader = new PCTemplateLoader();
    private EquipmentLoader equipmentLoader = new EquipmentLoader();
    private EquipmentModifierLoader eqModLoader = new EquipmentModifierLoader();
    private CompanionModLoader companionModLoader = new CompanionModLoader();
    private KitLoader kitLoader = new KitLoader();
    private PaperInfoLoader paperLoader = new PaperInfoLoader();
    private PointBuyLoader pointBuyLoader = new PointBuyLoader();
    private SponsorLoader sponsorLoader = new SponsorLoader();
    private RaceLoader raceLoader = new RaceLoader();
    private final Set<String> sourcesSet = new TreeSet<String>();
    private SizeAdjustmentLoader sizeLoader = new SizeAdjustmentLoader();
    private SkillLoader skillLoader = new SkillLoader();
    private SpellLoader spellLoader = new SpellLoader();
    private StatsAndChecksLoader statCheckLoader = new StatsAndChecksLoader();
    private String skillReq = "";
    private StringBuffer licensesToDisplayString = new StringBuffer();
    private StringBuffer matureCampaigns = new StringBuffer();
    private TraitLoader traitLoader = new TraitLoader();
    private WeaponProfLoader wProfLoader = new WeaponProfLoader();
    private boolean customItemsLoaded = false;
    private boolean showD20 = false;
    private boolean showLicensed = true;
    private boolean showMature = false;
    private boolean showOGL = false;

    public LstSystemLoader() {
        this.bioLoader.addObserver(this);
        this.campaignLoader.addObserver(this);
        this.companionModLoader.addObserver(this);
        this.deityLoader.addObserver(this);
        this.domainLoader.addObserver(this);
        this.equipmentLoader.addObserver(this);
        this.eqModLoader.addObserver(this);
        this.eqSlotLoader.addObserver(this);
        this.abilityLoader.addObserver(this);
        this.featLoader.addObserver(this);
        this.kitLoader.addObserver(this);
        this.languageLoader.addObserver(this);
        this.locationLoader.addObserver(this);
        this.classLoader.addObserver(this);
        this.paperLoader.addObserver(this);
        this.pointBuyLoader.addObserver(this);
        this.sponsorLoader.addObserver(this);
        this.raceLoader.addObserver(this);
        this.sizeLoader.addObserver(this);
        this.skillLoader.addObserver(this);
        this.spellLoader.addObserver(this);
        this.statCheckLoader.addObserver(this);
        this.templateLoader.addObserver(this);
        this.traitLoader.addObserver(this);
        this.wProfLoader.addObserver(this);
        try {
            this.globalCampaign = new CampaignSourceEntry(new Campaign(), new URI("file:/System%20Configuration%20Document"));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new UnreachableError(uRISyntaxException);
        }
    }

    @Override
    public void setChosenCampaignSourcefiles(List<URI> list) {
        this.chosenCampaignSourcefiles.clear();
        this.chosenCampaignSourcefiles.addAll(list);
        SettingsHandler.getOptions().setProperty("pcgen.files.chosenCampaignSourcefiles", CoreUtility.join(this.chosenCampaignSourcefiles, ','));
    }

    @Override
    public List<URI> getChosenCampaignSourcefiles() {
        return this.chosenCampaignSourcefiles;
    }

    public void setCustomItemsLoaded(boolean bl) {
        this.customItemsLoaded = bl;
    }

    @Override
    public boolean isCustomItemsLoaded() {
        return this.customItemsLoaded;
    }

    @Override
    public Set<String> getSources() {
        return this.sourcesSet;
    }

    @Override
    public void emptyLists() {
        this.loadedFiles.clear();
        this.chosenCampaignSourcefiles.clear();
        this.licensesToDisplayString = new StringBuffer();
        this.matureCampaigns = new StringBuffer();
        this.releaseFileData();
        this.skillReq = "";
        this.customItemsLoaded = false;
    }

    @Override
    public void initialize() throws PersistenceLayerException {
        this.loadGameModes();
        this.loadSponsorsLstFile();
        this.loadPCCFilesInDirectory(SettingsHandler.getPccFilesLocation().getAbsolutePath());
        this.loadPCCFilesInDirectory(SettingsHandler.getPcgenVendorDataDir().getAbsolutePath());
        this.campaignLoader.initRecursivePccFiles();
        Globals.sortPObjectListByName(Globals.getCampaignList());
    }

    private void loadSponsorsLstFile() {
        File file = new File(SettingsHandler.getPcgenSystemDir(), "sponsors");
        File file2 = new File(file, "sponsors.lst");
        try {
            this.sponsorLoader.loadLstFile(file2.toURI(), null);
        }
        catch (PersistenceLayerException persistenceLayerException) {
            Logging.errorPrint("Warning: sponsors file is missing");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadCampaigns(List<Campaign> list) throws PersistenceLayerException {
        Globals.setSorted(false);
        this.sourcesSet.clear();
        this.licenseFiles.clear();
        if (list.size() == 0) {
            throw new PersistenceLayerException("You must select at least one campaign to load.");
        }
        try {
            if (SettingsHandler.getGame() == null) {
                return;
            }
            File file = new File(SettingsHandler.getPcgenSystemDir(), "gameModes");
            File file2 = new File(file, SettingsHandler.getGame().getFolderName());
            List<CampaignSourceEntry> list2 = new File(file2, "statsandchecks.lst");
            this.statCheckLoader.loadLstFile(((File)((Object)list2)).toURI());
            this.sortCampaignsByRank(list);
            this.readPccFiles(list, null);
            this.addCustomFilesToStartOfList();
            this.setChanged();
            this.notifyObservers(this.countTotalFilesToLoad());
            this.wProfLoader.loadLstFiles(this.weaponProfFileList);
            this.skillLoader.loadLstFiles(this.skillFileList);
            this.languageLoader.loadLstFiles(this.languageFileList);
            this.abilityLoader.loadLstFiles(this.abilityFileList);
            this.featLoader.loadLstFiles(this.featFileList);
            this.raceLoader.loadLstFiles(this.raceFileList);
            this.domainLoader.loadLstFiles(this.domainFileList);
            this.spellLoader.loadLstFiles(this.spellFileList);
            this.deityLoader.loadLstFiles(this.deityFileList);
            this.classLoader.loadLstFiles(this.classFileList);
            this.templateLoader.loadLstFiles(this.templateFileList);
            this.eqModLoader.loadLstFiles(this.equipmodFileList);
            this.equipmentLoader.loadLstFiles(this.equipmentFileList);
            this.companionModLoader.loadLstFiles(this.companionmodFileList);
            this.kitLoader.loadLstFiles(this.kitFileList);
            for (int i = 0; i < loadOrder.length; ++i) {
                int n = loadOrder[i];
                list2 = this.getFilesForType(n);
                if (list2 == null || list2.isEmpty()) continue;
                Logging.errorPrint("*WARNING*: You are using a file type that has been deprecated");
                Logging.errorPrint(" The following file types will not be supported after 5.12:");
                Logging.errorPrint("  Class Skill LST file");
                Logging.errorPrint("  Class Spell LST file");
                Logging.errorPrint("  Required Skill LST file");
                Logging.errorPrint(" Function for these files has been provided in other LST files");
                ArrayList<PObject> arrayList = new ArrayList<PObject>();
                this.processFileList(n, list2, arrayList);
            }
            this.bioLoader.loadLstFiles(this.bioSetFileList);
            if (this.reqSkillFileList != null) {
                this.addToGlobals(16, this.reqSkillFileList);
            }
            this.checkRequiredSkills();
            this.checkRequiredDeities();
            this.eqModLoader.addDefaultEquipmentMods();
            this.loadCustomItems();
            this.verifyWeaponsMeleeOrRanged();
            if (!SettingsHandler.wantToLoadMasterworkAndMagic()) {
                EquipmentList.autoGenerateEquipment();
            }
            PObjectLoader.finishFeatProcessing();
            this.showLicensesIfNeeded();
            this.showSponsorsIfNeeded();
        }
        catch (Throwable throwable) {
            Logging.errorPrint("Exception loading files.", throwable);
        }
        finally {
            this.releaseFileData();
            this.setChanged();
            this.notifyObservers("DONE");
        }
    }

    private int countTotalFilesToLoad() {
        int n = this.bioSetFileList.size();
        n += this.classFileList.size();
        n += this.classSkillFileList.size();
        n += this.classSpellFileList.size();
        n += this.companionmodFileList.size();
        n += this.deityFileList.size();
        n += this.domainFileList.size();
        n += this.equipmentFileList.size();
        n += this.equipmodFileList.size();
        n += this.abilityFileList.size();
        n += this.featFileList.size();
        n += this.kitFileList.size();
        n += this.languageFileList.size();
        n += this.raceFileList.size();
        n += this.skillFileList.size();
        n += this.spellFileList.size();
        n += this.templateFileList.size();
        return n += this.weaponProfFileList.size();
    }

    @Override
    @Deprecated
    public void loadFileIntoList(URI uRI, int n, List<PObject> list) throws PersistenceLayerException {
        URL uRL = null;
        try {
            uRL = uRI.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            try {
                this.setChanged();
                this.notifyObservers("Unable to convert '" + uRI + "' to a URL");
                uRL = new URL("http://g");
            }
            catch (MalformedURLException malformedURLException2) {
                malformedURLException2.printStackTrace();
            }
        }
        this.setChanged();
        this.notifyObservers(uRL);
        this.initFile(uRI, n, list);
    }

    @Override
    public void loadModItems(boolean bl) {
    }

    @Override
    public void refreshCampaigns() {
        Globals.clearCampaignsForRefresh();
        this.loadPCCFilesInDirectory(SettingsHandler.getPccFilesLocation().getAbsolutePath());
        this.loadPCCFilesInDirectory(SettingsHandler.getPcgenVendorDataDir().getAbsolutePath());
    }

    private static void setCampaignOptions(Campaign campaign) {
        Properties properties = campaign.getOptions();
        if (properties != null) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                SettingsHandler.setPCGenOption(string, string2);
            }
        }
    }

    @Deprecated
    private List<CampaignSourceEntry> getFilesForType(int n) {
        List<CampaignSourceEntry> list = null;
        switch (n) {
            case 14: {
                list = this.classSkillFileList;
                break;
            }
            case 15: {
                list = this.classSpellFileList;
                break;
            }
            default: {
                this.logError("Campaign list corrupt; no such lineType (" + n + ") exists. Stopped parsing campaigns, but not aborting program.");
            }
        }
        return list;
    }

    private static String[] getGameFilesList() {
        String string = SettingsHandler.getPcgenSystemDir() + File.separator + "gameModes" + File.separator;
        return new File(string).list(gameModeFileFilter);
    }

    private void addCustomFilesToStartOfList() {
        File file;
        File file2;
        File file3;
        File file4;
        File file5;
        File file6;
        File file7;
        File file8;
        File file9;
        File file10;
        CampaignSourceEntry campaignSourceEntry = null;
        Campaign campaign = new Campaign();
        campaign.setName("Custom");
        campaign.addDescription(new Description("Custom data"));
        File file11 = new File(CustomData.customBioSetFilePath(true));
        if (file11.exists()) {
            campaignSourceEntry = new CampaignSourceEntry(campaign, file11.toURI());
            this.bioSetFileList.remove(campaignSourceEntry);
            this.bioSetFileList.add(0, campaignSourceEntry);
        }
        if ((file10 = new File(CustomData.customClassFilePath(true))).exists()) {
            campaignSourceEntry = new CampaignSourceEntry(campaign, file10.toURI());
            this.classFileList.remove(campaignSourceEntry);
            this.classFileList.add(0, campaignSourceEntry);
        }
        if ((file9 = new File(CustomData.customDeityFilePath(true))).exists()) {
            campaignSourceEntry = new CampaignSourceEntry(campaign, file9.toURI());
            this.deityFileList.remove(campaignSourceEntry);
            this.deityFileList.add(0, campaignSourceEntry);
        }
        if ((file8 = new File(CustomData.customDomainFilePath(true))).exists()) {
            campaignSourceEntry = new CampaignSourceEntry(campaign, file8.toURI());
            this.domainFileList.remove(campaignSourceEntry);
            this.domainFileList.add(0, campaignSourceEntry);
        }
        if ((file7 = new File(CustomData.customAbilityFilePath(true))).exists()) {
            campaignSourceEntry = new CampaignSourceEntry(campaign, file7.toURI());
            this.abilityFileList.remove(campaignSourceEntry);
            this.abilityFileList.add(0, campaignSourceEntry);
        }
        if ((file6 = new File(CustomData.customFeatFilePath(true))).exists()) {
            campaignSourceEntry = new CampaignSourceEntry(campaign, file6.toURI());
            this.featFileList.remove(campaignSourceEntry);
            this.featFileList.add(0, campaignSourceEntry);
        }
        if ((file5 = new File(CustomData.customLanguageFilePath(true))).exists()) {
            campaignSourceEntry = new CampaignSourceEntry(campaign, file5.toURI());
            this.languageFileList.remove(campaignSourceEntry);
            this.languageFileList.add(0, campaignSourceEntry);
        }
        if ((file4 = new File(CustomData.customRaceFilePath(true))).exists()) {
            campaignSourceEntry = new CampaignSourceEntry(campaign, file4.toURI());
            this.raceFileList.remove(campaignSourceEntry);
            this.raceFileList.add(0, campaignSourceEntry);
        }
        if ((file3 = new File(CustomData.customSkillFilePath(true))).exists()) {
            campaignSourceEntry = new CampaignSourceEntry(campaign, file3.toURI());
            this.skillFileList.remove(campaignSourceEntry);
            this.skillFileList.add(0, campaignSourceEntry);
        }
        if ((file2 = new File(CustomData.customSpellFilePath(true))).exists()) {
            campaignSourceEntry = new CampaignSourceEntry(campaign, file2.toURI());
            this.spellFileList.remove(campaignSourceEntry);
            this.spellFileList.add(0, campaignSourceEntry);
        }
        if ((file = new File(CustomData.customTemplateFilePath(true))).exists()) {
            campaignSourceEntry = new CampaignSourceEntry(campaign, file.toURI());
            this.templateFileList.remove(campaignSourceEntry);
            this.templateFileList.add(0, campaignSourceEntry);
        }
    }

    @Deprecated
    private void addToGlobals(int n, List<?> list) {
        String string = "";
        block6: for (int i = 0; i < list.size(); ++i) {
            switch (n) {
                case 14: {
                    LstSystemLoader.parseClassSkillFrom(list.get(i).toString());
                    continue block6;
                }
                case 15: {
                    string = LstSystemLoader.parseClassSpellFrom(list.get(i).toString(), string);
                    continue block6;
                }
                case 16: {
                    String string2 = list.get(i).toString();
                    if ("ALL".equals(string2) || "UNTRAINED".equals(string2)) {
                        this.skillReq = string2;
                        continue block6;
                    }
                    Skill skill = Globals.getSkillKeyed(string2);
                    if (skill != null) {
                        skill.setRequired(true);
                        continue block6;
                    }
                    this.logError("The skill " + string2 + " defined as a REQSKILL could not be found." + " The skill could not be made required.");
                    continue block6;
                }
                case -1: {
                    continue block6;
                }
                default: {
                    this.logError("In LstSystemLoader.initValue the lineType " + n + " is not handled.");
                }
            }
        }
        list.clear();
    }

    private void checkRequiredDeities() throws PersistenceLayerException {
        List<String> list = Globals.getGlobalDeityList();
        if (list != null && list.size() != 0) {
            for (String string : list) {
                this.deityLoader.parseLine((Deity)null, string, this.globalCampaign);
            }
        }
    }

    @Deprecated
    private void checkRequiredSkills() {
        if (this.skillReq.length() > 0) {
            for (Skill skill : Globals.getSkillList()) {
                if ((!"UNTRAINED".equals(this.skillReq) || !skill.isUntrained()) && !this.skillReq.equals("ALL")) continue;
                skill.setRequired(true);
            }
        }
    }

    @Deprecated
    private int countCloseParens(String string) {
        String string2 = string;
        int n = 0;
        while (string2.lastIndexOf(41) >= 0) {
            ++n;
            string2 = string2.substring(0, string2.lastIndexOf(41));
        }
        return n;
    }

    @Deprecated
    private int countOpenParens(String string) {
        String string2 = string;
        int n = 0;
        while (string2.lastIndexOf(40) >= 0) {
            ++n;
            string2 = string2.substring(0, string2.lastIndexOf(40));
        }
        return n;
    }

    @Deprecated
    private void initFile(URI uRI, int n, List<PObject> list) throws PersistenceLayerException {
        if (this.lstExcludeFiles.contains(uRI)) {
            return;
        }
        StringBuilder stringBuilder = LstFileLoader.readFromURI(uRI);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = stringBuilder.toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        String string2 = "";
        String string3 = "";
        block3: while (stringTokenizer.hasMoreTokens()) {
            Object object;
            boolean bl;
            string3 = stringTokenizer.nextToken();
            ++lineNum;
            if (string3.startsWith("CAMPAIGN:") && n != 13 || string3.length() == 0 || n != 13 && string3.length() > 0 && string3.charAt(0) == '#') continue;
            if (string3.startsWith("SOURCE") && n != 13) {
                hashMap.putAll(SourceLoader.parseLine(string3, uRI));
                continue;
            }
            boolean bl2 = string3.endsWith(".MOD");
            if (bl2 && string3.startsWith("CLASS:")) {
                string2 = string3.substring(0, string3.length() - 4);
            }
            if (bl = string3.endsWith(".FORGET")) {
                string2 = string3.substring(0, string3.length() - 7);
            }
            if (string3.indexOf(9) > 2) {
                object = new StringTokenizer(string3, "\t");
                string2 = ((StringTokenizer)object).nextToken();
                bl2 = string2.endsWith(".MOD");
                if (bl2) {
                    string2 = string2.substring(0, string2.length() - 4);
                } else if (string2.indexOf(".COPY=") > 0) {
                    string2 = string2.substring(0, string2.indexOf(".COPY="));
                }
            }
            switch (n) {
                case -1: 
                case 14: 
                case 15: {
                    object = new PObject();
                    ((PObject)object).setName(string3);
                    list.add((PObject)object);
                    continue block3;
                }
            }
            this.logError("In LstSystemLoader.initValue the fileType " + n + " is not handled.");
        }
    }

    private void loadCampaignFile(Campaign campaign) {
        campaign.setIsLoaded(true);
        URI uRI = campaign.getSourceURI();
        if (!this.chosenCampaignSourcefiles.contains(uRI)) {
            this.chosenCampaignSourcefiles.add(uRI);
            SettingsHandler.getOptions().setProperty("pcgen.files.chosenCampaignSourcefiles", CoreUtility.join(this.chosenCampaignSourcefiles, ','));
        }
        this.showOGL |= campaign.isOGL();
        this.showD20 |= campaign.isD20();
        this.showLicensed |= campaign.isLicensed();
        if (campaign.isLicensed()) {
            List<URI> list;
            List<String> list2 = campaign.getLicenses();
            if (list2 != null && list2.size() > 0) {
                this.licensesToDisplayString.append(campaign.getLicenses());
            }
            if ((list = campaign.getLicenseFiles()) != null) {
                this.licenseFiles.addAll(list);
            }
        }
        this.showMature |= campaign.isMature();
        if (campaign.isMature()) {
            this.matureCampaigns.append(campaign.getSourceEntry().getFieldByType(SourceEntry.SourceFormat.LONG) + " (" + campaign.getPubNameLong() + ")<br>");
        }
        this.lstExcludeFiles.addAll(campaign.getLstExcludeFiles());
        this.raceFileList.addAll(campaign.getRaceFiles());
        this.classFileList.addAll(campaign.getClassFiles());
        this.companionmodFileList.addAll(campaign.getCompanionModFiles());
        this.skillFileList.addAll(campaign.getSkillFiles());
        this.abilityFileList.addAll(campaign.getAbilityFiles());
        this.featFileList.addAll(campaign.getFeatFiles());
        this.deityFileList.addAll(campaign.getDeityFiles());
        this.domainFileList.addAll(campaign.getDomainFiles());
        this.weaponProfFileList.addAll(campaign.getWeaponProfFiles());
        this.equipmentFileList.addAll(campaign.getEquipFiles());
        this.classSkillFileList.addAll(campaign.getClassSkillFiles());
        this.classSpellFileList.addAll(campaign.getClassSpellFiles());
        this.spellFileList.addAll(campaign.getSpellFiles());
        this.languageFileList.addAll(campaign.getLanguageFiles());
        this.reqSkillFileList.addAll(campaign.getReqSkillFiles());
        this.templateFileList.addAll(campaign.getTemplateFiles());
        this.equipmodFileList.addAll(campaign.getEquipModFiles());
        this.kitFileList.addAll(campaign.getKitFiles());
        this.bioSetFileList.addAll(campaign.getBioSetFiles());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCustomItems() {
        this.customItemsLoaded = true;
        if (!SettingsHandler.getSaveCustomEquipment()) {
            return;
        }
        BufferedReader bufferedReader = CustomData.getCustomEquipmentReader();
        EquipmentList.setAutoGeneration(true);
        try {
            while (bufferedReader != null) {
                int n;
                String string = bufferedReader.readLine();
                if (string == null) {
                    break;
                }
                if (!string.startsWith("BASEITEM:") || (n = string.indexOf(9, 9)) < 10) continue;
                String string2 = string.substring(9, n);
                string = string.substring(n + 1);
                Equipment equipment = EquipmentList.getEquipmentKeyed(string2);
                if (equipment == null) continue;
                equipment = equipment.clone();
                equipment.load(string);
                if (!equipment.isType("CUSTOM")) {
                    equipment.addMyType("CUSTOM");
                }
                EquipmentList.addEquipment(equipment);
            }
        }
        catch (IOException iOException) {
            this.logError("Error when loading custom items", iOException);
        }
        finally {
            EquipmentList.setAutoGeneration(false);
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                this.logError("Error when closing infile after loading custom items", iOException);
            }
        }
    }

    private static void loadGameModeInfoFile(GameMode gameMode, URI uRI, String string) {
        String string2;
        try {
            string2 = LstFileLoader.readFromURI(uRI).toString();
        }
        catch (PersistenceLayerException persistenceLayerException) {
            Logging.errorPrint(PropertyFactory.getFormattedString("Errors.LstSystemLoader.loadGameModeInfoFile", uRI, persistenceLayerException.getMessage()));
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\r\n");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            ++n;
            String string3 = stringTokenizer.nextToken().trim();
            if (string3.length() > 0 && string3.charAt(0) == '#' || string3.length() == 0) continue;
            if (string.equals("load")) {
                gameMode.addLoadString(string3);
                continue;
            }
            if (string.equals("level")) {
                LevelInfo levelInfo = new LevelInfo();
                LevelLoader.parseLine(levelInfo, string3, n, uRI);
                gameMode.addLevelInfo(levelInfo);
                continue;
            }
            if (!string.equals("rules")) continue;
            RuleCheckLoader.parseLine(gameMode, string3, uRI);
        }
    }

    private static GameMode loadGameModeMiscInfo(String string, URI uRI) {
        String string2;
        GameMode gameMode = null;
        try {
            string2 = LstFileLoader.readFromURI(uRI).toString();
        }
        catch (PersistenceLayerException persistenceLayerException) {
            Logging.errorPrint(PropertyFactory.getFormattedString("Errors.LstSystemLoader.loadGameModeInfoFile", uRI, persistenceLayerException.getMessage()));
            return gameMode;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\r\n");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            ++n;
            String string3 = stringTokenizer.nextToken().trim();
            if (string3.length() > 0 && string3.charAt(0) == '#' || string3.length() == 0) continue;
            if (gameMode == null) {
                gameMode = new GameMode(string);
                SystemCollections.addToGameModeList(gameMode);
            }
            GameModeLoader.parseMiscGameInfoLine(gameMode, string3, uRI, n);
        }
        return gameMode;
    }

    private void loadPCCFilesInDirectory(String string) {
        new File(string).list(this.pccFileFilter);
    }

    private void loadPCCFilesInDirectory(File file) {
        file.list(this.pccFileFilter);
    }

    @Deprecated
    private static void parseClassSkillFrom(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        String string2 = stringTokenizer.nextToken();
        PCClass pCClass = Globals.getClassKeyed(string2);
        String string3 = string2;
        if (pCClass != null) {
            string3 = pCClass.getKeyName();
        }
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            stringTokenizer = new StringTokenizer(string2, "|");
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                String string5 = string4 + "(";
                Skill skill = Globals.getSkillKeyed(string4);
                if (skill != null) {
                    skill.getClassList().add(string3);
                    continue;
                }
                for (Skill skill2 : Globals.getSkillList()) {
                    if (!skill2.getKeyName().startsWith(string5)) continue;
                    skill2.getClassList().add(string3);
                }
            }
        }
    }

    @Deprecated
    private static String parseClassSpellFrom(String string, String string2) {
        PObject pObject3;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        String string3 = stringTokenizer.nextToken();
        if (string3.startsWith("DOMAIN:")) {
            string2 = string3.substring(7);
            pObject3 = Globals.getDomainKeyed(string2);
            string2 = pObject3 != null ? "DOMAIN|" + string2 : "";
        }
        if (string3.startsWith("CLASS:")) {
            PObject pObject2;
            boolean bl = true;
            string2 = "";
            if (string3.length() > 6) {
                string2 = string3.substring(6);
            }
            if ((pObject2 = Globals.getClassKeyed(string2)) != null && ((PCClass)pObject2).getSpellType().equalsIgnoreCase("None")) {
                pObject2 = null;
            }
            if (pObject2 == null && (pObject2 = Globals.getDomainKeyed(string2)) != null) {
                bl = false;
            }
            if (pObject2 != null) {
                string2 = pObject2.getKeyName();
            }
            string2 = bl ? "CLASS|" + string2 : "DOMAIN|" + string2;
        } else if (stringTokenizer.hasMoreTokens()) {
            String string4 = string2.substring(string2.indexOf(124) + 1);
            if (string2.startsWith("DOMAIN|")) {
                pObject3 = Globals.getDomainKeyed(string4);
            } else if (string2.startsWith("CLASS|")) {
                pObject3 = Globals.getClassKeyed(string4);
            } else {
                return string2;
            }
            if (pObject3 == null) {
                for (PObject pObject3 : pList) {
                    if (pObject3.getKeyName().equals(string4)) break;
                    pObject3 = null;
                }
                if (pObject3 == null) {
                    pObject3 = new PObject();
                    pObject3.setName(string4);
                    pObject3.setKeyName(string4);
                    pList.add(pObject3);
                }
            }
            int n = Integer.parseInt(string3);
            String string5 = stringTokenizer.nextToken();
            stringTokenizer = new StringTokenizer(string5, "|");
            while (stringTokenizer.hasMoreTokens()) {
                Spell spell = Globals.getSpellKeyed(stringTokenizer.nextToken().trim());
                if (spell == null) continue;
                spell.setLevelInfo(string2, n);
            }
        }
        return string2;
    }

    private void loadGameModeLstFile(LstLineFileLoader lstLineFileLoader, String string, String string2, String string3) {
        this.loadGameModeLstFile(lstLineFileLoader, string, string2, string3, true);
    }

    private void loadGameModeLstFile(LstLineFileLoader lstLineFileLoader, String string, String string2, String string3, boolean bl) {
        block6: {
            File file;
            File file2;
            File file3 = new File(SettingsHandler.getPcgenSystemDir(), "gameModes");
            try {
                file2 = new File(file3, string2);
                file = new File(file2, string3);
                if (file.exists()) {
                    lstLineFileLoader.loadLstFile(file.toURI(), string);
                    return;
                }
            }
            catch (PersistenceLayerException persistenceLayerException) {
                // empty catch block
            }
            try {
                file2 = new File(file3, "default");
                file = new File(file2, string3);
                if (file.exists()) {
                    lstLineFileLoader.loadLstFile(file.toURI(), string);
                }
            }
            catch (PersistenceLayerException persistenceLayerException) {
                if (!bl) break block6;
                Logging.errorPrint("Warning: game mode " + string + " is missing file " + string3);
            }
        }
    }

    private void loadGameModes() {
        String[] stringArray = LstSystemLoader.getGameFilesList();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        SystemCollections.clearGameModeList();
        File file = new File(SettingsHandler.getPcgenSystemDir(), "gameModes");
        for (String string : stringArray) {
            SystemCollections.setEmptyUnitSetList(string);
            File file2 = new File(file, string);
            File file3 = new File(file2, "miscinfo.lst");
            GameMode gameMode = LstSystemLoader.loadGameModeMiscInfo(string, file3.toURI());
            String string2 = gameMode.getName();
            SettingsHandler.setGame(string2);
            if (gameMode == null) continue;
            LstSystemLoader.loadGameModeInfoFile(gameMode, new File(file2, "level.lst").toURI(), "level");
            LstSystemLoader.loadGameModeInfoFile(gameMode, new File(file2, "rules.lst").toURI(), "rules");
            this.loadGameModeLstFile(this.eqSlotLoader, string2, string, "equipmentslots.lst");
            this.loadGameModeLstFile(this.paperLoader, string2, string, "paperInfo.lst");
            this.loadGameModeLstFile(this.traitLoader, string2, string, "bio" + File.separator + "traits.lst");
            this.loadGameModeLstFile(this.locationLoader, string2, string, "bio" + File.separator + "locations.lst");
            this.loadGameModeLstFile(this.bioLoader, string2, string, "bio" + File.separator + "biosettings.lst");
            this.loadGameModeLstFile(this.loadInfoLoader, string2, string, "load.lst");
            this.loadGameModeLstFile(this.unitSetLoader, string2, string, "unitset.lst", false);
            this.loadGameModeLstFile(this.pointBuyLoader, string2, string, "pointbuymethods.lst", false);
            this.loadGameModeLstFile(this.sizeLoader, string2, string, "sizeAdjustment.lst");
            this.loadGameModeLstFile(this.statCheckLoader, string2, string, "statsandchecks.lst");
        }
        SystemCollections.sortGameModeList();
    }

    @Deprecated
    private void processExtraInfo(int n, List<? extends PObject> list, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        int n2 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n3 = this.countOpenParens(string2);
            int n4 = this.countCloseParens(string2);
            boolean bl = false;
            if (string2.startsWith("(EXCLUDE")) {
                String string3 = string2.substring(9);
                if (string3.endsWith(")")) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                arrayList.add(string3);
                n2 = -1;
                bl = true;
            } else if (string2.startsWith("(INCLUDE")) {
                String string4 = string2.substring(9);
                if (string4.endsWith(")")) {
                    string4 = string4.substring(0, string4.length() - 1);
                }
                arrayList.add(string4);
                n2 = 1;
                bl = true;
            }
            if (string2.endsWith(")") && n4 > n3) {
                PObject pObject;
                if (!bl) {
                    arrayList.add(string2.substring(0, string2.length() - 1));
                }
                if (n2 == -1) {
                    for (int i = list.size() - 1; i >= 0; --i) {
                        pObject = list.get(i);
                        if (!arrayList.contains(pObject.getKeyName())) continue;
                        list.remove(i);
                    }
                } else if (n2 == 1) {
                    for (int i = list.size() - 1; i >= 0; --i) {
                        pObject = list.get(i);
                        if (arrayList.contains(pObject.getKeyName())) continue;
                        list.remove(i);
                    }
                }
                bl = true;
                n2 = 0;
            }
            if (bl) continue;
            if (n != 12) {
                arrayList.add(string2);
                continue;
            }
            Logging.errorPrint("Unhandled INCLUDE/EXCLUDE: " + string2);
        }
    }

    @Deprecated
    private void processFileList(int n, List<CampaignSourceEntry> list, List<PObject> list2) throws PersistenceLayerException {
        if (n == 13) {
            this.logError("No longer processing campaigns in processFileList.");
            return;
        }
        for (CampaignSourceEntry campaignSourceEntry : list) {
            URI uRI = campaignSourceEntry.getURI();
            if (this.loadedFiles.contains(uRI)) continue;
            this.loadFileIntoList(uRI, n, list2);
            List<String> list3 = campaignSourceEntry.getExcludeItems();
            for (int i = list2.size() - 1; i >= 0; --i) {
                PObject pObject = list2.get(i);
                if (!list3.contains(pObject.getKeyName())) continue;
                list2.remove(i);
            }
            List<String> list4 = campaignSourceEntry.getIncludeItems();
            for (int i = list2.size() - 1; i >= 0; --i) {
                PObject pObject = list2.get(i);
                if (list4.contains(pObject.getKeyName())) continue;
                list2.remove(i);
            }
            if (list3.size() == 0 && list4.size() == 0) {
                this.loadedFiles.add(uRI);
            }
            if (list2.isEmpty()) continue;
            this.addToGlobals(n, list2);
        }
    }

    private void readPccFiles(List<Campaign> list, PlayerCharacter playerCharacter) {
        if (SettingsHandler.isOptionAllowedInSources()) {
            SettingsHandler.setOptionsProperties(playerCharacter);
        }
        for (Campaign campaign : list) {
            this.loadCampaignFile(campaign);
            if (!SettingsHandler.isOptionAllowedInSources()) continue;
            LstSystemLoader.setCampaignOptions(campaign);
        }
        this.stripLstExcludes();
        if (SettingsHandler.isOptionAllowedInSources()) {
            SettingsHandler.getOptionsFromProperties(playerCharacter);
        }
    }

    private void stripLstExcludes() {
        this.raceFileList.removeAll(this.lstExcludeFiles);
        this.classFileList.removeAll(this.lstExcludeFiles);
        this.companionmodFileList.removeAll(this.lstExcludeFiles);
        this.skillFileList.removeAll(this.lstExcludeFiles);
        this.abilityFileList.removeAll(this.lstExcludeFiles);
        this.featFileList.removeAll(this.lstExcludeFiles);
        this.deityFileList.removeAll(this.lstExcludeFiles);
        this.domainFileList.removeAll(this.lstExcludeFiles);
        this.weaponProfFileList.removeAll(this.lstExcludeFiles);
        this.equipmentFileList.removeAll(this.lstExcludeFiles);
        this.classSkillFileList.removeAll(this.lstExcludeFiles);
        this.classSpellFileList.removeAll(this.lstExcludeFiles);
        this.spellFileList.removeAll(this.lstExcludeFiles);
        this.languageFileList.removeAll(this.lstExcludeFiles);
        this.reqSkillFileList.removeAll(this.lstExcludeFiles);
        this.templateFileList.removeAll(this.lstExcludeFiles);
        this.equipmodFileList.removeAll(this.lstExcludeFiles);
        this.kitFileList.removeAll(this.lstExcludeFiles);
        this.bioSetFileList.removeAll(this.lstExcludeFiles);
    }

    private void releaseFileData() {
        this.lstExcludeFiles.clear();
        this.raceFileList.clear();
        this.classFileList.clear();
        this.companionmodFileList.clear();
        this.skillFileList.clear();
        this.abilityFileList.clear();
        this.featFileList.clear();
        this.deityFileList.clear();
        this.domainFileList.clear();
        this.templateFileList.clear();
        this.weaponProfFileList.clear();
        this.equipmentFileList.clear();
        this.classSkillFileList.clear();
        this.classSpellFileList.clear();
        this.spellFileList.clear();
        this.reqSkillFileList.clear();
        this.languageFileList.clear();
        this.equipmodFileList.clear();
        this.kitFileList.clear();
        this.bioSetFileList.clear();
    }

    private void showLicensesIfNeeded() {
        if (Globals.getUseGUI()) {
            String string;
            if (this.showOGL && SettingsHandler.showLicense()) {
                pcGenGUI.showLicense();
            }
            if (this.showLicensed && SettingsHandler.showLicense()) {
                string = this.licensesToDisplayString.toString();
                if (string.trim().length() > 0) {
                    pcGenGUI.showLicense("Special Licenses", string);
                }
                pcGenGUI.showLicense("Special Licenses", this.licenseFiles);
            }
            if (this.showD20 && SettingsHandler.showD20Info()) {
                pcGenGUI.showMandatoryD20Info();
            }
            if (this.showMature && SettingsHandler.showMature() && (string = this.matureCampaigns.toString()).trim().length() > 0) {
                pcGenGUI.showMature(string);
            }
        }
        Globals.getSection15().setLength(0);
        this.showOGL = false;
        this.showD20 = false;
        this.showLicensed = false;
    }

    private void showSponsorsIfNeeded() {
        if (Globals.getUseGUI() && SettingsHandler.showSponsors()) {
            pcGenGUI.showSponsors();
        }
    }

    private void sortCampaignsByRank(List<Campaign> list) {
        Collections.sort(list, new Comparator<Campaign>(){

            @Override
            public int compare(Campaign campaign, Campaign campaign2) {
                return campaign.getRank() - campaign2.getRank();
            }
        });
        for (Campaign campaign : list) {
            this.sourcesSet.add(campaign.getSourceEntry().getFormattedString(SourceEntry.SourceFormat.LONG, true));
        }
    }

    private void verifyWeaponsMeleeOrRanged() throws PersistenceLayerException {
        Iterator<Map.Entry<String, Equipment>> iterator = EquipmentList.getEquipmentListIterator();
        while (iterator.hasNext()) {
            Equipment equipment = iterator.next().getValue();
            if (!equipment.isWeapon() || equipment.isMelee() || equipment.isRanged()) continue;
            throw new PersistenceLayerException("Weapon: " + equipment.getName() + " is neither Melee nor Ranged." + Constants.s_LINE_SEP + "PCGen" + " cannot calculate \"to hit\" unless one of these is selected." + Constants.s_LINE_SEP + "Source: " + equipment.getSourceURI());
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        this.setChanged();
        this.notifyObservers(object);
    }

    @Deprecated
    public void logError(String string) {
        Logging.errorPrint(string);
        this.setChanged();
        this.notifyObservers(new Exception(string));
    }

    public void logError(String string, Throwable throwable) {
        Logging.errorPrint(string, throwable);
        this.setChanged();
        this.notifyObservers(new Exception(string + ": " + throwable.getMessage()));
    }
}

