/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.LstFileLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LstLineFileLoader
extends LstFileLoader {
    protected String gameMode = "*";

    public void loadLstFile(URI uRI) throws PersistenceLayerException {
        StringBuilder stringBuilder = LstLineFileLoader.readFromURI(uRI);
        String string = stringBuilder.toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (this.isComment(string2)) continue;
            this.parseLine(string2, uRI);
        }
    }

    public void loadLstFile(URI uRI, String string) throws PersistenceLayerException {
        this.gameMode = string;
        this.loadLstFile(uRI);
    }

    public void loadLstFiles(List<CampaignSourceEntry> list) throws PersistenceLayerException {
        for (CampaignSourceEntry campaignSourceEntry : list) {
            this.loadLstFile(campaignSourceEntry.getURI());
        }
    }

    public abstract void parseLine(String var1, URI var2) throws PersistenceLayerException;

    public String getGameMode() {
        return this.gameMode;
    }

    public void setGameMode(String string) {
        this.gameMode = string;
    }
}

