/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import pcgen.core.Ability;
import pcgen.core.Globals;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.AbilityLoader;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.util.Logging;

public final class FeatLoader
extends AbilityLoader {
    private boolean defaultFeatsLoaded = false;

    public Ability parseLine(Ability ability, String string, CampaignSourceEntry campaignSourceEntry) throws PersistenceLayerException {
        Ability ability2 = ability;
        if (ability2 == null) {
            ability2 = new Ability();
        }
        ability2.setCategory("FEAT");
        return super.parseLine(ability2, string, campaignSourceEntry);
    }

    protected void loadLstFile(CampaignSourceEntry campaignSourceEntry) {
        super.loadLstFile(campaignSourceEntry);
        if (!this.defaultFeatsLoaded) {
            this.loadDefaultFeats(campaignSourceEntry);
        }
    }

    private void loadDefaultFeats(CampaignSourceEntry campaignSourceEntry) {
        if (Globals.getAbilityKeyed("FEAT", "PCGENi_WEAPON_PROFICIENCY") == null) {
            String string = "PCGENi_WEAPON_PROFICIENCY\tOUTPUTNAME:Weapon Proficiency\tTYPE:General\tCATEGORY:FEAT\tVISIBLE:NO\tMULT:YES\tSTACK:YES\tDESC:You attack with this specific weapon normally, non-proficiency incurs a -4 to hit penalty.\tSOURCELONG:PCGen Internal";
            try {
                this.parseLine((Ability)null, string, campaignSourceEntry);
            }
            catch (PersistenceLayerException persistenceLayerException) {
                Logging.errorPrint("Unable to parse the internal default feats '" + string + "': " + persistenceLayerException.getMessage());
            }
            this.defaultFeatsLoaded = true;
        }
    }

    protected Ability getObjectKeyed(String string) {
        return Globals.getAbilityKeyed("FEAT", string);
    }
}

