/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.StringTokenizer;
import pcgen.core.Campaign;
import pcgen.core.EquipmentList;
import pcgen.core.EquipmentModifier;
import pcgen.core.PObject;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.EquipmentModifierLstToken;
import pcgen.persistence.lst.LstObjectFileLoader;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.PObjectLoader;
import pcgen.persistence.lst.TokenStore;
import pcgen.util.Logging;
import pcgen.util.UnreachableError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EquipmentModifierLoader
extends LstObjectFileLoader<EquipmentModifier> {
    @Override
    protected void addGlobalObject(PObject pObject) {
        EquipmentModifier equipmentModifier = EquipmentList.getModifierKeyed(pObject.getKeyName());
        if (equipmentModifier == null) {
            EquipmentList.addEquipmentModifier((EquipmentModifier)pObject);
        }
    }

    @Override
    protected EquipmentModifier getObjectKeyed(String string) {
        return EquipmentList.getModifierKeyed(string);
    }

    @Override
    public EquipmentModifier parseLine(EquipmentModifier equipmentModifier, String string, CampaignSourceEntry campaignSourceEntry) throws PersistenceLayerException {
        if (equipmentModifier == null) {
            equipmentModifier = new EquipmentModifier();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        String string2 = stringTokenizer.nextToken();
        equipmentModifier.setName(string2.replace('|', ' '));
        equipmentModifier.setSourceCampaign(campaignSourceEntry.getCampaign());
        equipmentModifier.setSourceURI(campaignSourceEntry.getURI());
        Map<String, LstToken> map = TokenStore.inst().getTokenMap(EquipmentModifierLstToken.class);
        while (stringTokenizer.hasMoreTokens()) {
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken().trim();
                int n = string3.indexOf(58);
                String string4 = "";
                try {
                    string4 = string3.substring(0, n);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                EquipmentModifierLstToken equipmentModifierLstToken = (EquipmentModifierLstToken)map.get(string4);
                if (equipmentModifierLstToken != null) {
                    String string5 = string3.substring(n + 1);
                    LstUtils.deprecationCheck(equipmentModifierLstToken, equipmentModifier, string5);
                    if (equipmentModifierLstToken.parse(equipmentModifier, string5)) continue;
                    Logging.errorPrint("Error parsing ability " + equipmentModifier.getDisplayName() + ':' + campaignSourceEntry.getURI() + ':' + string3 + "\"");
                    continue;
                }
                if (PObjectLoader.parseTag(equipmentModifier, string3)) continue;
                Logging.errorPrint("Illegal equipment modifier info " + campaignSourceEntry + ":" + " \"" + string3 + "\"");
            }
        }
        this.completeObject(campaignSourceEntry, equipmentModifier);
        return null;
    }

    @Override
    protected void performForget(EquipmentModifier equipmentModifier) {
        throw new UnsupportedOperationException("Cannot FORGET an EquipmentModifier");
    }

    public void addDefaultEquipmentMods() throws PersistenceLayerException {
        CampaignSourceEntry campaignSourceEntry;
        try {
            campaignSourceEntry = new CampaignSourceEntry(new Campaign(), new URI("file:/" + this.getClass().getName() + ".java"));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new UnreachableError(uRISyntaxException);
        }
        EquipmentModifier equipmentModifier = new EquipmentModifier();
        String string = "Add Type\tKEY:ADDTYPE\tTYPE:ALL\tCOST:0\tNAMEOPT:NONAME\tSOURCELONG:PCGen Internal\tCHOOSE:COUNT=ALL|desired TYPE(s)|TYPE=EQTYPES";
        this.parseLine(equipmentModifier, string, campaignSourceEntry);
        equipmentModifier = new EquipmentModifier();
        string = "PCGENi_WEAPON\tTYPE:Weapon\tVISIBLE:No\tCHOOSE:DUMMY\tNAMEOPT:NONAME";
        this.parseLine(equipmentModifier, string, campaignSourceEntry);
        equipmentModifier = new EquipmentModifier();
        string = "PCGENi_ARMOR\tTYPE:Armor\tVISIBLE:No\tCHOOSE:DUMMY\tNAMEOPT:NONAME";
        this.parseLine(equipmentModifier, string, campaignSourceEntry);
    }
}

