/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.util.Map;
import java.util.StringTokenizer;
import pcgen.core.Equipment;
import pcgen.core.EquipmentList;
import pcgen.core.PObject;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.EquipmentLstToken;
import pcgen.persistence.lst.LstObjectFileLoader;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.PObjectLoader;
import pcgen.persistence.lst.TokenStore;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EquipmentLoader
extends LstObjectFileLoader<Equipment> {
    @Override
    protected void addGlobalObject(PObject pObject) {
        Equipment equipment = EquipmentList.getEquipmentNamed(pObject.getKeyName());
        if (equipment == null) {
            EquipmentList.addEquipment((Equipment)pObject);
        }
    }

    @Override
    protected Equipment getObjectKeyed(String string) {
        return EquipmentList.getEquipmentNamed(string);
    }

    @Override
    public Equipment parseLine(Equipment equipment, String string, CampaignSourceEntry campaignSourceEntry) throws PersistenceLayerException {
        if (equipment == null) {
            equipment = new Equipment();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        String string2 = stringTokenizer.nextToken();
        equipment.setName(string2);
        equipment.setSourceCampaign(campaignSourceEntry.getCampaign());
        equipment.setSourceURI(campaignSourceEntry.getURI());
        Map<String, LstToken> map = TokenStore.inst().getTokenMap(EquipmentLstToken.class);
        while (stringTokenizer.hasMoreTokens()) {
            String string3;
            String string4 = stringTokenizer.nextToken().trim();
            int n = string4.indexOf(58);
            String string5 = "";
            try {
                string5 = string4.substring(0, n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            EquipmentLstToken equipmentLstToken = (EquipmentLstToken)map.get(string5);
            if (equipmentLstToken != null) {
                string3 = string4.substring(n + 1);
                LstUtils.deprecationCheck(equipmentLstToken, equipment, string3);
                if (equipmentLstToken.parse(equipment, string3)) continue;
                Logging.errorPrint("Error parsing Equipment " + equipment.getName() + ':' + campaignSourceEntry.getURI() + ':' + string4 + "\"");
                continue;
            }
            if (string4.startsWith("Cost:")) {
                Logging.errorPrint("Cost deprecated, use COST " + equipment.getName() + ':' + campaignSourceEntry.getURI() + ':' + string4 + "\"");
                equipmentLstToken = (EquipmentLstToken)map.get("COST");
                if (equipmentLstToken.parse(equipment, string3 = string4.substring(n + 1))) continue;
                Logging.errorPrint("Error parsing Equipment " + equipment.getName() + ':' + campaignSourceEntry.getURI() + ':' + string4 + "\"");
                continue;
            }
            if (PObjectLoader.parseTag(equipment, string4)) continue;
            Logging.errorPrint("Illegal Equipment info " + campaignSourceEntry.toString() + ":" + " \"" + string4 + "\"");
        }
        this.completeObject(campaignSourceEntry, equipment);
        return null;
    }

    @Override
    protected void performForget(Equipment equipment) {
        EquipmentList.remove(equipment);
    }
}

