/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.util.Map;
import java.util.StringTokenizer;
import pcgen.core.Domain;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.DomainLstToken;
import pcgen.persistence.lst.LstObjectFileLoader;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.PObjectLoader;
import pcgen.persistence.lst.TokenStore;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainLoader
extends LstObjectFileLoader<Domain> {
    @Override
    public Domain parseLine(Domain domain, String string, CampaignSourceEntry campaignSourceEntry) throws PersistenceLayerException {
        Domain domain2 = domain;
        if (domain2 == null) {
            domain2 = new Domain();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        int n = 0;
        Map<String, LstToken> map = TokenStore.inst().getTokenMap(DomainLstToken.class);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            int n2 = string2.indexOf(58);
            String string3 = "";
            try {
                string3 = string2.substring(0, n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            DomainLstToken domainLstToken = (DomainLstToken)map.get(string3);
            if (domainLstToken != null) {
                String string4 = string2.substring(n2 + 1);
                LstUtils.deprecationCheck(domainLstToken, domain2, string4);
                if (!domainLstToken.parse(domain2, string4)) {
                    Logging.errorPrint("Error parsing domain " + domain2.getDisplayName() + ':' + campaignSourceEntry.getURI() + ':' + string2 + "\"");
                }
            } else {
                if (PObjectLoader.parseTag(domain2, string2)) continue;
                if (n == 0) {
                    if (!string2.equals(domain2.getKeyName()) && string2.indexOf(".MOD") < 0) {
                        this.completeObject(campaignSourceEntry, domain2);
                        domain2 = new Domain();
                        domain2.setName(string2);
                        domain2.setSourceCampaign(campaignSourceEntry.getCampaign());
                        domain2.setSourceURI(campaignSourceEntry.getURI());
                    }
                } else if (n == 1) {
                    LstUtils.deprecationWarning("Positional DESC", "domain", domain2.getSourceURI(), string2, "A DESC tag has been used instead, please update your LST code. This default functionality will be removed in versions after 5.12");
                    domainLstToken = (DomainLstToken)map.get("DESC");
                    if (domainLstToken != null) {
                        LstUtils.deprecationCheck(domainLstToken, domain2, string2);
                        if (!domainLstToken.parse(domain2, string2)) {
                            Logging.errorPrint("Error parsing domain " + domain2.getDisplayName() + ':' + campaignSourceEntry.getURI() + ':' + string2 + "\"");
                        }
                    }
                } else {
                    Logging.errorPrint("Illegal obj info '" + string2 + "' in " + campaignSourceEntry.getURI());
                }
            }
            ++n;
        }
        this.completeObject(campaignSourceEntry, domain2);
        return null;
    }

    @Override
    protected Domain getObjectKeyed(String string) {
        return Globals.getDomainKeyed(string);
    }

    @Override
    protected void performForget(Domain domain) {
        Globals.getDomainList().remove(domain);
    }

    @Override
    protected void addGlobalObject(PObject pObject) {
        Globals.addDomain((Domain)pObject);
    }
}

