/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;
import pcgen.util.enumeration.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbilityToken
extends Token {
    public static final String TOKENNAME = "ABILITY";
    public static final int ABILITY_DEFAULT = 0;
    public static final int ABILITY_VISIBLE = 1;
    public static final int ABILITY_HIDDEN = 2;
    public static final int ABILITY_ALL = 3;
    private List<Ability> abilityList = new ArrayList<Ability>();
    private PlayerCharacter cachedPC = null;
    private int cachedPcSerial = 0;
    private String lastToken = null;
    private AbilityCategory lastCategory = null;
    private int visibility = 0;

    @Override
    public String getTokenName() {
        return TOKENNAME;
    }

    @Override
    public String getToken(String string, PlayerCharacter playerCharacter, ExportHandler exportHandler) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        AbilityCategory abilityCategory = SettingsHandler.getGame().getAbilityCategory(string3);
        return this.getTokenForCategory(string, playerCharacter, exportHandler, stringTokenizer, string2, abilityCategory);
    }

    protected String getTokenForCategory(String string, PlayerCharacter playerCharacter, ExportHandler exportHandler, StringTokenizer stringTokenizer, String string2, AbilityCategory abilityCategory) {
        Object object;
        if (this.cachedPC != playerCharacter || !abilityCategory.equals(this.lastCategory) || this.cachedPcSerial != playerCharacter.getSerial() || !string2.equals(this.lastToken)) {
            this.abilityList = this.getAbilityList(playerCharacter, abilityCategory);
            this.cachedPC = playerCharacter;
            this.lastCategory = abilityCategory;
            this.cachedPcSerial = playerCharacter.getSerial();
            this.lastToken = string2;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Object object2 = null;
        int n = -1;
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            try {
                n = Integer.parseInt((String)object);
                break;
            }
            catch (NumberFormatException numberFormatException) {
                if (((String)object).equals("VISIBLE")) {
                    this.visibility = 1;
                    continue;
                }
                if (((String)object).equals("HIDDEN")) {
                    this.visibility = 2;
                    continue;
                }
                if (((String)object).equals("ALL")) {
                    this.visibility = 3;
                    continue;
                }
                object2 = object;
            }
        }
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            int n2 = ((String)object).indexOf("TYPE");
            if (n2 == -1 || ((String)object).length() <= 4) continue;
            if (n2 > 0) {
                arrayList2.add(((String)object).substring(n2 + 5));
                continue;
            }
            arrayList.add(((String)object).substring(n2 + 5));
        }
        object = AbilityToken.buildAbilityList(arrayList, arrayList2, object2, this.visibility, this.abilityList);
        String string3 = this.getRetString(string, playerCharacter, exportHandler, n, (List<Ability>)object);
        return string3;
    }

    static List<Ability> buildAbilityList(List<String> list, List<String> list2, String string, int n, List<Ability> list3) {
        ArrayList<Ability> arrayList = new ArrayList<Ability>();
        Globals.sortPObjectListByName(list3);
        for (Ability ability : list3) {
            boolean bl = false;
            boolean bl2 = false;
            if (string != null) {
                if (ability.isType(string)) {
                    bl = true;
                }
            } else {
                bl = true;
            }
            boolean bl3 = false;
            boolean bl4 = true;
            if (list.size() > 0) {
                for (String string2 : list) {
                    bl3 |= ability.isType(string2);
                }
            } else {
                bl3 = true;
            }
            for (String string2 : list2) {
                bl4 &= !ability.isType(string2);
            }
            bl = bl && bl3 && bl4;
            switch (n) {
                case 3: {
                    bl2 = true;
                    break;
                }
                case 2: {
                    if (ability.getVisibility() != Visibility.HIDDEN && ability.getVisibility() != Visibility.DISPLAY_ONLY) break;
                    bl2 = true;
                    break;
                }
                default: {
                    if (ability.getVisibility() != Visibility.DEFAULT && ability.getVisibility() != Visibility.OUTPUT_ONLY) break;
                    bl2 = true;
                }
            }
            if (!bl || !bl2) continue;
            arrayList.add(ability);
        }
        return arrayList;
    }

    private String getRetString(String string, PlayerCharacter playerCharacter, ExportHandler exportHandler, int n, List<Ability> list) {
        String string2 = "";
        if (n >= 0 && n < list.size()) {
            Ability ability = list.get(n);
            if (n == list.size() - 1 && exportHandler != null && exportHandler.getExistsOnly()) {
                exportHandler.setNoMoreItems(true);
            }
            if (string.endsWith(".DESC")) {
                string2 = string2 + ability.getDescription(playerCharacter);
            } else if (string.endsWith(".TYPE")) {
                string2 = string2 + ability.getType();
            } else if (string.endsWith(".ASSOCIATED")) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < ability.getAssociatedCount(); ++i) {
                    if (i != 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(ability.getAssociated(i));
                }
                string2 = string2 + stringBuffer.toString();
            } else {
                string2 = string.endsWith(".ASSOCIATEDCOUNT") ? string2 + Integer.toString(ability.getAssociatedCount()) : (string.endsWith(".SOURCE") ? string2 + ability.getDefaultSourceString() : string2 + ability.qualifiedName());
            }
        } else if (exportHandler != null && exportHandler.getExistsOnly()) {
            exportHandler.setNoMoreItems(true);
        }
        return string2;
    }

    protected List<Ability> getAbilityList(PlayerCharacter playerCharacter, AbilityCategory abilityCategory) {
        ArrayList<Ability> arrayList = new ArrayList<Ability>();
        for (Ability ability : playerCharacter.getRealAbilityList(abilityCategory)) {
            arrayList.add(ability);
        }
        return arrayList;
    }

    protected int getVisibility() {
        return this.visibility;
    }

    protected void setVisibility(int n) {
        this.visibility = n;
    }
}

