/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.AbilityToken;
import pcgen.io.exporttoken.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbilityListToken
extends Token {
    private static final String DELIM = ", ";
    private List<Ability> abilityList = null;
    private PlayerCharacter lastPC = null;
    private int lastPCSerial;
    private String lastType = "";
    private AbilityCategory lastCategory = null;
    public static final String TOKENNAME = "ABILITYLIST";

    @Override
    public String getTokenName() {
        return TOKENNAME;
    }

    @Override
    public String getToken(String string, PlayerCharacter playerCharacter, ExportHandler exportHandler) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        AbilityCategory abilityCategory = SettingsHandler.getGame().getAbilityCategory(string3);
        return this.getTokenForCategory(playerCharacter, stringTokenizer, string2, abilityCategory);
    }

    protected String getTokenForCategory(PlayerCharacter playerCharacter, StringTokenizer stringTokenizer, String string, AbilityCategory abilityCategory) {
        int n;
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.lastPC != playerCharacter || !abilityCategory.equals(this.lastCategory) || this.lastPCSerial != playerCharacter.getSerial() || !string.equals(this.lastType)) {
            this.abilityList = this.getAbilityList(playerCharacter, abilityCategory);
            this.lastPC = playerCharacter;
            this.lastCategory = abilityCategory;
            this.lastPCSerial = playerCharacter.getSerial();
            this.lastType = string;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            n = ((String)object).indexOf("TYPE=");
            if (n == -1 || ((String)object).length() <= 5) continue;
            if (n > 0) {
                arrayList2.add(((String)object).substring(n + 5));
                continue;
            }
            arrayList.add(((String)object).substring(n + 5));
        }
        object = AbilityToken.buildAbilityList(arrayList, arrayList2, null, 1, this.abilityList);
        n = 0;
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Ability ability = (Ability)iterator.next();
            if (n != 0) {
                stringBuffer.append(DELIM);
            }
            n = 1;
            stringBuffer.append(ability.qualifiedName());
        }
        return stringBuffer.toString();
    }

    protected List<Ability> getAbilityList(PlayerCharacter playerCharacter, AbilityCategory abilityCategory) {
        ArrayList<Ability> arrayList = new ArrayList<Ability>();
        for (Ability ability : playerCharacter.getRealAbilitiesListAnyCat(abilityCategory)) {
            arrayList.add(ability);
        }
        return arrayList;
    }
}

