/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Ability;
import pcgen.core.AbilityUtilities;
import pcgen.core.Campaign;
import pcgen.core.CharacterDomain;
import pcgen.core.Constants;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.EquipmentList;
import pcgen.core.Globals;
import pcgen.core.NoteItem;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.SpecialAbility;
import pcgen.core.SpecialProperty;
import pcgen.core.character.CharacterSpell;
import pcgen.core.character.EquipSet;
import pcgen.core.character.Follower;
import pcgen.core.character.SpellInfo;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.core.spell.Spell;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.ListKey;
import pcgen.gui.PCGen_Frame1;
import pcgen.io.PCGParseException;
import pcgen.io.PCGParser;
import pcgen.io.parsers.CharacterDomainParser;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.PersistenceManager;
import pcgen.persistence.lst.PCClassLstToken;
import pcgen.persistence.lst.TokenStore;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PCGVer0Parser
implements PCGParser {
    private List<String> warnings = new ArrayList<String>();
    private PlayerCharacter aPC;
    private int ignoreDomainClassLine = 0;
    private int pcgVersion;

    PCGVer0Parser(PlayerCharacter playerCharacter) {
        this.aPC = playerCharacter;
    }

    @Override
    public List<String> getWarnings() {
        return this.warnings;
    }

    @Override
    public void parsePCG(String[] stringArray) throws PCGParseException {
        int n = 0;
        if (stringArray.length == 0) {
            return;
        }
        if (PCGVer0Parser.checkCampaignLine(stringArray[n])) {
            ++n;
        }
        this.pcgVersion = PCGVer0Parser.parseVersionLine(stringArray[n]);
        if (this.pcgVersion > -1) {
            // empty if block
        }
        int n2 = ++n;
        this.parseNameLine(stringArray[n2]);
        int n3 = ++n;
        this.parseStatsLine(stringArray[n3]);
        int n4 = ++n;
        this.parseClassesLine(stringArray[n4]);
        int n5 = ++n;
        this.parseFeatsLine(stringArray[n5]);
        this.parseRaceLine(stringArray[++n + 2]);
        this.parseSkillsLine(stringArray[n++]);
        this.parseDeityLine(stringArray[n++]);
        ++n;
        n = this.parseAutoSpellsLine(stringArray, n);
        n = this.pcgVersion < 272 ? this.parseOldSpellLine(stringArray, n) : this.parseSpellLine(stringArray, n);
        this.parseLanguagesLine(stringArray[n++]);
        int n6 = n++;
        this.parseUnusedPointsLine(stringArray[n++]);
        this.parseMiscLine(stringArray[n++]);
        this.parseEquipmentLine(stringArray[n++]);
        if (this.pcgVersion > 254) {
            this.parsePortraitLine(stringArray[n++]);
        }
        n = this.parseGoldBioDescriptionLine(stringArray, n);
        int n7 = 0;
        Iterator<PCClass> iterator = this.aPC.getClassList().iterator();
        while (iterator.hasNext()) {
            if (++n7 == this.ignoreDomainClassLine) {
                // empty if block
            }
            int n8 = ++n;
            ++n;
            this.parseClassesSkillLine(stringArray[n8]);
            iterator.next();
        }
        if (++n7 == this.ignoreDomainClassLine) {
            ++n;
        }
        n = this.parseExperienceAndMiscLine(stringArray, n);
        if ((n = this.parseClassSpecialtyAndSaveLines(stringArray, n)) < stringArray.length) {
            this.parseTemplateLine(stringArray[n++]);
        }
        n = this.parseEquipSetLine(stringArray, n);
        n = this.parseFollowerLine(stringArray, n);
        n = this.parseNoteLine(stringArray, n);
        this.parseWeaponProfLine(stringArray[n6]);
    }

    private static boolean checkCampaignLine(String string) throws PCGParseException {
        if (string.startsWith("CAMPAIGNS:")) {
            PCGVer0Parser.loadCampaignsForPC(string);
            if (!Globals.displayListsHappy()) {
                Logging.errorPrint("Insufficient campaign information to load character file.");
                throw new PCGParseException("checkCampaignLine", string, "Insufficient campaign information to load character file.");
            }
            return true;
        }
        return false;
    }

    private static void loadCampaignsForPC(String string) throws PCGParseException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":", false);
        String string2 = stringTokenizer.nextToken();
        if ("CAMPAIGNS".equals(string2) && SettingsHandler.isLoadCampaignsWithPC()) {
            Object object;
            ArrayList<Campaign> arrayList = new ArrayList<Campaign>();
            while (stringTokenizer.hasMoreTokens()) {
                object = Globals.getCampaignKeyed(stringTokenizer.nextToken());
                if (object == null || !((Campaign)object).isGameMode(SettingsHandler.getGame().getName()) || ((Campaign)object).isLoaded()) continue;
                arrayList.add((Campaign)object);
            }
            if (arrayList.size() > 0) {
                try {
                    object = PersistenceManager.getInstance();
                    ((PersistenceManager)object).loadCampaigns(arrayList);
                }
                catch (PersistenceLayerException persistenceLayerException) {
                    throw new PCGParseException("loadCampaignsForPC", string, persistenceLayerException.getMessage());
                }
                if (Globals.getUseGUI()) {
                    PCGen_Frame1.getInst().getMainSource().updateLoadedCampaignsUI();
                }
            }
        }
    }

    private static Float parseCarried(Float f, String string) {
        float f2;
        if ("Y".equals(string)) {
            f2 = f.floatValue();
        } else if ("N".equals(string)) {
            f2 = 0.0f;
        } else {
            try {
                f2 = Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                f2 = 0.0f;
            }
        }
        return new Float(f2);
    }

    private static int parseVersionLine(String string) throws PCGParseException {
        int n = -1;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        String string2 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
        String string3 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
        try {
            if ("VERSION".equals(string2)) {
                stringTokenizer = new StringTokenizer(string3, ".");
                n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    n = n * 10 + Integer.parseInt(stringTokenizer.nextToken());
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new PCGParseException("parseVersionLine", string, numberFormatException.getMessage());
        }
        return n;
    }

    private int parseAutoSpellsLine(String[] stringArray, int n) {
        if (n >= stringArray.length) {
            return n;
        }
        if (stringArray[n].startsWith("AUTOSPELLS:NO")) {
            this.aPC.setAutoSpells(false);
            ++n;
        }
        if (stringArray[n].startsWith("AUTOSPELLS:YES")) {
            this.aPC.setAutoSpells(true);
            ++n;
        }
        return n;
    }

    private int parseClassSpecialtyAndSaveLines(String[] stringArray, int n) throws PCGParseException {
        int n2 = n;
        try {
            ListKey<String> listKey = ListKey.SAVE;
            for (int i = 0; i < this.aPC.getClassList().size(); ++i) {
                String string;
                if ((string = stringArray[n2++]) == null) {
                    return n2;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string, ":", true);
                String string2 = stringTokenizer.nextToken();
                PCClass pCClass = this.aPC.getClassKeyed(string2);
                if (pCClass == null || "Domain".equals(pCClass.getKeyName())) continue;
                while (stringTokenizer.hasMoreTokens()) {
                    Object object;
                    Object object2;
                    String string3 = stringTokenizer.nextToken();
                    if (string3.startsWith("SPECIAL")) {
                        pCClass.addSpecialty(string3.substring(7));
                        continue;
                    }
                    if ("Smite Evil".equals(string3) || ":".equals(string3)) continue;
                    if (string3.startsWith("BONUS")) {
                        pCClass.addBonusList(string3.substring(6));
                        if (string3.lastIndexOf("|PCLEVEL|") > -1) {
                            object2 = string3.substring(string3.lastIndexOf("PCLEVEL"));
                            object = new StringTokenizer((String)object2, "|");
                            ((StringTokenizer)object).nextToken();
                            if (((StringTokenizer)object).hasMoreTokens()) {
                                SpecialAbility specialAbility = new SpecialAbility("Bonus Caster Level for " + ((StringTokenizer)object).nextToken());
                                if (this.pcgVersion > 270 && ((StringTokenizer)object).hasMoreTokens()) {
                                    specialAbility.setSASource("PCCLASS|" + pCClass.getKeyName() + "|" + ((StringTokenizer)object).nextToken());
                                }
                                pCClass.addSpecialAbilityToList(specialAbility);
                            }
                        }
                    } else if (!this.aPC.hasSpecialAbility(string3)) {
                        object2 = new SpecialAbility(string3);
                        object = "";
                        if (this.pcgVersion > 270 && stringTokenizer.hasMoreTokens()) {
                            object = stringTokenizer.nextToken();
                        }
                        if (":".equals(object)) {
                            object = "";
                        }
                        pCClass.addSpecialAbilityToList((SpecialAbility)object2);
                    }
                    if (pCClass.containsInList(listKey, string3) && !string3.startsWith("BONUS")) continue;
                    pCClass.addSave(string3);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new PCGParseException("parseClassSpecialtyAndSaveLines", stringArray[n2], numberFormatException.getMessage());
        }
        return n2;
    }

    private void parseClassesLine(String string) throws PCGParseException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        boolean bl = true;
        String string2 = "";
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            int n2;
            String string3;
            String string4;
            if (bl) {
                ++n;
                string4 = stringTokenizer.nextToken();
            } else {
                string4 = string2;
            }
            bl = true;
            if (!stringTokenizer.hasMoreTokens()) break;
            boolean bl2 = true;
            PCClass pCClass = this.aPC.getClassKeyed(string4);
            if (pCClass == null) {
                pCClass = Globals.getClassKeyed(string4);
            } else {
                bl2 = false;
            }
            if (pCClass == null && string4.equalsIgnoreCase("Domain")) {
                Logging.errorPrint("Domain class found and ignored. Please check character to verify conversion is successful.");
                this.ignoreDomainClassLine = n;
            } else if (pCClass == null) {
                string3 = PropertyFactory.getFormattedString("Exceptions.PCGenParser.ClassNotFound", string4);
                throw new PCGParseException("parseClassesLine", string, string3);
            }
            string3 = stringTokenizer.nextToken().trim();
            String string5 = stringTokenizer.nextToken().trim();
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            if (pCClass != null) {
                if (bl2) {
                    pCClass = pCClass.clone();
                    this.aPC.getClassList().add(pCClass);
                }
                pCClass.setSubClassKey(string3);
                PCClassLstToken pCClassLstToken = (PCClassLstToken)TokenStore.inst().getTokenMap(PCClassLstToken.class).get("PROHIBITED");
                pCClassLstToken.parse(pCClass, string5, -9);
            }
            for (n2 = 0; n2 < n3; ++n2) {
                int n4 = Integer.parseInt(stringTokenizer.nextToken());
                if (pCClass == null) continue;
                PCLevelInfo pCLevelInfo = this.aPC.saveLevelInfo(pCClass.getKeyName());
                pCClass.addLevel(pCLevelInfo, false, this.aPC);
                pCClass.setHitPoint(n2, n4);
                this.aPC.saveLevelInfo(pCClass.getKeyName());
            }
            n2 = Integer.parseInt(stringTokenizer.nextToken());
            if (pCClass != null) {
                pCClass.setSkillPool(n2);
            }
            if (!stringTokenizer.hasMoreTokens()) continue;
            string2 = stringTokenizer.nextToken();
            if (SettingsHandler.getGame().getStatFromAbbrev(string2.toUpperCase()) > -1 || string2.equalsIgnoreCase("None") || "Any".equalsIgnoreCase(string2) || "SPELL".equalsIgnoreCase(string2)) {
                if (pCClass == null) continue;
                pCClass.setSpellBaseStat(string2);
                continue;
            }
            bl = false;
        }
        this.aPC.setCurrentHP(this.aPC.hitPoints());
    }

    private void parseClassesSkillLine(String string) {
    }

    private void parseDeityLine(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            switch (n) {
                case 0: {
                    boolean bl = false;
                    for (Deity deity : Globals.getDeityList()) {
                        if (!deity.toString().equals(string2)) continue;
                        this.aPC.setDeity(deity);
                        bl = true;
                        break;
                    }
                    if (bl || string2.equals("None")) break;
                    String string3 = PropertyFactory.getFormattedString("Warnings.PCGenParser.DeityNotFound", string2);
                    this.warnings.add(string3);
                    break;
                }
                default: {
                    String string4;
                    Object object;
                    int n2 = this.aPC.indexOfFirstEmptyCharacterDomain();
                    if (n2 == -1) {
                        object = new CharacterDomain();
                        this.aPC.addCharacterDomain((CharacterDomain)object);
                        n2 = this.aPC.getCharacterDomainList().size() - 1;
                    }
                    if (n2 < 0) break;
                    object = new StringTokenizer(string2, "=", false);
                    String string5 = ((StringTokenizer)object).nextToken();
                    CharacterDomain characterDomain = this.aPC.getCharacterDomainList().get(n2);
                    Domain domain = Globals.getDomainKeyed(string5);
                    if (domain != null) {
                        domain = characterDomain.setDomain(domain, this.aPC);
                        while (((StringTokenizer)object).hasMoreTokens()) {
                            string4 = ((StringTokenizer)object).nextToken();
                            if (string4.startsWith("LIST|")) {
                                domain.addAllToAssociated(CoreUtility.split(string4.substring(5), '|'));
                                continue;
                            }
                            CharacterDomainParser characterDomainParser = new CharacterDomainParser();
                            characterDomainParser.setDomainSource(characterDomain, string4);
                        }
                        domain.setIsLocked(true, this.aPC);
                        break;
                    }
                    if (string5.equals("None")) break;
                    string4 = PropertyFactory.getFormattedString("Warnings.PCGenParser.DomainNotFound", string2);
                    this.warnings.add(string4);
                }
            }
            ++n;
        }
    }

    private int parseEquipSetLine(String[] stringArray, int n) {
        if (n >= stringArray.length) {
            return n;
        }
        String string = stringArray[n];
        while (string.startsWith("EQUIPSET:")) {
            Equipment equipment = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(9), ":", false);
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            EquipSet equipSet = new EquipSet(string2, string3);
            if (stringTokenizer.hasMoreTokens()) {
                Object object;
                String string4 = stringTokenizer.nextToken();
                equipSet.setValue(string4);
                Equipment equipment2 = EquipmentList.getEquipmentNamed(string4);
                if (equipment2 == null) {
                    object = "parseEquipSetLine: equipment not found: " + string4;
                    this.warnings.add((String)object);
                } else {
                    Equipment equipment3 = equipment2.clone();
                    object = new StringTokenizer(string2, ".", false);
                    if (stringTokenizer.hasMoreTokens()) {
                        float f = Float.parseFloat(stringTokenizer.nextToken());
                        Float f2 = new Float(f);
                        equipSet.setQty(f2);
                        equipment3.setQty(f2);
                        equipment3.setNumberCarried(f2);
                    }
                    if (((StringTokenizer)object).countTokens() > 3) {
                        EquipSet equipSet2 = this.aPC.getEquipSetByIdPath(equipSet.getParentIdPath());
                        if (equipSet2 != null) {
                            equipment = equipSet2.getItem();
                        }
                        if (equipment != null) {
                            equipment.insertChild(this.aPC, equipment3);
                            equipment3.setParent(equipment);
                        }
                    }
                    equipSet.setItem(equipment3);
                }
            }
            if (equipSet != null) {
                this.aPC.addEquipSet(equipSet);
            }
            if (++n >= stringArray.length) {
                return n;
            }
            string = stringArray[n];
        }
        return n;
    }

    private void parseEquipmentLine(String string) {
        Equipment equipment;
        String string2;
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList<Equipment> arrayList = new ArrayList<Equipment>();
        while (stringTokenizer.hasMoreTokens()) {
            Object object2;
            boolean bl;
            Object object3;
            String string3;
            Object object4 = stringTokenizer.nextToken().trim();
            object = "";
            if (((String)object4).indexOf(";NAME=") > -1 || ((String)object4).indexOf(";SIZE=") > -1 || ((String)object4).indexOf(";EQMOD=") > -1 || ((String)object4).indexOf(";ALTEQMOD=") > -1 || ((String)object4).indexOf(";SPROP=") > -1 || ((String)object4).indexOf(";COSTMOD=") > -1 || ((String)object4).indexOf(";WEIGHTMOD=") > -1) {
                int n = ((String)object4).indexOf(59);
                string2 = ((String)object4).substring(0, n);
                string3 = ((String)object4).substring(n + 1);
                object3 = EquipmentList.getEquipmentKeyed(string2);
                if (object3 != null) {
                    equipment = ((Equipment)object3).clone();
                    equipment.load(string3, ";", "=", this.aPC);
                    if (!((Equipment)object3).isType("CUSTOM")) {
                        ((Equipment)object3).addMyType("CUSTOM");
                    }
                    EquipmentList.addEquipment(equipment.clone());
                    bl = true;
                } else {
                    equipment = new Equipment();
                    bl = false;
                }
            } else {
                Object object5;
                object2 = new StringTokenizer((String)object4, ";");
                string2 = "";
                string3 = "";
                object3 = "";
                String string4 = "";
                int n = ((StringTokenizer)object2).countTokens();
                if (n >= 4 && n <= 6) {
                    if (n >= 5) {
                        object = ((StringTokenizer)object2).nextToken();
                    }
                    object5 = ((StringTokenizer)object2).nextToken();
                    string2 = ((StringTokenizer)object2).nextToken();
                    string3 = ((StringTokenizer)object2).nextToken();
                    object3 = ((StringTokenizer)object2).nextToken();
                    object4 = object5;
                    if (n == 6) {
                        string4 = ((StringTokenizer)object2).nextToken();
                    }
                }
                if ((object5 = EquipmentList.getEquipmentKeyed((String)object4)) == null) {
                    object5 = EquipmentList.getEquipmentFromName((String)object4, this.aPC);
                }
                bl = true;
                if (object5 == null) {
                    equipment = new Equipment();
                    bl = false;
                } else {
                    equipment = ((Equipment)object5).clone();
                    if (((String)object).length() == 0 && equipment.getEqModifierList(true).size() + equipment.getEqModifierList(false).size() != 0) {
                        object = object4;
                    }
                }
                if (string4.length() != 0) {
                    equipment.addSpecialProperty(SpecialProperty.createFromLst(string4));
                }
                equipment.addEqModifiers(string3, true);
                equipment.addEqModifiers((String)object3, false);
                if (string2.length() != 0 && !equipment.getSize().equals(string2) || equipment.getEqModifierList(true).size() + equipment.getEqModifierList(false).size() != 0 || string4.length() != 0) {
                    if (string2.length() == 0) {
                        string2 = equipment.getSize();
                    }
                    equipment.resizeItem(this.aPC, string2);
                    equipment.nameItemFromModifiers(this.aPC);
                }
                if (bl) {
                    if (((String)object).length() > 0) {
                        equipment.setName((String)object);
                    }
                    EquipmentList.addEquipment(equipment.clone());
                }
            }
            equipment.setQty(stringTokenizer.nextToken());
            if (this.pcgVersion >= 269) {
                equipment.setOutputIndex(Integer.parseInt(stringTokenizer.nextToken()));
            }
            stringTokenizer.nextToken();
            object2 = new StringTokenizer(stringTokenizer.nextToken(), "@", false);
            equipment.setCarried(PCGVer0Parser.parseCarried(new Float(equipment.qty()), ((StringTokenizer)object2).nextToken()));
            if (((StringTokenizer)object2).hasMoreTokens()) {
                hashMap.put(equipment.getKeyName(), ((StringTokenizer)object2).nextToken());
            }
            equipment.setLocation(Equipment.getLocationNum(stringTokenizer.nextToken()));
            if (equipment.getLocation() == 4) {
                equipment.setNumberEquipped(Integer.parseInt(stringTokenizer.nextToken()));
            }
            if (bl) {
                this.aPC.addEquipment(equipment);
                this.aPC.equipmentListAddAll(arrayList);
                continue;
            }
            if (((String)object4).indexOf("Natural/") >= 0) continue;
            string2 = PropertyFactory.getFormattedString("Warnings.PCGenParser.EquipmentNotFound", object4);
            this.warnings.add(string2);
        }
        for (Object object4 : hashMap.keySet()) {
            equipment = this.aPC.getEquipmentNamed((String)object4);
            if (equipment == null) continue;
            string2 = (String)hashMap.get(object4);
            object = this.aPC.getEquipmentNamed(string2);
            if (object != null) {
                ((Equipment)object).insertChild(this.aPC, equipment);
                continue;
            }
            Logging.errorPrint("Container \"" + string2 + "\" not found for \"" + (String)object4 + "\"");
        }
    }

    private int parseExperienceAndMiscLine(String[] stringArray, int n) throws PCGParseException {
        int n2 = n;
        try {
            int n3 = 0;
            boolean bl = true;
            String string = "";
            String string2 = "";
            while (n3 < 6) {
                if (bl) {
                    string = stringArray[n2++];
                }
                int n4 = string.indexOf(58);
                while (n4 > 0 && string.charAt(n4 - 1) == '\\') {
                    n4 = string.indexOf(58, n4 + 1);
                }
                if (n4 < 0 || string.charAt(n4 - 1) == '\\') {
                    n4 = -1;
                }
                if (n4 == -1) {
                    string2 = string2.concat(string);
                    string2 = string2.concat(Constants.s_LINE_SEP);
                    bl = true;
                    if (n3 <= 3) continue;
                    break;
                }
                n4 = string.indexOf(58);
                while (string.charAt(n4 - 1) == '\\') {
                    n4 = string.indexOf(58, n4 + 1);
                }
                string2 = string2.concat(string.substring(0, n4));
                switch (n3) {
                    case 0: {
                        this.aPC.setXP(Integer.parseInt(string2));
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        String string3 = "";
                        for (int i = 0; i < string2.length(); ++i) {
                            if (string2.charAt(i) != '\\') {
                                string3 = string3 + string2.charAt(i);
                                continue;
                            }
                            if (i + 1 >= string2.length() || string2.charAt(i + 1) == ':') continue;
                            string3 = string3 + "\\";
                        }
                        this.aPC.getMiscList().set(n3 - 1, string3.trim());
                        break;
                    }
                    default: {
                        Logging.errorPrint("In PCGVer0Parser.parseExperienceAndMiscLine the i value " + n3 + " is not handled.");
                    }
                }
                if (n3 < 6) {
                    string = string.substring(n4 + 1);
                }
                string2 = "";
                bl = false;
                ++n3;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new PCGParseException("parseExperienceAndMiscLine", stringArray[n2], numberFormatException.getMessage());
        }
        return n2;
    }

    private void parseFeatsLine(String string) throws PCGParseException {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            while (stringTokenizer.hasMoreTokens()) {
                String string2;
                String string3 = stringTokenizer.nextToken().trim();
                if (string3.length() == 0) continue;
                int n = Integer.parseInt(stringTokenizer.nextToken());
                StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "[]");
                Ability ability = Globals.getAbilityKeyed("FEAT", string3 = stringTokenizer2.nextToken());
                if (ability != null) {
                    ability = ability.clone();
                    AbilityUtilities.modFeat(this.aPC, null, ability.getKeyName(), true, !ability.isMultiples());
                    if (ability.isMultiples() && ability.getAssociatedCount() == 0 && this.aPC.getFeatKeyed(ability.getKeyName()) == null) {
                        this.aPC.addFeat(ability, null);
                    }
                    ability = this.aPC.getFeatKeyed(ability.getKeyName());
                    while (stringTokenizer2.hasMoreTokens()) {
                        string2 = stringTokenizer2.nextToken();
                        if (string2.startsWith("BONUS") && string2.length() > 6) {
                            ability.addBonusList(string2.substring(6));
                        }
                        ability.addSave(string2);
                    }
                } else {
                    ability = new Ability();
                }
                for (int i = 0; i < n; ++i) {
                    string2 = stringTokenizer.nextToken();
                    if (string3.endsWith("Weapon Proficiency")) {
                        this.aPC.addWeaponProf(string2);
                        continue;
                    }
                    if ((!ability.isMultiples() || !ability.isStacks()) && ability.containsAssociated(string2)) continue;
                    ability.addAssociated(string2);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new PCGParseException("parseFeatsLine", string, numberFormatException.getMessage());
        }
    }

    private int parseFollowerLine(String[] stringArray, int n) {
        if (n >= stringArray.length) {
            return n;
        }
        String string = stringArray[n];
        while (string.startsWith("FOLLOWER") || string.startsWith("MASTER")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            String string5 = stringTokenizer.nextToken();
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            Follower follower = new Follower(string3, string4, string5);
            follower.setUsedHD(n2);
            if ("FOLLOWER".equals(string2)) {
                this.aPC.addFollower(follower);
            } else if ("MASTER".equals(string2)) {
                this.aPC.setMaster(follower);
            }
            if (++n >= stringArray.length) {
                return n;
            }
            string = stringArray[n];
        }
        return n;
    }

    private int parseGoldBioDescriptionLine(String[] stringArray, int n) throws PCGParseException {
        int n2 = n;
        int n3 = 0;
        try {
            boolean bl = true;
            String string = "";
            String string2 = "";
            while (n3 < 3) {
                if (bl) {
                    string = stringArray[n2++];
                }
                int n4 = string.indexOf(58);
                while (n4 > 0 && string.charAt(n4 - 1) == '\\') {
                    n4 = string.indexOf(58, n4 + 1);
                }
                if (n4 < 0 || n4 > 0 && string.charAt(n4 - 1) == '\\') {
                    n4 = -1;
                }
                if (n4 == -1) {
                    string2 = string2.concat(string);
                    string2 = string2.concat(Constants.s_LINE_SEP);
                    bl = true;
                    continue;
                }
                n4 = string.indexOf(58);
                while (n4 > 0 && string.charAt(n4 - 1) == '\\') {
                    n4 = string.indexOf(58, n4 + 1);
                }
                string2 = string2.concat(string.substring(0, n4));
                String string3 = "";
                for (int i = 0; i < string2.length(); ++i) {
                    if (string2.charAt(i) != '\\') {
                        string3 = string3 + string2.charAt(i);
                        continue;
                    }
                    if (i + 1 >= string2.length() || string2.charAt(i + 1) == ':') continue;
                    string3 = string3 + "\\";
                }
                switch (n3) {
                    case 0: {
                        this.aPC.setGold(string3);
                        break;
                    }
                    case 1: {
                        this.aPC.setBio(string3);
                        break;
                    }
                    case 2: {
                        this.aPC.setDescription(string3);
                        break;
                    }
                    default: {
                        Logging.errorPrint("In PCGVer0Parser.parseGoldBioValue the i value " + n3 + " is not handled.");
                    }
                }
                if (n3 < 3) {
                    string = string.substring(n4 + 1);
                }
                string2 = "";
                bl = false;
                ++n3;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new PCGParseException("parseGoldBioDescriptionLine", Integer.toString(n3) + ":" + stringArray[n2], numberFormatException.getMessage());
        }
        return n2;
    }

    private void parseLanguagesLine(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        while (stringTokenizer.hasMoreTokens()) {
            this.aPC.addLanguageKeyed(stringTokenizer.nextToken());
        }
    }

    private void parseMiscLine(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = CoreUtility.unEscapeColons2(stringTokenizer.nextToken().trim());
            switch (n) {
                case 0: {
                    this.aPC.setEyeColor(string2);
                    break;
                }
                case 1: {
                    this.aPC.setSkinColor(string2);
                    break;
                }
                case 2: {
                    this.aPC.setHairColor(string2);
                    break;
                }
                case 3: {
                    this.aPC.setHairStyle(string2);
                    break;
                }
                case 4: {
                    this.aPC.setSpeechTendency(string2);
                    break;
                }
                case 5: {
                    this.aPC.setPhobias(string2);
                    break;
                }
                case 6: {
                    this.aPC.setInterests(string2);
                    break;
                }
                case 7: {
                    this.aPC.setTrait1(string2);
                    break;
                }
                case 8: {
                    this.aPC.setTrait2(string2);
                    break;
                }
                case 9: {
                    this.aPC.setCatchPhrase(string2);
                    break;
                }
                case 10: {
                    this.aPC.setLocation(string2);
                    break;
                }
                case 11: {
                    this.aPC.setResidence(string2);
                    break;
                }
                default: {
                    Logging.errorPrint("In PCGVer0Parser.parseMiscLine the i value " + n + " is not handled.");
                }
            }
            ++n;
        }
    }

    private void parseNameLine(String string) throws PCGParseException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (!stringTokenizer.hasMoreTokens()) {
            throw new PCGParseException("parseNameLine", string, "No character name found.");
        }
        this.aPC.setName(CoreUtility.unEscapeColons2(stringTokenizer.nextToken()));
        if (stringTokenizer.hasMoreTokens() && stringTokenizer.countTokens() > 1) {
            this.aPC.setTabName(CoreUtility.unEscapeColons2(stringTokenizer.nextToken()));
        }
        if (stringTokenizer.hasMoreTokens()) {
            this.aPC.setPlayersName(CoreUtility.unEscapeColons2(stringTokenizer.nextToken()));
        }
    }

    private int parseNoteLine(String[] stringArray, int n) {
        if (n >= stringArray.length) {
            return n;
        }
        String string = stringArray[n];
        boolean bl = string.startsWith("NOTES:");
        NoteItem noteItem = null;
        while (bl) {
            if (string.startsWith("NOTES:")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string.substring(6), ":", false);
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                int n3 = Integer.parseInt(stringTokenizer.nextToken());
                String string2 = stringTokenizer.nextToken();
                String string3 = "";
                if (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                }
                noteItem = new NoteItem(n2, n3, string2, string3);
                this.aPC.addNotesItem(noteItem);
            } else if (noteItem != null) {
                noteItem.setValue(noteItem.getValue() + Constants.s_LINE_SEP + string);
            }
            if (++n >= stringArray.length) {
                return n;
            }
            string = stringArray[n];
            bl = string != null && !":ENDNOTES:".equals(string);
        }
        return n;
    }

    private int parseOldSpellLine(String[] stringArray, int n) {
        if (n >= stringArray.length) {
            return n;
        }
        String string = stringArray[n];
        while (string.startsWith("SPELL:")) {
            Object object;
            string = string.substring(6);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":", false);
            string = stringArray[++n];
            String string2 = stringTokenizer.nextToken();
            Spell spell = Globals.getSpellKeyed(string2);
            if (spell == null) {
                String string3 = "Unable to find spell keyed: " + string2;
                this.warnings.add(string3);
                continue;
            }
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            String string4 = stringTokenizer.nextToken();
            String string5 = stringTokenizer.nextToken();
            String string6 = stringTokenizer.nextToken();
            PCClass pCClass = this.aPC.getClassKeyed(string5);
            if (pCClass == null) {
                String string7 = "Bad spell info - no class keyed " + string5;
                this.warnings.add(string7);
                continue;
            }
            PObject pObject = this.aPC.getCharacterDomainKeyed(string4);
            if (pObject == null) {
                pObject = pCClass;
            }
            if (pObject == null) {
                String string8 = "Bad spell info - no class or domain named " + string4;
                this.warnings.add(string8);
                continue;
            }
            int n3 = spell.getFirstLevelForKey(pObject.getSpellKey(), this.aPC);
            if (n3 == -1) {
                object = "Bad spell info -" + spell.getKeyName() + " doesn't have valid level info for " + string4;
                this.warnings.add((String)object);
                continue;
            }
            if (string6.equals(Globals.getDefaultSpellBook()) && pCClass.isAutoKnownSpell(spell.getKeyName(), n3, this.aPC)) continue;
            object = pCClass.getSpellSupport().getCharacterSpellForSpell(spell, pCClass);
            if (object == null) {
                object = new CharacterSpell(pCClass, spell);
                ((CharacterSpell)object).addInfo(n3, 1, Globals.getDefaultSpellBook());
                pCClass.getSpellSupport().addCharacterSpell((CharacterSpell)object);
            }
            SpellInfo spellInfo = null;
            if (!string6.equals(Globals.getDefaultSpellBook())) {
                spellInfo = ((CharacterSpell)object).addInfo(n3, n2, string6);
            }
            ArrayList<Ability> arrayList = new ArrayList<Ability>();
            while (stringTokenizer.hasMoreTokens()) {
                String string9 = stringTokenizer.nextToken();
                Ability ability = Globals.getAbilityKeyed("FEAT", string9);
                if (ability == null) continue;
                arrayList.add(ability);
            }
            if (spellInfo != null) {
                spellInfo.addFeatsToList(arrayList);
            }
            this.aPC.addSpellBook(string6);
        }
        return n;
    }

    private void parsePortraitLine(String string) throws PCGParseException {
        if (string == null || !string.startsWith("PORTRAIT:")) {
            throw new PCGParseException("parsePortraitLine", string, "Invalid portrait line ignored.");
        }
        this.aPC.setPortraitPath(string.substring(9));
    }

    private void parseRaceLine(String string) throws PCGParseException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        int n = 0;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        Race race = null;
        int n2 = 0;
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            switch (n2) {
                case 0: {
                    race = Globals.getRaceKeyed(string2);
                    if (race != null) {
                        this.aPC.setRace(race);
                        break;
                    }
                    String string3 = PropertyFactory.getFormattedString("Exceptions.PCGenParser.RaceNotFound", string2);
                    throw new PCGParseException("parseRaceLine", string, string3);
                }
                case 1: {
                    try {
                        this.aPC.setAlignment(Integer.parseInt(string2), true);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new PCGParseException("parseRaceLine", string, numberFormatException.getMessage());
                    }
                }
                case 2: {
                    try {
                        this.aPC.setHeight(Integer.parseInt(string2));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new PCGParseException("parseRaceLine", string, numberFormatException.getMessage());
                    }
                }
                case 3: {
                    try {
                        this.aPC.setWeight(Integer.parseInt(string2));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new PCGParseException("parseRaceLine", string, numberFormatException.getMessage());
                    }
                }
                case 4: {
                    try {
                        this.aPC.setAge(Integer.parseInt(string2));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new PCGParseException("parseRaceLine", string, numberFormatException.getMessage());
                    }
                }
                case 5: {
                    this.aPC.setGender(string2);
                    break;
                }
                case 6: {
                    this.aPC.setHanded(string2);
                    break;
                }
                default: {
                    try {
                        hashMap.put(Integer.toString(n++), Integer.valueOf(string2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new PCGParseException("parseRaceLine", string, numberFormatException.getMessage());
                    }
                    if (race == null || n != race.hitDice(this.aPC)) break;
                    this.aPC.getRace().setHitPointMap(hashMap);
                    return;
                }
            }
            ++n2;
        }
    }

    private void parseSkillsLine(String string) throws PCGParseException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        try {
            while (stringTokenizer.hasMoreElements()) {
                Skill skill;
                int n;
                String string2 = stringTokenizer.nextToken();
                if (!stringTokenizer.hasMoreTokens()) {
                    return;
                }
                Float f = new Float(stringTokenizer.nextToken());
                Integer n2 = this.pcgVersion >= 268 ? Integer.valueOf(stringTokenizer.nextToken()) : Integer.valueOf(0);
                ArrayList<String> arrayList = new ArrayList<String>();
                if (this.pcgVersion >= 2) {
                    int n3 = Integer.parseInt(stringTokenizer.nextToken());
                    for (n = 0; n < n3; ++n) {
                        arrayList.add(stringTokenizer.nextToken() + ":" + stringTokenizer.nextToken());
                    }
                }
                if ((skill = this.aPC.getSkillKeyed(string2)) == null) {
                    for (n = 0; n < Globals.getSkillList().size(); ++n) {
                        if (!string2.equals(Globals.getSkillList().get(n).toString())) continue;
                        skill = Globals.getSkillList().get(n);
                        skill = skill.clone();
                        this.aPC.getSkillList().add(skill);
                        break;
                    }
                }
                if (skill != null) {
                    String string3;
                    for (n = 0; n < arrayList.size(); ++n) {
                        String string4 = (String)arrayList.get(n);
                        int n4 = string4.indexOf(58);
                        Float f2 = new Float(string4.substring(n4 + 1));
                        PCClass pCClass = this.aPC.getClassKeyed(string4.substring(0, n4));
                        if (pCClass != null || string4.substring(0, n4).equals("None")) {
                            string4 = skill.modRanks(f2.doubleValue(), pCClass, true, this.aPC);
                            if (string4.length() == 0) continue;
                            Logging.errorPrint("loadSkillsLine: " + string4);
                            continue;
                        }
                        Logging.errorPrint("Class not found: " + string4.substring(0, n4));
                    }
                    if (this.pcgVersion < 2 && (string3 = skill.modRanks(f.doubleValue(), null, true, this.aPC)).length() != 0) {
                        Logging.errorPrint("loadSkillsLine: " + string3);
                    }
                    skill.setOutputIndex(n2);
                    continue;
                }
                Logging.errorPrint("Skill not found: " + string2);
                if (CoreUtility.doublesEqual(f.doubleValue(), 0.0)) continue;
                String string5 = PropertyFactory.getFormattedString("Warnings.PCGenParser.SkillNotFound", string2, f);
                this.warnings.add(string5);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new PCGParseException("parseSkillsLine", string, numberFormatException.getMessage());
        }
    }

    private int parseSpellLine(String[] stringArray, int n) {
        if (n >= stringArray.length) {
            return n;
        }
        String string = stringArray[n];
        while (string.startsWith("SPELL:")) {
            Object object;
            Object object2;
            Object object3;
            int n2;
            PObject pObject;
            string = string.substring(6);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":", false);
            string = stringArray[++n];
            String object4 = stringTokenizer.nextToken();
            Spell spell = Globals.getSpellKeyed(object4);
            if (spell == null) {
                String string2 = "Unable to find spell named: " + object4;
                this.warnings.add(string2);
                continue;
            }
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            String string5 = stringTokenizer.nextToken();
            String string6 = stringTokenizer.nextToken();
            int n4 = Integer.parseInt(stringTokenizer.nextToken());
            PCClass pCClass = this.aPC.getClassKeyed(string5);
            if (pCClass == null) {
                String n22 = "Bad spell info - no class named " + string5;
                this.warnings.add(n22);
                continue;
            }
            if ("DOMAIN".equals(string3)) {
                pObject = this.aPC.getCharacterDomainKeyed(string4);
                if (pObject == null) {
                    String string7 = "No Domain named " + string4 + " (" + string + ")";
                    this.warnings.add(string7);
                    continue;
                }
            } else {
                pObject = this.aPC.getClassKeyed(string4);
                if (pObject == null) {
                    pObject = pCClass;
                }
            }
            if ((n2 = spell.getFirstLevelForKey(((PObject)pObject).getSpellKey(), this.aPC)) == -1) {
                object3 = "Bad spell info - no spell for " + spell.getKeyName() + " in " + string3 + " " + string4;
                this.warnings.add((String)object3);
                continue;
            }
            if (string6.equals(Globals.getDefaultSpellBook()) && pCClass.isAutoKnownSpell(spell.getKeyName(), n2, this.aPC) && this.aPC.getAutoSpells()) continue;
            object3 = new ArrayList();
            while (stringTokenizer.hasMoreTokens()) {
                object2 = stringTokenizer.nextToken();
                object = Globals.getAbilityKeyed("FEAT", (String)object2);
                if (object == null) continue;
                object3.add(object);
            }
            object2 = pCClass.getSpellSupport().getCharacterSpellForSpell(spell, pCClass);
            if (object2 == null) {
                object2 = new CharacterSpell(pCClass, spell);
                if (!"DOMAIN".equals(string3)) {
                    ((CharacterSpell)object2).addInfo(n2, 1, Globals.getDefaultSpellBook());
                }
                pCClass.getSpellSupport().addCharacterSpell((CharacterSpell)object2);
            }
            object = null;
            if (!(!string4.equals(string5) && string6.equals(Globals.getDefaultSpellBook()) || (object = ((CharacterSpell)object2).getSpellInfoFor(string6, n4, -1)) != null && object3.isEmpty())) {
                object = ((CharacterSpell)object2).addInfo(n4, n3, string6);
            }
            if (object != null && !object3.isEmpty()) {
                ((SpellInfo)object).addFeatsToList((List<Ability>)object3);
            }
            this.aPC.addSpellBook(string6);
            if (n < stringArray.length) continue;
            return n;
        }
        for (PCClass pCClass : this.aPC.getClassList()) {
            pCClass.getSpellSupport().sortCharacterSpellList();
        }
        return n;
    }

    private void parseStatsLine(String string) throws PCGParseException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        int n = 6;
        if (string.startsWith("STATS:")) {
            stringTokenizer.nextToken();
            n = Integer.parseInt(stringTokenizer.nextToken());
        }
        if (n != SettingsHandler.getGame().s_ATTRIBLONG.length) {
            String string2 = "Number of Stats for character is " + n + ". " + "PCGen is currently using " + SettingsHandler.getGame().s_ATTRIBLONG.length + ". " + "Cannot load character.";
            throw new PCGParseException("parseStatsLine", string, string2);
        }
        try {
            for (int i = 0; stringTokenizer.hasMoreTokens() && i < SettingsHandler.getGame().s_ATTRIBLONG.length; ++i) {
                this.aPC.getStatList().getStatAt(i).setBaseScore(Integer.parseInt(stringTokenizer.nextToken()));
            }
            if (stringTokenizer.hasMoreTokens()) {
                this.aPC.setPoolAmount(Integer.parseInt(stringTokenizer.nextToken()));
            }
            if (stringTokenizer.hasMoreTokens()) {
                this.aPC.setCostPool(Integer.parseInt(stringTokenizer.nextToken()));
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new PCGParseException("parseStatsLine", string, numberFormatException.getMessage());
        }
    }

    private void parseTemplateLine(String string) {
        if (string == null) {
            return;
        }
        String string2 = string;
        if (string2.startsWith("TEMPLATE:")) {
            string2 = string2.substring(9);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
        while (stringTokenizer.hasMoreTokens()) {
            PCTemplate pCTemplate = Globals.getTemplateKeyed(stringTokenizer.nextToken());
            if (pCTemplate == null) continue;
            this.aPC.addTemplate(pCTemplate);
        }
    }

    private void parseUnusedPointsLine(String string) throws PCGParseException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        try {
            int n = Integer.parseInt(stringTokenizer.nextToken());
            this.aPC.setSkillPoints(n);
            int n2 = 0;
            for (PCClass pCClass : this.aPC.getClassList()) {
                n2 += pCClass.getSkillPool(this.aPC);
            }
            if (n2 != n) {
                String string2 = "Remaining class skill points incorrect (i.e. " + n2 + " instead of " + n + ")." + Constants.s_LINE_SEP + "Please correct manually on the Skills tab";
                this.warnings.add(string2);
            }
            this.aPC.setFeats(Double.parseDouble(stringTokenizer.nextToken()));
        }
        catch (NumberFormatException numberFormatException) {
            throw new PCGParseException("parseUnusedPointsLine", string, numberFormatException.getMessage());
        }
    }

    private void parseWeaponProfLine(String string) {
        Object object;
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":", false);
        Race race = null;
        PCClass pCClass = null;
        Domain domain = null;
        PObject pObject = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        block6: while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            if (((String)object).startsWith("RACE=")) {
                n = 1;
                race = this.aPC.getRace();
                continue;
            }
            if (((String)object).startsWith("CLASS=")) {
                n = 2;
                object = ((String)object).substring(6);
                pCClass = this.aPC.getClassKeyed((String)object);
                continue;
            }
            if (((String)object).startsWith("DOMAIN=")) {
                n = 3;
                object = ((String)object).substring(7);
                domain = this.aPC.getCharacterDomainKeyed((String)object);
                continue;
            }
            if (((String)object).startsWith("FEAT=")) {
                n = 4;
                object = ((String)object).substring(5);
                pObject = this.aPC.getFeatNamed((String)object);
                continue;
            }
            switch (n) {
                case 1: {
                    if (race == null) continue block6;
                    race.addSelectedWeaponProfBonus((String)object);
                    continue block6;
                }
                case 2: {
                    if (pCClass == null) continue block6;
                    pCClass.addSelectedWeaponProfBonus((String)object);
                    continue block6;
                }
                case 3: {
                    if (domain == null) continue block6;
                    domain.addSelectedWeaponProfBonus((String)object);
                    continue block6;
                }
                case 4: {
                    if (pObject == null) continue block6;
                    pObject.addSelectedWeaponProfBonus((String)object);
                    continue block6;
                }
            }
            arrayList.add(object);
        }
        this.aPC.setAutomaticAbilitiesStable(null, false);
        object = new ArrayList();
        for (String string2 : arrayList) {
            if (this.aPC.hasWeaponProfKeyed(string2)) continue;
            object.add(string2);
        }
        if (object.size() != 0) {
            Object object2 = object.toString();
            object2 = ((String)object2).substring(1, ((String)object2).length() - 1);
            String string2 = "No longer proficient with following weapon(s):" + Constants.s_LINE_SEP + (String)object2;
            this.warnings.add(string2);
        }
    }

    @Override
    public double getBaseFeatPool() {
        return 0.0;
    }

    @Override
    public boolean isCalcFeatPoolAfterLoad() {
        return false;
    }
}

