/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.io.filters.CharacterFilter;
import pcgen.io.filters.OutputFilter;
import pcgen.io.filters.PatternFilter;

public final class FileAccess {
    private static OutputFilter outputFilter = null;
    private static int maxLength = -1;

    public static String filterString(String string) {
        if (null == outputFilter) {
            return string;
        }
        return outputFilter.filterString(string);
    }

    public static void setCurrentOutputFilter(String string) {
        try {
            outputFilter = new PatternFilter(string);
        }
        catch (IOException iOException) {
            outputFilter = new CharacterFilter(string);
        }
    }

    public static void setCurrentOutputFilter(OutputFilter outputFilter) {
        FileAccess.outputFilter = outputFilter;
    }

    public static void encodeWrite(Writer writer, String string) {
        FileAccess.write(writer, FileAccess.filterString(string));
    }

    public static void maxLength(int n) {
        maxLength = n;
    }

    public static void newLine(BufferedWriter bufferedWriter) {
        try {
            bufferedWriter.newLine();
        }
        catch (IOException iOException) {
            ShowMessageDelegate.showMessageDialog(iOException.getMessage(), "PCGen", MessageType.ERROR);
        }
    }

    public static void write(Writer writer, String string) {
        if (string == null) {
            return;
        }
        if (maxLength > 0 && string.length() > maxLength) {
            string = string.substring(0, maxLength);
        }
        try {
            writer.write(string);
        }
        catch (IOException iOException) {
            ShowMessageDelegate.showMessageDialog(iOException.getMessage(), "PCGen", MessageType.ERROR);
        }
    }
}

