/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import pcgen.core.Constants;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.character.CharacterSpell;
import pcgen.core.character.Follower;
import pcgen.core.utils.CoreUtility;
import pcgen.io.FORNode;
import pcgen.io.FileAccess;
import pcgen.io.IIFNode;
import pcgen.io.exporttoken.ACCheckToken;
import pcgen.io.exporttoken.AbilityListToken;
import pcgen.io.exporttoken.AbilityToken;
import pcgen.io.exporttoken.AlignmentToken;
import pcgen.io.exporttoken.AttackToken;
import pcgen.io.exporttoken.BonusToken;
import pcgen.io.exporttoken.CheckToken;
import pcgen.io.exporttoken.DRToken;
import pcgen.io.exporttoken.DomainToken;
import pcgen.io.exporttoken.EqToken;
import pcgen.io.exporttoken.EqTypeToken;
import pcgen.io.exporttoken.GameModeToken;
import pcgen.io.exporttoken.HPToken;
import pcgen.io.exporttoken.HeightToken;
import pcgen.io.exporttoken.InitiativeMiscToken;
import pcgen.io.exporttoken.MovementToken;
import pcgen.io.exporttoken.ReachToken;
import pcgen.io.exporttoken.SRToken;
import pcgen.io.exporttoken.SizeLongToken;
import pcgen.io.exporttoken.SkillToken;
import pcgen.io.exporttoken.SkillpointsToken;
import pcgen.io.exporttoken.SpellFailureToken;
import pcgen.io.exporttoken.StatToken;
import pcgen.io.exporttoken.Token;
import pcgen.io.exporttoken.TotalToken;
import pcgen.io.exporttoken.VarToken;
import pcgen.io.exporttoken.WeaponToken;
import pcgen.io.exporttoken.WeaponhToken;
import pcgen.io.exporttoken.WeightToken;
import pcgen.util.Delta;
import pcgen.util.Logging;
import pcgen.util.enumeration.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExportHandler {
    private static final Float JEP_TRUE = new Float(1.0);
    private static final NumberFormat NUM_FMT = NumberFormat.getInstance();
    private static HashMap<String, Token> tokenMap = new HashMap();
    private static boolean tokenMapPopulated = false;
    private boolean existsOnly = false;
    private boolean noMoreItems = false;
    private boolean manualWhitespace = false;
    private File templateFile;
    private final Map<Object, Object> loopVariables = new HashMap<Object, Object>();
    private String csheetTag2 = "\\";
    private boolean skipMath = false;
    private boolean canWrite = true;
    private boolean checkBefore = false;
    private boolean inLabel = false;

    public ExportHandler(File file) {
        ExportHandler.populateTokenMap();
        this.setTemplateFile(file);
    }

    public void replaceTokenSkipMath(PlayerCharacter playerCharacter, String string, BufferedWriter bufferedWriter) {
        boolean bl = this.skipMath;
        this.skipMath = true;
        this.replaceToken(string, bufferedWriter, playerCharacter);
        this.skipMath = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void write(PlayerCharacter playerCharacter, BufferedWriter bufferedWriter) {
        playerCharacter.setCalcEquipmentList(playerCharacter.getUseTempMods());
        playerCharacter.getSpellList();
        FileAccess.setCurrentOutputFilter(this.templateFile.getName());
        playerCharacter.getAllSkillList(true);
        int n = SettingsHandler.getIncludeSkills();
        if (n == 3) {
            n = SettingsHandler.getSkillsTab_IncludeSkills();
        }
        playerCharacter.populateSkills(n);
        for (PCClass object2 : playerCharacter.getClassList()) {
            object2.getSpellSupport().sortCharacterSpellList();
        }
        playerCharacter.determinePrimaryOffWeapon();
        playerCharacter.modFromArmorOnWeaponRolls();
        playerCharacter.adjustMoveRates();
        playerCharacter.calcActiveBonuses();
        Object object = null;
        try {
            String string;
            object = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.templateFile), "UTF-8"));
            StringBuffer stringBuffer = new StringBuffer();
            while ((string = ((BufferedReader)object).readLine()) != null) {
                if (string.length() == 0) {
                    stringBuffer.append(' ').append(Constants.s_LINE_SEP);
                    continue;
                }
                if (string.indexOf("||") < 0) {
                    stringBuffer.append(string).append(Constants.s_LINE_SEP);
                    continue;
                }
                int n2 = string.indexOf("||");
                while (n2 >= 0) {
                    void iOException;
                    stringBuffer.append(iOException.substring(0, n2)).append("| |");
                    String iOException2 = iOException.substring(n2 + 2);
                    n2 = iOException2.indexOf("||");
                }
                if (iOException.length() > 0) {
                    stringBuffer.append((String)iOException);
                }
                stringBuffer.append(Constants.s_LINE_SEP);
            }
            String iOException = stringBuffer.toString();
            StringTokenizer stringTokenizer = new StringTokenizer(iOException, "\r\n", false);
            FileAccess fileAccess = new FileAccess();
            FORNode fORNode = this.parseFORs(stringTokenizer);
            this.loopVariables.put(null, "0");
            this.existsOnly = false;
            this.noMoreItems = false;
            this.loopFOR(fORNode, 0, 0, 1, bufferedWriter, fileAccess, playerCharacter);
            this.loopVariables.clear();
        }
        catch (IOException iOException) {
            Logging.errorPrint("Error in ExportHandler::write", iOException);
        }
        finally {
            if (object != null) {
                try {
                    ((BufferedReader)object).close();
                }
                catch (IOException iOException) {}
            }
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.flush();
                }
                catch (IOException iOException) {}
            }
        }
        this.csheetTag2 = "\\";
        playerCharacter.setCalcEquipmentList(false);
        playerCharacter.populateSkills(SettingsHandler.getSkillsTab_IncludeSkills());
    }

    public void write(Collection<PlayerCharacter> collection, BufferedWriter bufferedWriter) {
        this.write(collection.toArray(new PlayerCharacter[collection.size()]), bufferedWriter);
    }

    private static boolean isAttackRoutine(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if ("+-".indexOf(string.charAt(i)) > -1) {
                if (n != 0) {
                    return false;
                }
                n = 1;
                continue;
            }
            if ("/".indexOf(string.charAt(i)) > -1) {
                if (n != 2) {
                    return false;
                }
                n = 0;
                continue;
            }
            if (string.charAt(i) >= '0' && string.charAt(i) <= '9') {
                if (n != 1 && n != 2) {
                    return false;
                }
                n = 2;
                continue;
            }
            return false;
        }
        return true;
    }

    public static String getItemDescription(String string, String string2, String string3, PlayerCharacter playerCharacter) {
        if (SettingsHandler.isROG()) {
            if ("EMPTY".equals(playerCharacter.getDescriptionLst())) {
                playerCharacter.loadDescriptionFilesInDirectory("descriptions");
            }
            String string4 = string3;
            String string5 = string.toUpperCase() + ":" + string2 + Constants.s_LINE_SEP;
            int n = playerCharacter.getDescriptionLst().indexOf(string5);
            if (n >= 0) {
                string4 = playerCharacter.getDescriptionLst().substring(n + string5.length());
                string4 = string4.substring(0, string4.indexOf("####") - 1).trim();
            }
            return string4;
        }
        return string3;
    }

    private void setTemplateFile(File file) {
        this.templateFile = file;
    }

    public File getTemplateFile() {
        return this.templateFile;
    }

    private int getVarValue(String string, PlayerCharacter playerCharacter) {
        Object object;
        String string2;
        int n;
        int n2 = -1;
        while ((n2 = string.indexOf("COUNT[EQ", n2 + 1)) >= 0) {
            char c = string.charAt(n2 + 8);
            if (c != '.' && (c < '0' || c > '9') || (n = string.indexOf(93, n2 + 8)) < 0) continue;
            string2 = string.substring(n2 + 6, n);
            if (string2.indexOf("EQTYPE") > -1) {
                object = new EqTypeToken();
                string2 = ((EqTypeToken)object).getToken(string2, playerCharacter, this);
            } else {
                object = new EqToken();
                string2 = ((EqToken)object).getToken(string2, playerCharacter, this);
            }
            string = string.substring(0, n2) + string2 + string.substring(n + 1);
        }
        n2 = -1;
        while ((n2 = string.indexOf("STRLEN[", n2 + 1)) >= 0) {
            n = string.indexOf(93, n2 + 7);
            if (n < 0) continue;
            string2 = string.substring(n2 + 7, n);
            object = new StringWriter();
            BufferedWriter bufferedWriter = new BufferedWriter((Writer)object);
            this.replaceToken(string2, bufferedWriter, playerCharacter);
            ((StringWriter)object).flush();
            try {
                bufferedWriter.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            string2 = ((StringWriter)object).toString();
            string = string.substring(0, n2) + string2.length() + string.substring(n + 1);
        }
        return playerCharacter.getVariableValue(string, "").intValue();
    }

    public static void addToTokenMap(Token token) {
        Token token2 = tokenMap.put(token.getTokenName(), token);
        if (token2 != null) {
            Logging.errorPrint("More than one Output Token has the same Token Name: '" + token.getTokenName() + "'");
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean evaluateExpression(String string, PlayerCharacter playerCharacter) {
        void var5_20;
        Object object;
        ArrayList<PObject> arrayList;
        Object object2;
        String string2;
        Object object322;
        if (string.indexOf(".AND.") > 0) {
            String string4 = string.substring(0, string.indexOf(".AND."));
            String string5 = string.substring(string.indexOf(".AND.") + 5);
            return this.evaluateExpression(string4, playerCharacter) && this.evaluateExpression(string5, playerCharacter);
        }
        if (string.indexOf(".OR.") > 0) {
            String string6 = string.substring(0, string.indexOf(".OR."));
            String string7 = string.substring(string.indexOf(".OR.") + 4);
            return this.evaluateExpression(string6, playerCharacter) || this.evaluateExpression(string7, playerCharacter);
        }
        for (Object object322 : this.loopVariables.keySet()) {
            if (object322 == null) continue;
            String object4 = object322.toString();
            string2 = this.loopVariables.get(object4).toString();
            string = CoreUtility.replaceAll(string, object4, string2);
        }
        if (string.startsWith("HASVAR:")) {
            return playerCharacter.getVariableValue(string = string.substring(7).trim(), "").intValue() > 0;
        }
        if (string.startsWith("HASFEAT:")) {
            return playerCharacter.getFeatNamed(string = string.substring(8).trim()) != null;
        }
        if (string.startsWith("HASSA:")) {
            string = string.substring(6).trim();
            return playerCharacter.hasSpecialAbility(string);
        }
        if (string.startsWith("HASEQUIP:")) {
            return playerCharacter.getEquipmentNamed(string = string.substring(9).trim()) != null;
        }
        if (string.startsWith("SPELLCASTER:")) {
            object2 = string.substring(12).trim();
            if (((String)object2).indexOf(61) >= 0) {
                object322 = new StringTokenizer((String)object2, "=", false);
                int n = Integer.parseInt(((StringTokenizer)object322).nextToken());
                string2 = ((StringTokenizer)object322).nextToken();
                arrayList = playerCharacter.getClassList();
                if (n >= arrayList.size()) {
                    return false;
                }
                object = (PCClass)arrayList.get(n);
                if (string2.equalsIgnoreCase(((PCClass)object).getSpellType())) {
                    return true;
                }
                if (string2.equalsIgnoreCase(((PObject)object).getKeyName())) {
                    return true;
                }
                if (string2.equalsIgnoreCase(((PCClass)object).getCastAs())) {
                    return true;
                }
                if ("!Prepare".equalsIgnoreCase(string2) && ((PCClass)object).getMemorizeSpells()) {
                    return true;
                }
                if ("Prepare".equalsIgnoreCase(string2) && !((PCClass)object).getMemorizeSpells()) {
                    return true;
                }
            } else {
                for (PCClass string22 : playerCharacter.getClassList()) {
                    if (((String)object2).equalsIgnoreCase(string22.getSpellType())) {
                        return true;
                    }
                    if (((String)object2).equalsIgnoreCase(string22.getKeyName())) {
                        return true;
                    }
                    if (((String)object2).equalsIgnoreCase(string22.getCastAs())) {
                        return true;
                    }
                    if ("!Prepare".equalsIgnoreCase((String)object2) && string22.getMemorizeSpells()) {
                        return true;
                    }
                    if (!"Prepare".equalsIgnoreCase((String)object2) || string22.getMemorizeSpells()) continue;
                    return true;
                }
            }
        }
        if (string.startsWith("EVEN:")) {
            int n = 0;
            try {
                n = Integer.parseInt(string.substring(5).trim());
            }
            catch (NumberFormatException numberFormatException) {
                Logging.errorPrint("EVEN:" + n);
                return true;
            }
            return n % 2 == 0;
        }
        if (string.endsWith("UNTRAINED")) {
            void var5_17;
            int n;
            object2 = new StringTokenizer(string, ".");
            object322 = ((StringTokenizer)object2).nextToken();
            Object var5_15 = null;
            if (((String)object322).length() > 5 && (n = Integer.parseInt(((String)object322).substring(5))) <= (arrayList = playerCharacter.getSkillListInOutputOrder()).size() - 1) {
                Skill skill = (Skill)arrayList.get(n);
            }
            if (var5_17 == null) {
                return false;
            }
            return var5_17.isUntrained();
        }
        object2 = playerCharacter.getVariableProcessor().getJepOnlyVariableValue(null, string, "", 0);
        if (object2 != null) {
            return ((Float)object2).equals(JEP_TRUE);
        }
        object322 = new StringTokenizer(string, ":");
        int n = ((StringTokenizer)object322).countTokens();
        if (n == 1) {
            String string3 = string;
            string2 = "TRUE";
        } else {
            if (n != 2) {
                Logging.errorPrint("evaluateExpression: Incorrect syntax (missing parameter)");
                return false;
            }
            String string4 = ((StringTokenizer)object322).nextToken();
            string2 = ((StringTokenizer)object322).nextToken().toUpperCase();
        }
        object = new StringWriter();
        BufferedWriter bufferedWriter = new BufferedWriter((Writer)object);
        this.replaceToken((String)var5_20, bufferedWriter, playerCharacter);
        ((StringWriter)object).flush();
        try {
            bufferedWriter.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string5 = ((StringWriter)object).toString();
        if (var5_20.startsWith("VAR.")) {
            string5 = var5_20.substring(4);
            string5 = playerCharacter.getVariableValue(var5_20.substring(4), "").toString();
        }
        try {
            int n2 = Integer.parseInt(string5);
            return n2 == Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return string5.toUpperCase().indexOf(string2) >= 0;
        }
    }

    private void evaluateIIF(IIFNode iIFNode, BufferedWriter bufferedWriter, FileAccess fileAccess, PlayerCharacter playerCharacter) {
        String string = CoreUtility.replaceAll(iIFNode.expr(), ";", ",");
        if (this.evaluateExpression(string, playerCharacter)) {
            this.evaluateIIFChildren(iIFNode.trueChildren(), bufferedWriter, fileAccess, playerCharacter);
        } else {
            this.evaluateIIFChildren(iIFNode.falseChildren(), bufferedWriter, fileAccess, playerCharacter);
        }
    }

    private void evaluateIIFChildren(List<?> list, BufferedWriter bufferedWriter, FileAccess fileAccess, PlayerCharacter playerCharacter) {
        for (int i = 0; i < list.size(); ++i) {
            String string;
            String string2;
            Object object;
            if (list.get(i) instanceof FORNode) {
                object = (FORNode)list.get(i);
                this.loopVariables.put(((FORNode)object).var(), 0);
                this.existsOnly = ((FORNode)object).exists();
                Object object2 = ((FORNode)object).min();
                Object object3 = ((FORNode)object).max();
                string2 = ((FORNode)object).step();
                for (Object object4 : this.loopVariables.keySet()) {
                    if (object4 == null) continue;
                    string = object4.toString();
                    String string3 = this.loopVariables.get(string).toString();
                    object2 = CoreUtility.replaceAll((String)object2, string, string3);
                    object3 = CoreUtility.replaceAll((String)object3, string, string3);
                    string2 = CoreUtility.replaceAll(string2, string, string3);
                }
                this.loopFOR((FORNode)object, this.getVarValue((String)object2, playerCharacter), this.getVarValue((String)object3, playerCharacter), this.getVarValue(string2, playerCharacter), bufferedWriter, fileAccess, playerCharacter);
                this.existsOnly = ((FORNode)object).exists();
                this.loopVariables.remove(((FORNode)object).var());
                continue;
            }
            if (list.get(i) instanceof IIFNode) {
                this.evaluateIIF((IIFNode)list.get(i), bufferedWriter, fileAccess, playerCharacter);
                continue;
            }
            object = (String)list.get(i);
            for (Object object3 : this.loopVariables.keySet()) {
                if (object3 == null) continue;
                string2 = object3.toString();
                string = this.loopVariables.get(string2).toString();
                object = CoreUtility.replaceAll((String)object, string2, string);
            }
            this.replaceLine((String)object, bufferedWriter, playerCharacter);
            if (!this.canWrite || this.manualWhitespace) continue;
            FileAccess.newLine(bufferedWriter);
        }
    }

    private void loopFOR(FORNode fORNode, int n, int n2, int n3, BufferedWriter bufferedWriter, FileAccess fileAccess, PlayerCharacter playerCharacter) {
        if (n3 < 0) {
            for (int i = n; i >= n2; i += n3) {
                boolean bl = this.processLoop(fORNode, bufferedWriter, fileAccess, playerCharacter, i);
                if (!bl) continue;
                i = n2 - 1;
            }
        } else {
            for (int i = n; i <= n2; i += n3) {
                boolean bl = this.processLoop(fORNode, bufferedWriter, fileAccess, playerCharacter, i);
                if (!bl) continue;
                i = n2 + 1;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean processLoop(FORNode fORNode, BufferedWriter bufferedWriter, FileAccess fileAccess, PlayerCharacter playerCharacter, int n) {
        this.loopVariables.put(fORNode.var(), n);
        for (int i = 0; i < fORNode.children().size(); ++i) {
            String string;
            String string2;
            Object object;
            if (fORNode.children().get(i) instanceof FORNode) {
                void var9_11;
                object = (FORNode)fORNode.children().get(i);
                this.loopVariables.put(((FORNode)object).var(), 0);
                this.existsOnly = ((FORNode)object).exists();
                Object object2 = ((FORNode)object).min();
                String string3 = ((FORNode)object).max();
                string2 = ((FORNode)object).step();
                for (Object object3 : this.loopVariables.keySet()) {
                    if (object3 == null) continue;
                    string = object3.toString();
                    String string4 = this.loopVariables.get(string).toString();
                    object2 = CoreUtility.replaceAll((String)object2, string, string4);
                    String string5 = CoreUtility.replaceAll((String)var9_11, string, string4);
                    string2 = CoreUtility.replaceAll(string2, string, string4);
                }
                int n2 = this.getVarValue((String)object2, playerCharacter);
                int n3 = this.getVarValue((String)var9_11, playerCharacter);
                int n4 = this.getVarValue(string2, playerCharacter);
                this.loopFOR((FORNode)object, n2, n3, n4, bufferedWriter, fileAccess, playerCharacter);
                this.existsOnly = fORNode.exists();
                this.loopVariables.remove(((FORNode)object).var());
                continue;
            }
            if (fORNode.children().get(i) instanceof IIFNode) {
                this.evaluateIIF((IIFNode)fORNode.children().get(i), bufferedWriter, fileAccess, playerCharacter);
                continue;
            }
            object = (String)fORNode.children().get(i);
            for (Object e : this.loopVariables.keySet()) {
                if (e == null) continue;
                string2 = e.toString();
                string = this.loopVariables.get(string2).toString();
                object = CoreUtility.replaceAll((String)object, string2, string);
            }
            this.noMoreItems = false;
            this.replaceLine((String)object, bufferedWriter, playerCharacter);
            if (this.canWrite && !this.manualWhitespace) {
                FileAccess.newLine(bufferedWriter);
            }
            if (!this.existsOnly || !this.noMoreItems) continue;
            return true;
        }
        return false;
    }

    private String mathMode(String string, PlayerCharacter playerCharacter) {
        int n;
        Float f = new Float(0.0);
        while (string.lastIndexOf(40) >= 0) {
            int n2 = CoreUtility.innerMostStringStart(string);
            int n3 = CoreUtility.innerMostStringEnd(string);
            if (n3 < n2) break;
            String string2 = string.substring(n2 + 1, n3);
            if (n2 > 0 && string.charAt(n2 - 1) == ' ' && (string.charAt(n3 + 1) == '.' || n3 == string.length() - 1)) {
                string = string.substring(0, n2) + "[" + string2 + "]" + string.substring(n3 + 1);
                continue;
            }
            string = string.substring(0, n2) + this.mathMode(string2, playerCharacter) + string.substring(n3 + 1);
        }
        string = CoreUtility.replaceAll(string, "[", "(");
        string = CoreUtility.replaceAll(string, "]", ")");
        Object object = "";
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        Object object2 = "";
        for (n = 0; n < string.length(); ++n) {
            Object object3;
            Object object4;
            Object object5;
            object = (String)object + string.substring(n, n + 1);
            if (n != string.length() - 1 && ("+-/*".lastIndexOf(string.charAt(n)) <= -1 || n <= 0 || string.charAt(n - 1) == '.')) continue;
            if ("+-/*".lastIndexOf(string.charAt(n)) > -1) {
                object = ((String)object).substring(0, ((String)object).length() - 1);
            }
            if (n < string.length()) {
                if (((String)object).endsWith(".TRUNC")) {
                    if (bl) {
                        Logging.errorPrint("Math Mode Error: Using .TRUNC in Attack Mode.");
                    } else {
                        object = String.valueOf(Float.valueOf(this.mathMode(((String)object).substring(0, ((String)object).length() - 6), playerCharacter)).intValue());
                    }
                }
                if (((String)object).endsWith(".INTVAL")) {
                    if (bl) {
                        Logging.errorPrint("Math Mode Error: Using .INTVAL in Attack Mode.");
                    } else {
                        object = this.mathMode(((String)object).substring(0, ((String)object).length() - 7), playerCharacter);
                    }
                    n6 = 1;
                }
                if (((String)object).endsWith(".SIGN")) {
                    object = this.mathMode(((String)object).substring(0, ((String)object).length() - 5), playerCharacter);
                    n6 = 2;
                }
                if (((String)object).endsWith(".NOZERO")) {
                    object = this.mathMode(((String)object).substring(0, ((String)object).length() - 7), playerCharacter);
                    n6 = 3;
                }
                if (string.length() > 0 && string.charAt(n) == '+') {
                    n5 = 0;
                } else if (string.length() > 0 && string.charAt(n) == '-') {
                    n5 = 1;
                } else if (string.length() > 0 && string.charAt(n) == '*') {
                    n5 = 2;
                } else if (string.length() > 0 && string.charAt(n) == '/') {
                    n5 = 3;
                }
                object5 = new StringWriter();
                object4 = new BufferedWriter((Writer)object5);
                this.replaceTokenSkipMath(playerCharacter, (String)object, (BufferedWriter)object4);
                ((StringWriter)object5).flush();
                try {
                    ((BufferedWriter)object4).flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                object3 = ((StringWriter)object5).toString();
                try {
                    object = String.valueOf(Float.parseFloat((String)object3));
                }
                catch (NumberFormatException numberFormatException) {
                    object = object3;
                }
                if (!bl && ExportHandler.isAttackRoutine((String)object)) {
                    bl = true;
                    object2 = object;
                    object = "";
                }
            }
            try {
                if (((String)object).length() > 0) {
                    if (bl) {
                        object5 = new StringTokenizer((String)object2, "/");
                        object4 = "";
                        if (((StringTokenizer)object5).countTokens() > 0) {
                            block22: while (((StringTokenizer)object5).hasMoreTokens()) {
                                object3 = ((StringTokenizer)object5).nextToken();
                                switch (n4) {
                                    case 0: {
                                        object4 = (String)object4 + "/+" + Integer.toString(new Float(Float.parseFloat((String)object3) + Float.parseFloat((String)object)).intValue());
                                        continue block22;
                                    }
                                    case 1: {
                                        object4 = (String)object4 + "/+" + Integer.toString(new Float(Float.parseFloat((String)object3) - Float.parseFloat((String)object)).intValue());
                                        continue block22;
                                    }
                                    case 2: {
                                        object4 = (String)object4 + "/+" + Integer.toString(new Float(Float.parseFloat((String)object3) * Float.parseFloat((String)object)).intValue());
                                        continue block22;
                                    }
                                    case 3: {
                                        object4 = (String)object4 + "/+" + Integer.toString(new Float(Float.parseFloat((String)object3) / Float.parseFloat((String)object)).intValue());
                                        continue block22;
                                    }
                                }
                                Logging.errorPrint("In mathMode the mode " + n4 + " is unsupported.");
                            }
                            object2 = CoreUtility.replaceAll(((String)object4).substring(1), "+-", "-");
                        }
                    } else {
                        switch (n4) {
                            case 0: {
                                f = new Float(f.doubleValue() + Double.parseDouble((String)object));
                                break;
                            }
                            case 1: {
                                f = new Float(f.doubleValue() - Double.parseDouble((String)object));
                                break;
                            }
                            case 2: {
                                f = new Float(f.doubleValue() * Double.parseDouble((String)object));
                                break;
                            }
                            case 3: {
                                f = new Float(f.doubleValue() / Double.parseDouble((String)object));
                                break;
                            }
                            default: {
                                Logging.errorPrint("In mathMode the mode " + n4 + " is unsupported.");
                            }
                        }
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                object4 = new StringWriter();
                object3 = new BufferedWriter((Writer)object4);
                this.replaceTokenSkipMath(playerCharacter, string, (BufferedWriter)object3);
                ((StringWriter)object4).flush();
                try {
                    ((BufferedWriter)object3).flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return ((StringWriter)object4).toString();
            }
            n4 = n5;
            n5 = 0;
            object = "";
        }
        if (bl) {
            return object2;
        }
        if (n6 == 1) {
            return Integer.toString(f.intValue());
        }
        if (n6 == 2) {
            return Delta.toString(f.intValue());
        }
        if (n6 == 3) {
            n = f.intValue();
            if (n == 0) {
                return "";
            }
            return Delta.toString(n);
        }
        return f.toString();
    }

    private void outputNonToken(String string, BufferedWriter bufferedWriter) {
        if (!this.canWrite) {
            return;
        }
        if (string.length() > 0) {
            if (this.manualWhitespace) {
                string = string.replaceAll("[ \\t]", "");
            }
            FileAccess.write(bufferedWriter, string);
        }
    }

    private FORNode parseFORs(StringTokenizer stringTokenizer) {
        FORNode fORNode = new FORNode(null, "0", "0", "1", true);
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string = stringTokenizer.nextToken();
            if (string.startsWith("|FOR")) {
                object = new StringTokenizer(string, ",");
                if (((StringTokenizer)object).countTokens() > 1) {
                    ((StringTokenizer)object).nextToken();
                    if (((StringTokenizer)object).nextToken().startsWith("%")) {
                        fORNode.addChild(this.parseFORs(string, stringTokenizer));
                        continue;
                    }
                    fORNode.addChild(string);
                    continue;
                }
                fORNode.addChild(string);
                continue;
            }
            if (string.startsWith("|IIF(") && string.lastIndexOf(44) < 0) {
                object = string.substring(5, string.lastIndexOf(41));
                fORNode.addChild(this.parseIIFs((String)object, stringTokenizer));
                continue;
            }
            fORNode.addChild(string);
        }
        return fORNode;
    }

    private FORNode parseFORs(String string, StringTokenizer stringTokenizer) {
        List<String> list = ExportHandler.getParameters(string);
        String string2 = list.get(1);
        String string3 = list.get(2);
        String string4 = list.get(3);
        String string5 = list.get(4);
        String string6 = list.get(5);
        boolean bl = false;
        if (string6.length() > 0 && string6.charAt(0) == '1' || string6.length() > 0 && string6.charAt(0) == '2') {
            bl = true;
        }
        FORNode fORNode = new FORNode(string2, string3, string4, string5, bl);
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string7 = stringTokenizer.nextToken();
            if (string7.startsWith("|FOR")) {
                object = new StringTokenizer(string7, ",");
                ((StringTokenizer)object).nextToken();
                if (((StringTokenizer)object).nextToken().startsWith("%")) {
                    fORNode.addChild(this.parseFORs(string7, stringTokenizer));
                    continue;
                }
                fORNode.addChild(string7);
                continue;
            }
            if (string7.startsWith("|IIF(") && string7.lastIndexOf(44) < 0) {
                object = string7.substring(5, string7.lastIndexOf(41));
                fORNode.addChild(this.parseIIFs((String)object, stringTokenizer));
                continue;
            }
            if (string7.startsWith("|ENDFOR|")) {
                return fORNode;
            }
            fORNode.addChild(string7);
        }
        return fORNode;
    }

    public static List<String> getParameters(String string) {
        String[] stringArray = string.split(",");
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (String string2 : stringArray) {
            if (string2.indexOf("(") >= 0 && string2.indexOf(")") < string2.indexOf("(")) {
                bl = true;
                stringBuffer.append(string2);
                continue;
            }
            if (bl && string2.indexOf(")") >= 0) {
                bl = false;
                stringBuffer.append(",");
                stringBuffer.append(string2);
                arrayList.add(stringBuffer.toString());
                stringBuffer = new StringBuffer();
                continue;
            }
            if (bl) {
                stringBuffer.append(",");
                stringBuffer.append(string2);
                continue;
            }
            arrayList.add(string2);
        }
        return arrayList;
    }

    private IIFNode parseIIFs(String string, StringTokenizer stringTokenizer) {
        IIFNode iIFNode = new IIFNode(string);
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("|FOR")) {
                object = new StringTokenizer(string2, ",");
                ((StringTokenizer)object).nextToken();
                if (((StringTokenizer)object).nextToken().startsWith("%")) {
                    if (bl) {
                        iIFNode.addTrueChild(this.parseFORs(string2, stringTokenizer));
                        continue;
                    }
                    iIFNode.addFalseChild(this.parseFORs(string2, stringTokenizer));
                    continue;
                }
                if (bl) {
                    iIFNode.addTrueChild(string2);
                    continue;
                }
                iIFNode.addFalseChild(string2);
                continue;
            }
            if (string2.startsWith("|IIF(") && string2.lastIndexOf(44) < 0) {
                object = string2.substring(5, string2.lastIndexOf(41));
                if (bl) {
                    iIFNode.addTrueChild(this.parseIIFs((String)object, stringTokenizer));
                    continue;
                }
                iIFNode.addFalseChild(this.parseIIFs((String)object, stringTokenizer));
                continue;
            }
            if (string2.startsWith("|ELSE|")) {
                bl = false;
                continue;
            }
            if (string2.startsWith("|ENDIF|")) {
                return iIFNode;
            }
            if (bl) {
                iIFNode.addTrueChild(string2);
                continue;
            }
            iIFNode.addFalseChild(string2);
        }
        return iIFNode;
    }

    private static void populateTokenMap() {
        if (!tokenMapPopulated) {
            ExportHandler.addToTokenMap(new AbilityToken());
            ExportHandler.addToTokenMap(new AbilityListToken());
            ExportHandler.addToTokenMap(new ACCheckToken());
            ExportHandler.addToTokenMap(new AlignmentToken());
            ExportHandler.addToTokenMap(new AttackToken());
            ExportHandler.addToTokenMap(new BonusToken());
            ExportHandler.addToTokenMap(new CheckToken());
            ExportHandler.addToTokenMap(new DomainToken());
            ExportHandler.addToTokenMap(new DRToken());
            ExportHandler.addToTokenMap(new EqToken());
            ExportHandler.addToTokenMap(new EqTypeToken());
            ExportHandler.addToTokenMap(new GameModeToken());
            ExportHandler.addToTokenMap(new HeightToken());
            ExportHandler.addToTokenMap(new HPToken());
            ExportHandler.addToTokenMap(new InitiativeMiscToken());
            ExportHandler.addToTokenMap(new MovementToken());
            ExportHandler.addToTokenMap(new ReachToken());
            ExportHandler.addToTokenMap(new SizeLongToken());
            ExportHandler.addToTokenMap(new SkillToken());
            ExportHandler.addToTokenMap(new SkillpointsToken());
            ExportHandler.addToTokenMap(new SpellFailureToken());
            ExportHandler.addToTokenMap(new SRToken());
            ExportHandler.addToTokenMap(new StatToken());
            ExportHandler.addToTokenMap(new TotalToken());
            ExportHandler.addToTokenMap(new VarToken());
            ExportHandler.addToTokenMap(new WeaponToken());
            ExportHandler.addToTokenMap(new WeaponhToken());
            ExportHandler.addToTokenMap(new WeightToken());
            tokenMapPopulated = true;
        }
    }

    private void replaceLine(String string, BufferedWriter bufferedWriter, PlayerCharacter playerCharacter) {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer("");
        if (!bl && string.lastIndexOf(124) < 0) {
            if (string.length() > 0) {
                this.outputNonToken(string, bufferedWriter);
            }
        } else if (bl && string.lastIndexOf(124) < 0 || !bl && string.lastIndexOf(124) == 0) {
            stringBuffer.append(string.substring(string.lastIndexOf(124) + 1));
            bl = true;
        } else {
            StringTokenizer stringTokenizer;
            boolean bl2;
            if (!bl && string.charAt(0) == '|') {
                bl = true;
            }
            boolean bl3 = bl2 = (stringTokenizer = new StringTokenizer(string, "|", false)).countTokens() == 1;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (!bl) {
                    this.outputNonToken(string2, bufferedWriter);
                } else if (stringTokenizer.hasMoreTokens() || bl2 || bl && !stringTokenizer.hasMoreTokens() && string.charAt(string.length() - 1) == '|') {
                    this.replaceToken(stringBuffer.toString() + string2, bufferedWriter, playerCharacter);
                    stringBuffer = new StringBuffer("");
                } else {
                    stringBuffer.append(string2);
                }
                if (!stringTokenizer.hasMoreTokens() && !bl2) continue;
                bl = !bl;
            }
            if (bl && string.charAt(string.length() - 1) == '|') {
                bl = false;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public int replaceToken(String string, BufferedWriter bufferedWriter, PlayerCharacter playerCharacter) {
        try {
            int n = 1;
            if (!this.canWrite && string.length() > 0 && string.charAt(0) != '%') {
                return 0;
            }
            if ("%".equals(string)) {
                this.inLabel = false;
                this.canWrite = true;
                return 0;
            }
            FileAccess.maxLength(-1);
            if (string.length() > 0 && string.charAt(0) == '%' && string.length() > 1 && string.lastIndexOf(60) < 0 && string.lastIndexOf(62) < 0) {
                StringTokenizer stringTokenizer;
                boolean bl = false;
                this.canWrite = true;
                int n2 = 0;
                if (string.indexOf("MERGENONE") > 0) {
                    n2 = 1;
                }
                if (string.indexOf("MERGELOC") > 0) {
                    n2 = 2;
                }
                if (string.substring(1).startsWith("GAMEMODE:")) {
                    if (string.substring(10).endsWith(GameModeToken.getGameModeToken())) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if ("REGION".equals(string.substring(1))) {
                    if (playerCharacter.getRegion().equals("None")) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if ("NOTES".equals(string.substring(1))) {
                    if (playerCharacter.getNotesList().size() <= 0) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if ("SKILLPOINTS".equals(string.substring(1))) {
                    if (SkillpointsToken.getUnusedSkillPoints(playerCharacter) == 0) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if (string.substring(1).startsWith("TEMPLATE")) {
                    int n3;
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string.substring(1), ".");
                    ArrayList<PCTemplate> arrayList = playerCharacter.getTemplateList();
                    String string2 = stringTokenizer2.nextToken();
                    if (stringTokenizer2.hasMoreTokens()) {
                        n3 = Integer.parseInt(stringTokenizer2.nextToken());
                    } else {
                        if ("TEMPLATE".equals(string2)) {
                            if (arrayList.isEmpty()) {
                                this.canWrite = false;
                            }
                            return 0;
                        }
                        Logging.errorPrint("Old syntax %TEMPLATEx will be replaced for %TEMPLATE.x");
                        n3 = Integer.parseInt(string.substring(9));
                    }
                    if (n3 >= arrayList.size()) {
                        this.canWrite = false;
                        return 0;
                    }
                    PCTemplate pCTemplate = (PCTemplate)arrayList.get(n3);
                    if (pCTemplate.getVisibility() != Visibility.DEFAULT && pCTemplate.getVisibility() != Visibility.OUTPUT_ONLY) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if ("FOLLOWER".equals(string.substring(1))) {
                    if (playerCharacter.getFollowerList().isEmpty()) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if ("FOLLOWEROF".equals(string.substring(1))) {
                    if (playerCharacter.getMasterPC() == null) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if (string.substring(1).startsWith("FOLLOWERTYPE.")) {
                    ArrayList<Follower> arrayList = new ArrayList<Follower>();
                    for (Follower object2 : playerCharacter.getFollowerList()) {
                        for (PlayerCharacter playerCharacter2 : Globals.getPCList()) {
                            if (!playerCharacter2.getFileName().equals(object2.getFileName())) continue;
                            arrayList.add(object2);
                        }
                    }
                    StringTokenizer stringTokenizer3 = new StringTokenizer(string, ".");
                    stringTokenizer3.nextToken();
                    String n5 = stringTokenizer3.nextToken();
                    for (int i = arrayList.size() - 1; i >= 0; --i) {
                        Follower follower = (Follower)arrayList.get(i);
                        if (follower.getType().equalsIgnoreCase(n5)) continue;
                        arrayList.remove(i);
                    }
                    if (arrayList.isEmpty()) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if ("PROHIBITEDLIST".equals(string.substring(1))) {
                    for (PCClass pCClass : playerCharacter.getClassList()) {
                        if (pCClass.getLevel() <= 0 || pCClass.getProhibitedSchools() == null) continue;
                        return 0;
                    }
                    this.canWrite = false;
                    return 0;
                }
                if ("CATCHPHRASE".equals(string.substring(1))) {
                    if (playerCharacter.getCatchPhrase().equals("None")) {
                        this.canWrite = false;
                    } else if (playerCharacter.getCatchPhrase().trim().length() == 0) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if ("LOCATION".equals(string.substring(1))) {
                    if (playerCharacter.getLocation().equals("None")) {
                        this.canWrite = false;
                    } else if (playerCharacter.getLocation().trim().length() == 0) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if ("RESIDENCE".equals(string.substring(1))) {
                    if (playerCharacter.getResidence().equals("None")) {
                        this.canWrite = false;
                    } else if (playerCharacter.getResidence().trim().length() == 0) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if ("PHOBIAS".equals(string.substring(1))) {
                    if (playerCharacter.getPhobias().equals("None")) {
                        this.canWrite = false;
                    } else if (playerCharacter.getPhobias().trim().length() == 0) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if ("INTERESTS".equals(string.substring(1))) {
                    if (playerCharacter.getInterests().equals("None")) {
                        this.canWrite = false;
                    } else if (playerCharacter.getInterests().trim().length() == 0) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if ("SPEECHTENDENCY".equals(string.substring(1))) {
                    if (playerCharacter.getSpeechTendency().equals("None")) {
                        this.canWrite = false;
                    } else if (playerCharacter.getSpeechTendency().trim().length() == 0) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if ("PERSONALITY1".equals(string.substring(1))) {
                    if (playerCharacter.getTrait1().equals("None")) {
                        this.canWrite = false;
                    } else if (playerCharacter.getTrait1().trim().length() == 0) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if ("PERSONALITY2".equals(string.substring(1))) {
                    if (playerCharacter.getTrait2().equals("None")) {
                        this.canWrite = false;
                    } else if (playerCharacter.getTrait2().trim().length() == 0) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if ("MISC.FUNDS".equals(string.substring(1))) {
                    if (playerCharacter.getMiscList().get(0).equals("None")) {
                        this.canWrite = false;
                    } else if (playerCharacter.getMiscList().get(0).trim().length() == 0) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if ("COMPANIONS".equals(string.substring(1)) || "MISC.COMPANIONS".equals(string.substring(1))) {
                    if (playerCharacter.getMiscList().get(1).equals("None")) {
                        this.canWrite = false;
                    } else if (playerCharacter.getMiscList().get(1).trim().length() == 0) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if ("MISC.MAGIC".equals(string.substring(1))) {
                    if (playerCharacter.getMiscList().get(2).equals("None")) {
                        this.canWrite = false;
                    } else if (playerCharacter.getMiscList().get(2).trim().length() == 0) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if ("DESC".equals(string.substring(1))) {
                    if (playerCharacter.getDescription().equals("None")) {
                        this.canWrite = false;
                    } else if (playerCharacter.getDescription().trim().length() == 0) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if ("BIO".equals(string.substring(1))) {
                    if (playerCharacter.getBio().equals("None")) {
                        this.canWrite = false;
                    } else if (playerCharacter.getBio().trim().length() == 0) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if ("SUBREGION".equals(string.substring(1))) {
                    if (playerCharacter.getSubRegion().equals("None")) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if (string.substring(1).startsWith("TEMPBONUS.")) {
                    stringTokenizer = new StringTokenizer(string.substring(1), ".");
                    int n4 = -1;
                    stringTokenizer.nextToken();
                    if (stringTokenizer.hasMoreTokens()) {
                        n4 = Integer.parseInt(stringTokenizer.nextToken());
                    }
                    if (n4 > playerCharacter.getNamedTempBonusList().size()) {
                        this.canWrite = false;
                        return 0;
                    }
                    if (playerCharacter.getUseTempMods()) {
                        this.canWrite = true;
                        return 1;
                    }
                }
                if (string.substring(1).startsWith("ARMOR.ITEM")) {
                    void n8;
                    stringTokenizer = new StringTokenizer(string.substring(1), ".");
                    stringTokenizer.nextToken();
                    String string3 = stringTokenizer.nextToken();
                    ArrayList<Equipment> arrayList = new ArrayList<Equipment>();
                    for (Equipment equipment : playerCharacter.getEquipmentListInOutputOrder()) {
                        if (!equipment.getBonusListString("AC") || equipment.isArmor() || equipment.isShield()) continue;
                        arrayList.add(equipment);
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        int n6 = Integer.parseInt(stringTokenizer.nextToken());
                    } else {
                        Logging.errorPrint("Old syntax %ARMOR.ITEMx will be replaced for %ARMOR.ITEM.x");
                        int n7 = Integer.parseInt(string3.substring(string3.length() - 1));
                    }
                    if (n8 > arrayList.size()) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if (string.substring(1).startsWith("ARMOR.SHIELD")) {
                    void var9_37;
                    stringTokenizer = new StringTokenizer(string.substring(1), ".");
                    stringTokenizer.nextToken();
                    String string4 = stringTokenizer.nextToken();
                    List<Equipment> list = playerCharacter.getEquipmentOfTypeInOutputOrder("SHIELD", 3);
                    if (stringTokenizer.hasMoreTokens()) {
                        int n9 = Integer.parseInt(stringTokenizer.nextToken());
                    } else {
                        Logging.errorPrint("Old syntax %ARMOR.SHIELDx will be replaced for %ARMOR.SHIELD.x");
                        int stringTokenizer4 = Integer.parseInt(string4.substring(string4.length() - 1));
                    }
                    if (var9_37 > list.size()) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if (string.substring(1).startsWith("ARMOR")) {
                    void var9_40;
                    stringTokenizer = new StringTokenizer(string.substring(1), ".");
                    String string5 = stringTokenizer.nextToken();
                    List<Equipment> list = playerCharacter.getEquipmentOfTypeInOutputOrder("ARMOR", 3);
                    List<Equipment> list2 = playerCharacter.getEquipmentOfTypeInOutputOrder("SHIELD", 3);
                    for (int i = 0; i < list2.size(); ++i) {
                        list.remove(list2.get(i));
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        int n4 = Integer.parseInt(stringTokenizer.nextToken());
                    } else {
                        Logging.errorPrint("Old syntax %ARMORx will be replaced for %ARMOR.x");
                        int n5 = Integer.parseInt(string5.substring(string5.length() - 1));
                    }
                    if (var9_40 > list.size()) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if ("WEAPONPROF".equals(string.substring(1))) {
                    if (!SettingsHandler.getWeaponProfPrintout()) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if (string.substring(1).startsWith("WEAPON")) {
                    void var9_44;
                    stringTokenizer = new StringTokenizer(string.substring(1), ".");
                    String string6 = stringTokenizer.nextToken();
                    boolean bl2 = false;
                    List<Equipment> list = playerCharacter.getExpandedWeapons(n2);
                    if (stringTokenizer.hasMoreTokens()) {
                        int n6 = Integer.parseInt(stringTokenizer.nextToken());
                    } else {
                        Logging.errorPrint("Old syntax %WEAPONx will be replaced for %WEAPON.x");
                        int n7 = Integer.parseInt(string6.substring(string6.length() - 1));
                    }
                    if (var9_44 >= list.size()) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if (string.substring(1).startsWith("DOMAIN")) {
                    void var9_47;
                    stringTokenizer = new StringTokenizer(string.substring(1), ".");
                    String string7 = stringTokenizer.nextToken();
                    if (stringTokenizer.hasMoreTokens()) {
                        int n8 = Integer.parseInt(stringTokenizer.nextToken());
                    } else {
                        Logging.errorPrint("Old syntax %DOMAINx will be replaced for %DOMAIN.x");
                        int n9 = Integer.parseInt(string7.substring(6));
                    }
                    this.canWrite = var9_47 <= playerCharacter.getCharacterDomainList().size();
                    return 0;
                }
                if (string.substring(1).startsWith("SPELLLISTBOOK")) {
                    if (SettingsHandler.getPrintSpellsWithPC()) {
                        string = string.charAt(14) == '.' ? string.substring(15) : string.substring(14);
                        return this.replaceTokenSpellListBook(string, playerCharacter);
                    }
                    this.canWrite = false;
                    return 0;
                }
                if (string.substring(1).startsWith("VAR.")) {
                    this.replaceTokenVar(string, playerCharacter);
                    return 0;
                }
                if (string.substring(1).startsWith("COUNT[")) {
                    if (this.getVarValue(string.substring(1), playerCharacter) > 0) {
                        this.canWrite = true;
                        return 1;
                    }
                    this.canWrite = false;
                    return 0;
                }
                stringTokenizer = new StringTokenizer(string.substring(1), ",", false);
                while (stringTokenizer.hasMoreTokens()) {
                    PCClass pCClass;
                    String string8 = stringTokenizer.nextToken();
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string8, "=", false);
                    String string2 = stringTokenizer2.nextToken();
                    int n10 = 0;
                    if (stringTokenizer2.hasMoreTokens()) {
                        n10 = Integer.parseInt(stringTokenizer2.nextToken());
                    }
                    boolean bl3 = bl = (pCClass = playerCharacter.getClassKeyed(string2)) != null;
                    if (pCClass != null) {
                        this.canWrite = pCClass.getLevel() >= n10;
                    } else if (pCClass == null) {
                        this.canWrite = false;
                    }
                    if (!string2.startsWith("SPELLLISTCLASS")) continue;
                    string2 = string2.charAt(14) == '.' ? string2.substring(15) : string2.substring(14);
                    bl = true;
                    PObject pObject = playerCharacter.getSpellClassAtIndex(Integer.parseInt(string2));
                    this.canWrite = pObject != null;
                }
                if (bl) {
                    this.inLabel = true;
                    return 0;
                }
                this.canWrite = false;
                this.inLabel = true;
                return 0;
            }
            if (string.indexOf("SUB") == 0 && string.indexOf(".") > 3) {
                int n11 = string.indexOf(".");
                int n12 = -1;
                try {
                    n12 = Integer.parseInt(string.substring(3, n11));
                }
                catch (NumberFormatException numberFormatException) {
                    Logging.errorPrint("Number format error: " + string);
                    n12 = -1;
                }
                if (n12 > 0) {
                    string = string.substring(n11 + 1);
                    FileAccess.maxLength(n12);
                }
            }
            ExportHandler.populateTokenMap();
            string = this.correctOldFormatTag(string);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".,", false);
            String string10 = stringTokenizer.nextToken();
            String string11 = string;
            if (string11.indexOf(44) > -1) {
                string11 = string11.substring(0, string11.indexOf(44));
            }
            if (string11.indexOf(126) > -1) {
                string11 = string11.substring(0, string11.indexOf(126));
            }
            if (string.startsWith("FOR.") || string.startsWith("DFOR.")) {
                FileAccess.maxLength(-1);
                this.existsOnly = false;
                this.noMoreItems = false;
                this.checkBefore = false;
                this.replaceTokenForDfor(string, bufferedWriter, playerCharacter);
                this.existsOnly = false;
                this.noMoreItems = false;
                return 0;
            }
            if (string.startsWith("OIF(")) {
                this.replaceTokenOIF(string, bufferedWriter, playerCharacter);
            } else {
                if (!(string11.indexOf(40) < 0 && string11.indexOf(43) < 0 && string11.indexOf(45) < 0 && string11.indexOf(".INTVAL") < 0 && string11.indexOf(".SIGN") < 0 && string11.indexOf(".NOZERO") < 0 && string11.indexOf(".TRUNC") < 0 && string11.indexOf(42) < 0 && string11.indexOf(47) < 0 || this.skipMath)) {
                    FileAccess.maxLength(-1);
                    FileAccess.write(bufferedWriter, this.mathMode(string, playerCharacter));
                    return 0;
                }
                if (string.startsWith("CSHEETTAG2.")) {
                    this.csheetTag2 = string.substring(11, 12);
                    FileAccess.maxLength(-1);
                    return 0;
                }
                if (tokenMap.get(string10) != null) {
                    Token token = tokenMap.get(string10);
                    if (token.isEncoded()) {
                        FileAccess.encodeWrite(bufferedWriter, token.getToken(string, playerCharacter, this));
                    } else {
                        FileAccess.write(bufferedWriter, token.getToken(string, playerCharacter, this));
                    }
                } else {
                    n = string.trim().length();
                    if (this.manualWhitespace) {
                        string = string.replaceAll("[ \\t]", "");
                        if (n > 0) {
                            FileAccess.write(bufferedWriter, string);
                        }
                    } else {
                        FileAccess.write(bufferedWriter, string);
                    }
                }
            }
            FileAccess.maxLength(-1);
            return n;
        }
        catch (Exception exception) {
            Logging.errorPrint("Error replacing " + string, exception);
            return 0;
        }
    }

    private String correctOldFormatTag(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.startsWith("SPELLIST")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            String string2 = stringTokenizer.nextToken();
            if (string2.charAt(string2.length() - 1) >= '0' && string2.charAt(string2.length() - 1) <= '9') {
                if (string.regionMatches(9, "TYPE", 0, 4) || string.regionMatches(9, "BOOK", 0, 4) || string.regionMatches(9, "CAST", 0, 4)) {
                    stringBuffer.append(string.substring(0, 14));
                    stringBuffer.append('.');
                    stringBuffer.append(string.substring(14));
                } else if (string.regionMatches(9, "KNOWN", 0, 5) || string.regionMatches(9, "CLASS", 0, 5)) {
                    stringBuffer.append(string.substring(0, 15));
                    stringBuffer.append('.');
                    stringBuffer.append(string.substring(15));
                } else if (string.regionMatches(9, "DCSTAT", 0, 6)) {
                    stringBuffer.append(string.substring(0, 16));
                    stringBuffer.append('.');
                    stringBuffer.append(string.substring(16));
                } else if (string.regionMatches(9, "DC", 0, 2)) {
                    stringBuffer.append(string.substring(0, 12));
                    stringBuffer.append('.');
                    stringBuffer.append(string.substring(12));
                }
            }
        } else if (string.startsWith("SPELLMEM")) {
            if (string.length() > 8 && string.charAt(8) != '.') {
                stringBuffer.append(string.substring(0, 8));
                stringBuffer.append('.');
                stringBuffer.append(string.substring(8));
            }
        } else if (string.startsWith("SKILLSUBSET")) {
            if (string.length() > 11 && string.charAt(11) != '.') {
                stringBuffer.append(string.substring(0, 11));
                stringBuffer.append('.');
                stringBuffer.append(string.substring(11));
            }
        } else if (string.startsWith("SKILLTYPE")) {
            if (string.length() > 9 && string.charAt(9) != '.' && string.charAt(9) != '=') {
                stringBuffer.append(string.substring(0, 9));
                stringBuffer.append('.');
                stringBuffer.append(string.substring(9));
            }
        } else if (!(!string.startsWith("SKILL") || string.startsWith("SKILLLEVEL") || string.startsWith("SKILLLISTMODS") || string.startsWith("SKILLPOINTS") || string.startsWith("SKILLSUBSET") || string.startsWith("SKILLTYPE"))) {
            if (string.length() > 5 && string.charAt(5) != '.' && string.charAt(5) != '(') {
                stringBuffer.append(string.substring(0, 5));
                stringBuffer.append('.');
                stringBuffer.append(string.substring(5));
            }
        } else if (string.startsWith("FOLLOWER") && !string.startsWith("FOLLOWERLIST") && !string.startsWith("FOLLOWEROF") && !string.startsWith("FOLLOWERTYPE") && string.length() > 8 && string.charAt(8) != '.' && string.charAt(8) != '(') {
            stringBuffer.append(string.substring(0, 8));
            stringBuffer.append('.');
            stringBuffer.append(string.substring(8));
        }
        if (stringBuffer.length() > 0) {
            Logging.errorPrint("Old syntax '" + string + "' replaced with '" + stringBuffer.toString() + "'.");
            return stringBuffer.toString();
        }
        return string;
    }

    private void replaceTokenForDfor(String string, BufferedWriter bufferedWriter, PlayerCharacter playerCharacter) {
        int n = 0;
        int n2 = 0;
        StringTokenizer stringTokenizer = string.startsWith("DFOR.") ? new StringTokenizer(string.substring(5), ",", false) : new StringTokenizer(string.substring(4), ",", false);
        int n3 = 0;
        int n4 = 100;
        int n5 = 1;
        int n6 = 1;
        int n7 = 0;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        boolean bl = false;
        block9: while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            switch (n2++) {
                case 0: {
                    n3 = this.getVarValue(string5, playerCharacter);
                    continue block9;
                }
                case 1: {
                    n4 = this.getVarValue(string5, playerCharacter);
                    continue block9;
                }
                case 2: {
                    n5 = this.getVarValue(string5, playerCharacter);
                    if (!string.startsWith("DFOR.")) continue block9;
                    bl = true;
                    string5 = stringTokenizer.nextToken();
                    n7 = this.getVarValue(string5, playerCharacter);
                    string5 = stringTokenizer.nextToken();
                    n6 = this.getVarValue(string5, playerCharacter);
                    continue block9;
                }
                case 3: {
                    string2 = string5;
                    continue block9;
                }
                case 4: {
                    string3 = string5;
                    continue block9;
                }
                case 5: {
                    string4 = string5;
                    continue block9;
                }
                case 6: {
                    boolean bl2 = this.existsOnly = !"0".equals(string5);
                    if (!"2".equals(string5)) continue block9;
                    this.checkBefore = true;
                    continue block9;
                }
            }
            Logging.errorPrint("ExportHandler.replaceTokenForDfor can't handle token number " + n2);
        }
        if ("COMMA".equals(string3)) {
            string3 = ",";
        }
        if ("COMMA".equals(string4)) {
            string4 = ",";
        }
        if ("NONE".equals(string3)) {
            string3 = "";
        }
        if ("NONE".equals(string4)) {
            string4 = "";
        }
        if ("CRLF".equals(string3)) {
            string3 = Constants.s_LINE_SEP;
        }
        if ("CRLF".equals(string4)) {
            string4 = Constants.s_LINE_SEP;
        }
        for (int i = n3; i < n4; i += n5) {
            if (n++ == 0) {
                FileAccess.write(bufferedWriter, string3);
            }
            int n8 = i;
            if (!bl) {
                n7 = n8 + n5;
            }
            if (n7 > n4 && !bl) {
                n7 = n4;
            }
            while (n8 < n7 || bl && n8 < n4) {
                boolean bl3 = false;
                if (string2.startsWith(this.csheetTag2)) {
                    bl3 = true;
                }
                stringTokenizer = new StringTokenizer(string2, this.csheetTag2, false);
                int n9 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    int n10;
                    String string6 = stringTokenizer.nextToken();
                    String string7 = "";
                    String string8 = string6;
                    int n11 = 0;
                    while (string8.indexOf(37, n11) > 0 && (n11 = string8.indexOf(37, n11)) != -1) {
                        if (n11 < string8.length() - 1 && string8.charAt(n11 + 1) != '.') {
                            ++n11;
                            continue;
                        }
                        String string9 = string8.substring(0, n11);
                        if (n11 + 1 < string6.length()) {
                            string7 = string8.substring(n11 + 1);
                        }
                        string8 = string9 + Integer.toString(n8) + string7;
                    }
                    if ("%0".equals(string6) || "%1".equals(string6)) {
                        n10 = n8 + Integer.parseInt(string6.substring(1));
                        FileAccess.write(bufferedWriter, Integer.toString(n10));
                    } else if (bl3) {
                        this.replaceToken(string8, bufferedWriter, playerCharacter);
                    } else {
                        n10 = this.skipMath ? 1 : 0;
                        this.skipMath = true;
                        this.replaceToken(string8, bufferedWriter, playerCharacter);
                        this.skipMath = n10;
                    }
                    if (this.checkBefore && this.noMoreItems) {
                        n8 = n4;
                        i = n4;
                        if (n9 != 0) break;
                        this.existsOnly = false;
                        break;
                    }
                    ++n9;
                    bl3 = !bl3;
                }
                n8 += n6;
                if (n6 != 0) continue;
                break;
            }
            if (n6 <= 0 && (n6 != 0 || n != n5) && this.existsOnly != this.noMoreItems) continue;
            FileAccess.write(bufferedWriter, string4);
            n = 0;
            if (!this.existsOnly || !this.noMoreItems) continue;
            return;
        }
    }

    private void replaceTokenOIF(String string, BufferedWriter bufferedWriter, PlayerCharacter playerCharacter) {
        int n;
        int n2 = 0;
        String[] stringArray = new String[3];
        int n3 = 0;
        block5: for (int i = n = 4; i < string.length() && n3 != 3; ++i) {
            switch (string.charAt(i)) {
                case '(': {
                    ++n2;
                    continue block5;
                }
                case ')': {
                    if (--n2 != -1) continue block5;
                    if (n3 == 2) {
                        stringArray[n3++] = string.substring(n, i).trim();
                        n = i + 1;
                        continue block5;
                    }
                    Logging.errorPrint("OIF: not enough parameters (" + Integer.toString(n3) + ')');
                    for (int j = 0; j < n3; ++j) {
                        Logging.errorPrint("  " + Integer.toString(j) + ':' + stringArray[j]);
                    }
                    continue block5;
                }
                case ',': {
                    if (n2 != 0) continue block5;
                    if (n3 < 2) {
                        stringArray[n3] = string.substring(n, i).trim();
                        n = i + 1;
                    } else {
                        Logging.errorPrint("IIF: too many parameters");
                    }
                    ++n3;
                    continue block5;
                }
            }
        }
        if (n3 != 3) {
            Logging.errorPrint("OIF: invalid parameter count: " + n3);
        } else {
            string = string.substring(n);
            n = 2;
            if (this.evaluateExpression(stringArray[0], playerCharacter)) {
                n = 1;
            }
            FileAccess.write(bufferedWriter, stringArray[n]);
        }
        if (string.length() > 0) {
            Logging.errorPrint("OIF: extra characters on line: " + string);
            FileAccess.write(bufferedWriter, string);
        }
    }

    private int replaceTokenSpellListBook(String string, PlayerCharacter playerCharacter) {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        int n3 = Integer.parseInt(stringTokenizer.nextToken());
        if (stringTokenizer.hasMoreTokens()) {
            n = Integer.parseInt(stringTokenizer.nextToken());
        }
        String string2 = Globals.getDefaultSpellBook();
        if (n > 0) {
            string2 = playerCharacter.getSpellBooks().get(n);
        }
        this.canWrite = false;
        PObject pObject = playerCharacter.getSpellClassAtIndex(n2);
        if (pObject != null) {
            List<CharacterSpell> list = pObject.getSpellSupport().getCharacterSpell(null, string2, n3);
            this.canWrite = !list.isEmpty();
        }
        return 0;
    }

    private void replaceTokenVar(String string, PlayerCharacter playerCharacter) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(5), ".", false);
        String string2 = stringTokenizer.nextToken();
        String string3 = "EQ";
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        String string4 = "0";
        if (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
        }
        Float f = playerCharacter.getVariable(string2, true, true, "", "", 0);
        Float f2 = playerCharacter.getVariableValue(string4, "");
        this.canWrite = "GTEQ".equals(string3) ? f.doubleValue() >= f2.doubleValue() : ("GT".equals(string3) ? f.doubleValue() > f2.doubleValue() : ("LTEQ".equals(string3) ? f.doubleValue() <= f2.doubleValue() : ("LT".equals(string3) ? f.doubleValue() < f2.doubleValue() : ("NEQ".equals(string3) ? !CoreUtility.doublesEqual(f.doubleValue(), f2.doubleValue()) : !CoreUtility.doublesEqual(f.doubleValue(), f2.doubleValue())))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(PlayerCharacter[] playerCharacterArray, BufferedWriter bufferedWriter) {
        FileAccess.setCurrentOutputFilter(this.templateFile.getName());
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.templateFile), "UTF-8"));
            boolean bl = false;
            StringBuffer stringBuffer = new StringBuffer();
            while ((string = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer;
                boolean bl2;
                if (!bl && string.lastIndexOf(124) < 0) {
                    if (this.manualWhitespace) {
                        string = string.replaceAll("[ \\t]", "");
                    }
                    FileAccess.write(bufferedWriter, string);
                    if (this.manualWhitespace) continue;
                    FileAccess.newLine(bufferedWriter);
                    continue;
                }
                if (bl && string.lastIndexOf(124) < 0 || !bl && string.lastIndexOf(124) == 0) {
                    stringBuffer.append(string.substring(string.lastIndexOf(124) + 1));
                    bl = true;
                    continue;
                }
                if (!bl && string.charAt(0) == '|') {
                    bl = true;
                }
                boolean bl3 = bl2 = (stringTokenizer = new StringTokenizer(string, "|", false)).countTokens() == 1;
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (!bl) {
                        if (this.manualWhitespace) {
                            string2 = string2.replaceAll("[ \\t]", "");
                        }
                        FileAccess.write(bufferedWriter, string2);
                    } else if (stringTokenizer.hasMoreTokens() || bl2) {
                        int n;
                        String string3 = stringBuffer.toString() + string2;
                        if (string3.startsWith("FOR.")) {
                            int n2 = 0;
                            int n3 = 0;
                            PStringTokenizer pStringTokenizer = new PStringTokenizer(string3.substring(4), ",", "\\\\", "\\\\");
                            Integer n4 = 0;
                            Integer n5 = 100;
                            Integer n6 = 1;
                            String string4 = "";
                            String string5 = "";
                            String string6 = "";
                            string2 = null;
                            boolean bl4 = false;
                            boolean bl5 = false;
                            block22: while (pStringTokenizer.hasMoreTokens()) {
                                string2 = pStringTokenizer.nextToken();
                                switch (n3++) {
                                    case 0: {
                                        n4 = Delta.decode(string2);
                                        continue block22;
                                    }
                                    case 1: {
                                        n5 = Delta.decode(string2);
                                        continue block22;
                                    }
                                    case 2: {
                                        n6 = Delta.decode(string2);
                                        continue block22;
                                    }
                                    case 3: {
                                        string4 = string2;
                                        continue block22;
                                    }
                                    case 4: {
                                        string5 = string2;
                                        continue block22;
                                    }
                                    case 5: {
                                        string6 = string2;
                                        continue block22;
                                    }
                                    case 6: {
                                        bl4 = !"0".equals(string2);
                                        continue block22;
                                    }
                                }
                                Logging.errorPrint("In Party.print there is an unhandled case in a switch (the value is " + n3 + ".");
                            }
                            if (n5 >= playerCharacterArray.length && bl4) {
                                n5 = playerCharacterArray.length;
                            }
                            for (int i = n4.intValue(); i < n5; ++i) {
                                if (n2++ == 0) {
                                    Logging.errorPrint("Outputing A '" + string2 + "'.");
                                    FileAccess.write(bufferedWriter, string5);
                                }
                                String string7 = string4;
                                while (string7.length() > 0) {
                                    String string8 = "";
                                    for (int j = 0; j < string7.length() - 1; ++j) {
                                        if (string7.charAt(j) != '\\' || string7.charAt(j + 1) != '\\') continue;
                                        string8 = string7.substring(0, j);
                                        string7 = string7.substring(j + 2);
                                        break;
                                    }
                                    if ("".equals(string8)) {
                                        string8 = string7;
                                        string7 = "";
                                    }
                                    if (string8.startsWith("%.")) {
                                        n = i;
                                        if (n >= 0 && n < playerCharacterArray.length) {
                                            PlayerCharacter playerCharacter = playerCharacterArray[n];
                                            Globals.setCurrentPC(playerCharacter);
                                            if (playerCharacter != null) {
                                                this.replaceToken(string8.substring(2), bufferedWriter, playerCharacter);
                                                continue;
                                            }
                                            bl5 = true;
                                            continue;
                                        }
                                        bl5 = true;
                                        continue;
                                    }
                                    Logging.errorPrint("Outputing B '" + string8 + "'.");
                                    FileAccess.write(bufferedWriter, string8);
                                }
                                if (n2 != n6 && bl4 != bl5) continue;
                                Logging.errorPrint("Outputing C '" + string6 + "'.");
                                FileAccess.write(bufferedWriter, string6);
                                n2 = 0;
                                if (bl4 != bl5) {
                                    continue;
                                }
                                break;
                            }
                        } else {
                            int n7;
                            n = -1;
                            for (n7 = 0; n7 < string3.length() && string3.charAt(n7) >= '0' && string3.charAt(n7) <= '9'; ++n7) {
                            }
                            if (n7 > 0) {
                                n = Delta.parseInt(string3.substring(0, n7));
                            }
                            if (n >= 0 && n < Globals.getPCList().size()) {
                                PlayerCharacter playerCharacter = playerCharacterArray[n];
                                Globals.setCurrentPC(playerCharacter);
                                this.replaceToken(string3, bufferedWriter, playerCharacter);
                            } else if (string3.startsWith("EXPORT")) {
                                this.replaceToken(string3, bufferedWriter, null);
                            }
                        }
                        stringBuffer = new StringBuffer("");
                    } else {
                        stringBuffer.append(string2);
                    }
                    if (!stringTokenizer.hasMoreTokens() && !bl2) continue;
                    bl = !bl;
                }
                if (!bl || string.charAt(string.length() - 1) != '|') continue;
                bl = false;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public final void setCanWrite(boolean bl) {
        this.canWrite = bl;
    }

    public final boolean getCheckBefore() {
        return this.checkBefore;
    }

    public final boolean getInLabel() {
        return this.inLabel;
    }

    public final boolean getExistsOnly() {
        return this.existsOnly;
    }

    public final void setNoMoreItems(boolean bl) {
        this.noMoreItems = bl;
    }

    public final boolean isManualWhitespace() {
        return this.manualWhitespace;
    }

    public final void setManualWhitespace(boolean bl) {
        this.manualWhitespace = bl;
    }

    public static final String getTokenString(PlayerCharacter playerCharacter, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".,", false);
        String string2 = stringTokenizer.nextToken();
        ExportHandler.populateTokenMap();
        Token token = tokenMap.get(string2);
        if (token != null) {
            return token.getToken(string, playerCharacter, null);
        }
        return "";
    }

    private static final class PStringTokenizer {
        private String _andThat = "";
        private String _delimiter = "";
        private String _forThisString = "";
        private String _ignoreBetweenThis = "";

        PStringTokenizer(String string, String string2, String string3, String string4) {
            this._forThisString = string;
            this._delimiter = string2;
            this._ignoreBetweenThis = string3;
            this._andThat = string4;
        }

        public boolean hasMoreTokens() {
            return this._forThisString.length() > 0;
        }

        public String nextToken() {
            String string;
            boolean bl = false;
            if (this._forThisString.lastIndexOf(this._delimiter) == -1) {
                string = this._forThisString;
                this._forThisString = "";
            } else {
                int n;
                StringBuffer stringBuffer = new StringBuffer();
                for (n = 0; n < this._forThisString.length() && (!this._forThisString.substring(n).startsWith(this._delimiter) || bl); ++n) {
                    if (this._forThisString.substring(n).startsWith(this._ignoreBetweenThis) && !bl) {
                        bl = true;
                    } else if (this._forThisString.substring(n).startsWith(this._andThat)) {
                        bl = false;
                    }
                    stringBuffer.append(this._forThisString.substring(n, n + 1));
                }
                string = stringBuffer.toString();
                this._forThisString = this._forThisString.substring(n + 1);
            }
            return string;
        }
    }
}

