/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.utils;

import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import pcgen.gui.utils.ClickHandler;
import pcgen.gui.utils.JTreeTable;
import pcgen.gui.utils.PObjectNode;

public class JTreeTableMouseAdapter
extends MouseAdapter {
    private JTreeTable owner;
    private boolean allowControlClicks = false;
    private ClickHandler handler;

    public JTreeTableMouseAdapter(JTreeTable jTreeTable, ClickHandler clickHandler, boolean bl) {
        this.owner = jTreeTable;
        this.handler = clickHandler;
        this.allowControlClicks = bl;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        JTree jTree = this.owner.getTree();
        int n = jTree.getClosestRowForLocation(mouseEvent.getX(), mouseEvent.getY());
        Rectangle rectangle = jTree.getRowBounds(n);
        if (mouseEvent.getY() < rectangle.y || mouseEvent.getY() > rectangle.y + rectangle.height) {
            return;
        }
        if (n != -1) {
            TreePath treePath = jTree.getPathForRow(n);
            if (treePath == null) {
                return;
            }
            if (mouseEvent.getClickCount() >= 1) {
                if (this.allowControlClicks && mouseEvent.isControlDown()) {
                    if (jTree.isPathSelected(treePath)) {
                        jTree.removeSelectionPath(treePath);
                    } else if (!jTree.isPathSelected(treePath)) {
                        jTree.addSelectionPath(treePath);
                    }
                } else {
                    jTree.setSelectionPath(treePath);
                }
                this.handler.singleClickEvent();
            }
            if (mouseEvent.getClickCount() == 2) {
                PObjectNode pObjectNode = (PObjectNode)treePath.getLastPathComponent();
                Object object = pObjectNode.getItem();
                if (!this.handler.isSelectable(object)) {
                    if (jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY()) == null) {
                        if (jTree.isExpanded(treePath)) {
                            jTree.collapsePath(treePath);
                        } else {
                            jTree.expandPath(treePath);
                        }
                    }
                } else {
                    this.handler.doubleClickEvent();
                }
            }
        }
    }
}

