/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs.resources;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.character.Follower;
import pcgen.core.utils.CoreUtility;
import pcgen.gui.TableColumnManagerModel;
import pcgen.gui.utils.AbstractTreeTableModel;
import pcgen.gui.utils.PObjectNode;
import pcgen.gui.utils.TreeTableModel;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SelectedFollowerModel
extends AbstractTreeTableModel
implements TableColumnManagerModel {
    private static final int COL_NAME = 0;
    private static final int COL_TYPE = 1;
    private static final int COL_FILE = 2;
    private List<Boolean> displayList = null;
    private PObjectNode selRoot;
    private static String[] selNameList = new String[3];
    private final int[] selDefaultWidth = new int[]{200, 100, 100};
    private PlayerCharacter pc;

    public SelectedFollowerModel(PlayerCharacter playerCharacter) {
        super(null);
        this.setCharacter(playerCharacter);
        this.resetModel();
        int n = 1;
        this.displayList = new ArrayList<Boolean>();
        this.displayList.add(Boolean.TRUE);
        this.displayList.add(this.getColumnViewOption(selNameList[n++], true));
        this.displayList.add(this.getColumnViewOption(selNameList[n++], true));
    }

    @Override
    public boolean isCellEditable(Object object, int n) {
        return n == 0;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return n == 0 ? TreeTableModel.class : String.class;
    }

    @Override
    public int getColumnCount() {
        return selNameList.length;
    }

    @Override
    public String getColumnName(int n) {
        return selNameList[n];
    }

    @Override
    public Object getRoot() {
        return super.getRoot();
    }

    public void setCharacter(PlayerCharacter playerCharacter) {
        this.pc = playerCharacter;
    }

    @Override
    public Object getValueAt(Object object, int n) {
        PObjectNode pObjectNode = (PObjectNode)object;
        Race race = null;
        Follower follower = null;
        String string = "";
        if (pObjectNode == null) {
            Logging.errorPrint("No active node when doing getValueAt in InfoRace");
            return null;
        }
        if (pObjectNode.getItem() instanceof Race) {
            race = (Race)pObjectNode.getItem();
        } else if (pObjectNode.getItem() instanceof Follower) {
            follower = (Follower)pObjectNode.getItem();
        }
        n = this.adjustColumnConst(n);
        switch (n) {
            case 0: {
                if (race != null) {
                    return race.getKeyName();
                }
                return pObjectNode.toString();
            }
            case 1: {
                if (follower == null) break;
                string = follower.getType();
                break;
            }
            case 2: {
                if (follower == null) break;
                string = follower.getFileName();
                break;
            }
            default: {
                Logging.errorPrint("In InfoResources.FollowerModel.getValueAt the column " + n + " is not handled.");
            }
        }
        return string;
    }

    private void setRoot(PObjectNode pObjectNode) {
        super.setRoot(pObjectNode);
    }

    private int adjustColumnConst(int n) {
        return n;
    }

    public void resetModel() {
        List<FollowerType> list = this.buildCurrentCompanionsList();
        this.buildSelectedResources(list);
        PObjectNode pObjectNode = (PObjectNode)this.getRoot();
        if (pObjectNode.getChildCount() > 0) {
            this.fireTreeNodesChanged(super.getRoot(), new TreePath(super.getRoot()));
        }
    }

    private void buildSelectedResources(List<FollowerType> list) {
        this.selRoot = new PObjectNode();
        this.setRoot(this.selRoot);
        PObjectNode[] pObjectNodeArray = new PObjectNode[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            FollowerType followerType = list.get(i);
            pObjectNodeArray[i] = new PObjectNode();
            pObjectNodeArray[i].setItem(followerType);
            pObjectNodeArray[i].setParent(this.selRoot);
            for (Follower follower : this.pc.getFollowerList()) {
                if (!followerType.getType().equalsIgnoreCase(follower.getType())) continue;
                PObjectNode pObjectNode = new PObjectNode();
                pObjectNode.setItem(follower);
                pObjectNode.setParent(pObjectNodeArray[i]);
                pObjectNodeArray[i].addChild(pObjectNode);
                followerType.incrementFollowerCount(1);
            }
        }
        this.selRoot.setChildren(pObjectNodeArray);
    }

    private List<FollowerType> buildCurrentCompanionsList() {
        ArrayList<FollowerType> arrayList = new ArrayList<FollowerType>();
        String string = "Followers";
        int n = this.pc.getMaxFollowers(string);
        if (n != 0) {
            arrayList.add(new FollowerType(string, n));
        }
        for (String string2 : Globals.getFollowerTypes()) {
            n = this.pc.getMaxFollowers(string2);
            if (n == 0) continue;
            arrayList.add(new FollowerType(string2, n));
        }
        return arrayList;
    }

    @Override
    public List<String> getMColumnList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 1; i < selNameList.length; ++i) {
            arrayList.add(selNameList[i]);
        }
        return arrayList;
    }

    @Override
    public boolean isMColumnDisplayed(int n) {
        return this.displayList.get(n);
    }

    @Override
    public void setMColumnDisplayed(int n, boolean bl) {
        this.setColumnViewOption(selNameList[n], bl);
        this.displayList.set(n, bl);
    }

    @Override
    public int getMColumnOffset() {
        return 1;
    }

    @Override
    public int getMColumnDefaultWidth(int n) {
        return SettingsHandler.getPCGenOption("InfoResources.FollowerModel.sizecol." + selNameList[n], this.selDefaultWidth[n]);
    }

    @Override
    public void setMColumnDefaultWidth(int n, int n2) {
        SettingsHandler.setPCGenOption("InfoResources.FollowerModel.sizecol." + selNameList[n], n2);
    }

    private boolean getColumnViewOption(String string, boolean bl) {
        return SettingsHandler.getPCGenOption("InfoResources.FollowerModel.viewcol." + string, bl);
    }

    private void setColumnViewOption(String string, boolean bl) {
        SettingsHandler.setPCGenOption("InfoResources.FollowerModel.viewcol." + string, bl);
    }

    @Override
    public void resetMColumn(int n, TableColumn tableColumn) {
    }

    static {
        SelectedFollowerModel.selNameList[0] = PropertyFactory.getString("in_typeName");
        SelectedFollowerModel.selNameList[1] = PropertyFactory.getString("in_typeRace");
        SelectedFollowerModel.selNameList[2] = PropertyFactory.getString("in_fileName");
    }

    public class FollowerType {
        private String theTypeName;
        private int theMaxNumber = -1;
        private int theSelectedNumber = 0;
        private boolean theDisplayNumberFlag = true;

        public FollowerType(String string) {
            this.theTypeName = string;
        }

        public FollowerType(String string, int n) {
            this.theTypeName = string;
            this.theMaxNumber = n;
        }

        public void setDisplayNumber(boolean bl) {
            this.theDisplayNumberFlag = bl;
        }

        public String getType() {
            return this.theTypeName;
        }

        public void incrementFollowerCount(int n) {
            this.theSelectedNumber += n;
        }

        public int getNumRemaining() {
            if (this.theMaxNumber < 0) {
                return this.theMaxNumber;
            }
            return this.theMaxNumber - this.theSelectedNumber;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(CoreUtility.capitalizeFirstLetter(this.theTypeName));
            if (this.theDisplayNumberFlag) {
                stringBuffer.append(" (");
                stringBuffer.append(this.theSelectedNumber);
                stringBuffer.append("/");
                if (this.theMaxNumber > 0) {
                    stringBuffer.append(this.theMaxNumber);
                } else {
                    stringBuffer.append("*");
                }
                stringBuffer.append(")");
            }
            return stringBuffer.toString();
        }
    }
}

