/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs.ability;

import java.awt.FlowLayout;
import java.math.BigDecimal;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import pcgen.core.AbilityCategory;
import pcgen.core.PlayerCharacter;
import pcgen.gui.utils.Utility;
import pcgen.util.BigDecimalHelper;
import pcgen.util.PropertyFactory;

public class AbilityPoolPanel
extends JPanel {
    private PlayerCharacter thePC;
    private AbilityCategory theCategory;
    private JTextField theNumAbilitiesField = new JTextField();

    public AbilityPoolPanel(PlayerCharacter playerCharacter, AbilityCategory abilityCategory) {
        this.thePC = playerCharacter;
        this.theCategory = abilityCategory;
        this.setLayout(new FlowLayout());
        JLabel jLabel = new JLabel();
        jLabel.setText(PropertyFactory.getFormattedString("InfoAbility.Remaining.Label", this.theCategory));
        this.add(jLabel);
        this.theNumAbilitiesField.setInputVerifier(new InputVerifier(){

            public boolean verify(JComponent jComponent) {
                String string = ((JTextField)jComponent).getText();
                if (string.length() > 0) {
                    try {
                        if (!AbilityPoolPanel.this.theCategory.allowFractionalPool()) {
                            Integer.parseInt(string);
                            return true;
                        }
                        Double.parseDouble(string);
                        return true;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
                return true;
            }

            public boolean shouldYieldFocus(JComponent jComponent) {
                boolean bl = super.shouldYieldFocus(jComponent);
                if (!bl) {
                    AbilityPoolPanel.this.getToolkit().beep();
                } else if (AbilityPoolPanel.this.theNumAbilitiesField.getText().length() > 0) {
                    BigDecimal bigDecimal = AbilityPoolPanel.this.thePC.getAvailableAbilityPool(AbilityPoolPanel.this.theCategory);
                    BigDecimal bigDecimal2 = new BigDecimal(AbilityPoolPanel.this.theNumAbilitiesField.getText());
                    AbilityPoolPanel.this.thePC.adjustAbilities(AbilityPoolPanel.this.theCategory, bigDecimal2.subtract(bigDecimal));
                } else {
                    AbilityPoolPanel.this.showRemainingAbilityPoints();
                }
                return bl;
            }
        });
        this.showRemainingAbilityPoints();
        this.theNumAbilitiesField.setColumns(3);
        this.theNumAbilitiesField.setEditable(abilityCategory.allowPoolMod());
        Utility.setDescription(this.theNumAbilitiesField, PropertyFactory.getFormattedString("InfoAbility.Pool.Description", this.theCategory.getDisplayName()));
        this.add(this.theNumAbilitiesField);
    }

    public void setPC(PlayerCharacter playerCharacter) {
        this.thePC = playerCharacter;
    }

    public void showRemainingAbilityPoints() {
        this.theNumAbilitiesField.setText(BigDecimalHelper.trimBigDecimal(this.thePC.getAvailableAbilityPool(this.theCategory)).toString());
    }
}

