/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.SequencedCollection;
import java.util.SortedSet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import pcgen.core.CharacterDomain;
import pcgen.core.Constants;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.Language;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.SpecialAbility;
import pcgen.core.WeaponProf;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.ListKey;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.AddSpecialAbility;
import pcgen.gui.CharacterInfoTab;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.utils.Utility;
import pcgen.util.InputFactory;
import pcgen.util.PropertyFactory;
import pcgen.util.chooser.ChooserFactory;
import pcgen.util.chooser.ChooserInterface;
import pcgen.util.enumeration.Tab;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InfoSpecialAbilities
extends JPanel
implements CharacterInfoTab {
    static final long serialVersionUID = -7316622743996841985L;
    private static final Tab tab = Tab.SABILITIES;
    private JButton weaponButton = null;
    private JButton langButton = null;
    private JButton langButton2 = null;
    private JButton spAddButton = null;
    private JButton spRemButton = null;
    private JTextArea languageText = new JTextArea();
    private JTextArea saText = new JTextArea();
    private JTextArea weaponText = new JTextArea();
    private PlayerCharacter pc;
    private int serial = 0;
    private boolean readyForRefresh = false;

    public InfoSpecialAbilities(PlayerCharacter playerCharacter) {
        this.pc = playerCharacter;
        this.setName(tab.toString());
        this.initComponents();
        this.initActionListeners();
    }

    @Override
    public void setPc(PlayerCharacter playerCharacter) {
        if (this.pc != playerCharacter || playerCharacter.getSerial() > this.serial) {
            this.pc = playerCharacter;
            this.serial = playerCharacter.getSerial();
            this.forceRefresh();
        }
    }

    @Override
    public PlayerCharacter getPc() {
        return this.pc;
    }

    @Override
    public int getTabOrder() {
        return SettingsHandler.getPCGenOption(".Panel.Abilities.Order", tab.ordinal());
    }

    @Override
    public void setTabOrder(int n) {
        SettingsHandler.setPCGenOption(".Panel.Abilities.Order", n);
    }

    @Override
    public String getTabName() {
        GameMode gameMode = SettingsHandler.getGame();
        return gameMode.getTabName(tab);
    }

    @Override
    public boolean isShown() {
        return SettingsHandler.isAbilitiesShownAsATab();
    }

    @Override
    public List<String> getToDos() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.pc.getTotalLevels() <= 1 || Globals.checkRule("INTBONUSLANG")) {
            int n = this.pc.languageNum(false);
            ArrayList<Language> arrayList2 = new ArrayList<Language>();
            ArrayList<Language> arrayList3 = new ArrayList<Language>();
            ArrayList<Language> arrayList4 = new ArrayList<Language>();
            this.buildLangLists(arrayList2, arrayList3, arrayList4);
            if (arrayList3.size() < n) {
                if (Globals.checkRule("INTBONUSLANG")) {
                    arrayList.add(PropertyFactory.getString("in_isaTodoLangRemain"));
                } else {
                    arrayList.add(PropertyFactory.getString("in_isaTodoLangRemainFirstOnly"));
                }
            } else if (arrayList3.size() > n) {
                arrayList.add(PropertyFactory.getString("in_isaTodoLangTooMany"));
            }
        }
        return arrayList;
    }

    @Override
    public void refresh() {
        if (this.pc.getSerial() > this.serial) {
            this.serial = this.pc.getSerial();
            this.forceRefresh();
        }
    }

    @Override
    public void forceRefresh() {
        if (this.readyForRefresh) {
            this.updateCharacterInfo();
        } else {
            this.serial = 0;
        }
    }

    @Override
    public JComponent getView() {
        return this;
    }

    private void updateCharacterInfo() {
        if (this.pc == null) {
            return;
        }
        ArrayList<String> arrayList = this.pc.getSpecialAbilityTimesList();
        this.pc.getAutoLanguages();
        String string = this.pc.getLanguagesListNames();
        if (arrayList.size() > 0) {
            this.saText.setText(CoreUtility.commaDelimit(arrayList));
        } else {
            this.saText.setText("None");
        }
        if (string.length() > 0) {
            this.languageText.setText(string);
        } else {
            this.languageText.setText("None");
        }
        this.showWeaponProfList();
    }

    private List<Object> getOptionalWeaponProficiencies() {
        if (this.pc != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Race race = this.pc.getRace();
            if (race != null && race.getWeaponProfBonus().size() != 0) {
                arrayList.add(race);
            }
            for (PCClass object : this.pc.getClassList()) {
                if (object.getWeaponProfBonus().size() == 0) continue;
                arrayList.add(object);
            }
            for (PCTemplate pCTemplate : this.pc.getTemplateList()) {
                if (pCTemplate.getWeaponProfBonus().size() == 0) continue;
                arrayList.add(pCTemplate);
            }
            for (CharacterDomain characterDomain : this.pc.getCharacterDomainList()) {
                if (!characterDomain.isFromPCClass() && !characterDomain.isFromFeat() || characterDomain.toString().length() == 0 || !characterDomain.getDomain().getChoiceString().startsWith("WEAPONPROF|")) continue;
                arrayList.add(characterDomain);
            }
            return arrayList;
        }
        return null;
    }

    private void addSpecialAbility() {
        if (this.pc == null || this.pc.getClassList().isEmpty()) {
            return;
        }
        new AddSpecialAbility(this.pc, this);
        this.refresh();
    }

    private void ensureFocus() {
        this.getRootPane().getParent().requestFocus();
    }

    private void formComponentShown() {
        this.requestFocus();
        PCGen_Frame1.setMessageAreaTextWithoutSaving(PropertyFactory.getString("in_iaLangTip"));
        this.refresh();
    }

    private void initActionListeners() {
        this.langButton.addActionListener(new racialLanguageButtonListener());
        this.langButton2.addActionListener(new skillLanguageButtonListener());
        this.spAddButton.addActionListener(new addSpecialButtonListener());
        this.spRemButton.addActionListener(new removeSpecialButtonListener());
        this.weaponButton.addActionListener(new weaponSelectButtonListener());
        this.addComponentListener(new componentShownAdapter());
        this.addFocusListener(new focusAdapter());
    }

    private void initComponents() {
        this.readyForRefresh = true;
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(gridBagLayout);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout());
        jPanel4.add(new JLabel(PropertyFactory.getString("in_languages")));
        this.langButton = new JButton(PropertyFactory.getString("in_other"));
        this.langButton2 = new JButton(PropertyFactory.getString("in_skill"));
        jPanel4.add(this.langButton2);
        jPanel4.add(this.langButton);
        jPanel3.add((Component)jPanel4, "North");
        JScrollPane jScrollPane = new JScrollPane();
        this.languageText.setLineWrap(true);
        this.languageText.setWrapStyleWord(true);
        this.languageText.setEditable(false);
        jScrollPane.setViewportView(this.languageText);
        jPanel3.add((Component)jScrollPane, "Center");
        Utility.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 1.0, 0.5);
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel2.add(jPanel3);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout());
        jPanel6.add(new JLabel(PropertyFactory.getString("in_specialAb")));
        this.spAddButton = new JButton(PropertyFactory.getString("in_add"));
        jPanel6.add(this.spAddButton);
        this.spRemButton = new JButton(PropertyFactory.getString("in_remove"));
        jPanel6.add(this.spRemButton);
        jPanel5.add((Component)jPanel6, "North");
        JScrollPane jScrollPane2 = new JScrollPane();
        this.saText.setLineWrap(true);
        this.saText.setWrapStyleWord(true);
        this.saText.setEditable(false);
        jScrollPane2.setViewportView(this.saText);
        jPanel5.add((Component)jScrollPane2, "Center");
        Utility.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0.0, 0.5);
        gridBagLayout.setConstraints(jPanel5, gridBagConstraints);
        jPanel2.add(jPanel5);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout());
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new FlowLayout());
        JLabel jLabel = new JLabel(PropertyFactory.getString("in_weaProfs"));
        jPanel8.add(jLabel);
        this.weaponButton = new JButton(PropertyFactory.getString("in_optProfs"));
        Utility.setDescription(this.weaponButton, PropertyFactory.getString("in_iaOptTip"));
        jPanel8.add(this.weaponButton);
        jPanel7.add((Component)jPanel8, "North");
        this.weaponText.setLineWrap(true);
        this.weaponText.setWrapStyleWord(true);
        this.weaponText.setEditable(false);
        JScrollPane jScrollPane3 = new JScrollPane();
        jScrollPane3.setViewportView(this.weaponText);
        jPanel7.add((Component)jScrollPane3, "Center");
        Utility.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 0.0, 0.5);
        gridBagLayout.setConstraints(jPanel7, gridBagConstraints);
        jPanel2.add(jPanel7);
        this.add((Component)jPanel2, "Center");
    }

    private void racialLanguageSelectPressed() {
        if (this.pc != null) {
            this.pc.setDirty(true);
            ArrayList<Language> arrayList = new ArrayList<Language>();
            ArrayList<Language> arrayList2 = new ArrayList<Language>();
            ArrayList<Language> arrayList3 = new ArrayList<Language>();
            ArrayList arrayList4 = new ArrayList();
            int n = this.pc.languageNum(false);
            this.buildLangLists(arrayList, arrayList2, arrayList3);
            Globals.sortPObjectListByName(arrayList);
            ChooserInterface chooserInterface = ChooserFactory.getChooserInstance();
            chooserInterface.setVisible(false);
            chooserInterface.setAvailableList(arrayList);
            chooserInterface.setSelectedList(arrayList2);
            if (this.pc.getTotalLevels() > 1) {
                if (Globals.checkRule("INTBONUSLANG")) {
                    chooserInterface.setPool(n - arrayList2.size());
                } else {
                    chooserInterface.setPool(0);
                }
            } else {
                chooserInterface.setPool(n - arrayList2.size());
            }
            chooserInterface.setPoolFlag(false);
            chooserInterface.setVisible(true);
            if (chooserInterface.getSelectedList().size() > n) {
                return;
            }
            this.pc.clearLanguages();
            this.pc.addLanguages(chooserInterface.getSelectedList());
            this.pc.addLanguages(arrayList3);
            this.refresh();
            this.ensureFocus();
        }
    }

    private void buildLangLists(List<Language> list, List<Language> list2, List<Language> list3) {
        SortedSet<Language> sortedSet = this.pc.getAutoLanguages();
        Skill skill = null;
        ArrayList<Skill> arrayList = new ArrayList<Skill>(this.pc.getSkillList());
        for (Skill pObject : arrayList) {
            if (pObject.getChoiceString().indexOf(PropertyFactory.getString("in_language")) < 0) continue;
            skill = pObject;
        }
        for (Language language : this.pc.getLanguageBonusSelectionList()) {
            if (language == null || !PrereqHandler.passesAll(language.getPreReqList(), this.pc, language)) continue;
            list.add(language);
        }
        for (Language language : this.pc.getLanguagesList()) {
            boolean bl = false;
            if (skill != null && skill.containsAssociated(language.getKeyName())) {
                bl = false;
            } else if (!sortedSet.contains(language)) {
                bl = true;
            }
            if (bl) {
                list2.add(language);
                continue;
            }
            list.remove(language);
            list3.add(language);
        }
    }

    private void removeSpecialAbility() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = new ArrayList();
        ArrayList<SpecialAbility> arrayList3 = new ArrayList<SpecialAbility>();
        for (PCClass object : this.pc.getClassList()) {
            for (SpecialAbility n : object.getSafeListFor(ListKey.SPECIAL_ABILITY)) {
                if (!n.getSASource().endsWith("|0")) continue;
                arrayList.add(n.getKeyName());
                arrayList3.add(n);
            }
        }
        ChooserInterface chooserInterface = ChooserFactory.getChooserInstance();
        chooserInterface.setVisible(false);
        chooserInterface.setTitle(PropertyFactory.getString("in_iaReSpeAb"));
        chooserInterface.setMessageText(PropertyFactory.getString("in_iaSelSpeAb"));
        chooserInterface.setAvailableList(arrayList);
        chooserInterface.setSelectedList(arrayList2);
        chooserInterface.setPool(arrayList.size());
        chooserInterface.setPoolFlag(false);
        chooserInterface.setVisible(true);
        for (Object object : chooserInterface.getSelectedList()) {
            SpecialAbility specialAbility;
            String string;
            PCClass pCClass;
            int n = arrayList.indexOf(object);
            if (n < 0 || n >= arrayList3.size() || (pCClass = this.pc.getClassKeyed((string = (specialAbility = (SpecialAbility)arrayList3.get(n)).getSASource()).substring(string.indexOf("|") + 1, string.lastIndexOf("|")))) == null) continue;
            pCClass.removeSave(specialAbility.getKeyName());
            pCClass.removeSpecialAbility(specialAbility);
        }
        this.serial = 0;
        this.refresh();
        this.ensureFocus();
    }

    private void showWeaponProfList() {
        SequencedCollection<Object> sequencedCollection;
        if (this.weaponButton != null) {
            sequencedCollection = this.getOptionalWeaponProficiencies();
            this.weaponButton.setEnabled(sequencedCollection != null && sequencedCollection.size() > 0);
        }
        if ((sequencedCollection = this.pc.getWeaponProfs()).size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            for (WeaponProf weaponProf : sequencedCollection) {
                if (weaponProf == null) continue;
                if (!bl) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(weaponProf.toString());
                bl = false;
            }
            this.weaponText.setText(stringBuffer.toString());
        } else {
            this.weaponText.setText("None");
        }
        this.weaponText.setCaretPosition(0);
    }

    private void skillLanguageSelectPressed() {
        if (Skill.chooseLanguageForSkill(this.pc)) {
            this.refresh();
        }
        this.ensureFocus();
    }

    private void weaponSelectPressed() {
        if (this.pc != null) {
            List<Object> list = this.getOptionalWeaponProficiencies();
            if (list.size() == 0) {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_iaNoOptProfs"), "PCGen", MessageType.INFORMATION);
                return;
            }
            int n = 0;
            do {
                Object object;
                Object object2;
                if (list.size() == 1) {
                    object2 = list.get(0);
                } else {
                    object = InputFactory.getInputInstance();
                    Object object3 = object.showInputDialog(null, PropertyFactory.getString("in_iaMultiChoice1") + Constants.s_LINE_SEP + PropertyFactory.getString("in_iaMultiChoice2"), "PCGen", MessageType.INFORMATION, list.toArray(), list.get(n));
                    if (object3 != null) {
                        object2 = object3;
                        n = list.indexOf(object3);
                    } else {
                        this.ensureFocus();
                        return;
                    }
                }
                if (object2 instanceof CharacterDomain) {
                    object = ((CharacterDomain)object2).getDomain();
                    ((PObject)object).getChoices(((PObject)object).getChoiceString(), this.pc);
                } else if (object2 instanceof PCClass) {
                    object = ((PCClass)object2).getWeaponProfBonus();
                    ((PCClass)object2).getChoices("WEAPONPROF|1|" + CoreUtility.join(object, "[WEAPONPROF]|") + PropertyFactory.getString("in_proficiency"), this.pc);
                } else if (object2 instanceof Race) {
                    object = ((Race)object2).getWeaponProfBonus();
                    ((Race)object2).getChoices("WEAPONPROF|1|" + CoreUtility.join(object, "[WEAPONPROF]|") + PropertyFactory.getString("in_proficiency"), this.pc);
                } else if (object2 instanceof PCTemplate) {
                    object = ((PCTemplate)object2).getWeaponProfBonus();
                    ((PCTemplate)object2).getChoices("WEAPONPROF|1|" + CoreUtility.join(object, "[WEAPONPROF]|") + PropertyFactory.getString("in_proficiency"), this.pc);
                }
                this.pc.setDirty(true);
                this.pc.aggregateFeatList();
                this.showWeaponProfList();
            } while (list.size() != 1);
            this.ensureFocus();
            return;
        }
    }

    private class focusAdapter
    extends FocusAdapter {
        private focusAdapter() {
        }

        public void focusGained(FocusEvent focusEvent) {
            InfoSpecialAbilities.this.refresh();
        }
    }

    private class componentShownAdapter
    extends ComponentAdapter {
        private componentShownAdapter() {
        }

        public void componentShown(ComponentEvent componentEvent) {
            InfoSpecialAbilities.this.formComponentShown();
        }
    }

    private class weaponSelectButtonListener
    implements ActionListener {
        private weaponSelectButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            InfoSpecialAbilities.this.weaponSelectPressed();
        }
    }

    private class removeSpecialButtonListener
    implements ActionListener {
        private removeSpecialButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            InfoSpecialAbilities.this.removeSpecialAbility();
        }
    }

    private class addSpecialButtonListener
    implements ActionListener {
        private addSpecialButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            InfoSpecialAbilities.this.addSpecialAbility();
        }
    }

    private class skillLanguageButtonListener
    implements ActionListener {
        private skillLanguageButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            InfoSpecialAbilities.this.skillLanguageSelectPressed();
        }
    }

    private class racialLanguageButtonListener
    implements ActionListener {
        private racialLanguageButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            InfoSpecialAbilities.this.racialLanguageSelectPressed();
        }
    }
}

