/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import pcgen.core.Equipment;
import pcgen.core.GameMode;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.gui.CharacterInfoTab;
import pcgen.gui.filter.FilterAdapterPanel;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.utils.JTableEx;
import pcgen.util.Delta;
import pcgen.util.enumeration.Tab;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfoNaturalWeapons
extends FilterAdapterPanel
implements CharacterInfoTab {
    static final long serialVersionUID = 7796493138427983908L;
    private static final Tab tab = Tab.NATWEAPONS;
    private static boolean needsUpdate = true;
    private JScrollPane scpNaturalAttacks;
    private JTableEx tblNaturalAttacks;
    private PlayerCharacter pc;
    private int serial = 0;
    private boolean readyForRefresh = false;

    public InfoNaturalWeapons(PlayerCharacter playerCharacter) {
        this.pc = playerCharacter;
        this.setName(tab.toString());
        this.initComponents();
    }

    @Override
    public void setPc(PlayerCharacter playerCharacter) {
        if (this.pc != playerCharacter || playerCharacter.getSerial() > this.serial) {
            this.pc = playerCharacter;
            this.serial = playerCharacter.getSerial();
            this.forceRefresh();
        }
    }

    @Override
    public PlayerCharacter getPc() {
        return this.pc;
    }

    @Override
    public int getTabOrder() {
        return SettingsHandler.getPCGenOption(".Panel.NaturalWeapons.Order", tab.ordinal());
    }

    @Override
    public void setTabOrder(int n) {
        SettingsHandler.setPCGenOption(".Panel.NaturalWeapons.Order", n);
    }

    @Override
    public String getTabName() {
        GameMode gameMode = SettingsHandler.getGame();
        return gameMode.getTabName(tab);
    }

    @Override
    public boolean isShown() {
        GameMode gameMode = SettingsHandler.getGame();
        return gameMode.getTabShown(tab);
    }

    @Override
    public List<String> getToDos() {
        ArrayList<String> arrayList = new ArrayList<String>();
        return arrayList;
    }

    @Override
    public void refresh() {
        if (this.pc.getSerial() > this.serial) {
            this.serial = this.pc.getSerial();
            this.forceRefresh();
        }
    }

    @Override
    public void forceRefresh() {
        if (this.readyForRefresh) {
            needsUpdate = true;
            this.updateCharacterInfo();
        } else {
            this.serial = 0;
        }
    }

    @Override
    public JComponent getView() {
        return this;
    }

    @Override
    public boolean isMatchAnyEnabled() {
        return true;
    }

    public static void setNeedsUpdate(boolean bl) {
        needsUpdate = bl;
    }

    @Override
    public boolean isNegateEnabled() {
        return true;
    }

    @Override
    public int getSelectionMode() {
        return 2;
    }

    @Override
    public void initializeFilters() {
        FilterFactory.registerAllSourceFilters(this);
        FilterFactory.registerAllSizeFilters(this);
        FilterFactory.registerAllEquipmentFilters(this);
    }

    @Override
    public void refreshFiltering() {
        this.forceRefresh();
    }

    private void updateCharacterInfo() {
        int n;
        if (!needsUpdate) {
            // empty if block
        }
        ArrayList<Equipment> arrayList = new ArrayList<Equipment>();
        for (Equipment equipment : this.pc.getEquipmentMasterList()) {
            if (!equipment.isWeapon() || !equipment.isType("Natural")) continue;
            arrayList.add(equipment);
        }
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.tblNaturalAttacks.getModel();
        for (n = defaultTableModel.getRowCount() - 1; n >= 0; --n) {
            defaultTableModel.removeRow(n);
        }
        n = arrayList.size();
        if (n == 0) {
            return;
        }
        if (n >= 1) {
            Collections.sort(arrayList, new Comparator<Object>(){

                @Override
                public final int compare(Object object, Object object2) {
                    if (((Equipment)object).isType("Primary")) {
                        return -1;
                    }
                    return ((Equipment)object).getName().compareToIgnoreCase(((Equipment)object2).getName());
                }
            });
        }
        int n2 = (int)this.pc.getStatBonusTo("TOHIT", "TYPE=MELEE");
        int n3 = (int)this.pc.getStatBonusTo("TOHIT", "TYPE=RANGED");
        int n4 = (int)this.pc.getStatBonusTo("DAMAGE", "TYPE=MELEE");
        int n5 = this.pc.baseAttackBonus();
        int n6 = (int)this.pc.getSizeAdjustmentBonusTo("TOHIT", "TOHIT");
        for (int i = 0; i < n; ++i) {
            Equipment equipment = (Equipment)arrayList.get(i);
            int n7 = (int)this.pc.getTotalBonusTo("WEAPONPROF=" + equipment.profKey(this.pc), "TOHIT");
            Object[] objectArray = new Object[7];
            objectArray[0] = equipment.getName();
            objectArray[1] = (int)equipment.qty();
            StringBuffer stringBuffer = new StringBuffer(12);
            int n8 = n5 + n6;
            n8 = !equipment.isType("Primary") ? (n8 -= 5 - (int)this.pc.getTotalBonusTo("COMBAT", "TOHIT-SECONDARY")) : (n8 += (int)this.pc.getTotalBonusTo("COMBAT", "TOHIT-PRIMARY"));
            if (equipment.isMelee()) {
                stringBuffer.append(Delta.toString(n8 + n2 + n7));
                stringBuffer.append(" melee");
            } else if (equipment.isRanged()) {
                stringBuffer.append(Delta.toString(n8 + n3));
                stringBuffer.append(" ranged");
            }
            objectArray[2] = stringBuffer.toString();
            int n9 = n4;
            if (n9 > 0) {
                if (equipment.isType("Primary") && arrayList.size() == 1 && (int)equipment.qty() == 1) {
                    if (!equipment.isRanged()) {
                        n9 = n9 * 3 / 2;
                    }
                } else if (equipment.isType("Secondary")) {
                    n9 /= 2;
                }
            }
            StringBuffer stringBuffer2 = new StringBuffer(12);
            stringBuffer2.append(equipment.getDamage(this.pc));
            if (n9 != 0) {
                stringBuffer2.append(Delta.toString(n9));
            }
            objectArray[3] = stringBuffer2.toString();
            objectArray[4] = Boolean.FALSE;
            objectArray[5] = Boolean.FALSE;
            objectArray[6] = Boolean.TRUE;
            defaultTableModel.addRow(objectArray);
        }
    }

    private void initComponents() {
        this.readyForRefresh = true;
        this.scpNaturalAttacks = new JScrollPane();
        this.tblNaturalAttacks = new JTableEx();
        this.setLayout(new BorderLayout());
        this.tblNaturalAttacks.setBackground(this.getBackground());
        this.tblNaturalAttacks.setModel(new DefaultTableModel(new String[]{"Attack", "#", "To-Hit Modifier", "Damage/Attack", "Excludes Weapons", "Iterative BAB", "Enabled"}, 0){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Integer.class, String.class, String.class, Boolean.class, Boolean.class, Boolean.class};
                this.canEdit = new boolean[]{false, false, false, false, true, true, true};
            }

            @Override
            public Class<?> getColumnClass(int n) {
                return this.types[n];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.scpNaturalAttacks.setViewportView(this.tblNaturalAttacks);
        this.add((Component)this.scpNaturalAttacks, "Center");
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                InfoNaturalWeapons.this.refresh();
            }
        });
    }
}

