/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.AbilityUtilities;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.CharacterInfo;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.panes.FlippingSplitPane;
import pcgen.gui.tabs.BaseCharacterInfoTab;
import pcgen.gui.tabs.ability.AbilityInfoPanel;
import pcgen.gui.tabs.ability.AbilityPoolPanel;
import pcgen.gui.tabs.ability.AbilitySelectionPanel;
import pcgen.gui.tabs.ability.AvailableAbilityPanel;
import pcgen.gui.tabs.ability.IAbilitySelectionListener;
import pcgen.gui.tabs.ability.SelectedAbilityPanel;
import pcgen.gui.utils.PObjectNode;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;
import pcgen.util.enumeration.Tab;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InfoAbility
extends BaseCharacterInfoTab
implements IAbilitySelectionListener {
    private static final Tab tab = Tab.ABILITIES;
    private static final String NO_QUALIFY_MESSAGE = PropertyFactory.getString("InfoAbility.Messages.NotQualified");
    private static final String DUPLICATE_MESSAGE = PropertyFactory.getString("InfoAbility.Messages.Duplicate");
    private static String POOL_FULL_MESSAGE = PropertyFactory.getString("InfoAbility.Messages.NoPoints");
    private static int splitOrientation = 1;
    private static final int ABILITY_OK = 0;
    private static final int ABILITY_DUPLICATE = 1;
    private static final int ABILITY_NOT_QUALIFIED = 2;
    private static final int ABILITY_FULL = 3;
    private AbilityCategory theCategory;
    private AbilitySelectionPanel theAvailablePane = null;
    private AbilitySelectionPanel theSelectedPane = null;
    private AbilityInfoPanel theInfoPanel = null;
    private AbilityPoolPanel thePoolPanel = null;
    private FlippingSplitPane splitBotLeftRight = null;
    private FlippingSplitPane splitTopBot = null;
    private FlippingSplitPane splitTopLeftRight = null;
    private JCheckBox chkViewAll = new JCheckBox();
    private boolean hasBeenSized = false;
    private String theOptionKey = "InfoAbility.";

    public InfoAbility(PlayerCharacter playerCharacter, AbilityCategory abilityCategory) {
        super(playerCharacter);
        this.theCategory = abilityCategory;
        this.theOptionKey = this.theOptionKey + this.theCategory.getKeyName();
        this.setName(this.theCategory.getPluralName());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InfoAbility.this.initComponents();
                InfoAbility.this.initActionListeners();
            }
        });
    }

    @Override
    public int getTabOrder() {
        String string = ".Panel." + this.theOptionKey + ".Order";
        return SettingsHandler.getPCGenOption(string, tab.ordinal());
    }

    @Override
    public void setTabOrder(int n) {
        String string = ".Panel." + this.theOptionKey + ".Order";
        SettingsHandler.setPCGenOption(string, n);
    }

    @Override
    public List<String> getToDos() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.getPc() != null) {
            BigDecimal bigDecimal = this.getPc().getAvailableAbilityPool(this.theCategory);
            int n = bigDecimal.compareTo(BigDecimal.ZERO);
            if (n > 0) {
                arrayList.add(PropertyFactory.getFormattedString("in_featTodoRemain", this.theCategory.getPluralName()));
            } else if (n < 0) {
                arrayList.add(PropertyFactory.getFormattedString("in_featTodoTooMany", this.theCategory.getPluralName()));
            }
        }
        return arrayList;
    }

    @Override
    public boolean isMatchAnyEnabled() {
        return true;
    }

    @Override
    public boolean isNegateEnabled() {
        return true;
    }

    @Override
    public int getSelectionMode() {
        return 2;
    }

    @Override
    public void initializeFilters() {
        FilterFactory.registerAllSourceFilters(this);
        FilterFactory.registerAllFeatFilters(this);
    }

    @Override
    public void refreshFiltering() {
        this.forceRefresh();
    }

    private int checkAbilityQualify(Ability ability) {
        BigDecimal bigDecimal;
        boolean bl;
        String string;
        PlayerCharacter playerCharacter = this.getPc();
        Ability ability2 = playerCharacter.getAbilityKeyed(this.theCategory, string = ability.getKeyName());
        boolean bl2 = bl = ability2 != null;
        if (bl && !ability2.isMultiples()) {
            return 1;
        }
        if (!(bl || (ability2 = Globals.getAbilityKeyed(this.theCategory, string)) == null || PrereqHandler.passesAll(ability2.getPreReqList(), playerCharacter, ability2) || Globals.checkRule("FEATPRE"))) {
            return 2;
        }
        if (ability2 != null && (bigDecimal = BigDecimal.valueOf(ability2.getCost(playerCharacter))).compareTo(playerCharacter.getAvailableAbilityPool(this.theCategory)) > 0) {
            return 3;
        }
        return 0;
    }

    private void formComponentShown() {
        this.requestFocus();
        PCGen_Frame1.setMessageAreaTextWithoutSaving(PropertyFactory.getString("InfoAbility.StatusLine.Info"));
        if (this.theAvailablePane != null) {
            this.theAvailablePane.setPC(this.getPc());
        }
        if (this.theSelectedPane != null) {
            this.theSelectedPane.setPC(this.getPc());
        }
        if (this.theInfoPanel != null) {
            this.theInfoPanel.setPC(this.getPc());
        }
        if (this.thePoolPanel != null) {
            this.thePoolPanel.setPC(this.getPc());
        }
        this.refresh();
        if (!this.hasBeenSized) {
            int n;
            this.hasBeenSized = true;
            if (this.splitTopLeftRight != null) {
                n = SettingsHandler.getPCGenOption(this.theOptionKey + ".splitTopLeftRight", (int)(this.getSize().getWidth() * 6.0 / 10.0));
                this.splitTopLeftRight.setDividerLocation(n);
            }
            if (this.splitTopBot != null) {
                n = SettingsHandler.getPCGenOption(this.theOptionKey + ".splitTopBot", (int)(this.getSize().getHeight() * 75.0 / 100.0));
                this.splitTopBot.setDividerLocation(n);
            }
            if (this.splitBotLeftRight != null) {
                n = SettingsHandler.getPCGenOption(this.theOptionKey + ".splitBotLeftRight", (int)(this.getSize().getWidth() * 6.0 / 10.0));
                this.splitBotLeftRight.setDividerLocation(n);
            }
        }
    }

    private void initActionListeners() {
        this.chkViewAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoAbility.this.chkViewAllActionPerformed();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                InfoAbility.this.formComponentShown();
            }
        });
        FilterFactory.restoreFilterSettings(this);
    }

    private void initComponents() {
        if (Globals.getGameModeHasPointPool()) {
            // empty if block
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        if (this.theCategory.isEditable()) {
            this.theAvailablePane = new AvailableAbilityPanel(this.getPc(), this.theCategory);
            this.theAvailablePane.addAbilitySelectionListener(this);
            this.theAvailablePane.addFilterer(this);
        }
        this.theSelectedPane = new SelectedAbilityPanel(this.getPc(), this.theCategory);
        this.theSelectedPane.addAbilitySelectionListener(this);
        this.theSelectedPane.addFilterer(this);
        if (this.theCategory.isEditable()) {
            this.splitTopLeftRight = new FlippingSplitPane(splitOrientation, this.theAvailablePane, this.theSelectedPane);
            this.splitTopLeftRight.setOneTouchExpandable(true);
            this.splitTopLeftRight.setDividerSize(10);
            this.splitTopLeftRight.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    SettingsHandler.setPCGenOption(InfoAbility.this.theOptionKey + ".splitTopLeftRight", propertyChangeEvent.getNewValue().toString());
                }
            });
            jPanel.add((Component)this.splitTopLeftRight, "Center");
        } else {
            jPanel.add((Component)this.theSelectedPane, "Center");
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        this.theInfoPanel = new AbilityInfoPanel(this.getPc(), PropertyFactory.getFormattedString("InfoAbility.Title", this.theCategory.getDisplayName()));
        if (this.theCategory.isEditable()) {
            this.thePoolPanel = new AbilityPoolPanel(this.getPc(), this.theCategory);
            this.splitBotLeftRight = new FlippingSplitPane(splitOrientation, this.theInfoPanel, this.thePoolPanel);
            this.splitBotLeftRight.setOneTouchExpandable(true);
            this.splitBotLeftRight.setDividerSize(10);
            this.splitBotLeftRight.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    SettingsHandler.setPCGenOption(InfoAbility.this.theOptionKey + ".splitBotLeftRight", propertyChangeEvent.getNewValue().toString());
                }
            });
            jPanel2.add((Component)this.splitBotLeftRight, "Center");
        } else {
            jPanel2.add((Component)this.theInfoPanel, "Center");
        }
        this.splitTopBot = new FlippingSplitPane(0, jPanel, jPanel2);
        this.splitTopBot.setOneTouchExpandable(true);
        this.splitTopBot.setDividerSize(10);
        this.splitTopBot.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SettingsHandler.setPCGenOption(InfoAbility.this.theOptionKey + ".splitTopBot", propertyChangeEvent.getNewValue().toString());
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitTopBot, "Center");
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                InfoAbility.this.refresh();
            }
        });
    }

    private void updateAvailableModel() {
        if (this.theAvailablePane != null) {
            this.theAvailablePane.setPC(this.getPc());
            this.theAvailablePane.update();
        }
    }

    @Override
    protected void updateCharacterInfo() {
        PObjectNode.resetPC(this.getPc());
        if (this.getPc() == null || !this.needsUpdate()) {
            return;
        }
        this.getPc().setAggregateAbilitiesStable(this.theCategory, false);
        if (this.theCategory == AbilityCategory.FEAT) {
            this.getPc().aggregateFeatList();
        }
        if (this.theInfoPanel != null) {
            this.theInfoPanel.setPC(this.getPc());
            this.theInfoPanel.setAbility(null);
        }
        this.updateAvailableModel();
        this.updateSelectedModel();
        if (this.thePoolPanel != null) {
            this.thePoolPanel.setPC(this.getPc());
            this.thePoolPanel.showRemainingAbilityPoints();
        }
        this.setNeedsUpdate(false);
    }

    private void updateSelectedModel() {
        if (this.theSelectedPane != null) {
            this.theSelectedPane.setPC(this.getPc());
            this.theSelectedPane.update();
        }
    }

    private void chkViewAllActionPerformed() {
        this.updateSelectedModel();
    }

    @Override
    protected Tab getTab() {
        return tab;
    }

    @Override
    public String getTabName() {
        return this.theCategory.getPluralName();
    }

    @Override
    public void abilitySelected(Ability ability) {
        this.theInfoPanel.setAbility(ability);
    }

    @Override
    public boolean addAbility(Ability ability) {
        int n = this.checkAbilityQualify(ability);
        switch (n) {
            case 2: {
                ShowMessageDelegate.showMessageDialog(NO_QUALIFY_MESSAGE, "PCGen", MessageType.INFORMATION);
                return false;
            }
            case 1: {
                ShowMessageDelegate.showMessageDialog(DUPLICATE_MESSAGE, "PCGen", MessageType.INFORMATION);
                return false;
            }
            case 3: {
                ShowMessageDelegate.showMessageDialog(POOL_FULL_MESSAGE, "PCGen", MessageType.INFORMATION);
                return false;
            }
            case 0: {
                break;
            }
            default: {
                Logging.debugPrint(this.theCategory.getDisplayName() + " " + ability.getDisplayName() + " " + PropertyFactory.getString("in_iayIsSomehowInState") + " " + n + " " + PropertyFactory.getString("in_iayWhichIsNotHandeledInIAaddAb"));
            }
        }
        try {
            this.getPc().setDirty(true);
            if (this.theCategory == AbilityCategory.FEAT) {
                AbilityUtilities.modFeat(this.getPc(), null, ability.getKeyName(), true, false);
            } else {
                this.getPc().addAbility(null, this.theCategory, ability.getKeyName(), true, false);
            }
        }
        catch (Exception exception) {
            Logging.errorPrint("Failed to add ability due to ", exception);
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_iayAddAbility", exception.getMessage()), "PCGen", MessageType.ERROR);
        }
        CharacterInfo characterInfo = PCGen_Frame1.getCharacterPane();
        characterInfo.setPaneForUpdate(characterInfo.infoSkills());
        characterInfo.setPaneForUpdate(characterInfo.infoInventory());
        characterInfo.setPaneForUpdate(characterInfo.infoSpells());
        characterInfo.setPaneForUpdate(characterInfo.infoSummary());
        characterInfo.refresh();
        this.getPc().aggregateFeatList();
        this.updateAvailableModel();
        this.updateSelectedModel();
        this.getPc().calcActiveBonuses();
        this.thePoolPanel.showRemainingAbilityPoints();
        return true;
    }

    @Override
    public boolean removeAbility(Ability ability) {
        try {
            this.getPc().setDirty(true);
            if (this.theCategory == AbilityCategory.FEAT) {
                AbilityUtilities.modFeat(this.getPc(), null, ability.getKeyName(), false, false);
            } else {
                AbilityUtilities.modAbility(this.getPc(), null, ability, null, false, this.theCategory);
            }
        }
        catch (Exception exception) {
            Logging.errorPrintLocalised("in_iayFailedToRemoveAbility", exception);
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_iayRemoveAbility") + ": " + exception.getMessage(), "PCGen", MessageType.ERROR);
            return false;
        }
        CharacterInfo characterInfo = PCGen_Frame1.getCharacterPane();
        characterInfo.setPaneForUpdate(characterInfo.infoSkills());
        characterInfo.setPaneForUpdate(characterInfo.infoInventory());
        characterInfo.setPaneForUpdate(characterInfo.infoSpells());
        characterInfo.setPaneForUpdate(characterInfo.infoSummary());
        characterInfo.refresh();
        this.getPc().aggregateFeatList();
        this.updateAvailableModel();
        this.updateSelectedModel();
        this.getPc().calcActiveBonuses();
        this.thePoolPanel.showRemainingAbilityPoints();
        return true;
    }
}

