/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import gmgen.pluginmgr.PluginLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Observer;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.party.Party;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.MessageWrapper;
import pcgen.core.utils.ShowMessageConsoleObserver;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.HPFrame;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.SplashScreen;
import pcgen.gui.TipOfTheDay;
import pcgen.gui.UIFactory;
import pcgen.gui.utils.DialogInputInterface;
import pcgen.gui.utils.Hyperactive;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.NonGuiChooser;
import pcgen.gui.utils.NonGuiChooserRadio;
import pcgen.gui.utils.ShowMessageGuiObserver;
import pcgen.gui.utils.SwingChooser;
import pcgen.gui.utils.SwingChooserRadio;
import pcgen.gui.utils.SwingChooserUserInput;
import pcgen.gui.utils.Utility;
import pcgen.io.ExportHandler;
import pcgen.io.PCGFile;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.LstFileLoader;
import pcgen.persistence.lst.SponsorLoader;
import pcgen.util.InputFactory;
import pcgen.util.Logging;
import pcgen.util.chooser.ChooserFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class pcGenGUI {
    private static SplashScreen splash;
    private static String templateName;
    private static String inFileName;
    private static String outFileName;
    private static boolean partyMode;
    private static String[] startupArgs;
    private static HPFrame hpFrame;
    private PCGen_Frame1 frame;
    private boolean packFrame = false;

    public pcGenGUI() {
        Object[] objectArray;
        Dimension dimension = null;
        try {
            if (SettingsHandler.getFirstRun() && Globals.getUseGUI()) {
                pcGenGUI.hideSplashScreen();
                this.askFileLocation();
            }
            SettingsHandler.readOptionsProperties();
            dimension = SettingsHandler.getOptionsFromProperties(null);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            objectArray = exception.getMessage();
            if (objectArray == null || objectArray.length() == 0) {
                objectArray = "Unknown error whilst reading options.ini";
            }
            objectArray = (String)objectArray + "\n\nIt MAY be possible to fix this problem by deleting your options.ini file.";
            ShowMessageDelegate.showMessageDialog(new MessageWrapper(objectArray, "PCGen - Error processing Options.ini", MessageType.ERROR));
            if (Globals.getUseGUI()) {
                pcGenGUI.hideSplashScreen();
            }
            System.exit(0);
        }
        if (Globals.getUseGUI()) {
            pcGenGUI.macSpecificInit();
            ChooserFactory.setInterfaceClassname(SwingChooser.class.getName());
            ChooserFactory.setRadioInterfaceClassname(SwingChooserRadio.class.getName());
            ChooserFactory.setUserInputInterfaceClassname(SwingChooserUserInput.class.getName());
            InputFactory.setInterfaceClassname(DialogInputInterface.class.getName());
        } else {
            ChooserFactory.setInterfaceClassname(NonGuiChooser.class.getName());
            ChooserFactory.setRadioInterfaceClassname(NonGuiChooserRadio.class.getName());
            ChooserFactory.setUserInputInterfaceClassname(NonGuiChooser.class.getName());
        }
        if (!Globals.getUseGUI()) {
            this.runNonGui();
            return;
        }
        this.frame = new PCGen_Frame1();
        this.frame.setMainClass(this);
        if (System.getProperty("os.name").equals("Mac OS X")) {
            try {
                Class[] classArray = new Class[]{PCGen_Frame1.class};
                objectArray = new Object[]{this.frame};
                Class.forName("pcgen.gui.MacGUI").getDeclaredMethod("setPCGenFrame", classArray).invoke(null, objectArray);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        if (this.packFrame) {
            this.frame.pack();
        } else {
            this.frame.validate();
        }
        int n = -11;
        int n2 = -11;
        if (SettingsHandler.getLeftUpperCorner() != null) {
            n = (int)SettingsHandler.getLeftUpperCorner().getX();
            n2 = (int)SettingsHandler.getLeftUpperCorner().getY();
        }
        if (n < -10 || n2 < -10 || dimension.height == 0 || dimension.width == 0) {
            this.frame.setSize(new Dimension(1020, 716));
            Utility.centerFrame(this.frame, false);
        } else {
            this.frame.setLocation(n, n2);
            this.frame.setSize(dimension);
        }
        int n3 = SettingsHandler.getWindowState();
        if (n3 != 0) {
            this.frame.setExtendedState(n3);
        }
        UIFactory.initLookAndFeel();
        this.frame.resetUI();
        this.processStartupArgs();
        pcGenGUI.hideSplashScreen();
        SettingsHandler.readGUIOptionsProperties();
        Utility.handleToolTipShownStateChange();
        PCGen_Frame1.enableDisableMenuItems();
        this.frame.setVisible(true);
        if (SettingsHandler.getShowTipOfTheDay()) {
            pcGenGUI.showTipOfTheDay();
        }
    }

    private static void macSpecificInit() {
        if (System.getProperty("os.name").equals("Mac OS X")) {
            try {
                Class.forName("pcgen.gui.MacGUI").getDeclaredMethod("initialize", null).invoke((Object)null, (Object[])null);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("This build of PCGen doesn't include Mac-enhanced features.  Try the Mac build for a more Mac-like interface.");
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    private void runNonGui() {
        PlayerCharacter playerCharacter = this.runNonGuiLoad(new File(inFileName));
        if (playerCharacter != null && templateName != null && outFileName != null) {
            this.runNonGuiExport(playerCharacter);
        }
    }

    private void runNonGuiExport(PlayerCharacter playerCharacter) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFileName), "UTF-8"));
            File file = new File(templateName);
            if (partyMode) {
                SettingsHandler.setSelectedPartyHTMLOutputSheet(file.getAbsolutePath());
                new ExportHandler(file).write(Globals.getPCList(), bufferedWriter);
            } else {
                SettingsHandler.setSelectedCharacterHTMLOutputSheet(file.getAbsolutePath(), playerCharacter);
                new ExportHandler(file).write(playerCharacter, bufferedWriter);
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            Logging.errorPrint("Exception in writing", exception);
        }
        Globals.executePostExportCommandStandard(outFileName);
    }

    private PlayerCharacter runNonGuiLoad(File file) {
        Party party = partyMode ? Party.makePartyFromFile(file) : Party.makeSingleCharacterParty(file);
        PlayerCharacter playerCharacter = party.load(null);
        if (playerCharacter == null) {
            ShowMessageDelegate.showMessageDialog(new MessageWrapper("Problems occurred while loading the file:" + file.getName(), "Error", MessageType.ERROR));
        }
        return playerCharacter;
    }

    public static void main(String[] stringArray) {
        Object object;
        templateName = System.getProperty("pcgen.templatefile");
        inFileName = System.getProperty("pcgen.inputfile");
        outFileName = System.getProperty("pcgen.outputfile");
        startupArgs = stringArray;
        if (inFileName != null) {
            partyMode = PCGFile.isPCGenPartyFile(new File(inFileName));
            Globals.setUseGUI(false);
        }
        Observer observer = null;
        if (Globals.getUseGUI()) {
            pcGenGUI.macSpecificInit();
            observer = new ShowMessageGuiObserver();
        } else {
            observer = new ShowMessageConsoleObserver();
        }
        ShowMessageDelegate.getInstance().addObserver(observer);
        try {
            object = System.getProperty("java.version");
            if (Double.valueOf(Globals.javaVersion.substring(0, 3)) < 1.5) {
                ShowMessageDelegate.showMessageDialog(new MessageWrapper("PCGen requires Java 2 v1.5 or higher.\nYour version of java is currently " + (String)object + ".\n" + "To be able to run PCGen properly you will need:\n" + " * The Java 2 runtime environment available from\n" + "   http://java.sun.com/javase/index.jsp\n\n" + "You'll need to pick the version of java appropriate for your\n" + "OS (the choices are Solaris/SPARC, Linux and Windows).", "PCGen", MessageType.INFORMATION));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (Globals.getUseGUI()) {
                if (stringArray.length > 0 && stringArray[0].equals("-j")) {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                } else {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
            }
        }
        catch (Exception exception) {
            Logging.errorPrint("Couldn't set look and feel", exception);
        }
        if (Globals.getUseGUI() && (stringArray.length <= 0 || !stringArray[0].equals("--nosplash"))) {
            pcGenGUI.showSplashScreen();
        }
        object = PluginLoader.inst();
        ((PluginLoader)object).startSystemPlugins("Tokens");
        new pcGenGUI();
    }

    public static void showHpFrame(PlayerCharacter playerCharacter) {
        pcGenGUI.initHpFrame(playerCharacter);
        hpFrame.setPSize();
        hpFrame.pack();
        hpFrame.setVisible(true);
    }

    public static void showLicense() {
        String string = " ";
        string = string + pcGenGUI.readTextFromFile(SettingsHandler.getPcgenSystemDir() + File.separator + "opengaminglicense.10a.txt");
        if (Globals.getSection15() != null) {
            string = string + Globals.getSection15().toString();
        }
        pcGenGUI.showLicense("OGL License 1.0a", string);
    }

    public static void showMature(String string) {
        Logging.errorPrint("Warning: The following datasets contains mature themes. User discretion is advised.");
        Logging.errorPrint(string);
        final JFrame jFrame = new JFrame("Maturity Warning");
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JLabel jLabel = new JLabel("Warning: The following datasets contains mature themes.", 0);
        JLabel jLabel2 = new JLabel("User discretion is advised.", 0);
        final JCheckBox jCheckBox = new JCheckBox("Show on source load");
        JButton jButton = new JButton("Close");
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jLabel2, "South");
        jPanel2.setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)jPanel, "North");
        jFrame.getContentPane().add((Component)jPanel2, "Center");
        jFrame.getContentPane().add((Component)jPanel3, "South");
        JEditorPane jEditorPane = new JEditorPane("text/html", string);
        jEditorPane.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(jEditorPane);
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel3.add(jCheckBox);
        jPanel3.add(jButton);
        jCheckBox.setSelected(SettingsHandler.showMature());
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jFrame.dispose();
            }
        });
        jCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SettingsHandler.setShowMature(jCheckBox.isSelected());
            }
        });
        jFrame.setSize(new Dimension(456, 176));
        Utility.centerFrame(jFrame, false);
        jFrame.setVisible(true);
    }

    public static void showLicense(String string, List<URI> list) {
        for (URI uRI : list) {
            try {
                StringBuilder stringBuilder = LstFileLoader.readFromURI(uRI);
                pcGenGUI.showLicense(string, stringBuilder.toString());
            }
            catch (PersistenceLayerException persistenceLayerException) {
                Logging.errorPrint("Could not read license at " + uRI, persistenceLayerException);
            }
        }
    }

    public static void showLicense(String string, String string2) {
        if (string == null) {
            string = "OGL License 1.0a";
        }
        if (string2 == null) {
            string2 = "No license information found";
        }
        final JFrame jFrame = new JFrame(string);
        JButton jButton = new JButton("Close");
        JPanel jPanel = new JPanel();
        final JCheckBox jCheckBox = new JCheckBox("Show on source load");
        jPanel.add(jCheckBox);
        jCheckBox.setSelected(SettingsHandler.showLicense());
        jCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SettingsHandler.setShowLicense(jCheckBox.isSelected());
            }
        });
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jFrame.dispose();
            }
        });
        IconUtilitities.maybeSetIcon(jFrame, "PcgenIcon.gif");
        JEditorPane jEditorPane = new JEditorPane("text/html", string2);
        jEditorPane.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(jEditorPane);
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)jScrollPane, "Center");
        jFrame.getContentPane().add((Component)jPanel, "South");
        jFrame.setSize(new Dimension(700, 500));
        Utility.centerFrame(jFrame, false);
        jFrame.setVisible(true);
    }

    public static void showSponsors() {
        Map<String, String> map;
        String string = "PCGen's sponsors";
        final JFrame jFrame = new JFrame(string);
        JButton jButton = new JButton("Close");
        JPanel jPanel = new JPanel();
        final JCheckBox jCheckBox = new JCheckBox("Show on source load");
        jPanel.add(jCheckBox);
        jCheckBox.setSelected(SettingsHandler.showSponsors());
        jCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SettingsHandler.setShowSponsors(jCheckBox.isSelected());
            }
        });
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jFrame.dispose();
            }
        });
        IconUtilitities.maybeSetIcon(jFrame, "PcgenIcon.gif");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>");
        stringBuffer.append("<img src='").append(SponsorLoader.getConvertedSponsorPath(Globals.getSponsor("PCGEN").get("IMAGEBANNER"))).append("'><br>");
        String string2 = "";
        if (Globals.getSponsors().size() > 2) {
            string2 = "s";
        }
        stringBuffer.append("<H2><CENTER>Would like to thank our official sponsor").append(string2).append(":</CENTER></h2>");
        List<Map<String, String>> list = Globals.getSponsors();
        int n = 172;
        for (int i = 0; i < list.size(); ++i) {
            map = list.get(i);
            if (map.get("SPONSOR").equals("PCGEN")) continue;
            n += 70;
            stringBuffer.append("<img src='").append(SponsorLoader.getConvertedSponsorPath(map.get("IMAGEBANNER"))).append("'><br>");
        }
        stringBuffer.append("</html>");
        JEditorPane jEditorPane = new JEditorPane("text/html", stringBuffer.toString());
        jEditorPane.setEditable(false);
        map = new JScrollPane();
        ((JScrollPane)((Object)map)).setViewportView(jEditorPane);
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)((Object)map), "Center");
        jFrame.getContentPane().add((Component)jPanel, "South");
        jFrame.setSize(new Dimension(505, n));
        Utility.centerFrame(jFrame, false);
        jFrame.setVisible(true);
    }

    public static void showMandatoryD20Info() {
        ImageIcon imageIcon = IconUtilitities.getImageIcon("D20_logo_RGB.jpg");
        if (imageIcon != null) {
            final JFrame jFrame = new JFrame("D20 Required Information");
            IconUtilitities.maybeSetIcon(jFrame, "PcgenIcon.gif");
            JPanel jPanel = new JPanel();
            JPanel jPanel2 = new JPanel();
            JPanel jPanel3 = new JPanel();
            JLabel jLabel = new JLabel(imageIcon);
            final JCheckBox jCheckBox = new JCheckBox("Show on source load");
            JButton jButton = new JButton("Close");
            jPanel.add(jLabel);
            jPanel2.setLayout(new BorderLayout());
            jFrame.getContentPane().add((Component)jPanel, "North");
            jFrame.getContentPane().add((Component)jPanel2, "Center");
            jFrame.getContentPane().add((Component)jPanel3, "South");
            String string = pcGenGUI.readTextFromFile(SettingsHandler.getPcgenSystemDir() + File.separator + "D20System.htm");
            JEditorPane jEditorPane = new JEditorPane("text/html", string);
            jEditorPane.setEditable(false);
            jEditorPane.addHyperlinkListener(new Hyperactive());
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setViewportView(jEditorPane);
            jPanel2.add((Component)jScrollPane, "Center");
            jPanel3.add(jCheckBox);
            jPanel3.add(jButton);
            jCheckBox.setSelected(SettingsHandler.showD20Info());
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jFrame.dispose();
                }
            });
            jCheckBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    SettingsHandler.setShowD20Info(jCheckBox.isSelected());
                }
            });
            jFrame.setSize(new Dimension(456, 352));
            Utility.centerFrame(jFrame, false);
            jFrame.setVisible(true);
        }
    }

    public static void showTipOfTheDay() {
        new TipOfTheDay().setVisible(true);
    }

    private void askFileLocation() {
        Object[] objectArray = new Object[]{"OK"};
        JLabel jLabel = new JLabel("<html>Select a directory to store PCGen options in:<hr><b>PCGen Dir</b>: This is the directory that PCGen is installed into (default)<br><b>Home Dir</b>: This is your home directory<br><b>Select</b>: Select a directory to use <br>If you have an existing options.ini file, then select the directory containing that file<hr>");
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JPanel jPanel4 = new JPanel(new BorderLayout());
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButton jRadioButton = new JRadioButton("PCGen Dir", "pcgen".equals(SettingsHandler.getFilePaths()));
        JRadioButton jRadioButton2 = new JRadioButton("Home Dir", "user".equals(SettingsHandler.getFilePaths()));
        JRadioButton jRadioButton3 = new JRadioButton("Select a directory", !"pcgen".equals(SettingsHandler.getFilePaths()) && !"user".equals(SettingsHandler.getFilePaths()));
        final JTextField jTextField = new JTextField(String.valueOf(SettingsHandler.getPcgenFilesDir()));
        jTextField.setEditable(false);
        jTextField.setMinimumSize(new Dimension(90, 25));
        if ("user".equals(SettingsHandler.getFilePaths())) {
            jTextField.setText(System.getProperty("user.home") + File.separator + ".pcgen");
        }
        final JButton jButton = new JButton("...");
        jButton.setEnabled(false);
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        jPanel.add(jLabel);
        jPanel2.add(jRadioButton);
        jPanel2.add(jRadioButton2);
        jPanel3.add((Component)jRadioButton3, "North");
        jRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SettingsHandler.setFilePaths("pcgen");
                jTextField.setText(System.getProperty("user.dir"));
            }
        });
        jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SettingsHandler.setFilePaths("user");
                jTextField.setText(System.getProperty("user.home") + File.separator + ".pcgen");
            }
        });
        jRadioButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SettingsHandler.setFilePaths("select");
                jButton.setEnabled(true);
            }
        });
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                File file = SettingsHandler.getPcgenFilesDir();
                JFileChooser jFileChooser = file == null ? new JFileChooser() : new JFileChooser(file);
                jFileChooser.setFileSelectionMode(1);
                int n = jFileChooser.showOpenDialog(null);
                if (n == 0) {
                    file = jFileChooser.getSelectedFile();
                }
                jTextField.setText(String.valueOf(file));
                SettingsHandler.setPcgenFilesDir(file);
            }
        });
        jPanel3.add((Component)jTextField, "Center");
        jPanel3.add((Component)jButton, "East");
        jPanel4.setSize(new Dimension(400, 200));
        jPanel4.add((Component)jPanel, "North");
        jPanel4.add((Component)jPanel2, "Center");
        jPanel4.add((Component)jPanel3, "South");
        Object[] objectArray2 = new Object[]{jPanel4};
        JOptionPane.showOptionDialog(null, objectArray2, "Directory for options.ini location", -1, 1, null, objectArray, objectArray[0]);
    }

    private static void hideSplashScreen() {
        if (splash != null) {
            splash.dispose();
            splash = null;
        }
    }

    private static void initHpFrame(PlayerCharacter playerCharacter) {
        if (hpFrame == null) {
            hpFrame = new HPFrame();
        }
        hpFrame.setCharacter(playerCharacter);
    }

    private boolean processStartupArgs() {
        boolean bl = true;
        for (int i = 0; i < startupArgs.length; ++i) {
            File file = new File(startupArgs[i]);
            if (PCGFile.isPCGenCharacterFile(file)) {
                if (this.frame.loadPCFromFile(file) != null) continue;
                Logging.errorPrint("No such PC file: " + startupArgs[i]);
                bl = false;
                continue;
            }
            if (!PCGFile.isPCGenPartyFile(file) || this.frame.loadPartyFromFile(file)) continue;
            Logging.errorPrint("No such Party file: " + startupArgs[i]);
            bl = false;
        }
        return bl;
    }

    private static String readTextFromFile(String string) {
        String string2;
        File file = new File(string);
        if (!file.exists()) {
            Logging.errorPrint("Could not find license at " + string);
            String string3 = "No license information found";
            return string3;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            int n = (int)file.length();
            char[] cArray = new char[n];
            bufferedReader.read(cArray, 0, n);
            bufferedReader.close();
            string2 = new String(cArray);
        }
        catch (IOException iOException) {
            Logging.errorPrint("Could not read license at " + string, iOException);
            string2 = "No license information found";
        }
        return string2;
    }

    private static void showSplashScreen() {
        splash = new SplashScreen();
    }

    static {
        templateName = "";
        inFileName = "";
        outFileName = "";
        partyMode = false;
        startupArgs = new String[0];
        hpFrame = null;
    }
}

