/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import java.util.StringTokenizer;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.spell.Spell;
import pcgen.gui.filter.AbstractPObjectFilter;
import pcgen.util.PropertyFactory;

final class RangeFilter
extends AbstractPObjectFilter {
    private String range;

    RangeFilter(String string) {
        this.range = string;
        this.range = RangeFilter.normalizeCategory(this.range);
        this.range = RangeFilter.normalizeRange(this.range);
        this.setCategory(PropertyFactory.getString("in_range"));
        this.setName(this.range);
    }

    public boolean accept(PlayerCharacter playerCharacter, PObject pObject) {
        if (pObject == null) {
            return false;
        }
        if (pObject instanceof Spell) {
            return RangeFilter.normalizeRange(((Spell)pObject).getRange()).indexOf(this.range) > -1;
        }
        return true;
    }

    private static String normalizeCategory(String string) {
        String string2 = string.trim().toUpperCase();
        if (string2.startsWith("CLOSE")) {
            return "Close";
        }
        if (string2.startsWith("MEDIUM")) {
            return "Medium";
        }
        if (string2.startsWith("LONG")) {
            return "Long";
        }
        if (string2.startsWith("PERSONAL")) {
            return "Personal";
        }
        if (string2.startsWith("TOUCH")) {
            return "Touch";
        }
        return string;
    }

    private static String normalizeRange(String string) {
        StringTokenizer stringTokenizer;
        StringBuffer stringBuffer;
        int n;
        String string2 = string.trim();
        if ("SEE TEXT".equals(string2.toUpperCase())) {
            return "See text";
        }
        int n2 = string2.indexOf("ft");
        int n3 = string2.indexOf("'");
        while (n2 + n3 > -2) {
            if (n3 > -1) {
                string2 = string2.substring(0, n3) + " feet" + string2.substring(n3 + 1);
            }
            if (n2 > -1) {
                n = 2;
                if (string2.indexOf("ft.") == n2) {
                    n = 3;
                }
                string2 = string2.substring(0, n2) + " feet" + string2.substring(n2 + n);
            }
            n2 = string2.indexOf("ft");
            n3 = string2.indexOf("'");
        }
        n = string2.indexOf("+");
        String string3 = "";
        if (n > -1) {
            stringBuffer = new StringBuffer();
            stringTokenizer = new StringTokenizer(string2, "+");
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append(string3).append(stringTokenizer.nextToken());
                string3 = " + ";
            }
            string2 = stringBuffer.toString();
        }
        int n4 = string2.indexOf("/");
        string3 = "";
        if (n4 > -1) {
            stringBuffer = new StringBuffer();
            stringTokenizer = new StringTokenizer(string2, "/");
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append(string3).append(stringTokenizer.nextToken());
                string3 = " / ";
            }
            string2 = stringBuffer.toString();
        }
        int n5 = string2.indexOf("lvl");
        while (n5 > -1) {
            string2 = string2.substring(0, n5) + "level" + string2.substring(n5 + 3);
            n5 = string2.indexOf("lvl");
        }
        int n6 = string2.indexOf("touch");
        if (n6 > -1) {
            stringBuffer = new StringBuffer();
            stringTokenizer = new StringTokenizer(string2, " ", true);
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if ("touch".equals(string4)) {
                    string4 = "Touch";
                }
                stringBuffer.append(string4);
            }
            string2 = stringBuffer.toString();
        }
        if (string2.length() > 0) {
            stringBuffer = new StringBuffer();
            stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append(stringTokenizer.nextToken()).append(" ");
            }
            string2 = stringBuffer.toString().trim();
        }
        return string2;
    }
}

