/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import pcgen.gui.filter.PObjectFilter;

final class FilterList
extends JList {
    static final long serialVersionUID = 6872311299112043236L;
    private static final Border NO_FOCUS_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);

    FilterList(ListModel listModel) {
        super(listModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setCellRenderer(new FilterListCellRenderer());
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        int n = this.locationToIndex(mouseEvent.getPoint());
        if (n > -1) {
            PObjectFilter pObjectFilter = (PObjectFilter)this.getModel().getElementAt(n);
            return pObjectFilter.getDescription().length() > 0 ? pObjectFilter.getDescription() : pObjectFilter.getName();
        }
        return this.getToolTipText();
    }

    private static class FilterListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private FilterListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setComponentOrientation(jList.getComponentOrientation());
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            PObjectFilter pObjectFilter = (PObjectFilter)object;
            this.setText(pObjectFilter.getCategory() + " :  " + pObjectFilter.getName());
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            this.setBorder(bl2 ? UIManager.getBorder("List.focusCellHighlightBorder") : NO_FOCUS_BORDER);
            return this;
        }
    }
}

