/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import pcgen.core.Description;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.SettingsHandler;
import pcgen.core.spell.Spell;
import pcgen.gui.editor.AvailableSelectedPanel;
import pcgen.gui.editor.BasePanel;
import pcgen.gui.editor.DescriptionPanel;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.WholeNumberField;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.GlobalLstToken;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.TokenStore;
import pcgen.util.DecimalNumberField;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public class SpellBasePanel
extends BasePanel {
    private DecimalNumberField txtCost;
    private DescriptionPanel pnlDescription;
    private JButton btnChooseDescriptor;
    private JCheckBox chkPotionAllowed;
    private JCheckBox chkRingAllowed;
    private JCheckBox chkScrollAllowed;
    private JCheckBox chkWandAllowed;
    private JComboBoxEx cmbCastingTime;
    private JComboBoxEx cmbComponents;
    private JComboBoxEx cmbDuration;
    private JComboBoxEx cmbRange;
    private JComboBoxEx cmbSavingThrow;
    private JComboBoxEx cmbSchool;
    private JComboBoxEx cmbSpellRes;
    private JComboBoxEx cmbStat;
    private JComboBoxEx cmbSubschool;
    private JComboBoxEx cmbTarget;
    private JLabel lblCastingTime;
    private JLabel lblComponents;
    private JLabel lblCost;
    private JLabel lblDescriptor;
    private JLabel lblDuration;
    private JLabel lblPotionAllowed;
    private JLabel lblRange;
    private JLabel lblRingAllowed;
    private JLabel lblSavingThrow;
    private JLabel lblSchool;
    private JLabel lblScrollAllowed;
    private JLabel lblSpellRes;
    private JLabel lblStat;
    private JLabel lblSubschool;
    private JLabel lblTarget;
    private JLabel lblWandAllowed;
    private JLabel lblXpCost;
    private JPanel pnlMagicTypes;
    private JTextField txtDescriptor;
    private WholeNumberField txtXpCost;

    public SpellBasePanel() {
        this.initComponents();
        this.initComponentContents();
    }

    public void updateData(PObject pObject) {
        CharSequence charSequence;
        StringTokenizer stringTokenizer;
        Spell spell = (Spell)pObject;
        String string = this.pnlDescription.getText();
        Map<String, LstToken> map = TokenStore.inst().getTokenMap(GlobalLstToken.class);
        GlobalLstToken globalLstToken = (GlobalLstToken)map.get("DESC");
        if (globalLstToken != null) {
            stringTokenizer = new StringTokenizer(string, "\t");
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    globalLstToken.parse(spell, stringTokenizer.nextToken(), -9);
                }
                catch (PersistenceLayerException persistenceLayerException) {
                    Logging.errorPrint("Invalid Description: " + string);
                    Logging.errorPrint("  Token Parse Failed: " + persistenceLayerException.getLocalizedMessage());
                }
            }
        }
        spell.setDescIsPI(this.pnlDescription.getDescIsPI());
        spell.setComponentList(".CLEAR");
        String string2 = (String)this.cmbComponents.getSelectedItem();
        if (string2 != null) {
            spell.setComponentList(string2);
        }
        spell.setCastingTime(".CLEAR");
        string2 = (String)this.cmbCastingTime.getSelectedItem();
        if (string2 != null) {
            spell.setCastingTime(string2);
        }
        spell.setRange(".CLEAR");
        string2 = (String)this.cmbRange.getSelectedItem();
        if (string2 != null) {
            spell.setRange(string2);
        }
        string2 = (String)this.cmbTarget.getSelectedItem();
        spell.setTarget(string2);
        spell.setDuration(".CLEAR");
        string2 = (String)this.cmbDuration.getSelectedItem();
        if (string2 != null) {
            spell.setDuration(string2);
        }
        spell.setSaveInfo(".CLEAR");
        string2 = (String)this.cmbSavingThrow.getSelectedItem();
        if (string2 != null) {
            spell.setSaveInfo(string2);
        }
        spell.setSpellResistance(".CLEAR");
        string2 = (String)this.cmbSpellRes.getSelectedItem();
        if (string2 != null) {
            spell.setSpellResistance(string2);
        }
        spell.addSchool(".CLEAR");
        string2 = (String)this.cmbSchool.getSelectedItem();
        if (string2 != null) {
            spell.addSchool(string2);
        }
        spell.addSubschool(".CLEAR");
        string2 = (String)this.cmbSubschool.getSelectedItem();
        if (string2 != null && !string2.equals("(None)")) {
            spell.addSubschool(string2);
        }
        spell.addDescriptor(".CLEAR");
        string2 = this.txtDescriptor.getText();
        stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            charSequence = stringTokenizer.nextToken();
            spell.addDescriptor((String)charSequence);
        }
        spell.setCost(Double.toString(this.txtCost.getValue()));
        spell.setXPCost(this.txtXpCost.getValue());
        spell.setStat((String)this.cmbStat.getSelectedItem());
        charSequence = new StringBuffer();
        if (this.chkPotionAllowed.isSelected()) {
            ((StringBuffer)charSequence).append("potion");
        }
        if (!this.chkRingAllowed.isSelected()) {
            ((StringBuffer)charSequence).append("[ring]");
        }
        if (!this.chkScrollAllowed.isSelected()) {
            ((StringBuffer)charSequence).append("[scroll]");
        }
        if (!this.chkWandAllowed.isSelected()) {
            ((StringBuffer)charSequence).append("[wand]");
        }
        spell.setCreatableItem(((StringBuffer)charSequence).toString());
    }

    /*
     * WARNING - void declaration
     */
    public void updateView(PObject pObject) {
        void var5_8;
        Object object;
        Spell spell = (Spell)pObject;
        StringBuffer stringBuffer = new StringBuffer();
        for (Description object22 : pObject.getDescriptionList()) {
            if (stringBuffer.length() == 0) {
                stringBuffer.append("\t");
            }
            stringBuffer.append(object22.getPCCText());
        }
        this.pnlDescription.setText(stringBuffer.toString());
        this.pnlDescription.setDescIsPI(spell.getDescIsPI());
        this.cmbComponents.setSelectedItem(spell.getComponentList());
        this.cmbCastingTime.setSelectedItem(spell.getCastingTime());
        this.cmbRange.setSelectedItem(spell.getRange());
        this.cmbTarget.setSelectedItem(spell.getTarget());
        this.cmbDuration.setSelectedItem(spell.getDuration());
        this.cmbSavingThrow.setSelectedItem(spell.getSaveInfo());
        this.cmbSpellRes.setSelectedItem(spell.getSpellResistance());
        this.cmbSchool.setSelectedItem(spell.getSchool());
        this.cmbSubschool.setSelectedItem(spell.getSubschool());
        List<String> list = spell.getDescriptorList();
        StringBuffer stringBuffer2 = new StringBuffer();
        if (list.size() > 0) {
            object = list.iterator();
            while (object.hasNext()) {
                stringBuffer2.append(object.next()).append(",");
            }
            StringBuffer stringBuffer3 = stringBuffer2.deleteCharAt(stringBuffer2.length() - 1);
        }
        this.txtDescriptor.setText(var5_8.toString());
        if (this.cmbSubschool.getSelectedIndex() < 0) {
            this.cmbSubschool.setSelectedIndex(0);
        }
        this.cmbStat.setSelectedItem(spell.getStat());
        this.txtCost.setValue(spell.getCost().doubleValue());
        this.txtXpCost.setValue(spell.getXPCost());
        object = spell.getCreatableItem().toLowerCase();
        this.chkPotionAllowed.setSelected(SpellBasePanel.canCreateItem("potion", (String)object));
        this.chkRingAllowed.setSelected(SpellBasePanel.canCreateItem("ring", (String)object));
        this.chkScrollAllowed.setSelected(SpellBasePanel.canCreateItem("scroll", (String)object));
        this.chkWandAllowed.setSelected(SpellBasePanel.canCreateItem("wand", (String)object));
    }

    private static boolean canCreateItem(String string, String string2) {
        boolean bl = true;
        if (string.equals("potion")) {
            bl = false;
        }
        if (string2.indexOf("[" + string + "]") >= 0) {
            bl = false;
        } else if (string2.indexOf(string) >= 0) {
            bl = true;
        }
        return bl;
    }

    private void initComponentContents() {
        this.cmbCastingTime.setModel(new DefaultComboBoxModel<Object>(Globals.getCastingTimesSet().toArray()));
        this.cmbRange.setModel(new DefaultComboBoxModel<Object>(Globals.getRangesSet().toArray()));
        this.cmbSpellRes.setModel(new DefaultComboBoxModel<Object>(Globals.getSrSet().toArray()));
        this.cmbSchool.setModel(new DefaultComboBoxModel<Object>(SettingsHandler.getGame().getUnmodifiableSchoolsList().toArray()));
        this.cmbSavingThrow.setModel(new DefaultComboBoxModel<Object>(Globals.getSaveInfoSet().toArray()));
        this.cmbTarget.setModel(new DefaultComboBoxModel<Object>(Globals.getTargetSet().toArray()));
        this.cmbComponents.setModel(new DefaultComboBoxModel<Object>(Globals.getComponentSet().toArray()));
        this.cmbDuration.setModel(new DefaultComboBoxModel<Object>(Globals.getDurationSet().toArray()));
        this.cmbStat.setModel(new DefaultComboBoxModel<Object>(Globals.getStatSet().toArray()));
        ArrayList<String> arrayList = new ArrayList<String>(10);
        arrayList.add("(None)");
        arrayList.addAll(Globals.getSubschools());
        this.cmbSubschool.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
    }

    private void initComponents() {
        this.pnlDescription = new DescriptionPanel();
        this.lblComponents = new JLabel();
        this.cmbComponents = new JComboBoxEx();
        this.lblCastingTime = new JLabel();
        this.cmbCastingTime = new JComboBoxEx();
        this.lblRange = new JLabel();
        this.cmbRange = new JComboBoxEx();
        this.lblTarget = new JLabel();
        this.cmbTarget = new JComboBoxEx();
        this.lblDuration = new JLabel();
        this.cmbDuration = new JComboBoxEx();
        this.lblSavingThrow = new JLabel();
        this.cmbSavingThrow = new JComboBoxEx();
        this.lblSpellRes = new JLabel();
        this.cmbSpellRes = new JComboBoxEx();
        this.lblCost = new JLabel();
        this.txtCost = new DecimalNumberField(0.0, 6);
        this.lblSchool = new JLabel();
        this.cmbSchool = new JComboBoxEx();
        this.lblSubschool = new JLabel();
        this.cmbSubschool = new JComboBoxEx();
        this.lblDescriptor = new JLabel();
        this.txtDescriptor = new JTextField(10);
        this.btnChooseDescriptor = new JButton(new ChooseDescriptorAction(this));
        this.lblStat = new JLabel();
        this.cmbStat = new JComboBoxEx();
        this.lblXpCost = new JLabel();
        this.txtXpCost = new WholeNumberField(0, 6);
        this.pnlMagicTypes = new JPanel();
        this.lblPotionAllowed = new JLabel();
        this.chkPotionAllowed = new JCheckBox();
        this.chkRingAllowed = new JCheckBox();
        this.lblRingAllowed = new JLabel();
        this.lblScrollAllowed = new JLabel();
        this.chkScrollAllowed = new JCheckBox();
        this.lblWandAllowed = new JLabel();
        this.chkWandAllowed = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.pnlDescription.setPreferredSize(new Dimension(150, 40));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        this.add((Component)this.pnlDescription, gridBagConstraints);
        this.lblComponents.setText(PropertyFactory.getString("in_demComponents"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.lblComponents, gridBagConstraints);
        this.lblCastingTime.setText(PropertyFactory.getString("in_demCastingTime"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.lblCastingTime, gridBagConstraints);
        this.cmbCastingTime.setEditable(true);
        this.cmbCastingTime.setPreferredSize(new Dimension(120, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.25;
        this.add((Component)this.cmbCastingTime, gridBagConstraints);
        this.lblRange.setText(PropertyFactory.getString("in_demRange"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.lblRange, gridBagConstraints);
        this.cmbRange.setEditable(true);
        this.cmbRange.setPreferredSize(new Dimension(120, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.cmbRange, gridBagConstraints);
        this.lblTarget.setText(PropertyFactory.getString("in_demTargetArea"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.lblTarget, gridBagConstraints);
        this.cmbTarget.setEditable(true);
        this.cmbTarget.setPreferredSize(new Dimension(120, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.cmbTarget, gridBagConstraints);
        this.lblDuration.setText(PropertyFactory.getString("in_demDuration"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.lblDuration, gridBagConstraints);
        this.cmbDuration.setEditable(true);
        this.cmbDuration.setPreferredSize(new Dimension(120, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.cmbDuration, gridBagConstraints);
        this.lblSavingThrow.setText(PropertyFactory.getString("in_demSavingThrow"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.lblSavingThrow, gridBagConstraints);
        this.cmbSavingThrow.setEditable(true);
        this.cmbSavingThrow.setPreferredSize(new Dimension(120, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.cmbSavingThrow, gridBagConstraints);
        this.lblSpellRes.setText(PropertyFactory.getString("in_demSpellResistance"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.lblSpellRes, gridBagConstraints);
        this.cmbSpellRes.setEditable(true);
        this.cmbSpellRes.setPreferredSize(new Dimension(120, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.cmbSpellRes, gridBagConstraints);
        this.lblCost.setText(PropertyFactory.getString("in_demComponentCost"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.lblCost, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.txtCost, gridBagConstraints);
        this.lblSchool.setText(PropertyFactory.getString("in_demSchool"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(2, 10, 2, 2);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.lblSchool, gridBagConstraints);
        this.cmbSchool.setEditable(true);
        this.cmbSchool.setPreferredSize(new Dimension(120, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.cmbSchool, gridBagConstraints);
        this.lblSubschool.setText(PropertyFactory.getString("in_demSubschool"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(2, 10, 2, 2);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.lblSubschool, gridBagConstraints);
        this.cmbSubschool.setEditable(true);
        this.cmbSubschool.setPreferredSize(new Dimension(120, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.25;
        this.add((Component)this.cmbSubschool, gridBagConstraints);
        this.lblDescriptor.setText(PropertyFactory.getString("in_demDescriptor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(2, 10, 2, 2);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.lblDescriptor, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setPreferredSize(new Dimension(80, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        jPanel.add((Component)this.txtDescriptor, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        jPanel.add((Component)this.btnChooseDescriptor, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.weightx = 0.25;
        this.add((Component)jPanel, gridBagConstraints);
        this.lblStat.setText(PropertyFactory.getString("in_demStat"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(2, 10, 2, 2);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.lblStat, gridBagConstraints);
        this.cmbStat.setEditable(true);
        this.cmbStat.setPreferredSize(new Dimension(120, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.25;
        this.add((Component)this.cmbStat, gridBagConstraints);
        this.lblXpCost.setText(PropertyFactory.getString("in_demXPCost"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.insets = new Insets(2, 10, 2, 2);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.lblXpCost, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.txtXpCost, gridBagConstraints);
        this.cmbComponents.setEditable(true);
        this.cmbComponents.setPreferredSize(new Dimension(120, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.cmbComponents, gridBagConstraints);
        this.pnlMagicTypes.setLayout(new GridBagLayout());
        this.pnlMagicTypes.setBorder(new TitledBorder(PropertyFactory.getString("in_demAllowedMagicItemType")));
        this.lblPotionAllowed.setLabelFor(this.chkPotionAllowed);
        this.lblPotionAllowed.setText(PropertyFactory.getString("in_demPotion"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(2, 0, 2, 2);
        gridBagConstraints.anchor = 13;
        this.pnlMagicTypes.add((Component)this.lblPotionAllowed, gridBagConstraints);
        this.chkPotionAllowed.setHorizontalTextPosition(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        this.pnlMagicTypes.add((Component)this.chkPotionAllowed, gridBagConstraints);
        this.lblScrollAllowed.setLabelFor(this.chkScrollAllowed);
        this.lblScrollAllowed.setText(PropertyFactory.getString("in_demScroll"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(2, 0, 2, 2);
        gridBagConstraints.anchor = 13;
        this.pnlMagicTypes.add((Component)this.lblScrollAllowed, gridBagConstraints);
        this.chkScrollAllowed.setHorizontalTextPosition(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        this.pnlMagicTypes.add((Component)this.chkScrollAllowed, gridBagConstraints);
        this.lblWandAllowed.setLabelFor(this.chkWandAllowed);
        this.lblWandAllowed.setText(PropertyFactory.getString("in_demWand"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(2, 0, 2, 2);
        gridBagConstraints.anchor = 13;
        this.pnlMagicTypes.add((Component)this.lblWandAllowed, gridBagConstraints);
        this.chkWandAllowed.setHorizontalTextPosition(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        this.pnlMagicTypes.add((Component)this.chkWandAllowed, gridBagConstraints);
        this.lblRingAllowed.setLabelFor(this.chkRingAllowed);
        this.lblRingAllowed.setText(PropertyFactory.getString("in_demRing"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(2, 0, 2, 2);
        gridBagConstraints.anchor = 13;
        this.pnlMagicTypes.add((Component)this.lblRingAllowed, gridBagConstraints);
        this.chkRingAllowed.setHorizontalTextPosition(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        this.pnlMagicTypes.add((Component)this.chkRingAllowed, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 18;
        this.add((Component)this.pnlMagicTypes, gridBagConstraints);
    }

    private class SelectDescriptorDialog
    extends JDialog {
        private AvailableSelectedPanel pnlSelectDescriptor;
        private JButton btnSave;
        private JButton btnCancel;
        private String descriptorList;

        public SelectDescriptorDialog(JComponent jComponent, String string) {
            this.setModal(true);
            this.descriptorList = string;
            this.initComponents();
            this.initComponentsContents();
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    SelectDescriptorDialog.this.closeDialog();
                }
            });
            this.setLocationRelativeTo(jComponent);
        }

        public SelectDescriptorDialog(JComponent jComponent) {
            this(jComponent, null);
        }

        public String getDescriptor() {
            return this.descriptorList;
        }

        private void closeDialog() {
            this.setVisible(false);
        }

        private void initComponents() {
            JPanel jPanel = new JPanel(new BorderLayout());
            this.pnlSelectDescriptor = new AvailableSelectedPanel();
            this.btnSave = new JButton(new AbstractAction(PropertyFactory.getString("in_save")){

                public void actionPerformed(ActionEvent actionEvent) {
                    Object[] objectArray = SelectDescriptorDialog.this.pnlSelectDescriptor.getSelectedList();
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < objectArray.length; ++i) {
                        stringBuffer.append(objectArray[i]).append(",");
                    }
                    stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                    SelectDescriptorDialog.this.descriptorList = stringBuffer.toString();
                    SelectDescriptorDialog.this.closeDialog();
                }
            });
            this.btnCancel = new JButton(new AbstractAction(PropertyFactory.getString("in_cancel")){

                public void actionPerformed(ActionEvent actionEvent) {
                    SelectDescriptorDialog.this.closeDialog();
                }
            });
            JPanel jPanel2 = new JPanel(new FlowLayout(2, 3, 0));
            jPanel2.add(this.btnCancel);
            jPanel2.add(this.btnSave);
            jPanel.add((Component)this.pnlSelectDescriptor, "Center");
            jPanel.add((Component)jPanel2, "South");
            this.getContentPane().add(jPanel);
            this.setSize(new Dimension(400, 400));
        }

        private void initComponentsContents() {
            this.pnlSelectDescriptor.setAvailableList(new ArrayList<String>(Globals.getDescriptorSet()), true);
            if (!this.descriptorList.equals("")) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.descriptorList, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    this.pnlSelectDescriptor.addItemToSelected(stringTokenizer.nextToken());
                }
            }
        }
    }

    private class ChooseDescriptorAction
    extends AbstractAction {
        private JComponent parentComponent;

        public ChooseDescriptorAction(JComponent jComponent) {
            super("...");
            this.parentComponent = jComponent;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = SpellBasePanel.this.txtDescriptor.getText();
            SelectDescriptorDialog selectDescriptorDialog = new SelectDescriptorDialog(this.parentComponent, string);
            selectDescriptorDialog.setVisible(true);
            String string2 = selectDescriptorDialog.getDescriptor();
            SpellBasePanel.this.txtDescriptor.setText(string2);
            selectDescriptorDialog.dispose();
        }
    }
}

