/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import pcgen.core.Deity;
import pcgen.core.Description;
import pcgen.core.Globals;
import pcgen.core.PCAlignment;
import pcgen.core.PObject;
import pcgen.core.SettingsHandler;
import pcgen.core.WeaponProf;
import pcgen.gui.editor.AvailableSelectedPanel;
import pcgen.gui.editor.BasePanel;
import pcgen.gui.editor.DescriptionPanel;
import pcgen.gui.editor.EditUtil;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.GlobalLstToken;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.TokenStore;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DeityBasePanel
extends BasePanel {
    private AvailableSelectedPanel pnlFavoredWeapons;
    private DescriptionPanel pnlDescription;
    private JComboBoxEx cmbDeityAlignment;
    private JLabel lblDeityAlignment;
    private JLabel lblHolyItem;
    private JPanel pnlDeityAlignment;
    private JPanel pnlHolyItem;
    private JTextField txtHolyItem;

    DeityBasePanel() {
        this.initComponents();
        this.initComponentContents();
    }

    public void setDeityAlignment(String string) {
        for (PCAlignment pCAlignment : SettingsHandler.getGame().getUnmodifiableAlignmentList()) {
            if (!pCAlignment.isValidForDeity() || !pCAlignment.getKeyName().equals(string)) continue;
            this.cmbDeityAlignment.setSelectedItem(pCAlignment.getKeyName());
        }
    }

    public String getDeityAlignment() {
        int n;
        String string = (String)this.cmbDeityAlignment.getSelectedItem();
        if (string != null && (n = SettingsHandler.getGame().getIndexOfAlignment(string)) >= 0) {
            return SettingsHandler.getGame().getShortAlignmentAtIndex(n);
        }
        return null;
    }

    public void setDescIsPI(boolean bl) {
        this.pnlDescription.setDescIsPI(bl);
    }

    public boolean getDescIsPI() {
        return this.pnlDescription.getDescIsPI();
    }

    public void setDescriptionText(String string) {
        this.pnlDescription.setText(string);
    }

    public String getDescriptionText() {
        return this.pnlDescription.getText();
    }

    public void setFavoredWeaponsAvailableList(List<WeaponProf> list, boolean bl) {
        this.pnlFavoredWeapons.setAvailableList(list, bl);
    }

    public Object[] getFavoredWeaponsAvailableList() {
        return this.pnlFavoredWeapons.getAvailableList();
    }

    public void setFavoredWeaponsSelectedList(List<WeaponProf> list, boolean bl) {
        this.pnlFavoredWeapons.setSelectedList(list, bl);
    }

    public Object[] getFavoredWeaponsSelectedList() {
        return this.pnlFavoredWeapons.getSelectedList();
    }

    public void setHolyItemText(String string) {
        this.txtHolyItem.setText(string);
    }

    public String getHolyItemText() {
        return this.txtHolyItem.getText().trim();
    }

    @Override
    public void updateData(PObject pObject) {
        Object object;
        ((Deity)pObject).setHolyItem(this.getHolyItemText());
        ((Deity)pObject).setAlignment(this.getDeityAlignment());
        String string = this.getDescriptionText();
        Map<String, LstToken> map = TokenStore.inst().getTokenMap(GlobalLstToken.class);
        GlobalLstToken globalLstToken = (GlobalLstToken)map.get("DESC");
        if (globalLstToken != null) {
            object = new StringTokenizer(string, "\t");
            while (((StringTokenizer)object).hasMoreTokens()) {
                try {
                    globalLstToken.parse(pObject, ((StringTokenizer)object).nextToken(), -9);
                }
                catch (PersistenceLayerException persistenceLayerException) {
                    Logging.errorPrint("Invalid Description: " + string);
                    Logging.errorPrint("  Token Parse Failed: " + persistenceLayerException.getLocalizedMessage());
                }
            }
        }
        pObject.setDescIsPI(this.getDescIsPI());
        if (this.getFavoredWeaponsAvailableList().length == 0) {
            object = "Any";
        } else {
            Object[] objectArray = this.getFavoredWeaponsSelectedList();
            object = EditUtil.delimitArray(objectArray, '|');
        }
        ((Deity)pObject).setFavoredWeapon((String)object);
    }

    @Override
    public void updateView(PObject pObject) {
        this.setHolyItemText(((Deity)pObject).getHolyItem());
        StringBuffer stringBuffer = new StringBuffer();
        for (Description object2 : pObject.getDescriptionList()) {
            if (stringBuffer.length() == 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(object2.getPCCText());
        }
        this.setDescriptionText(stringBuffer.toString());
        this.setDescIsPI(pObject.getDescIsPI());
        this.setDeityAlignment(((Deity)pObject).getAlignment());
        ArrayList arrayList = new ArrayList();
        List<WeaponProf> list = Globals.getWeaponProfArrayCopy();
        StringTokenizer stringTokenizer = new StringTokenizer(((Deity)pObject).getFavoredWeapon(), "|", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.equalsIgnoreCase("ALL") || "ANY".equalsIgnoreCase(string)) {
                arrayList.addAll(list);
                list.clear();
                break;
            }
            WeaponProf weaponProf = Globals.getWeaponProfKeyed(string);
            if (weaponProf == null) continue;
            arrayList.add(weaponProf);
            list.remove(weaponProf);
        }
        this.setFavoredWeaponsAvailableList(list, true);
        this.setFavoredWeaponsSelectedList(arrayList, true);
    }

    private void initComponentContents() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PCAlignment pCAlignment : SettingsHandler.getGame().getUnmodifiableAlignmentList()) {
            if (!pCAlignment.isValidForDeity()) continue;
            arrayList.add(pCAlignment.getKeyName());
        }
        this.cmbDeityAlignment.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
    }

    private void initComponents() {
        this.pnlHolyItem = new JPanel();
        this.lblHolyItem = new JLabel();
        this.txtHolyItem = new JTextField();
        this.pnlDeityAlignment = new JPanel();
        this.lblDeityAlignment = new JLabel();
        this.cmbDeityAlignment = new JComboBoxEx();
        this.pnlDescription = new DescriptionPanel();
        this.pnlFavoredWeapons = new AvailableSelectedPanel();
        this.setLayout(new GridBagLayout());
        this.pnlHolyItem.setLayout(new GridBagLayout());
        this.lblHolyItem.setLabelFor(this.txtHolyItem);
        this.lblHolyItem.setText(PropertyFactory.getString("in_demHolyItem"));
        this.lblHolyItem.setDisplayedMnemonic(PropertyFactory.getMnemonic("in_mn_demHolyItem"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.pnlHolyItem.add((Component)this.lblHolyItem, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 1.0;
        this.pnlHolyItem.add((Component)this.txtHolyItem, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pnlHolyItem, gridBagConstraints);
        this.pnlDeityAlignment.setLayout(new GridBagLayout());
        this.lblDeityAlignment.setLabelFor(this.cmbDeityAlignment);
        this.lblDeityAlignment.setText(PropertyFactory.getString("in_demDeityAlign"));
        this.lblDeityAlignment.setDisplayedMnemonic(PropertyFactory.getMnemonic("in_mn_demDeityAlign"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.pnlDeityAlignment.add((Component)this.lblDeityAlignment, gridBagConstraints);
        this.cmbDeityAlignment.setPreferredSize(new Dimension(180, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.pnlDeityAlignment.add((Component)this.cmbDeityAlignment, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pnlDeityAlignment, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlDescription, gridBagConstraints);
        this.pnlFavoredWeapons.setHeader(PropertyFactory.getString("in_demFavWea"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlFavoredWeapons, gridBagConstraints);
    }
}

