/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JOptionPane;
import pcgen.core.Globals;
import pcgen.core.SettingsHandler;
import pcgen.gui.CsheetFilter;

class TemplateListModel
extends AbstractListModel {
    private CsheetFilter csheetFilter = null;
    private CsheetFilter psheetFilter = null;
    private String fileType = null;
    private String[] cSheets;
    private String[] pSheets;
    private boolean partyMode = false;
    private int attempts = 0;

    public TemplateListModel(CsheetFilter csheetFilter, CsheetFilter csheetFilter2, boolean bl, String string) {
        this.csheetFilter = csheetFilter;
        this.psheetFilter = csheetFilter2;
        this.partyMode = bl;
        this.fileType = string;
        this.updateTemplateList();
    }

    public Object getElementAt(int n) {
        if (this.partyMode) {
            if (n >= this.pSheets.length) {
                return "No templates found";
            }
            return this.pSheets[n];
        }
        if (n >= this.cSheets.length) {
            return "No templates found";
        }
        return this.cSheets[n];
    }

    public int getSize() {
        if (this.partyMode) {
            return Math.max(1, this.pSheets.length);
        }
        return Math.max(1, this.cSheets.length);
    }

    public int getNumFiles() {
        if (this.partyMode) {
            return this.pSheets.length;
        }
        return this.cSheets.length;
    }

    public int indexOf(Object object) {
        if (this.partyMode) {
            return Arrays.binarySearch(this.pSheets, object);
        }
        return Arrays.binarySearch(this.cSheets, object);
    }

    public void updateTemplateList() {
        int n;
        this.csheetFilter.setDirFilter(this.fileType);
        this.csheetFilter.setIgnoreExtension(".");
        List<String> list = this.csheetFilter.getAccepted();
        if (list.size() == 0 && this.attempts == 0) {
            Object[] objectArray = new Object[]{"OK", "CANCEL"};
            if (JOptionPane.showOptionDialog(null, "No templates found. Attempt to change to " + Globals.getDefaultPath() + File.separator + "outputsheets ?", "Warning", -1, 2, null, objectArray, objectArray[0]) == 0) {
                SettingsHandler.setPcgenOutputSheetDir(new File(Globals.getDefaultPath() + File.separator + "outputsheets"));
                this.attempts = 1;
                list = this.csheetFilter.getAccepted();
            }
        }
        this.cSheets = new String[list.size()];
        for (n = 0; n < list.size(); ++n) {
            this.cSheets[n] = list.get(n);
        }
        this.psheetFilter.setDirFilter(this.fileType);
        this.psheetFilter.setIgnoreExtension(".");
        list = this.psheetFilter.getAccepted();
        this.pSheets = new String[list.size()];
        for (n = 0; n < list.size(); ++n) {
            this.pSheets[n] = list.get(n);
        }
        Arrays.sort(this.pSheets);
        Arrays.sort(this.cSheets);
    }

    public boolean isPartyMode() {
        return this.partyMode;
    }

    public void setPartyMode(boolean bl) {
        this.partyMode = bl;
    }
}

