/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.apache.fop.apps.Options;
import org.apache.fop.apps.Version;
import org.apache.fop.render.awt.AWTRenderer;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.CsheetFilter;
import pcgen.gui.PFileChooser;
import pcgen.gui.TemplateListModel;
import pcgen.io.ExportHandler;
import pcgen.util.FOPHandler;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

final class MainPrint
extends JPanel {
    public static final int EXPORT_MODE = 0;
    public static final int PRINT_MODE = 1;
    static final long serialVersionUID = 2322087772130893998L;
    private static final String MSG = "Please standby while rendering ...";
    private static final CsheetFilter csheetFilter = new CsheetFilter();
    private static final CsheetFilter psheetFilter = new CsheetFilter(1);
    private ButtonListener bl = new ButtonListener();
    private FOPHandler fh = new FOPHandler();
    private JButton closeButton = new JButton();
    private JButton exportButton = new JButton();
    private JButton printButton = new JButton();
    private JButton templatePathButton = new JButton();
    private JCheckBox cboxParty = new JCheckBox();
    private JFrame parentFrame;
    private JLabel lblPCs = new JLabel();
    private JLabel lblTemplates = new JLabel();
    private JList pcList;
    private JList templateList;
    private JPanel buttonPanel = new JPanel();
    private JProgressBar progressBar = new JProgressBar();
    private JScrollPane pcScroll;
    private JScrollPane templateScroll;
    private JTextField progressField = new JTextField();
    private TemplateListModel templateModel;
    private Timer timer;
    private boolean partyMode = false;
    private int mode;

    public MainPrint(JFrame jFrame, int n) {
        this.mode = n;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logging.errorPrint("Error while initing form", exception);
        }
        this.parentFrame = jFrame;
        this.timer = new Timer(5, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = MainPrint.this.progressBar.getValue();
                if (n == MainPrint.this.progressBar.getMaximum()) {
                    n = -1;
                }
                MainPrint.this.progressBar.setValue(n + 1);
            }
        });
    }

    public void setCurrentPCSelection(int n) {
        this.pcList.updateUI();
        if (n > 0 && n - 1 < this.pcList.getModel().getSize() || this.pcList.getModel().getSize() == 1) {
            this.setPartyMode(false);
            this.pcList.setSelectedIndex(n - 1);
        } else {
            this.setPartyMode(true);
            this.pcList.setSelectedIndex(this.pcList.getModel().getSize() - 1);
        }
        this.setDefaultTemplateSelection();
    }

    private void setDefaultTemplateSelection() {
        int n;
        String string = this.partyMode ? SettingsHandler.getSelectedPartyPDFOutputSheet() : SettingsHandler.getSelectedCharacterPDFOutputSheet(null);
        File file = SettingsHandler.getPcgenOutputSheetDir();
        if (file != null && (n = file.getAbsolutePath().length() + 1) > 1 && n < string.length()) {
            string = string.substring(n);
        }
        n = Math.max(0, this.templateModel.indexOf(string));
        this.templateList.setSelectedIndex(n);
        this.templateList.ensureIndexIsVisible(n);
    }

    private void setPartyMode(boolean bl) {
        if (this.partyMode != bl) {
            this.partyMode = bl;
            TemplateListModel templateListModel = (TemplateListModel)this.templateList.getModel();
            templateListModel.setPartyMode(bl);
            templateListModel.updateTemplateList();
            this.templateList.updateUI();
            this.cboxParty.setSelected(bl);
        }
    }

    private void getTemplatePath() {
        PFileChooser pFileChooser = new PFileChooser();
        pFileChooser.setCurrentDirectory(new File(SettingsHandler.getPDFOutputSheetPath()));
        if (pFileChooser.showOpenDialog(this) == 0) {
            File file = pFileChooser.getSelectedFile();
            if (!file.isDirectory()) {
                file = file.getParentFile().getParentFile();
            }
            TemplateListModel templateListModel = (TemplateListModel)this.templateList.getModel();
            templateListModel.updateTemplateList();
            this.templateList.updateUI();
            this.setDefaultTemplateSelection();
        }
    }

    private void block() {
        this.closeButton.setEnabled(false);
        this.closeButton.update(this.closeButton.getGraphics());
        this.exportButton.setEnabled(false);
        this.exportButton.update(this.exportButton.getGraphics());
        this.printButton.setEnabled(false);
        this.printButton.update(this.printButton.getGraphics());
        this.progressField.setText(MSG);
        this.progressField.update(this.progressField.getGraphics());
        this.progressBar.setValue(0);
    }

    private void export() {
        PFileChooser pFileChooser = new PFileChooser();
        pFileChooser.setCurrentDirectory(new File(SettingsHandler.getPcgPath().toString()));
        pFileChooser.setFileSelectionMode(0);
        pFileChooser.addChoosableFileFilter(null, "All Files (*.*)");
        pFileChooser.addChoosableFileFilter("pdf", "PDF Documents (*.pdf)");
        int[] nArray = !this.partyMode ? this.pcList.getSelectedIndices() : new int[]{-2};
        for (int i = 0; i < nArray.length; ++i) {
            String string;
            block18: {
                string = this.partyMode ? "Entire Party" : (String)this.pcList.getModel().getElementAt(nArray[i]);
                pFileChooser.setSelectedFile(new File(SettingsHandler.getPcgPath().toString() + File.separator + string + ".pdf"));
                pFileChooser.setDialogTitle("Export " + string);
                try {
                    if (pFileChooser.showSaveDialog(this) != 0) {
                    }
                    break block18;
                }
                catch (Exception exception) {
                    Logging.errorPrint("Could not show Save Dialog for " + string);
                }
                continue;
            }
            String string2 = pFileChooser.getSelectedFile().getAbsolutePath();
            if (string2.length() < 1) {
                ShowMessageDelegate.showMessageDialog("You must set a filename.", "PCGen", MessageType.ERROR);
                continue;
            }
            try {
                CharSequence charSequence;
                Serializable serializable;
                File file;
                int n;
                File file2 = new File(string2);
                if (file2.isDirectory()) {
                    ShowMessageDelegate.showMessageDialog("You cannot overwrite a directory with a file.", "PCGen", MessageType.ERROR);
                    continue;
                }
                if (file2.exists() && !SettingsHandler.getAlwaysOverwrite() && (n = JOptionPane.showConfirmDialog(this, "The file " + file2.getName() + " already exists, " + "are you sure you want " + "to overwrite it?", "Confirm overwriting " + file2.getName(), 0)) != 0) continue;
                this.block();
                String string3 = (String)this.templateList.getSelectedValue();
                if (string3.endsWith(".xslt") || string3.endsWith(".xsl")) {
                    file = File.createTempFile("currentPC_", ".xml");
                    this.printToXMLFile(file, nArray[i]);
                    serializable = new File(SettingsHandler.getPcgenOutputSheetDir() + File.separator + (String)this.templateList.getSelectedValue());
                    this.fh.setInputFile(file, (File)serializable);
                    SettingsHandler.setSelectedCharacterPDFOutputSheet(((File)serializable).getAbsolutePath(), Globals.getPCList().get(nArray[i]));
                } else {
                    file = File.createTempFile("currentPC_", ".fo");
                    this.printToFile(file, nArray[i]);
                    this.fh.setInputFile(file);
                }
                this.fh.setMode(0);
                this.fh.setOutputFile(file2);
                serializable = null;
                this.timer.start();
                try {
                    Logging.memoryReport();
                    Runtime.getRuntime().gc();
                    Logging.memoryReport();
                    new Options();
                    System.out.println("Fop Version: " + Version.getVersion());
                    this.fh.run();
                    Logging.memoryReport();
                    Runtime.getRuntime().gc();
                    Logging.memoryReport();
                }
                catch (Throwable throwable) {
                    Logging.memoryReport();
                    serializable = throwable;
                }
                this.timer.stop();
                this.unblock();
                file.deleteOnExit();
                if (serializable != null) {
                    ((Throwable)serializable).printStackTrace();
                    if (serializable instanceof OutOfMemoryError) {
                        charSequence = new StringBuffer("Your character could not be exported as there was not\nenough memory available.\n\n");
                        if (Globals.getPCList().size() > 1) {
                            ((StringBuffer)charSequence).append("To export out your character, please try closing and \nreopening PCGen and then only loading the required PC.");
                        } else {
                            ((StringBuffer)charSequence).append("To export out your character, please try running PCGen\nusing the pcgenhighmem.bat file (or an equivalent).");
                        }
                        ShowMessageDelegate.showMessageDialog(((StringBuffer)charSequence).toString(), "PCGen", MessageType.ERROR);
                        Runtime.getRuntime().gc();
                        Logging.memoryReport();
                    } else {
                        ShowMessageDelegate.showMessageDialog(serializable.getClass().getName() + ": " + ((Throwable)serializable).getMessage(), "PCGen", MessageType.ERROR);
                    }
                }
                if (((String)(charSequence = this.fh.getErrorMessage())).length() > 0) {
                    ShowMessageDelegate.showMessageDialog(charSequence, "PCGen", MessageType.ERROR);
                }
                Globals.executePostExportCommandPDF(string2);
                continue;
            }
            catch (IOException iOException) {
                Logging.errorPrint("Could not export " + string, iOException);
                ShowMessageDelegate.showMessageDialog("Could not export " + string + ". Try another filename.", "PCGen", MessageType.ERROR);
            }
        }
    }

    private void jbInit() throws Exception {
        this.lblPCs.setText("Select a Character:");
        this.pcList = new JList(new PCListModel());
        this.pcList.setSelectionMode(2);
        this.pcScroll = new JScrollPane();
        this.pcScroll.getViewport().setView(this.pcList);
        this.lblTemplates.setText("Select a Template:");
        this.templateModel = new TemplateListModel(csheetFilter, psheetFilter, this.partyMode, "pdf");
        this.templateList = new JList(this.templateModel);
        this.templateList.setSelectionMode(0);
        this.templateScroll = new JScrollPane();
        this.templateScroll.getViewport().setView(this.templateList);
        this.templatePathButton.setText("Find Templates...");
        this.templatePathButton.setMnemonic(70);
        this.templatePathButton.addActionListener(this.bl);
        this.exportButton.setText("Export");
        this.exportButton.setMnemonic(69);
        this.exportButton.addActionListener(this.bl);
        this.printButton.setText("Print");
        this.printButton.setMnemonic(80);
        this.printButton.addActionListener(this.bl);
        this.closeButton.setText("Close");
        this.closeButton.setMnemonic(67);
        this.closeButton.addActionListener(this.bl);
        if (this.mode == 0) {
            this.buttonPanel.add(this.exportButton);
        } else if (this.mode == 1) {
            this.buttonPanel.add(this.printButton);
        }
        this.buttonPanel.add(this.closeButton);
        this.cboxParty.setText("Entire Party");
        this.cboxParty.addActionListener(this.bl);
        this.progressField.setBackground(UIManager.getColor("Panel.background"));
        this.progressField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.progressField.setEditable(false);
        this.progressField.setText("");
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.progressBar.setValue(0);
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        jPanel.add(this.progressField);
        jPanel.add(this.progressBar);
        this.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        jPanel2.add(this.buttonPanel);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        jPanel3.add((Component)this.lblPCs, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel3.add((Component)this.lblTemplates, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0;
        jPanel3.add((Component)this.pcScroll, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.8;
        jPanel3.add((Component)this.templateScroll, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel3.add((Component)this.cboxParty, gridBagConstraints);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)jPanel3, "Center");
        jPanel4.add((Component)jPanel2, "South");
        this.add((Component)jPanel4, "Center");
        this.add((Component)jPanel, "South");
        this.setSize(new Dimension(500, 400));
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    private void print() {
        int[] nArray = !this.partyMode ? this.pcList.getSelectedIndices() : new int[]{-2};
        for (int i = 0; i < nArray.length; ++i) {
            String string = this.partyMode ? "Entire Party" : (String)this.pcList.getModel().getElementAt(nArray[i]);
            this.block();
            try {
                CharSequence charSequence;
                Serializable serializable;
                File file;
                Logging.debugPrint((String)this.templateList.getSelectedValue());
                if (((String)this.templateList.getSelectedValue()).endsWith(".xslt")) {
                    Logging.debugPrint("Printing using XML/XSLT");
                    file = File.createTempFile("currentPC_", ".xml");
                    this.printToXMLFile(file, nArray[i]);
                    serializable = new File(SettingsHandler.getPcgenOutputSheetDir() + File.separator + (String)this.templateList.getSelectedValue());
                    this.fh.setInputFile(file, (File)serializable);
                } else {
                    Logging.debugPrint("Printing using FO sheets");
                    file = File.createTempFile("currentPC_", ".fo");
                    this.printToFile(file, nArray[i]);
                    this.fh.setInputFile(file);
                }
                this.fh.setMode(1);
                serializable = null;
                this.timer.start();
                try {
                    Logging.memoryReport();
                    Runtime.getRuntime().gc();
                    Logging.memoryReport();
                    this.fh.run();
                    Logging.memoryReport();
                    Runtime.getRuntime().gc();
                    Logging.memoryReport();
                }
                catch (Throwable throwable) {
                    Logging.memoryReport();
                    serializable = throwable;
                }
                this.timer.stop();
                file.deleteOnExit();
                if (serializable != null) {
                    Logging.errorPrint("Could not print " + string, (Throwable)serializable);
                    if (serializable instanceof OutOfMemoryError) {
                        charSequence = new StringBuffer("Your character could not be printed as there was not\nenough memory available.\n\n");
                        if (Globals.getPCList().size() > 1) {
                            ((StringBuffer)charSequence).append("To print out your character, please try closing and \nreopening PCGen and then only loading the required PC.");
                        } else {
                            ((StringBuffer)charSequence).append("To print out your character, please try running PCGen\nusing the pcgenhighmem.bat file (or an equivalent).");
                        }
                        ShowMessageDelegate.showMessageDialog(((StringBuffer)charSequence).toString(), "PCGen", MessageType.ERROR);
                        Runtime.getRuntime().gc();
                        Logging.memoryReport();
                    } else {
                        ShowMessageDelegate.showMessageDialog(serializable.getClass().getName() + ": " + ((Throwable)serializable).getMessage(), "PCGen", MessageType.ERROR);
                    }
                }
                if (((String)(charSequence = this.fh.getErrorMessage())).length() > 0) {
                    ShowMessageDelegate.showMessageDialog(charSequence, "PCGen", MessageType.ERROR);
                } else if (serializable == null) {
                    AWTRenderer aWTRenderer = (AWTRenderer)this.fh.getRenderer();
                    PrinterJob printerJob = PrinterJob.getPrinterJob();
                    printerJob.setPrintable((Printable)aWTRenderer);
                    printerJob.setPageable((Pageable)aWTRenderer);
                    if (printerJob.printDialog()) {
                        printerJob.print();
                    }
                }
            }
            catch (Exception exception) {
                Logging.errorPrint("Could not print " + string, exception);
                ShowMessageDelegate.showMessageDialog("Could not print " + string + ". Try again.", "PCGen", MessageType.ERROR);
            }
            this.unblock();
        }
    }

    private void printToFile(File file, int n) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        File file2 = new File(SettingsHandler.getPcgenOutputSheetDir() + File.separator + (String)this.templateList.getSelectedValue());
        if (this.partyMode) {
            SettingsHandler.setSelectedPartyPDFOutputSheet(file2.getAbsolutePath());
            new ExportHandler(file2).write(Globals.getPCList(), bufferedWriter);
        } else {
            PlayerCharacter playerCharacter = Globals.getPCList().get(n);
            SettingsHandler.setSelectedCharacterPDFOutputSheet(file2.getAbsolutePath(), playerCharacter);
            new ExportHandler(file2).write(playerCharacter, bufferedWriter);
        }
        bufferedWriter.close();
    }

    private void printToXMLFile(File file, int n) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        File file2 = new File(SettingsHandler.getPcgenSystemDir() + File.separator + "gameModes" + File.separator + SettingsHandler.getGame().getName() + File.separator + "base.xml");
        if (!file2.exists()) {
            file2 = new File(SettingsHandler.getPcgenOutputSheetDir() + File.separator + "base.xml");
        }
        if (this.partyMode) {
            for (int i = 0; i < Globals.getPCList().size(); ++i) {
                PlayerCharacter playerCharacter = Globals.getPCList().get(i);
                new ExportHandler(file2).write(playerCharacter, bufferedWriter);
            }
        } else {
            PlayerCharacter playerCharacter = Globals.getPCList().get(n);
            new ExportHandler(file2).write(playerCharacter, bufferedWriter);
        }
        bufferedWriter.close();
    }

    private void unblock() {
        this.progressBar.setValue(0);
        this.progressField.setText("");
        this.progressField.update(this.progressField.getGraphics());
        this.printButton.setEnabled(true);
        this.printButton.update(this.printButton.getGraphics());
        this.exportButton.setEnabled(true);
        this.exportButton.update(this.exportButton.getGraphics());
        this.closeButton.setEnabled(true);
        this.closeButton.update(this.closeButton.getGraphics());
    }

    private static class PCListModel
    extends AbstractListModel {
        private PCListModel() {
        }

        public Object getElementAt(int n) {
            if (n < Globals.getPCList().size()) {
                PlayerCharacter playerCharacter = Globals.getPCList().get(n);
                return playerCharacter.getDisplayName();
            }
            return null;
        }

        public int getSize() {
            return Globals.getPCList().size();
        }
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object.equals(MainPrint.this.exportButton)) {
                if (MainPrint.this.templateList.getSelectedValue() == null) {
                    ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_exportNoTemplate"), "PCGen", MessageType.ERROR);
                } else {
                    new Thread(new Runnable(){

                        public void run() {
                            MainPrint.this.export();
                        }
                    }).start();
                }
            } else if (object.equals(MainPrint.this.printButton)) {
                if (MainPrint.this.templateList.getSelectedValue() == null) {
                    ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_printNoTemplate"), "PCGen", MessageType.ERROR);
                } else {
                    new Thread(new Runnable(){

                        public void run() {
                            MainPrint.this.print();
                        }
                    }).start();
                }
            } else if (object.equals(MainPrint.this.closeButton)) {
                MainPrint.this.parentFrame.dispose();
            } else if (object.equals(MainPrint.this.cboxParty)) {
                MainPrint.this.setPartyMode(MainPrint.this.cboxParty.isSelected());
                MainPrint.this.pcList.setEnabled(!MainPrint.this.cboxParty.isSelected());
                MainPrint.this.templateList.updateUI();
                boolean bl = ((TemplateListModel)MainPrint.this.templateList.getModel()).getNumFiles() > 0;
                MainPrint.this.exportButton.setEnabled(bl);
                MainPrint.this.printButton.setEnabled(bl);
                MainPrint.this.setDefaultTemplateSelection();
            } else if (object.equals(MainPrint.this.templatePathButton)) {
                MainPrint.this.getTemplatePath();
            }
        }
    }
}

