/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.spell;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.core.Ability;
import pcgen.core.CharacterDomain;
import pcgen.core.Domain;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.character.CharacterSpell;
import pcgen.core.character.SpellInfo;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Spell
extends PObject {
    private BigDecimal cost = BigDecimal.ZERO;
    private HashMap<String, Integer> levelInfo = null;
    private List<String> descriptorList = new ArrayList<String>();
    private List<String> variantList = null;
    private Map<String, Prerequisite> preReqMap = null;
    private SortedSet<String> castingTime = new TreeSet<String>();
    private SortedSet<String> componentList = new TreeSet<String>();
    private SortedSet<String> duration = new TreeSet<String>();
    private SortedSet<String> range = new TreeSet<String>();
    private SortedSet<String> saveInfo = new TreeSet<String>();
    private SortedSet<String> school = new TreeSet<String>();
    private SortedSet<String> spellResistance = new TreeSet<String>();
    private SortedSet<String> subschool = new TreeSet<String>();
    private String fixedCasterLevel = null;
    private String fixedDC = null;
    private String creatableItem = "";
    private String spellStat = "";
    private String target = "";
    private int castingThreshold = 0;
    private int xpCost = 0;
    private int ppCost = 0;
    static boolean hasPPCost = false;

    public static boolean hasPPCost() {
        return hasPPCost;
    }

    public void setCastingThreshold(int n) {
        this.castingThreshold = n;
    }

    public int getCastingThreshold() {
        return this.castingThreshold;
    }

    public void setCastingTime(String string) {
        if (string.equals(".CLEAR")) {
            this.castingTime.clear();
        } else if (string.length() != 0) {
            this.castingTime.add(string);
            Globals.addSpellCastingTimesSet(string);
        }
    }

    public String getCastingTime() {
        String string = this.castingTime.toString();
        return string.substring(1, string.length() - 1);
    }

    public void setComponentList(String string) {
        if (string.equals(".CLEAR")) {
            this.componentList.clear();
        } else if (string.length() != 0) {
            this.componentList.add(string);
            Globals.addSpellComponentSet(string);
        }
    }

    public String getComponentList() {
        String string = this.componentList.toString();
        return string.substring(1, string.length() - 1);
    }

    public void setCost(String string) {
        try {
            this.cost = new BigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public BigDecimal getCost() {
        return this.cost;
    }

    public void setCreatableItem(String string) {
        this.creatableItem = string;
    }

    public String getCreatableItem() {
        return this.creatableItem;
    }

    public String getFixedCasterLevel() {
        return this.fixedCasterLevel;
    }

    public void setFixedCasterLevel(String string) {
        this.fixedCasterLevel = string;
    }

    public String getFixedDC() {
        return this.fixedDC;
    }

    public void setFixedDC(String string) {
        this.fixedDC = string;
    }

    public int getDCForPlayerCharacter(PlayerCharacter playerCharacter, SpellInfo spellInfo) {
        return this.getDCForPlayerCharacter(playerCharacter, spellInfo, null, 0);
    }

    public int getDCForPlayerCharacter(PlayerCharacter playerCharacter, SpellInfo spellInfo, PCClass pCClass, int n) {
        String string;
        PObject pObject = null;
        int n2 = n;
        String string2 = "";
        String string22 = "";
        String string3 = "";
        String string4 = "";
        int n3 = 0;
        int n4 = 0;
        if (this.fixedDC != null && spellInfo != null && "INNATE".equalsIgnoreCase(spellInfo.getBook())) {
            return playerCharacter.getVariableValue(this.fixedDC, "").intValue();
        }
        if (spellInfo != null) {
            CharacterSpell characterSpell = spellInfo.getOwner();
            if (characterSpell != null) {
                n2 = spellInfo.getActualLevel();
                pObject = characterSpell.getOwner();
            }
            if (this.fixedDC != null && pObject != null && !(pObject instanceof PCClass)) {
                return playerCharacter.getVariableValue(this.fixedDC, "").intValue();
            }
            if (spellInfo.getFeatList() != null) {
                for (Ability iterator2 : spellInfo.getFeatList()) {
                    n2 -= iterator2.getAddSpellLevel();
                    n3 = (int)((double)n3 + iterator2.bonusTo("DC", "FEATBONUS", playerCharacter, playerCharacter));
                }
            }
        } else {
            pObject = pCClass;
        }
        if (pObject instanceof Domain) {
            string2 = "DOMAIN." + pObject.getKeyName();
            CharacterDomain characterDomain = playerCharacter.getCharacterDomainForDomain(pObject.getKeyName());
            if (characterDomain != null && characterDomain.isFromPCClass()) {
                String string5 = characterDomain.getObjectName();
                pCClass = playerCharacter.getClassKeyed(string5);
            }
        }
        if (pCClass != null || pObject instanceof PCClass) {
            if (pCClass == null || pObject instanceof PCClass) {
                pCClass = pObject;
            }
            string22 = "CLASS." + pCClass.getKeyName();
            string4 = "CLASS:" + pCClass.getKeyName();
            string3 = pCClass.getSpellType();
            n4 = pCClass.baseSpellIndex();
        }
        if (!(pObject instanceof PCClass) && !(pObject instanceof Domain)) {
            n4 = -2;
        }
        playerCharacter.setSpellLevelTemp(n2);
        int n5 = playerCharacter.getVariableValue(Globals.getGameModeBaseSpellDC(), string4).intValue() + n3;
        n5 += (int)playerCharacter.getTotalBonusTo("DC", "ALLSPELLS");
        if (n4 == -2 && (string = this.getStat()).length() > 0) {
            n5 += playerCharacter.getStatList().getStatModFor(string);
        }
        if (this.getKeyName().length() > 0) {
            n5 += (int)playerCharacter.getTotalBonusTo("DC", "SPELL." + this.getKeyName());
        }
        if (string2.length() > 0) {
            n5 += (int)playerCharacter.getTotalBonusTo("DC", string2);
        }
        if (string22.length() > 0) {
            n5 += (int)playerCharacter.getTotalBonusTo("DC", string22);
        }
        n5 += (int)playerCharacter.getTotalBonusTo("DC", "TYPE." + string3);
        if (string3.equals("ALL")) {
            for (String string6 : this.getTypeList(false)) {
                n5 += (int)playerCharacter.getTotalBonusTo("DC", "TYPE." + string6);
            }
        }
        for (String string6 : this.school) {
            n5 += (int)playerCharacter.getTotalBonusTo("DC", "SCHOOL." + string6);
        }
        for (String string6 : this.subschool) {
            n5 += (int)playerCharacter.getTotalBonusTo("DC", "SUBSCHOOL." + string6);
        }
        for (String string6 : this.descriptorList) {
            n5 += (int)playerCharacter.getTotalBonusTo("DC", "DESCRIPTOR." + string6);
        }
        playerCharacter.setSpellLevelTemp(0);
        return n5;
    }

    public List<String> getDescriptorList() {
        return this.descriptorList;
    }

    public void setDuration(String string) {
        if (string.equals(".CLEAR")) {
            this.duration.clear();
        } else if (string.length() != 0) {
            this.duration.add(string);
            Globals.addDurationSet(string);
        }
    }

    public String getDuration() {
        String string = this.duration.toString();
        return string.substring(1, string.length() - 1);
    }

    public int getFirstLevelForKey(String string, PlayerCharacter playerCharacter) {
        int[] nArray = this.levelForKey(string, playerCharacter);
        int n = -1;
        if (nArray.length > 0) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] <= -1) continue;
                return nArray[i];
            }
        }
        return n;
    }

    @Override
    protected void doGlobalTypeUpdate(String string) {
        Globals.addTypeForSpells(string);
    }

    public void setLevelInfo(String string, String string2) {
        try {
            this.setLevelInfo(string, Integer.parseInt(string2));
        }
        catch (NumberFormatException numberFormatException) {
            Logging.errorPrint("Could not set level info.", numberFormatException);
        }
    }

    public void clearLevelInfo(String string) {
        if (this.levelInfo != null) {
            String string2 = string + "|";
            Iterator<String> iterator = this.levelInfo.keySet().iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().startsWith(string2)) continue;
                iterator.remove();
            }
        }
    }

    public void setLevelInfo(String string, int n) {
        if (n == -1) {
            if (this.levelInfo != null) {
                this.levelInfo.remove(string);
            }
        } else {
            if (this.levelInfo == null) {
                this.levelInfo = new HashMap();
            }
            this.levelInfo.put(string, n);
        }
    }

    public Map<String, Integer> getLevelInfo(PlayerCharacter playerCharacter) {
        HashMap<String, Integer> hashMap = null;
        if (this.levelInfo != null) {
            hashMap = new HashMap<String, Integer>(this.levelInfo);
        }
        if (playerCharacter != null) {
            if (hashMap == null) {
                hashMap = new HashMap();
            }
            hashMap.putAll(playerCharacter.getSpellInfoMap("CLASS", this.getKeyName()));
            hashMap.putAll(playerCharacter.getSpellInfoMap("DOMAIN", this.getKeyName()));
        }
        return hashMap;
    }

    @Override
    public String getPCCText() {
        String string;
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(this.getDisplayName());
        this.appendPCCText(stringBuffer, this.castingTime, "CASTTIME");
        this.appendPCCText(stringBuffer, this.componentList, "COMPS");
        if (this.getCost().compareTo(BigDecimal.ZERO) != 0) {
            stringBuffer.append("\tCOST:").append(this.getCost().toString());
        }
        if (this.getLevelInfo(null) != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (Map.Entry<String, Integer> entry : this.getLevelInfo(null).entrySet()) {
                string = entry.getKey();
                if (string.startsWith("CLASS|")) {
                    arrayList.add(string.substring(6) + '=' + entry.getValue().toString());
                    continue;
                }
                if (string.startsWith("DOMAIN|")) {
                    arrayList2.add(string.substring(7) + '=' + entry.getValue().toString());
                    continue;
                }
                arrayList3.add(string + '|' + entry.getValue().toString());
            }
            if (arrayList.size() != 0) {
                stringBuffer.append("\tCLASSES:").append(CoreUtility.join(arrayList, "|"));
            }
            if (arrayList2.size() != 0) {
                stringBuffer.append("\tDOMAINS:").append(CoreUtility.join(arrayList2, "|"));
            }
            if (arrayList3.size() != 0) {
                stringBuffer.append("\tSPELLLEVEL:").append(CoreUtility.join(arrayList3, "|"));
            }
        }
        if (this.getCastingThreshold() != 0) {
            stringBuffer.append("\tCT:").append(this.getCastingThreshold());
        }
        if ((string = this.getDescriptor("|")).length() != 0) {
            stringBuffer.append("\tDESCRIPTOR:").append(string);
        }
        this.appendPCCText(stringBuffer, this.duration, "DURATION");
        string = this.getCreatableItem();
        if (string.length() != 0) {
            stringBuffer.append("\tITEM:").append(string);
        }
        this.appendPCCText(stringBuffer, this.range, "RANGE");
        this.appendPCCText(stringBuffer, this.saveInfo, "SAVEINFO");
        this.appendPCCText(stringBuffer, this.school, "SCHOOL");
        string = this.getStat();
        if (string.length() != 0) {
            stringBuffer.append("\tSTAT:").append(string);
        }
        this.appendPCCText(stringBuffer, this.spellResistance, "SPELLRES");
        this.appendPCCText(stringBuffer, this.subschool, "SUBSCHOOL");
        string = this.getTarget();
        if (string.length() != 0) {
            stringBuffer.append("\tTARGETAREA:").append(string);
        }
        if (this.variantList != null && this.variantList.size() != 0) {
            stringBuffer.append("\tVARIANTS:").append(CoreUtility.join(this.variantList, "|"));
        }
        if (this.getXPCost() != 0) {
            stringBuffer.append("\tXPCOST:").append(this.getXPCost());
        }
        if (this.getPPCost() != 0) {
            stringBuffer.append("\tPPCOST:").append(this.getPPCost());
        }
        stringBuffer.append(super.getPCCText(false));
        return stringBuffer.toString();
    }

    public void setRange(String string) {
        if (string.equals(".CLEAR")) {
            this.range.clear();
        } else if (string.length() != 0) {
            this.range.add(string);
            Globals.addSpellRangesSet(string);
        }
    }

    public String getRange() {
        String string = this.range.toString();
        return string.substring(1, string.length() - 1);
    }

    public void setSaveInfo(String string) {
        if (string.equals(".CLEAR")) {
            this.saveInfo.clear();
        } else if (string.length() != 0) {
            this.saveInfo.add(string);
            Globals.addSpellSaveInfoSet(string);
        }
    }

    public String getSaveInfo() {
        String string = this.saveInfo.toString();
        return string.substring(1, string.length() - 1);
    }

    public void addSchool(String string) {
        if (string.equals(".CLEAR")) {
            this.school.clear();
        } else if (string.length() != 0) {
            this.school.add(string);
        }
    }

    public String getSchool() {
        String string = this.school.toString();
        return string.substring(1, string.length() - 1);
    }

    public SortedSet<String> getSchools() {
        return this.school;
    }

    public void setSpellResistance(String string) {
        if (string.equals(".CLEAR")) {
            this.spellResistance.clear();
        } else if (string.length() != 0) {
            this.spellResistance.add(string);
            Globals.addSpellSrSet(string);
        }
    }

    public String getSpellResistance() {
        String string = this.spellResistance.toString();
        return string.substring(1, string.length() - 1);
    }

    public void setStat(String string) {
        this.spellStat = string;
        Globals.addSpellStatSet(string);
    }

    public String getStat() {
        return this.spellStat;
    }

    public void addSubschool(String string) {
        if (string.equals(".CLEAR")) {
            this.subschool.clear();
        } else if (string.length() != 0) {
            this.subschool.add(string);
            if (string.length() != 0) {
                Globals.getSubschools().add(string);
            }
        }
    }

    public String getSubschool() {
        String string = this.subschool.toString();
        return string.substring(1, string.length() - 1);
    }

    public SortedSet<String> getSubschools() {
        return this.subschool;
    }

    public void setTarget(String string) {
        this.target = string;
        if (string.length() != 0) {
            Globals.addSpellTargetSet(string);
        }
    }

    public String getTarget() {
        return this.target;
    }

    public List<String> getVariants() {
        if (this.variantList == null) {
            this.variantList = new ArrayList<String>();
        }
        return this.variantList;
    }

    public void setXPCost(int n) {
        this.xpCost = n;
    }

    public int getXPCost() {
        return this.xpCost;
    }

    public void setPPCost(int n) {
        hasPPCost = true;
        this.ppCost = n;
    }

    public int getPPCost() {
        return this.ppCost;
    }

    public void addDescriptor(String string) {
        if (string.equals(".CLEAR")) {
            this.descriptorList.clear();
        } else {
            this.descriptorList.add(string);
        }
    }

    public void addPreReqMapEntry(String string, Prerequisite prerequisite) {
        if (this.preReqMap == null) {
            this.preReqMap = new HashMap<String, Prerequisite>();
        }
        this.preReqMap.put(string, prerequisite);
    }

    public void addVariant(String string) {
        if (this.variantList == null) {
            this.variantList = new ArrayList<String>();
        }
        if (string.length() != 0) {
            this.variantList.add(string);
        }
    }

    @Deprecated
    public void clearLevelInfo() {
        this.levelInfo = null;
    }

    public void clearVariants() {
        this.variantList = null;
    }

    @Override
    public Spell clone() {
        Spell spell = null;
        try {
            spell = (Spell)super.clone();
            spell.school = this.school;
            spell.subschool = this.subschool;
            spell.componentList = this.componentList;
            spell.castingTime = this.castingTime;
            spell.range = this.range;
            spell.target = this.target;
            spell.duration = this.duration;
            spell.saveInfo = this.saveInfo;
            spell.spellResistance = this.spellResistance;
            spell.descriptorList = new ArrayList<String>();
            spell.descriptorList.addAll(this.descriptorList);
            spell.setCastingThreshold(this.castingThreshold);
            spell.creatableItem = this.creatableItem;
            spell.cost = this.cost;
            spell.xpCost = this.xpCost;
            if (this.variantList == null) {
                spell.variantList = null;
            } else {
                spell.variantList = new ArrayList<String>();
                spell.variantList.addAll(this.variantList);
            }
            spell.ppCost = this.ppCost;
            if (this.levelInfo != null) {
                spell.levelInfo = new HashMap<String, Integer>(this.levelInfo);
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ShowMessageDelegate.showMessageDialog(cloneNotSupportedException.getMessage(), "PCGen", MessageType.ERROR);
        }
        return spell;
    }

    public String descriptor() {
        return this.getDescriptor(", ");
    }

    public boolean descriptorListContains(Collection<String> collection) {
        return CoreUtility.containsAny(this.descriptorList, collection);
    }

    public String getLevelString() {
        if (this.levelInfo == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.levelInfo.keySet()) {
            String string2 = this.levelInfo.get(string).toString();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
            stringTokenizer.nextToken();
            if (stringBuffer.toString().length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(stringTokenizer.nextToken()).append(" ");
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public boolean isLevel(int n, PlayerCharacter playerCharacter) {
        if (this.levelInfo == null) {
            return false;
        }
        Integer n2 = n;
        for (PCClass object : playerCharacter.getClassList()) {
            if (!n2.equals(this.levelInfo.get("CLASS|" + object.getKeyName()))) continue;
            return true;
        }
        for (CharacterDomain characterDomain : playerCharacter.getCharacterDomainList()) {
            if (!n2.equals(this.levelInfo.get("DOMAIN|" + characterDomain.getDomain().getKeyName()))) continue;
            return true;
        }
        return false;
    }

    public boolean isLevel(int n) {
        if (this.levelInfo == null) {
            return false;
        }
        for (String string : this.levelInfo.keySet()) {
            if (n != this.levelInfo.get(string)) continue;
            return true;
        }
        return false;
    }

    public int levelForKey(String string, String string2, PlayerCharacter playerCharacter) {
        int n = -1;
        Map<String, Integer> map = this.getLevelInfo(playerCharacter);
        if (map != null && map.size() != 0) {
            PCClass pCClass;
            Integer n2 = map.get(string + "|" + string2);
            if (n2 == null) {
                n2 = map.get(string + "|ALL");
            }
            if (n2 == null && string.equals("CLASS") && (pCClass = Globals.getClassKeyed(string2)) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(pCClass.getType(), ".", false);
                while (stringTokenizer.hasMoreTokens() && n2 == null) {
                    n2 = map.get(string + "|TYPE." + stringTokenizer.nextToken());
                }
            }
            if (n2 != null) {
                n = n2;
            }
        }
        return n;
    }

    public int[] levelForKey(String string, PlayerCharacter playerCharacter) {
        if (this.levelInfo == null || this.levelInfo.size() == 0) {
            int[] nArray = new int[]{playerCharacter != null ? playerCharacter.getSpellLevelforKey(string + "|" + this.getKeyName(), -1) : -1};
            return nArray;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
        int[] nArray = new int[stringTokenizer.countTokens() / 2];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) continue;
            String string3 = stringTokenizer.nextToken();
            nArray[n++] = this.levelForKey(string2, string3, playerCharacter);
        }
        return nArray;
    }

    public boolean levelForKeyContains(String string, int n, PlayerCharacter playerCharacter) {
        Object object;
        if (this.preReqMap != null && this.preReqMap.containsKey(string)) {
            object = new ArrayList();
            object.add(this.preReqMap.get(string));
            if (!PrereqHandler.passesAll((List<Prerequisite>)object, playerCharacter, this)) {
                return false;
            }
        }
        object = this.levelForKey(string, playerCharacter);
        for (int i = 0; i < ((int[])object).length; ++i) {
            if ((n != -1 || object[i] < 0) && (n < 0 || object[i] != n)) continue;
            return true;
        }
        if (playerCharacter != null) {
            return playerCharacter.isSpellLevelforKey(string + "|" + this.getKeyName(), n);
        }
        return false;
    }

    public boolean schoolContains(Collection<String> collection) {
        return CoreUtility.containsAny(this.school, collection);
    }

    public boolean subschoolContains(Collection<String> collection) {
        return CoreUtility.containsAny(this.subschool, collection);
    }

    public boolean descriptorContains(String string) {
        return this.descriptorList.contains(string);
    }

    private String getDescriptor(String string) {
        StringBuffer stringBuffer = new StringBuffer(this.descriptorList.size() * 5);
        for (String string2 : this.descriptorList) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private void appendPCCText(StringBuffer stringBuffer, Set<String> set, String string) {
        for (String string2 : set) {
            stringBuffer.append('\t').append(string).append(':').append(string2);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Spell)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        Spell spell = (Spell)object;
        if (this.getKeyName().equals(spell.getKeyName())) {
            return this.levelInfo == null && spell.levelInfo == null || this.levelInfo != null && this.levelInfo.equals(spell.levelInfo);
        }
        return false;
    }

    public int hashCode() {
        return this.getKeyName().hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Component {
        VERBAL("V", "Spell.Components.Verbal"),
        SOMATIC("S", "Spell.Components.Somatic"),
        MATERIAL("M", "Spell.Components.Material"),
        DIVINEFOCUS("DF", "Spell.Components.DivineFocus"),
        FOCUS("F", "Spell.Components.Focus"),
        EXPERIENCE("XP", "Spell.Components.Experience"),
        OTHER("See text", "Spell.Components.SeeText");

        private String theKey;
        private String theName;

        private Component(String string2, String string3) {
            this.theKey = string2;
            this.theName = string3;
        }

        public String getKey() {
            return this.theKey;
        }

        public static Component getComponentFromKey(String string) {
            for (Component component : Component.values()) {
                if (!component.getKey().equalsIgnoreCase(string)) continue;
                return component;
            }
            return OTHER;
        }

        public String toString() {
            return this.theName;
        }
    }
}

