/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.spell;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import pcgen.core.CharacterDomain;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.util.DoubleKeyMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PCSpellTracker {
    protected PlayerCharacter pc;
    protected DoubleKeyMap<String, String, Integer> spellSerialMap = new DoubleKeyMap();
    protected DoubleKeyMap<String, String, Map<String, Integer>> spellMap = new DoubleKeyMap();
    protected Map<String, Integer> spellLevelMap = new HashMap<String, Integer>();
    protected int spellLevelMapSerial = 0;

    public PCSpellTracker(PlayerCharacter playerCharacter) {
        this.pc = playerCharacter;
    }

    public Map<String, Integer> getSpellInfoMap(String string, String string2) {
        Integer n = this.spellSerialMap.get(string, string2);
        if (n != null && n >= this.pc.getSerial()) {
            return this.spellMap.get(string, string2);
        }
        Map<String, Integer> map = this.buildSpellInfoMap(string, string2);
        this.spellMap.put(string, string2, map);
        this.spellSerialMap.put(string, string2, this.pc.getSerial());
        return map;
    }

    public Map<String, Integer> buildSpellInfoMap(String string, String string2) {
        ArrayList<Object> arrayList;
        Iterator<PObject> iterator;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        if (!this.pc.getClassList().isEmpty()) {
            iterator = this.pc.getClassList().iterator();
            this.buildSpellInfoMap(hashMap, string, string2, iterator);
        }
        if (!this.pc.getCompanionModList().isEmpty()) {
            iterator = this.pc.getCompanionModList().iterator();
            this.buildSpellInfoMap(hashMap, string, string2, iterator);
        }
        if (!this.pc.getEquipmentList().isEmpty()) {
            iterator = this.pc.getEquipmentList().iterator();
            this.buildSpellInfoMap(hashMap, string, string2, iterator);
        }
        if (!this.pc.aggregateFeatList().isEmpty()) {
            iterator = this.pc.aggregateFeatList().iterator();
            this.buildSpellInfoMap(hashMap, string, string2, iterator);
        }
        if (!this.pc.getTemplateList().isEmpty()) {
            iterator = this.pc.getTemplateList().iterator();
            this.buildSpellInfoMap(hashMap, string, string2, iterator);
        }
        if (this.pc.hasCharacterDomainList()) {
            arrayList = new ArrayList();
            for (CharacterDomain characterDomain : this.pc.getCharacterDomainList()) {
                arrayList.add(characterDomain.getDomain());
            }
            this.buildSpellInfoMap(hashMap, string, string2, arrayList.iterator());
        }
        if (!(arrayList = new ArrayList<Skill>(this.pc.getSkillList())).isEmpty()) {
            iterator = arrayList.iterator();
            this.buildSpellInfoMap(hashMap, string, string2, iterator);
        }
        if (this.pc.getRace() != null) {
            hashMap.putAll(this.getSpellInfoMapPassesPrereqs(this.pc.getRace(), string, string2));
        }
        if (this.pc.getDeity() != null) {
            hashMap.putAll(this.getSpellInfoMapPassesPrereqs(this.pc.getDeity(), string, string2));
        }
        return hashMap;
    }

    private void buildSpellInfoMap(Map<String, Integer> map, String string, String string2, Iterator<? extends PObject> iterator) {
        while (iterator.hasNext()) {
            PObject pObject = iterator.next();
            if (pObject == null) continue;
            map.putAll(this.getSpellInfoMapPassesPrereqs(pObject, string, string2));
        }
    }

    public Map<String, Integer> getSpellInfoMapPassesPrereqs(PObject pObject, String string, String string2) {
        if (pObject.getSpellSupport() == null) {
            return new HashMap<String, Integer>();
        }
        return pObject.getSpellSupport().getSpellInfoMapPassesPrereqs(string, string2, this.pc);
    }

    public boolean isSpellLevelforKey(String string, int n) {
        if (this.spellLevelMapSerial < this.pc.getSerial()) {
            this.buildSpellLevelMap(n);
            this.spellLevelMapSerial = this.pc.getSerial();
        }
        if (!this.spellLevelMap.containsKey(string)) {
            return false;
        }
        int n2 = this.spellLevelMap.get(string);
        if (n == n2) {
            return true;
        }
        return n == -1 && n2 >= 0;
    }

    public int getSpellLevelforKey(String string, int n) {
        if (this.spellLevelMapSerial < this.pc.getSerial()) {
            this.buildSpellLevelMap(n);
            this.spellLevelMapSerial = this.pc.getSerial();
        }
        if (!this.spellLevelMap.containsKey(string)) {
            return -1;
        }
        return this.spellLevelMap.get(string);
    }

    public void buildSpellLevelMap(int n) {
        ArrayList<Skill> arrayList;
        Iterator<Object> iterator;
        this.spellLevelMap.clear();
        if (!this.pc.getClassList().isEmpty()) {
            iterator = this.pc.getClassList().iterator();
            this.buildSpellLevelMap(n, iterator);
        }
        if (!this.pc.getCompanionModList().isEmpty()) {
            iterator = this.pc.getCompanionModList().iterator();
            this.buildSpellLevelMap(n, iterator);
        }
        if (!this.pc.getEquipmentList().isEmpty()) {
            iterator = this.pc.getEquipmentList().iterator();
            this.buildSpellLevelMap(n, iterator);
        }
        if (!this.pc.aggregateFeatList().isEmpty()) {
            iterator = this.pc.aggregateFeatList().iterator();
            this.buildSpellLevelMap(n, iterator);
        }
        if (!this.pc.getTemplateList().isEmpty()) {
            iterator = this.pc.getTemplateList().iterator();
            this.buildSpellLevelMap(n, iterator);
        }
        if (this.pc.hasCharacterDomainList()) {
            iterator = this.pc.getCharacterDomainList().iterator();
            this.buildSpellLevelMap(n, iterator);
        }
        if (!(arrayList = new ArrayList<Skill>(this.pc.getSkillList())).isEmpty()) {
            iterator = arrayList.iterator();
            this.buildSpellLevelMap(n, iterator);
        }
        if (this.pc.getRace() != null) {
            this.spellLevelMap.putAll(this.getSpellMapPassesPrereqs(this.pc.getRace(), n));
        }
        if (this.pc.getDeity() != null) {
            this.spellLevelMap.putAll(this.getSpellMapPassesPrereqs(this.pc.getDeity(), n));
        }
    }

    private void buildSpellLevelMap(int n, Iterator<?> iterator) {
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof CharacterDomain) {
                object = ((CharacterDomain)object).getDomain();
            }
            if (!(object instanceof PObject)) continue;
            PObject pObject = (PObject)object;
            this.spellLevelMap.putAll(this.getSpellMapPassesPrereqs(pObject, n));
        }
    }

    public Map<String, Integer> getSpellMapPassesPrereqs(PObject pObject, int n) {
        if (pObject.getSpellSupport() == null) {
            return new HashMap<String, Integer>();
        }
        return pObject.getSpellSupport().getSpellMapPassesPrereqs(n, this.pc);
    }
}

