/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.levelability;

import java.util.Collections;
import java.util.List;
import pcgen.core.Globals;
import pcgen.core.Language;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.levelability.LevelAbility;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.util.chooser.ChooserInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LevelAbilityLanguage
extends LevelAbility {
    LevelAbilityLanguage(PObject pObject, int n, String string) {
        super(pObject, n, string);
    }

    @Override
    public boolean isLanguage() {
        return true;
    }

    @Override
    List<String> getChoicesList(String string, PlayerCharacter playerCharacter) {
        List<String> list = super.getChoicesList(string.substring(9), playerCharacter);
        Collections.sort(list);
        return list;
    }

    @Override
    String prepareChooser(ChooserInterface chooserInterface, PlayerCharacter playerCharacter) {
        super.prepareChooser(chooserInterface, playerCharacter);
        chooserInterface.setTitle("Language Choice");
        return this.rawTagData;
    }

    @Override
    public boolean processChoice(List<String> list, List<String> list2, PlayerCharacter playerCharacter, PCLevelInfo pCLevelInfo) {
        for (String string : list2) {
            playerCharacter.addLanguageKeyed(string);
        }
        return true;
    }

    @Override
    void processToken(String string, List<String> list, PlayerCharacter playerCharacter) {
        if (string.startsWith("TYPE=") || string.startsWith("TYPE.")) {
            string = string.substring(5);
            for (Language language : Globals.getLanguageList()) {
                if (!language.isType(string)) continue;
                list.add(language.getKeyName());
            }
        } else {
            Language language = Globals.getLanguageKeyed(string);
            if (language != null) {
                if (!playerCharacter.getLanguagesList().contains(language)) {
                    list.add(string);
                }
            } else {
                System.err.println("Language not found: " + string);
            }
        }
    }
}

