/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.levelability;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.CharacterDomain;
import pcgen.core.Domain;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SpecialAbility;
import pcgen.core.levelability.LevelAbilityAbility;
import pcgen.core.levelability.LevelAbilityClassSkills;
import pcgen.core.levelability.LevelAbilityEquipment;
import pcgen.core.levelability.LevelAbilityFeat;
import pcgen.core.levelability.LevelAbilityInterface;
import pcgen.core.levelability.LevelAbilityLanguage;
import pcgen.core.levelability.LevelAbilityList;
import pcgen.core.levelability.LevelAbilitySkill;
import pcgen.core.levelability.LevelAbilitySpecial;
import pcgen.core.levelability.LevelAbilitySpellCaster;
import pcgen.core.levelability.LevelAbilityWeaponBonus;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.util.Logging;
import pcgen.util.chooser.ChooserFactory;
import pcgen.util.chooser.ChooserInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LevelAbility
extends PObject
implements LevelAbilityInterface {
    protected PObject owner;
    protected String rawTagData;
    protected String aText;
    private int level;
    protected int type;
    protected static final int SKILL = 2;
    private static final int DOMAIN = 4;
    protected static final int SPELLCASTER = 6;
    private static final int SPELLLEVEL = 7;
    private static final int TYPE = 8;

    LevelAbility(PObject pObject, int n, String string) {
        this.owner = pObject;
        this.level = n;
        this.rawTagData = string;
    }

    public final String getTagData() {
        return this.rawTagData;
    }

    public final int level() {
        return this.level;
    }

    public boolean isAbility() {
        return false;
    }

    public boolean isFeat() {
        return false;
    }

    public boolean isLanguage() {
        return false;
    }

    public final void process(PlayerCharacter playerCharacter, PCLevelInfo pCLevelInfo) {
        this.process(null, playerCharacter, pCLevelInfo);
    }

    public void process(List<String> list, PlayerCharacter playerCharacter, PCLevelInfo pCLevelInfo) {
        block2: {
            List<String> list2;
            ChooserInterface chooserInterface;
            block3: {
                block1: {
                    this.aText = this.rawTagData;
                    this.setType(playerCharacter);
                    chooserInterface = ChooserFactory.getChooserInstance();
                    String string = this.prepareChooser(chooserInterface, playerCharacter);
                    list2 = this.getChoicesList(string, playerCharacter);
                    if (list == null) break block1;
                    list.addAll(list2);
                    break block2;
                }
                if (chooserInterface.getPool() != Integer.MIN_VALUE) break block3;
                this.processChoice(list2, list2, playerCharacter, pCLevelInfo);
                break block2;
            }
            chooserInterface.setAvailableList(list2);
            chooserInterface.setVisible(false);
            if (list2.size() <= 0 || this.type == 7) break block2;
            do {
                chooserInterface.setVisible(true);
            } while (!this.processChoice(list2, chooserInterface.getSelectedList(), playerCharacter, pCLevelInfo));
        }
    }

    protected void setType(PlayerCharacter playerCharacter) {
        this.type = 4;
        if (this.rawTagData.startsWith("SPELLLEVEL")) {
            this.getSpellLevelChoices(playerCharacter, this.rawTagData);
            this.type = 7;
        } else if (this.rawTagData.startsWith("TYPE=") || this.rawTagData.startsWith("TYPE.")) {
            this.type = 8;
        }
    }

    private void getSpellLevelChoices(PlayerCharacter playerCharacter, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "[]", false);
        String string2 = stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        this.getChoices(string2, playerCharacter);
    }

    @Override
    public boolean processChoice(List<String> list, List<String> list2, PlayerCharacter playerCharacter, PCLevelInfo pCLevelInfo) {
        switch (this.type) {
            case 4: {
                if (this.aText.startsWith("DOMAIN")) {
                    this.processDomain(list2, playerCharacter);
                    break;
                }
                this.processSA(list2, playerCharacter, pCLevelInfo);
                break;
            }
            case 8: {
                this.processType(list2);
                break;
            }
            default: {
                Logging.errorPrint("In LevelAbility.processChoice the type " + this.type + " is not supported.");
            }
        }
        return true;
    }

    private void processSA(List<String> list, PlayerCharacter playerCharacter, PCLevelInfo pCLevelInfo) {
        String string = this.aText + '(';
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            String string2 = list.get(i);
            if (string2.startsWith("TYPE=") || string2.startsWith("TYPE.")) {
                object = new LevelAbility(this.owner, this.level, string2);
                ((LevelAbility)object).process(playerCharacter, pCLevelInfo);
                string2 = ((LevelAbility)object).rawTagData;
            }
            object = new StringBuffer().append(string).append(string2).append(')').toString();
            SpecialAbility specialAbility = new SpecialAbility((String)object, "PCCLASS|" + this.owner.getKeyName() + '|' + this.level);
            this.owner.addSpecialAbilityToList(specialAbility);
            this.owner.addSave((String)object);
        }
    }

    private void processDomain(List list, PlayerCharacter playerCharacter) {
        String string = null;
        int n = playerCharacter.getMaxCharacterDomains() - playerCharacter.getCharacterDomainUsed();
        if (n <= 0) {
            n = (int)this.owner.bonusTo("DOMAIN", "NUMBER", playerCharacter, playerCharacter);
        }
        if (this.owner instanceof PCClass) {
            string = this.owner.getKeyName();
            int n2 = ((PCClass)this.owner).getLevel();
            if (n <= 0) {
                n = (int)((PCClass)this.owner).getBonusTo("DOMAIN", "NUMBER", n2, playerCharacter);
            }
        }
        if (n <= 0) {
            n = 1;
        }
        Iterator iterator = list.iterator();
        while (n > 0 && iterator.hasNext()) {
            Domain domain;
            String string2 = (String)iterator.next();
            if (playerCharacter.containsCharacterDomain(string2) || (domain = Globals.getDomainKeyed(string2)) == null) continue;
            domain = domain.clone();
            CharacterDomain characterDomain = playerCharacter.getNewCharacterDomain(string);
            characterDomain.setDomain(domain, playerCharacter);
            playerCharacter.addCharacterDomain(characterDomain);
            domain.setIsLocked(true, playerCharacter);
            --n;
        }
    }

    private void processType(List list) {
        if (list.size() > 0) {
            this.rawTagData = list.get(0).toString();
        }
    }

    public final PObject getOwner() {
        return this.owner;
    }

    public final void setOwner(PObject pObject) {
        this.owner = pObject;
    }

    public static LevelAbility createAbility(PObject pObject, int n, String string) {
        if (string.startsWith("SPECIAL")) {
            return new LevelAbilitySpecial(pObject, n, string);
        }
        if (string.startsWith("FEAT")) {
            return new LevelAbilityFeat(pObject, n, string, false);
        }
        if (string.startsWith("VFEAT")) {
            return new LevelAbilityFeat(pObject, n, string, true);
        }
        if (string.startsWith("ABILITY")) {
            return new LevelAbilityAbility(pObject, n, string, false);
        }
        if (string.startsWith("VABILITY")) {
            return new LevelAbilityAbility(pObject, n, string, true);
        }
        if (string.startsWith("CLASSSKILLS")) {
            return new LevelAbilityClassSkills(pObject, n, string);
        }
        if (string.startsWith("WEAPONBONUS")) {
            return new LevelAbilityWeaponBonus(pObject, n, string);
        }
        if (string.startsWith("EQUIP")) {
            return new LevelAbilityEquipment(pObject, n, string);
        }
        if (string.startsWith("LIST")) {
            return new LevelAbilityList(pObject, n, string);
        }
        if (string.startsWith("LANGUAGE") || string.startsWith("Language")) {
            return new LevelAbilityLanguage(pObject, n, string);
        }
        if (string.startsWith("SKILL")) {
            return new LevelAbilitySkill(pObject, n, string);
        }
        if (string.startsWith("SPELLCASTER")) {
            return new LevelAbilitySpellCaster(pObject, n, string);
        }
        return new LevelAbility(pObject, n, string);
    }

    public final boolean canProcess() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.rawTagData, "(", false);
        return stringTokenizer.countTokens() > 1;
    }

    public void subForLevel(PlayerCharacter playerCharacter) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.rawTagData, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if ("FEAT".equals(string)) {
                playerCharacter.adjustFeats(-1.0);
                continue;
            }
            if (!string.startsWith("INIT|") || !(this.owner instanceof PCClass)) continue;
            ((PCClass)this.owner).addInitMod(-Integer.parseInt(string.substring(5)));
        }
        this.clearAssociated();
    }

    /*
     * WARNING - void declaration
     */
    List<String> getChoicesList(String string, PlayerCharacter playerCharacter) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.type == 8) {
            String string2 = string.substring(5);
            for (Race pObject : Globals.getAllRaces()) {
                if (!pObject.getType().equalsIgnoreCase(string2)) continue;
                arrayList.add(pObject.getKeyName());
            }
            for (PCClass pCClass : Globals.getClassList()) {
                if (!pCClass.isType(string2) || arrayList.contains(pCClass.getKeyName())) continue;
                arrayList.add(pCClass.getKeyName());
            }
            return arrayList;
        }
        string = this.truncateStringInsideBalancingParenthesis(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens() && bl) {
            Object object;
            String string2 = stringTokenizer.nextToken();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            if (string2.lastIndexOf(60) > -1) {
                object = new StringTokenizer(string, "<>|", true);
                int n = 0;
                String string3 = "";
                while (((StringTokenizer)object).hasMoreTokens() && !">".equals(string3)) {
                    string3 = ((StringTokenizer)object).nextToken();
                    if (n == 0) {
                        String string4 = string3;
                    }
                    if (n > 0 && PreParserFactory.isPreReqString(string3)) {
                        arrayList2.add(string3);
                    }
                    n += string3.length();
                }
                if (n < string.length()) {
                    string = string.substring(n + 1);
                    stringTokenizer = new StringTokenizer(string, ",", false);
                } else {
                    bl = false;
                }
            }
            try {
                void var6_11;
                object = PreParserFactory.getInstance();
                List<Prerequisite> list = ((PreParserFactory)object).parse(arrayList2);
                if (!PrereqHandler.passesAll(list, playerCharacter, null)) continue;
                this.processToken((String)var6_11, arrayList, playerCharacter);
            }
            catch (PersistenceLayerException persistenceLayerException) {}
        }
        return arrayList;
    }

    private String truncateStringInsideBalancingParenthesis(String string) {
        int n;
        int n2 = 0;
        for (n = 0; n < string.length(); ++n) {
            switch (string.charAt(n)) {
                case '(': {
                    ++n2;
                    break;
                }
                case ')': {
                    --n2;
                    break;
                }
            }
            if (n2 < 0) break;
        }
        if (n2 < 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    String prepareChooser(ChooserInterface chooserInterface, PlayerCharacter playerCharacter) {
        this.setNumberofChoices(chooserInterface, playerCharacter);
        String string = this.rawTagData;
        switch (this.type) {
            case 4: {
                int n = this.rawTagData.lastIndexOf(40);
                if (n > 0) {
                    this.aText = this.rawTagData.substring(0, n);
                    string = this.rawTagData.substring(n + 1);
                } else {
                    this.aText = this.rawTagData;
                    string = this.rawTagData;
                }
                chooserInterface.setTitle(this.aText);
                break;
            }
            case 8: {
                chooserInterface.setTitle("Type Selection");
                break;
            }
            default: {
                Logging.errorPrint("In LevelAbility.prepareChooser the type " + this.type + " is not supported.");
            }
        }
        return string;
    }

    protected void setNumberofChoices(ChooserInterface chooserInterface, PlayerCharacter playerCharacter) {
        int n = this.rawTagData.lastIndexOf(41);
        if (n >= 0 && n < this.rawTagData.length() - 1) {
            if (this.rawTagData.substring(n + 1).equalsIgnoreCase("ALL")) {
                chooserInterface.setPool(Integer.MIN_VALUE);
                this.rawTagData = this.rawTagData.substring(0, n + 1);
            } else {
                chooserInterface.setPool(playerCharacter.getVariableValue(this.rawTagData.substring(n + 1), "").intValue());
                this.rawTagData = this.rawTagData.substring(0, n + 1);
            }
        } else {
            chooserInterface.setPool(1);
        }
    }

    void processToken(String string, List<String> list, PlayerCharacter playerCharacter) {
        switch (this.type) {
            case 4: {
                if (playerCharacter.hasSpecialAbility(this.aText + '(' + string + ')')) break;
                list.add(string);
                break;
            }
            default: {
                Logging.errorPrint("In LevelAbility.processToken the type " + this.type + " is not supported.");
            }
        }
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(": ").append(this.level);
        stringBuffer.append(" - ").append(this.rawTagData);
        return stringBuffer.toString();
    }
}

