/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.PCTemplate;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.kit.BaseKit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KitTemplate
extends BaseKit
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String templateStr = null;
    private transient List<PCTemplate> theTemplates = new ArrayList<PCTemplate>();

    public KitTemplate(String string) {
        this.templateStr = string;
    }

    @Override
    public void apply(PlayerCharacter playerCharacter) {
        boolean bl = SettingsHandler.getShowHPDialogAtLevelUp();
        SettingsHandler.setShowHPDialogAtLevelUp(false);
        for (PCTemplate pCTemplate : this.theTemplates) {
            playerCharacter.addTemplate(pCTemplate, pCTemplate.templatesAdded().size() == 0);
        }
        SettingsHandler.setShowHPDialogAtLevelUp(bl);
    }

    @Override
    public boolean testApply(Kit kit, PlayerCharacter playerCharacter, List<String> list) {
        if (this.templateStr == null) {
            return false;
        }
        boolean bl = SettingsHandler.getShowHPDialogAtLevelUp();
        SettingsHandler.setShowHPDialogAtLevelUp(false);
        StringTokenizer stringTokenizer = new StringTokenizer(this.templateStr, "|");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string, "[]");
            PCTemplate pCTemplate = null;
            while (stringTokenizer2.hasMoreTokens()) {
                Object object;
                String string2 = stringTokenizer2.nextToken();
                if (string2.startsWith("TEMPLATE:")) {
                    object = string2.substring(9);
                    PCTemplate pCTemplate2 = Globals.getTemplateKeyed((String)object);
                    if (pCTemplate2 != null) {
                        pCTemplate.addTemplateName((String)object);
                        continue;
                    }
                    if (list == null) continue;
                    list.add("TEMPLATE: Could not add owned template \"" + (String)object + "\"");
                    continue;
                }
                object = Globals.getTemplateKeyed(string2);
                if (object != null) {
                    try {
                        pCTemplate = ((PCTemplate)object).clone();
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {}
                    continue;
                }
                if (list == null) continue;
                list.add("TEMPLATE: Could not add template \"" + string + "\"");
            }
            playerCharacter.addTemplate(pCTemplate, pCTemplate.templatesAdded().size() == 0);
            this.theTemplates.add(pCTemplate);
        }
        SettingsHandler.setShowHPDialogAtLevelUp(bl);
        return this.theTemplates.size() > 0;
    }

    @Override
    public KitTemplate clone() {
        return (KitTemplate)super.clone();
    }

    @Override
    public String getObjectName() {
        return "Templates";
    }

    public String toString() {
        return this.templateStr.replaceAll("\\|", ", ");
    }
}

