/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.chooser;

import java.util.List;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.core.chooser.AbstractComplexChoiceManager;
import pcgen.util.enumeration.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkillsNamedChoiceManager
extends AbstractComplexChoiceManager<String> {
    public SkillsNamedChoiceManager(PObject pObject, String string, PlayerCharacter playerCharacter) {
        super(pObject, string, playerCharacter);
        this.title = "Skills Choice";
        this.chooserHandled = "SKILLSNAMED";
        if (this.choices != null && this.choices.size() > 0 && ((String)this.choices.get(0)).equals(this.chooserHandled)) {
            this.choices = this.choices.subList(1, this.choices.size());
        }
    }

    @Override
    public void getChoices(PlayerCharacter playerCharacter, List<String> list, List<String> list2) {
        for (String string : this.choices) {
            boolean bl = false;
            if (string.startsWith("TYPE.") || string.startsWith("TYPE=")) {
                for (Skill skill : Globals.getPartialSkillList(Visibility.DISPLAY_ONLY)) {
                    if (!skill.isType(string.substring(5))) continue;
                    list.add(skill.getKeyName());
                }
            }
            if ("ALL".equals(string)) {
                for (Skill skill : Globals.getPartialSkillList(Visibility.DISPLAY_ONLY)) {
                    list.add(skill.getKeyName());
                }
            }
            if ("CLASS".equals(string)) {
                for (Skill skill : Globals.getPartialSkillList(Visibility.DISPLAY_ONLY)) {
                    if (skill.costForPCClassList(playerCharacter.getClassList(), playerCharacter) != Globals.getGameModeSkillCost_Class()) continue;
                    list.add(skill.getKeyName());
                }
            }
            if ("CROSSCLASS".equals(string)) {
                for (Skill skill : Globals.getPartialSkillList(Visibility.DISPLAY_ONLY)) {
                    if (skill.costForPCClassList(playerCharacter.getClassList(), playerCharacter) <= Globals.getGameModeSkillCost_Class()) continue;
                    list.add(skill.getKeyName());
                }
            }
            if ("EXCLUSIVE".equals(string)) {
                for (Skill skill : Globals.getPartialSkillList(Visibility.DISPLAY_ONLY)) {
                    if (skill.costForPCClassList(playerCharacter.getClassList(), playerCharacter) != Globals.getGameModeSkillCost_Exclusive()) continue;
                    list.add(skill.getKeyName());
                }
            }
            if ("NORANK".equals(string)) {
                for (Skill skill : Globals.getPartialSkillList(Visibility.DISPLAY_ONLY)) {
                    Skill skill2 = playerCharacter.getSkillKeyed(skill.getKeyName());
                    if (skill2 != null && Double.compare(skill2.getRank().doubleValue(), 0.0) != 0) continue;
                    list.add(skill.getKeyName());
                }
            }
            if (string.endsWith("%")) {
                bl = true;
                string = string.substring(0, string.length() - 1);
            }
            for (Skill skill : Globals.getPartialSkillList(Visibility.DISPLAY_ONLY)) {
                if (!skill.getKeyName().equals(string) && (!bl || !skill.getKeyName().startsWith(string))) continue;
                list.add(skill.getKeyName());
            }
        }
        this.pobject.addAssociatedTo(list2);
    }
}

