/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.List;
import pcgen.core.Campaign;
import pcgen.core.Description;
import pcgen.core.PCClass;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.PCClassLoader;
import pcgen.util.Logging;

public final class SubClass
extends PCClass {
    private List<String> levelArray = null;
    private String choice = null;
    private boolean prohibitCostSet = false;
    private int cost = 0;
    private int prohibitCost = 0;

    public SubClass() {
        this.setKnownSpellsFromSpecialty(0);
        this.setSpellBaseStat(null);
    }

    public void setChoice(String string) {
        this.choice = string;
    }

    public String getChoice() {
        if (this.choice == null) {
            return "";
        }
        return this.choice;
    }

    public void setCost(int n) {
        this.cost = n;
    }

    public int getCost() {
        return this.cost;
    }

    public void setProhibitCost(int n) {
        this.prohibitCost = n;
        this.prohibitCostSet = true;
    }

    public int getProhibitCost() {
        if (this.prohibitCostSet) {
            return this.prohibitCost;
        }
        return this.cost;
    }

    public void addToLevelArray(String string) {
        if (this.levelArray == null) {
            this.levelArray = new ArrayList<String>();
        }
        this.levelArray.add(string);
    }

    public void applyLevelArrayModsTo(PCClass pCClass) {
        if (this.levelArray == null) {
            return;
        }
        try {
            Campaign campaign = new Campaign();
            campaign.setName("Custom");
            campaign.addDescription(new Description("Custom data"));
            CampaignSourceEntry campaignSourceEntry = new CampaignSourceEntry(campaign, pCClass.getSourceURI());
            for (String string : this.levelArray) {
                PCClassLoader pCClassLoader = new PCClassLoader();
                pCClassLoader.parseLine(pCClass, string, campaignSourceEntry);
            }
        }
        catch (PersistenceLayerException persistenceLayerException) {
            Logging.errorPrint(persistenceLayerException.getMessage());
        }
    }

    public String getSupplementalDisplayInfo() {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getKnownSpellsFromSpecialty() != 0) {
            stringBuffer.append("SPECIALTY SPELLS:").append(this.getKnownSpellsFromSpecialty());
            bl = true;
        }
        if (this.getSpellBaseStat() != null) {
            if (bl) {
                stringBuffer.append(" ");
            }
            stringBuffer.append("SPELL BASE STAT:").append(this.getSpellBaseStat());
            bl = true;
        }
        if (!bl) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }
}

