/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import pcgen.core.Ability;
import pcgen.core.PCClass;
import pcgen.core.PCSpell;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.character.CharacterSpell;
import pcgen.core.character.SpellInfo;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.spell.Spell;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriter;
import pcgen.util.DoubleKeyMap;
import pcgen.util.HashMapToList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpellSupport
implements Cloneable {
    private static final String PIPE = "|";
    private static final String SPELLCASTER = "SPELLCASTER";
    private static final String CLASSSPELLCASTER = "CLASS|SPELLCASTER";
    private static final String ALL = "ALL";
    private HashMap<String, Integer> spellLevelMap = new HashMap();
    private DoubleKeyMap<String, String, Info> spellInfoMap = new DoubleKeyMap();
    private HashMapToList<Integer, PCSpell> spellMap = new HashMapToList();
    private HashMap<String, List<Prerequisite>> preReqSpellLevelMap = new HashMap();
    private List<CharacterSpell> characterSpellList = null;

    public void clearSpellLevelMap() {
        this.spellLevelMap.clear();
    }

    public void putLevel(String string, String string2, String string3, String string4) {
        Integer n = -1;
        try {
            n = Integer.parseInt(string4);
            this.spellLevelMap.put(string + PIPE + string2 + PIPE + string3, n);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public boolean containsLevelFor(String string, String string2, String string3) {
        return this.spellLevelMap.containsKey(string + PIPE + string2 + PIPE + string3);
    }

    public void putInfo(String string, String string2, String string3, String string4) {
        this.spellInfoMap.put(string, string2, new Info(string3, Integer.parseInt(string4)));
    }

    public void clearSpellInfoMap() {
        this.spellInfoMap.clear();
    }

    public boolean containsInfoFor(String string, String string2) {
        return this.spellInfoMap.containsKey(string, string2);
    }

    public Info getInfo(String string, String string2) {
        return this.spellInfoMap.get(string, string2);
    }

    public void addSpells(int n, List<PCSpell> list) {
        Integer n2 = n;
        for (PCSpell pCSpell : list) {
            if (this.spellMap.containsInList(n2, pCSpell)) continue;
            this.spellMap.addToListFor(n2, pCSpell);
        }
    }

    public List<PCSpell> getSpellList(int n) {
        boolean bl = n == -1;
        ArrayList<PCSpell> arrayList = new ArrayList<PCSpell>();
        if (this.spellMap != null) {
            for (Integer n2 : this.spellMap.getKeySet()) {
                if (!bl && n2 > n) continue;
                arrayList.addAll(this.spellMap.getListFor(n2));
            }
        }
        return arrayList;
    }

    public List<PCSpell> getSpellListForLevel(int n) {
        ArrayList<PCSpell> arrayList = new ArrayList<PCSpell>();
        if (this.spellMap != null) {
            for (Integer n2 : this.spellMap.getKeySet()) {
                if (n2 != n) continue;
                arrayList.addAll(this.spellMap.getListFor(n2));
            }
        }
        return arrayList;
    }

    public final int getMaxSpellListLevel() {
        int n = 0;
        if (this.spellMap != null) {
            for (Integer n2 : this.spellMap.getKeySet()) {
                if (n2 <= n) continue;
                n = n2;
            }
        }
        return n;
    }

    public final void clearSpellList() {
        this.spellMap = new HashMapToList();
    }

    public void addSpellLevel(String string, String string2, String string3, String string4, List<Prerequisite> list) {
        this.preReqSpellLevelMap.put(string + PIPE + string2 + PIPE + string3, list);
        this.putLevel(string, string2, string3, string4);
        this.putInfo(string, string3, string2, string4);
    }

    public Map<String, Integer> getSpellMapPassesPrereqs(int n, PlayerCharacter playerCharacter) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (String string : this.spellLevelMap.keySet()) {
            int n2 = this.spellLevelMap.get(string);
            if ((n != -1 || n2 < 0) && (n < 0 || n2 != n) || !this.preReqSpellLevelMap.containsKey(string)) continue;
            if (string.startsWith(CLASSSPELLCASTER)) {
                String string2 = string.substring(18);
                if (!ALL.equals(string2 = string2.substring(0, string2.indexOf(PIPE))) && !playerCharacter.isSpellCaster(string2, 1) || !PrereqHandler.passesAll(this.preReqSpellLevelMap.get(string), playerCharacter, null)) continue;
                for (PCClass pCClass : playerCharacter.getClassList()) {
                    if (!pCClass.getSpellType().equals(string2) && !ALL.equals(string2)) continue;
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(pCClass.getSpellKey()).append(PIPE).append(string.substring(string.lastIndexOf(PIPE) + 1));
                    hashMap.put(stringBuffer.toString(), n2);
                }
                continue;
            }
            if (!PrereqHandler.passesAll(this.preReqSpellLevelMap.get(string), playerCharacter, null)) continue;
            hashMap.put(string, n2);
        }
        return hashMap;
    }

    public Map<String, Integer> getSpellInfoMapPassesPrereqs(String string, String string2, PlayerCharacter playerCharacter) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        if (this.spellInfoMap.containsKey(string, string2)) {
            Info info = this.spellInfoMap.get(string, string2);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string).append(PIPE).append(info.name).append(PIPE).append(string2);
            String string3 = stringBuffer.toString();
            if (this.preReqSpellLevelMap.containsKey(string3)) {
                if (info.name.startsWith(SPELLCASTER)) {
                    String string4 = info.name.substring(12);
                    if ((ALL.equals(string4) || playerCharacter.isSpellCaster(string4, 1)) && PrereqHandler.passesAll(this.preReqSpellLevelMap.get(string3), playerCharacter, null)) {
                        for (PCClass pCClass : playerCharacter.getClassList()) {
                            if (!pCClass.getSpellType().equals(string4) && !ALL.equals(string4)) continue;
                            hashMap.put(pCClass.getSpellKey(), info.level);
                        }
                    }
                } else if (PrereqHandler.passesAll(this.preReqSpellLevelMap.get(string3), playerCharacter, null)) {
                    StringBuffer stringBuffer2 = new StringBuffer();
                    stringBuffer2.append(string).append(PIPE).append(info.name);
                    hashMap.put(stringBuffer2.toString(), info.level);
                }
            }
        }
        return hashMap;
    }

    final boolean removeCharacterSpell(CharacterSpell characterSpell) {
        if (this.characterSpellList == null) {
            return false;
        }
        return this.characterSpellList.remove(characterSpell);
    }

    public final boolean removeSpellIfUnused(CharacterSpell characterSpell) {
        SpellInfo spellInfo = characterSpell.getSpellInfoFor("", -1, -1, null);
        if (spellInfo == null) {
            return this.removeCharacterSpell(characterSpell);
        }
        return false;
    }

    final void clearCharacterSpells() {
        if (this.characterSpellList != null && !this.characterSpellList.isEmpty()) {
            this.characterSpellList.clear();
        }
    }

    public final void sortCharacterSpellList() {
        if (this.characterSpellList != null) {
            Collections.sort(this.characterSpellList);
        }
    }

    public final void addAllCharacterSpells(List<CharacterSpell> list) {
        if (this.characterSpellList == null) {
            this.characterSpellList = new ArrayList<CharacterSpell>();
        }
        this.characterSpellList.addAll(list);
    }

    public final void addCharacterSpell(CharacterSpell characterSpell) {
        if (this.characterSpellList == null) {
            this.characterSpellList = new ArrayList<CharacterSpell>();
        }
        this.characterSpellList.add(characterSpell);
    }

    public final boolean containsCharacterSpell(CharacterSpell characterSpell) {
        return this.characterSpellList != null && this.characterSpellList.contains(characterSpell);
    }

    public final int getCharacterSpellCount() {
        if (this.characterSpellList == null) {
            return 0;
        }
        return this.characterSpellList.size();
    }

    public final CharacterSpell getCharacterSpellForSpell(Spell spell, PObject pObject) {
        if (spell == null || this.characterSpellList == null) {
            return null;
        }
        for (CharacterSpell characterSpell : this.characterSpellList) {
            Spell spell2 = characterSpell.getSpell();
            if (!spell.equals(spell2) || pObject != null && !characterSpell.getOwner().equals(pObject)) continue;
            return characterSpell;
        }
        return null;
    }

    public final List<CharacterSpell> getCharacterSpell(Spell spell, String string, int n, ArrayList<Ability> arrayList) {
        ArrayList<CharacterSpell> arrayList2 = new ArrayList<CharacterSpell>();
        if (this.getCharacterSpellCount() == 0) {
            return arrayList2;
        }
        for (CharacterSpell characterSpell : this.characterSpellList) {
            SpellInfo spellInfo;
            if (spell != null && !characterSpell.getSpell().equals(spell) || (spellInfo = characterSpell.getSpellInfoFor(string, n, -1, arrayList)) == null) continue;
            arrayList2.add(characterSpell);
        }
        return arrayList2;
    }

    public final List<CharacterSpell> getCharacterSpell(Spell spell, String string, int n) {
        return this.getCharacterSpell(spell, string, n, null);
    }

    public Collection<CharacterSpell> getCharacterSpellList() {
        if (this.characterSpellList == null) {
            return new ArrayList<CharacterSpell>();
        }
        return new ArrayList<CharacterSpell>(this.characterSpellList);
    }

    public SpellSupport clone() throws CloneNotSupportedException {
        SpellSupport spellSupport = (SpellSupport)super.clone();
        spellSupport.spellInfoMap = this.spellInfoMap.clone();
        spellSupport.spellMap = new HashMapToList();
        spellSupport.spellMap.addAllLists(this.spellMap);
        if (this.characterSpellList != null) {
            spellSupport.characterSpellList = new ArrayList<CharacterSpell>(this.characterSpellList);
        }
        spellSupport.preReqSpellLevelMap = new HashMap<String, List<Prerequisite>>(this.preReqSpellLevelMap);
        spellSupport.spellLevelMap = new HashMap<String, Integer>(this.spellLevelMap);
        return spellSupport;
    }

    public String getPCCText() {
        StringBuffer stringBuffer = new StringBuffer();
        TreeMap<String, StringBuffer> treeMap = new TreeMap<String, StringBuffer>();
        Set<String> set = this.spellInfoMap.getKeySet();
        for (String object : set) {
            Set<String> set2 = this.spellInfoMap.getSecondaryKeySet(object);
            for (String string : set2) {
                Info info = this.spellInfoMap.get(object, string);
                List<Prerequisite> list = this.preReqSpellLevelMap.get(object + PIPE + info.name + PIPE + string);
                if (list == null || list.isEmpty()) {
                    StringBuffer stringBuffer2 = new StringBuffer();
                    stringBuffer2.append(object);
                    stringBuffer2.append(PIPE).append(info.name);
                    stringBuffer2.append("=").append(info.level);
                    StringBuffer stringBuffer3 = (StringBuffer)treeMap.get(stringBuffer2.toString());
                    if (stringBuffer3 == null) {
                        stringBuffer3 = new StringBuffer();
                        treeMap.put(stringBuffer2.toString(), stringBuffer3);
                    } else {
                        stringBuffer3.append(',');
                    }
                    stringBuffer3.append(string);
                    continue;
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.append('\t');
                }
                stringBuffer.append(this.getSpellLevelPccText(object, string, info, list));
            }
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append('\t');
            }
            stringBuffer.append("SPELLLEVEL:").append((String)entry.getKey());
            stringBuffer.append(PIPE);
            stringBuffer.append((StringBuffer)entry.getValue());
        }
        return stringBuffer.toString();
    }

    private String getSpellLevelPccText(String string, String string2, Info info, List<Prerequisite> list) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SPELLLEVEL:").append(string);
        stringBuffer.append(PIPE).append(info.name);
        stringBuffer.append("=").append(info.level);
        stringBuffer.append(PIPE).append(string2);
        StringWriter stringWriter = new StringWriter();
        for (Prerequisite prerequisite : list) {
            PrerequisiteWriter prerequisiteWriter = new PrerequisiteWriter();
            try {
                stringWriter.write(PIPE);
                prerequisiteWriter.write(stringWriter, prerequisite);
            }
            catch (PersistenceLayerException persistenceLayerException) {
                persistenceLayerException.printStackTrace();
            }
        }
        stringBuffer.append(stringWriter);
        return stringBuffer.toString();
    }

    public class Info {
        public final String name;
        public final int level;

        public Info(String string, int n) {
            this.name = string;
            this.level = n;
        }
    }
}

