/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.Language;
import pcgen.core.PCStat;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.SizeAdjustment;
import pcgen.core.Skill;
import pcgen.core.Vision;
import pcgen.core.bonus.BonusObj;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Race
extends PObject {
    private List<String> monCCSkillList = null;
    private List<String> monCSkillList = null;
    private Map<String, Integer> hitPointMap = new HashMap<String, Integer>();
    private Integer initMod = 0;
    private Integer startingAC = 10;
    private String hitDieLock = "";
    private String ageString = "";
    private String bonusSkillList = "";
    private Point2D.Double face = new Point2D.Double(5.0, 0.0);
    private String favoredClass = "";
    private String featList = "";
    private String heightString = "";
    private String levelAdjustment = "0";
    private String mFeatList = "";
    private String monsterClass = null;
    private String size = "";
    private String weightString = "";
    private int[] hitDiceAdvancement;
    private boolean unlimitedAdvancement = false;
    private int CR = 0;
    private int bonusSkillsPerLevel = 0;
    private int hands = 2;
    private int hitDice = 0;
    private int hitDiceSize = 0;
    private int initialSkillMultiplier = 4;
    private int langNum = 0;
    private int legs = 2;
    private int monsterClassLevels = 0;
    private int reach = 5;
    private String raceType = "None";
    private List<String> racialSubTypes = new ArrayList<String>();

    public void setAdvancementUnlimited(boolean bl) {
        this.unlimitedAdvancement = bl;
    }

    public boolean isAdvancementUnlimited() {
        return this.unlimitedAdvancement;
    }

    public void setBonusInitialFeats(BonusObj bonusObj) {
        this.addBonusList(bonusObj);
    }

    public int getBonusInitialFeats() {
        return 0;
    }

    public void setBonusSkillList(String string) {
        this.bonusSkillList = string;
    }

    public void setBonusSkillsPerLevel(int n) {
        this.bonusSkillsPerLevel = n;
    }

    public int getBonusSkillsPerLevel() {
        return this.bonusSkillsPerLevel;
    }

    public void setCR(int n) {
        this.CR = n;
    }

    public int getCR() {
        return this.CR;
    }

    public String getDisplayVision(PlayerCharacter playerCharacter) {
        if (this.vision == null) {
            return "";
        }
        if (playerCharacter == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(25);
        for (Vision vision : this.vision) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(';');
            }
            stringBuffer.append(vision.toString(playerCharacter));
        }
        return stringBuffer.toString();
    }

    public void setFace(double d, double d2) {
        this.face = new Point2D.Double(d, d2);
    }

    public Point2D.Double getFace() {
        return this.face;
    }

    public void setFavoredClass(String string) {
        this.favoredClass = string;
    }

    public String getFavoredClass() {
        return this.favoredClass;
    }

    public void setFeatList(String string) {
        this.featList = string;
    }

    public String getFeatList(PlayerCharacter playerCharacter) {
        return this.getFeatList(playerCharacter, true);
    }

    public String getFeatList(PlayerCharacter playerCharacter, boolean bl) {
        if (bl && playerCharacter != null && playerCharacter.isMonsterDefault() && !"".equals(this.mFeatList)) {
            return this.featList + "|" + this.mFeatList;
        }
        if (!bl || playerCharacter != null) {
            return this.featList;
        }
        return "";
    }

    public void setHands(int n) {
        this.hands = n;
    }

    public int getHands() {
        return this.hands;
    }

    public void setHeightString(String string) {
        this.heightString = string;
    }

    public void setHitDice(int n) {
        if (n < 0) {
            ShowMessageDelegate.showMessageDialog("Invalid number of hit dice in race " + this.displayName, "PCGen", MessageType.ERROR);
            return;
        }
        this.hitDice = n;
    }

    public void setHitDiceAdvancement(int[] nArray) {
        this.hitDiceAdvancement = nArray;
    }

    public int getHitDiceAdvancement(int n) {
        return this.hitDiceAdvancement[n];
    }

    public void setHitDiceSize(int n) {
        this.hitDiceSize = n;
    }

    public int getHitDiceSize(PlayerCharacter playerCharacter) {
        return this.getHitDiceSize(playerCharacter, true);
    }

    public int getHitDiceSize(PlayerCharacter playerCharacter, boolean bl) {
        if (!bl || playerCharacter != null && playerCharacter.isMonsterDefault()) {
            return this.hitDiceSize;
        }
        return 0;
    }

    public void setHitDieLock(String string) {
        this.hitDieLock = string;
    }

    public void setHitPoint(int n, Integer n2) {
        this.hitPointMap.put(Integer.toString(n), n2);
    }

    public Integer getHitPoint(int n) {
        Integer n2 = this.hitPointMap.get(Integer.toString(n));
        if (n2 == null) {
            return 0;
        }
        return n2;
    }

    public void setHitPointMap(HashMap<String, Integer> hashMap) {
        this.hitPointMap.clear();
        this.hitPointMap.putAll(hashMap);
    }

    public int getHitPointMapSize() {
        return this.hitPointMap.size();
    }

    public void setInitMod(Integer n) {
        this.initMod = n;
    }

    public void setInitialSkillMultiplier(int n) {
        this.initialSkillMultiplier = n;
    }

    public int getInitialSkillMultiplier() {
        return this.initialSkillMultiplier;
    }

    public void setLangNum(int n) {
        this.langNum = n;
    }

    public void setLegs(int n) {
        this.legs = n;
    }

    public int getLegs() {
        return this.legs;
    }

    public void setLevelAdjustment(String string) {
        this.levelAdjustment = string;
    }

    public int getLevelAdjustment(PlayerCharacter playerCharacter) {
        int n;
        if (playerCharacter != null) {
            return playerCharacter.getVariableValue(this.levelAdjustment, "").intValue();
        }
        try {
            n = Integer.parseInt(this.levelAdjustment);
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        return n;
    }

    public String getLevelAdjustmentFormula() {
        return this.levelAdjustment;
    }

    public void setMFeatList(String string) {
        this.mFeatList = string;
    }

    public String getMFeatList() {
        return this.mFeatList;
    }

    public void setMonCCSkillList(String string) {
        if (this.monCCSkillList == null) {
            this.monCCSkillList = new ArrayList<String>();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (".CLEAR".equals(string2)) {
                this.monCCSkillList.clear();
                continue;
            }
            if (string2.startsWith("TYPE.") || string2.startsWith("TYPE=")) {
                for (Skill skill : Globals.getSkillList()) {
                    if (!skill.isType(string2.substring(5))) continue;
                    this.monCCSkillList.add(skill.getKeyName());
                }
                continue;
            }
            this.monCCSkillList.add(string2);
        }
    }

    public void setMonCSkillList(String string) {
        if (this.monCSkillList == null) {
            this.monCSkillList = new ArrayList<String>();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (".CLEAR".equals(string2)) {
                this.monCSkillList.clear();
                continue;
            }
            if (string2.startsWith("TYPE.") || string2.startsWith("TYPE=")) {
                for (Skill skill : Globals.getSkillList()) {
                    if (!skill.isType(string2.substring(5))) continue;
                    this.monCSkillList.add(skill.getKeyName());
                }
                continue;
            }
            this.monCSkillList.add(string2);
        }
    }

    public void setMonsterClass(String string) {
        this.monsterClass = string;
    }

    public String getMonsterClass(PlayerCharacter playerCharacter, boolean bl) {
        if (!bl || playerCharacter != null && !playerCharacter.isMonsterDefault()) {
            return this.monsterClass;
        }
        return null;
    }

    public void setMonsterClassLevels(int n) {
        this.monsterClassLevels = n;
    }

    public int getMonsterClassLevels(PlayerCharacter playerCharacter) {
        return this.getMonsterClassLevels(playerCharacter, true);
    }

    public int getMonsterClassLevels(PlayerCharacter playerCharacter, boolean bl) {
        if (!bl || playerCharacter != null && !playerCharacter.isMonsterDefault()) {
            return this.monsterClassLevels;
        }
        return 0;
    }

    public boolean isNonAbility(int n) {
        List<PCStat> list = SettingsHandler.getGame().getUnmodifiableStatList();
        if (n < 0 || n >= list.size()) {
            return true;
        }
        String string = "|LOCK." + list.get(n).getAbb() + "|10";
        int n2 = this.getVariableCount();
        for (int i = 0; i < n2; ++i) {
            String string2 = this.getVariableDefinition(i);
            if (!string2.endsWith(string)) continue;
            return true;
        }
        return false;
    }

    public int getNumberOfHitDiceAdvancements() {
        return this.hitDiceAdvancement != null ? this.hitDiceAdvancement.length : 0;
    }

    public String getUdam() {
        int n = Globals.sizeInt(this.getSize());
        SizeAdjustment sizeAdjustment = SettingsHandler.getGame().getDefaultSizeAdjustment();
        SizeAdjustment sizeAdjustment2 = SettingsHandler.getGame().getSizeAdjustmentAtIndex(n);
        if (sizeAdjustment != null && sizeAdjustment2 != null) {
            return Globals.adjustDamage("1d3", sizeAdjustment.getAbbreviation(), sizeAdjustment2.getAbbreviation());
        }
        return "1d3";
    }

    public String getRaceType() {
        return this.raceType;
    }

    public void setRaceType(String string) {
        this.raceType = string;
    }

    public void addRacialSubType(String string) {
        this.racialSubTypes.add(string);
    }

    public boolean removeRacialSubType(String string) {
        return this.racialSubTypes.remove(string);
    }

    public List<String> getRacialSubTypes() {
        return Collections.unmodifiableList(this.racialSubTypes);
    }

    @Override
    public String getPCCText() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(super.getPCCText());
        if (this.favoredClass != null && this.favoredClass.length() > 0) {
            stringBuffer.append("\tFAVCLASS:").append(this.favoredClass);
        }
        if (this.size != null && this.size.length() > 0) {
            stringBuffer.append("\tSIZE:").append(this.size);
        }
        if (this.reach != 5) {
            stringBuffer.append("\tREACH:").append(this.reach);
        }
        if (this.getChooseLanguageAutos() != null && this.getChooseLanguageAutos().length() > 0) {
            stringBuffer.append("\tCHOOSE:LANGAUTO:").append(this.getChooseLanguageAutos());
        }
        if (this.getLanguageBonus() != null && !this.getLanguageBonus().isEmpty()) {
            object = new StringBuffer();
            for (Language object2 : this.getLanguageBonus()) {
                if (((StringBuffer)object).length() != 0) {
                    ((StringBuffer)object).append(',');
                }
                ((StringBuffer)object).append(object2.toString());
            }
            stringBuffer.append("\tLANGBONUS:").append(((StringBuffer)object).toString());
        }
        if (this.getWeaponProfBonus().size() > 0) {
            object = new StringBuffer();
            for (String string : this.getWeaponProfBonus()) {
                if (((StringBuffer)object).length() != 0) {
                    ((StringBuffer)object).append('|');
                }
                ((StringBuffer)object).append(string);
            }
            stringBuffer.append("\tWEAPONBONUS:").append(((StringBuffer)object).toString());
        }
        if (this.mFeatList != null && this.mFeatList.length() > 0) {
            stringBuffer.append("\tMFEAT:").append(this.mFeatList);
        }
        if (this.legs != 2) {
            stringBuffer.append("\tLEGS:").append(this.legs);
        }
        if (this.hands != 2) {
            stringBuffer.append("\tHANDS:").append(this.hands);
        }
        if (this.getNaturalWeapons() != null && this.getNaturalWeapons().size() > 0) {
            object = new StringBuffer();
            for (Equipment equipment : this.getNaturalWeapons()) {
                String string;
                int n;
                if (((StringBuffer)object).length() != 0) {
                    ((StringBuffer)object).append('|');
                }
                if ((n = (string = equipment.getName()).indexOf(" (Natural/Primary)")) >= 0) {
                    string = string.substring(0, n) + string.substring(n + " (Natural/Primary)".length());
                }
                if ((n = string.indexOf(" (Natural/Secondary)")) >= 0) {
                    string = string.substring(0, n) + string.substring(n + " (Natural/Secondary)".length());
                }
                ((StringBuffer)object).append(string).append(',');
                ((StringBuffer)object).append(equipment.getType(false)).append(',');
                if (!equipment.isAttacksProgress()) {
                    ((StringBuffer)object).append('*');
                }
                ((StringBuffer)object).append((int)equipment.bonusTo(null, "WEAPON", "ATTACKS", true) + 1).append(',');
                ((StringBuffer)object).append(equipment.getDamage(null));
            }
            stringBuffer.append("\tNATURALATTACKS:").append(((StringBuffer)object).toString());
        }
        if (this.initialSkillMultiplier != 4) {
            stringBuffer.append("\tSKILLMULT:").append(this.initialSkillMultiplier);
        }
        if (this.monsterClass != null) {
            stringBuffer.append("\tMONSTERCLASS:").append(this.monsterClass);
            stringBuffer.append(':').append(this.monsterClassLevels);
        }
        if ((object = this.getTemplateList()) != null && object.size() > 0) {
            Iterator<Object> iterator = object.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                stringBuffer.append("\tTEMPLATE:").append(string);
            }
        }
        if (this.hitDiceAdvancement != null && this.hitDiceAdvancement.length > 0) {
            stringBuffer.append("\tHITDICEADVANCEMENT:");
            for (int i = 0; i < this.hitDiceAdvancement.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                if (this.hitDiceAdvancement[i] == -1 && this.isAdvancementUnlimited()) {
                    stringBuffer.append('*');
                    continue;
                }
                stringBuffer.append(this.hitDiceAdvancement[i]);
            }
        }
        if (this.CR != 0) {
            stringBuffer.append("\tCR:");
            if (this.CR < 0) {
                stringBuffer.append("1/").append(-this.CR);
            } else {
                stringBuffer.append(this.CR);
            }
        }
        if (this.startingAC != 10) {
            stringBuffer.append("\tAC:").append(this.startingAC.toString());
        }
        if (CoreUtility.doublesEqual(this.face.getY(), 0.0)) {
            stringBuffer.append("\tFACE:").append(this.face.getX() + " ft.");
        } else {
            stringBuffer.append("\tFACE:").append(this.face.getX() + " ft. by " + this.face.getY() + " ft.");
        }
        if (this.featList != null && this.featList.length() > 0) {
            stringBuffer.append("\tFEAT:").append(this.featList);
        }
        if (this.hitDice != 0 || this.hitDiceSize != 0) {
            stringBuffer.append("\tHITDICE:").append(this.hitDice).append(',').append(this.hitDiceSize);
        }
        if (this.initMod != 0) {
            stringBuffer.append("\tINIT:").append(this.initMod.toString());
        }
        if (this.langNum != 0) {
            stringBuffer.append("\tLANGNUM:").append(this.langNum);
        }
        if (!"0".equals(this.levelAdjustment)) {
            stringBuffer.append("\tLEVELADJUSTMENT:").append(this.levelAdjustment);
        }
        if (!"None".equals(this.displayName)) {
            stringBuffer.append("\tRACENAME:").append(this.displayName);
        }
        if (this.bonusSkillList != null && this.bonusSkillList.length() > 0) {
            stringBuffer.append("\tSKILL:").append(this.bonusSkillList);
        }
        if (this.bonusSkillsPerLevel != 0) {
            stringBuffer.append("\tXTRASKILLPTSPERLVL:").append(this.bonusSkillsPerLevel);
        }
        return stringBuffer.toString();
    }

    public void setReach(int n) {
        this.reach = n;
    }

    public int getReach() {
        return this.reach;
    }

    public void setSize(String string) {
        this.size = string;
    }

    public String getSize() {
        return this.size;
    }

    public void setStartingAC(Integer n) {
        this.startingAC = n;
    }

    @Override
    public Race clone() {
        Race race = null;
        try {
            race = (Race)super.clone();
            race.favoredClass = this.favoredClass;
            race.bonusSkillsPerLevel = this.bonusSkillsPerLevel;
            race.size = this.size;
            race.bonusSkillList = this.bonusSkillList;
            race.ageString = this.ageString;
            race.heightString = this.heightString;
            race.weightString = this.weightString;
            race.featList = this.featList;
            race.langNum = this.langNum;
            race.initialSkillMultiplier = this.initialSkillMultiplier;
            race.levelAdjustment = this.levelAdjustment;
            race.CR = this.CR;
            race.hitDice = this.hitDice;
            race.hitDiceSize = this.hitDiceSize;
            race.hitPointMap = new HashMap<String, Integer>(this.hitPointMap);
            race.hitDiceAdvancement = this.hitDiceAdvancement;
            race.hands = this.hands;
            race.reach = this.reach;
            race.face = this.face;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ShowMessageDelegate.showMessageDialog(cloneNotSupportedException.getMessage(), "PCGen", MessageType.ERROR);
        }
        return race;
    }

    public boolean hasAdvancement() {
        return this.hitDiceAdvancement != null;
    }

    public int hashCode() {
        return this.getKeyName().hashCode();
    }

    public int hitDice(PlayerCharacter playerCharacter) {
        return this.hitDice(playerCharacter, true);
    }

    public int hitDice(PlayerCharacter playerCharacter, boolean bl) {
        if (!bl || playerCharacter != null && playerCharacter.isMonsterDefault()) {
            return this.hitDice;
        }
        return 0;
    }

    public void rollHP(PlayerCharacter playerCharacter) {
        if (!playerCharacter.isImporting()) {
            int n = 1 + (int)playerCharacter.getTotalBonusTo("HD", "MIN");
            int n2 = this.hitDiceSize + (int)playerCharacter.getTotalBonusTo("HD", "MAX");
            for (int i = 0; i < this.hitDice; ++i) {
                this.setHitPoint(i, Globals.rollHP(n, n2, this.getKeyName(), i + 1));
            }
        }
        playerCharacter.setCurrentHP(playerCharacter.hitPoints());
    }

    @Override
    protected int getSR(PlayerCharacter playerCharacter) {
        int n;
        if (this.getSRFormula() != null && playerCharacter != null) {
            return playerCharacter.getVariableValue(this.getSRFormula(), "").intValue();
        }
        try {
            n = Integer.parseInt(this.getSRFormula());
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        return n;
    }

    @Override
    protected void doGlobalTypeUpdate(String string) {
        Globals.getRaceTypes().add(string);
    }

    int getBAB(PlayerCharacter playerCharacter) {
        return 0;
    }

    String getHitDieLock() {
        return this.hitDieLock;
    }

    int getLangNum() {
        return this.langNum;
    }

    String getMonsterClass(PlayerCharacter playerCharacter) {
        return this.getMonsterClass(playerCharacter, true);
    }

    int bonusForSkill(String string) {
        if (this.getBonusSkillList().length() == 0) {
            return 0;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.bonusSkillList, "=");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = Integer.parseInt(stringTokenizer.nextToken());
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",", false);
            while (stringTokenizer2.hasMoreTokens()) {
                String string3 = stringTokenizer2.nextToken();
                if (!string3.equals(string)) continue;
                return n;
            }
        }
        return 0;
    }

    int calcHitPoints(int n) {
        int n2 = 0;
        for (int i = 0; i <= this.hitDice; ++i) {
            if (this.getHitPoint(i) <= 0) continue;
            int n3 = this.getHitPoint(i) + n;
            if (n3 < 1) {
                n3 = 1;
            }
            n2 += n3;
        }
        return n2;
    }

    boolean canBeAlignment(String string) {
        if (this.hasPreReqs()) {
            for (Prerequisite prerequisite : this.getPreReqList()) {
                if (!"ALIGN".equalsIgnoreCase(prerequisite.getKind())) continue;
                String string2 = string;
                String[] stringArray = SettingsHandler.getGame().getAlignmentListStrings(false);
                try {
                    int n = Integer.parseInt(string2);
                    string2 = stringArray[n];
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                String string3 = prerequisite.getKey();
                try {
                    int n = Integer.parseInt(string3);
                    string3 = stringArray[n];
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return string3.equalsIgnoreCase(string2);
            }
        }
        return true;
    }

    boolean hasMonsterCCSkill(String string) {
        if (this.monCCSkillList == null || this.monCCSkillList.isEmpty()) {
            return false;
        }
        if (this.monCCSkillList.contains(string)) {
            return true;
        }
        for (String string2 : this.monCCSkillList) {
            if (string2.lastIndexOf(37) < 0 || !string.startsWith(string2 = string2.substring(0, string2.length() - 1))) continue;
            return true;
        }
        return false;
    }

    boolean hasMonsterCSkill(String string) {
        if (this.monCSkillList == null || this.monCSkillList.isEmpty()) {
            return false;
        }
        if (this.monCSkillList.contains(string)) {
            return true;
        }
        if (this.monCSkillList.contains("LIST")) {
            for (int i = 0; i < this.getAssociatedCount(); ++i) {
                String string2 = this.getAssociated(i);
                if (!string.startsWith(string2) && !string2.startsWith(string)) continue;
                return true;
            }
        }
        for (String string2 : this.monCSkillList) {
            if (string2.lastIndexOf(37) < 0 || !string.startsWith(string2 = string2.substring(0, string2.length() - 1))) continue;
            return true;
        }
        return false;
    }

    int maxHitDiceAdvancement() {
        if (this.hitDiceAdvancement != null && this.hitDiceAdvancement.length >= 1) {
            return this.hitDiceAdvancement[this.hitDiceAdvancement.length - 1];
        }
        return 0;
    }

    int sizesAdvanced(int n) {
        if (this.hitDiceAdvancement != null) {
            for (int i = 0; i < this.hitDiceAdvancement.length; ++i) {
                if (n > this.hitDiceAdvancement[i] && this.hitDiceAdvancement[i] != -1) continue;
                return i;
            }
        }
        return 0;
    }

    private String getBonusSkillList() {
        return this.bonusSkillList;
    }
}

