/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import pcgen.core.PObject;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PObjectDataStore<T extends PObject> {
    private Map<String, T> byKey = new HashMap<String, T>(100);
    private Map<String, Map<String, T>> byType = new HashMap<String, Map<String, T>>(4);
    private Set<String> nameSet;
    private SortedMap<String, T> byUpperName = new TreeMap<String, T>();
    private String containedType;

    public PObjectDataStore(String string) {
        this.containedType = string;
    }

    public Collection<T> getAll() {
        return this.byKey.values();
    }

    public Collection<T> getAllOfType(String string) {
        String string2 = string.toUpperCase();
        ArrayList<T> arrayList = null;
        Map<String, T> map = this.byType.get(string2);
        if (map != null) {
            arrayList = new ArrayList<T>(map.values());
        }
        return arrayList;
    }

    public Set<String> getTypes() {
        return Collections.unmodifiableSet(this.byType.keySet());
    }

    public List<T> getArrayCopy() {
        return new ArrayList<T>(this.byUpperName.values());
    }

    public T getKeyed(String string) {
        return (T)((PObject)this.byKey.get(string.toUpperCase()));
    }

    public T getNamed(String string) {
        return (T)((PObject)this.byUpperName.get(string.toUpperCase()));
    }

    public String getNames(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = true;
        if (bl) {
            stringBuffer.append("[");
        }
        Iterator<T> iterator = this.byUpperName.values().iterator();
        while (iterator.hasNext()) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuffer.append(string);
            }
            PObject pObject = (PObject)iterator.next();
            stringBuffer.append(pObject.getDisplayName());
        }
        if (bl) {
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    public void add(T t) {
        String string = ((PObject)t).getKeyName().toUpperCase();
        this.byKey.put(string, t);
        String string2 = ((PObject)t).getDisplayName().toUpperCase();
        this.byUpperName.put(string2, t);
        for (String string3 : ((PObject)t).getTypeList(false)) {
            Map<String, T> map = this.byType.get(string3);
            if (map == null) {
                map = new TreeMap<String, T>();
                this.byType.put(string3, map);
            }
            map.put(string2, t);
        }
        this.clearVariableNameCache();
    }

    public void addUniqueAsStringTo(List<String> list) {
        for (PObject pObject : this.byUpperName.values()) {
            if (list.contains(pObject.toString())) continue;
            list.add(pObject.toString());
        }
        this.clearVariableNameCache();
    }

    public void clear() {
        this.byKey.clear();
        this.byType.clear();
        this.byUpperName.clear();
        this.clearVariableNameCache();
    }

    public boolean hasVariableNamed(Collection<T> collection, String string) {
        if (collection.isEmpty()) {
            return false;
        }
        if (!this.hasVariableNamed(string)) {
            return false;
        }
        for (PObject pObject : collection) {
            if (pObject == null) {
                Logging.debugPrint("No PObject for " + this.containedType + " " + pObject.getDisplayName());
                continue;
            }
            if (!pObject.hasVariableNamed(string)) continue;
            return true;
        }
        return false;
    }

    public void removeNamed(String string) {
        T t = this.getNamed(string);
        String string2 = ((PObject)t).getDisplayName().toUpperCase();
        this.byUpperName.remove(string2);
        this.byKey.remove(((PObject)t).getKeyName().toUpperCase());
        Map<String, T> map = this.byType.get(((PObject)t).getType().toUpperCase());
        if (map != null) {
            map.remove(string2);
        }
        this.clearVariableNameCache();
    }

    public int size() {
        return this.byUpperName.size();
    }

    public Collection<T> retainAll(Collection<T> collection) {
        ArrayList<PObject> arrayList = new ArrayList<PObject>(this.size());
        for (PObject pObject : this.byKey.values()) {
            if (!collection.contains(pObject)) continue;
            arrayList.add(pObject);
        }
        return arrayList;
    }

    private final void cacheVariableNames() {
        this.nameSet = new HashSet<String>();
        for (PObject pObject : this.byUpperName.values()) {
            Set<String> set = pObject.getVariableNamesAsUnmodifiableSet();
            if (set == null) continue;
            this.nameSet.addAll(set);
        }
    }

    private final void clearVariableNameCache() {
        this.nameSet = null;
    }

    public boolean hasVariableNamed(String string) {
        String string2 = string.toUpperCase();
        if (this.nameSet == null) {
            this.cacheVariableNames();
        }
        return this.nameSet.contains(string2);
    }
}

