/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Ability;
import pcgen.core.Equipment;
import pcgen.core.EquipmentChoice;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.SpecialProperty;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.spell.Spell;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.IntegerKey;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.util.Delta;
import pcgen.util.Logging;
import pcgen.util.chooser.ChooserFactory;
import pcgen.util.chooser.ChooserInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EquipmentModifier
extends PObject
implements Comparable<Object> {
    protected static final int VISIBLE_NO = 0;
    protected static final int VISIBLE_YES = 1;
    protected static final int VISIBLE_QUALIFIED = 2;
    private static final int NAMINGOPTION_NORMAL = 0;
    private static final int NAMINGOPTION_NONAME = 1;
    private static final int NAMINGOPTION_NOLIST = 2;
    private static final int NAMINGOPTION_NOTHING = 3;
    private static final int NAMINGOPTION_SPELL = 4;
    private static final int NAMINGOPTION_TEXT = 5;
    public static final int FORMATCAT_FRONT = 0;
    public static final int FORMATCAT_MIDDLE = 1;
    public static final int FORMATCAT_PARENS = 2;
    private static final String s_CHARGES = "CHARGES";
    private List<String> ignores = new ArrayList<String>();
    private List<String> itemType = new ArrayList<String>();
    private List<String> replaces = new ArrayList<String>();
    private List<SpecialProperty> specialPropertyList = new ArrayList<SpecialProperty>();
    private List<String> vFeatList = null;
    private List<String> armorType = new ArrayList<String>();
    private String cost = "0";
    private String preCost = "0";
    private String proficiency = "";
    private boolean assignToAll = false;
    private int costDouble = -1;
    private int equipmentVisible = 1;
    private int maxCharges = 0;
    private int minCharges = 0;
    private int namingOption = 0;
    private String namingOptionText = "";
    private int plus = 0;
    private String fumbleRange = "";

    public List<BonusObj> getActiveBonuses(PObject pObject, PlayerCharacter playerCharacter) {
        ArrayList<BonusObj> arrayList = new ArrayList<BonusObj>();
        for (BonusObj bonusObj : this.getBonusList()) {
            if (this.willIgnore(this.getKeyName())) continue;
            if (pObject instanceof Equipment) {
                if (!bonusObj.passesPreReqToGain((Equipment)pObject, playerCharacter)) continue;
                bonusObj.setApplied(true);
                arrayList.add(bonusObj);
                continue;
            }
            if (!bonusObj.qualifies(playerCharacter)) continue;
            bonusObj.setApplied(true);
            arrayList.add(bonusObj);
        }
        return arrayList;
    }

    public void setArmorType(String string) {
        this.armorType.add(string.toUpperCase().trim());
    }

    public boolean getAssignToAll() {
        return this.assignToAll;
    }

    public void setAssignment(String string) {
        this.assignToAll = string.length() > 0 && string.charAt(0) == 'Y';
    }

    @Override
    public List<BonusObj> getBonusList() {
        ArrayList<BonusObj> arrayList = new ArrayList<BonusObj>(super.getBonusList());
        for (int i = arrayList.size() - 1; i > -1; --i) {
            BonusObj bonusObj = (BonusObj)arrayList.get(i);
            String string = bonusObj.toString();
            int n = string.indexOf("%CHOICE");
            if (n < 0) continue;
            for (int j = this.getAssociatedCount() - 1; j >= 0; --j) {
                BonusObj bonusObj2 = Bonus.newBonus(string.substring(0, n) + this.getAssociated(j) + string.substring(n + 7));
                bonusObj2.setCreatorObject(this);
                if (bonusObj.hasPreReqs()) {
                    bonusObj2.clearPreReq();
                    for (Prerequisite prerequisite : bonusObj.getPreReqList()) {
                        try {
                            bonusObj2.addPreReq(prerequisite.clone());
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {}
                    }
                }
                bonusObj2.expandToken("%CHOICE", this.getAssociated(j));
                arrayList.add(bonusObj2);
            }
            arrayList.remove(bonusObj);
        }
        return arrayList;
    }

    @Override
    public List<BonusObj> getBonusListOfType(String string, String string2) {
        ArrayList<BonusObj> arrayList = new ArrayList<BonusObj>();
        for (BonusObj bonusObj : this.getBonusList()) {
            if (bonusObj.getTypeOfBonus().indexOf(string) < 0 || bonusObj.getBonusInfo().indexOf(string2) < 0 || this.willIgnore(this.getKeyName())) continue;
            arrayList.add(bonusObj);
        }
        return arrayList;
    }

    @Override
    public boolean getBonusListString(String string) {
        for (BonusObj bonusObj : this.getBonusList()) {
            if (!bonusObj.getBonusInfo().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public void setChargeInfo(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
        try {
            this.minCharges = Integer.parseInt(stringTokenizer.nextToken());
            if (this.minCharges < 0) {
                this.minCharges = 0;
            }
            this.maxCharges = this.minCharges;
            if (stringTokenizer.hasMoreTokens()) {
                this.maxCharges = Integer.parseInt(stringTokenizer.nextToken());
            }
            if (this.maxCharges < this.minCharges) {
                this.maxCharges = this.minCharges;
            }
        }
        catch (NumberFormatException numberFormatException) {
            Logging.errorPrint("Invalid CHARGES tag value: " + string);
        }
    }

    public void setCost(String string) {
        this.cost = string;
    }

    public String getCost() {
        return this.cost;
    }

    public void setCostDouble(boolean bl) {
        this.costDouble = bl ? 1 : 0;
    }

    public String getFumbleRange() {
        return this.fumbleRange;
    }

    public void setFumbleRange(String string) {
        this.fumbleRange = string;
    }

    public void setIgnores(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.toUpperCase().trim(), ",");
        this.ignores.clear();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (this.ignores.contains(string2)) continue;
            this.ignores.add(string2);
        }
    }

    public void setItemType(String string) {
        String string2 = string.toUpperCase().trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
        this.itemType.clear();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (this.itemType.contains(string3)) continue;
            this.itemType.add(string3);
        }
    }

    public List<String> getItemType() {
        return this.itemType;
    }

    public boolean isIType(String string) {
        String string2 = string.length() > 0 && string.charAt(0) == '!' ? string.substring(1).toUpperCase() : string.toUpperCase();
        return this.itemType.contains(string2);
    }

    public int getMaxCharges() {
        return this.maxCharges;
    }

    public int getMinCharges() {
        return this.minCharges;
    }

    public void setNamingOption(String string) {
        this.namingOptionText = "";
        if ("NOLIST".equalsIgnoreCase(string)) {
            this.namingOption = 2;
        } else if ("NONAME".equalsIgnoreCase(string)) {
            this.namingOption = 1;
        } else if ("NOTHING".equalsIgnoreCase(string)) {
            this.namingOption = 3;
        } else if ("SPELL".equalsIgnoreCase(string)) {
            this.namingOption = 4;
        } else if (string != null && string.toUpperCase().startsWith("TEXT=")) {
            this.namingOption = 5;
            this.namingOptionText = string.substring(5);
        } else {
            this.namingOption = 0;
        }
    }

    public void setPlus(String string) {
        try {
            this.plus = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public int getPlus() {
        return this.plus;
    }

    public void setPreCost(String string) {
        this.preCost = string;
    }

    public String getPreCost() {
        return this.preCost;
    }

    public void setProficiency(String string) {
        this.proficiency = string;
    }

    public void setReplacement(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.toUpperCase().trim(), ",");
        this.replaces.clear();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (this.replaces.contains(string2)) continue;
            this.replaces.add(string2);
        }
    }

    public void addSpecialProperty(SpecialProperty specialProperty) {
        this.specialPropertyList.add(specialProperty);
    }

    public List<String> getRawSpecialProperties() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SpecialProperty specialProperty : this.specialPropertyList) {
            arrayList.add(specialProperty.getText());
        }
        return arrayList;
    }

    public List<String> getSpecialProperties(Equipment equipment, PlayerCharacter playerCharacter) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.specialPropertyList.size(); ++i) {
            String string = this.specialPropertyList.get(i).getParsedText(playerCharacter, equipment);
            for (int j = 0; j < this.getAssociatedCount(); ++j) {
                string = string.replaceFirst("%CHOICE", this.getAssociated(j));
            }
            if (string == null || string.equals("")) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public void setSpellInfo(PObject pObject, Spell spell, String string, String string2, int n, int n2, Ability[] abilityArray, int n3) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("SPELLNAME[").append(spell.getKeyName()).append("] ");
        stringBuffer.append("CASTER[").append(pObject.getKeyName()).append("] ");
        if (string.length() != 0) {
            stringBuffer.append("VARIANT[").append(string).append("] ");
        }
        stringBuffer.append("SPELLTYPE[").append(string2).append("] ");
        stringBuffer.append("SPELLLEVEL[").append(n).append("] ");
        stringBuffer.append("CASTERLEVEL[").append(n2).append("] ");
        if (n3 > 0) {
            stringBuffer.append(s_CHARGES).append('[').append(n3).append("] ");
        }
        if (abilityArray != null && abilityArray.length > 0) {
            stringBuffer.append("METAFEATS[");
            for (int i = 0; i < abilityArray.length; ++i) {
                Ability ability = abilityArray[i];
                if (i != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(ability.getKeyName());
            }
            stringBuffer.append("] ");
        }
        this.addAssociated(stringBuffer.toString());
    }

    public void setVisible(String string) {
        this.equipmentVisible = string.length() > 0 && string.charAt(0) == 'Y' ? 1 : (string.length() > 0 && string.charAt(0) == 'Q' ? 2 : 0);
    }

    public void addVFeatList(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
        while (stringTokenizer.hasMoreTokens()) {
            if (this.vFeatList == null) {
                this.vFeatList = new ArrayList<String>();
            }
            this.vFeatList.add(stringTokenizer.nextToken());
        }
    }

    public double bonusTo(PlayerCharacter playerCharacter, String string, String string2, Object object) {
        return super.bonusTo(string, string2, object, this.getBonusList(), playerCharacter);
    }

    public void calcBonuses() {
        ArrayList<BonusObj> arrayList = new ArrayList<BonusObj>();
        ArrayList<BonusObj> arrayList2 = new ArrayList<BonusObj>();
        for (BonusObj bonusObj : this.getBonusList()) {
            String string = bonusObj.toString();
            int n = string.indexOf("%CHOICE");
            if (n < 0) continue;
            arrayList2.add(bonusObj);
            for (int i = 0; i < this.getAssociatedCount(); ++i) {
                BonusObj bonusObj2 = Bonus.newBonus(string.substring(0, n) + this.getAssociated(i) + string.substring(n + 7));
                bonusObj2.setCreatorObject(this);
                arrayList.add(bonusObj2);
            }
        }
        if (arrayList2.size() > 0) {
            for (BonusObj bonusObj : arrayList2) {
                this.removeBonusList(bonusObj);
            }
            for (BonusObj bonusObj : arrayList) {
                this.addBonusList(bonusObj);
            }
        }
    }

    @Override
    public EquipmentModifier clone() {
        EquipmentModifier equipmentModifier = null;
        try {
            equipmentModifier = (EquipmentModifier)super.clone();
            equipmentModifier.itemType = new ArrayList<String>(this.itemType);
            equipmentModifier.specialPropertyList = new ArrayList<SpecialProperty>(this.specialPropertyList);
            equipmentModifier.replaces = new ArrayList<String>(this.replaces);
            equipmentModifier.ignores = new ArrayList<String>(this.ignores);
            equipmentModifier.armorType = new ArrayList<String>(this.armorType);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ShowMessageDelegate.showMessageDialog(cloneNotSupportedException.getMessage(), "PCGen", MessageType.ERROR);
        }
        return equipmentModifier;
    }

    public boolean hasVFeats() {
        return this.vFeatList != null && this.vFeatList.size() > 0;
    }

    @Override
    public String toString() {
        return this.getEquipNamePortion();
    }

    public String getEquipNamePortion() {
        if (this.namingOption == 3) {
            return "";
        }
        if (this.namingOption == 5) {
            return this.namingOptionText;
        }
        StringBuffer stringBuffer = new StringBuffer(this.getDisplayName().length());
        if (this.namingOption == 4) {
            for (int i = 0; i < this.getAssociatedCount(); ++i) {
                List<String> list;
                Object object;
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                String string = this.getAssociated(i);
                String string2 = EquipmentModifier.getSpellName(string);
                if (SettingsHandler.guiUsesOutputNameSpells() && (object = Globals.getSpellKeyed(string2)) != null) {
                    string2 = ((PObject)object).getOutputName();
                }
                stringBuffer.append(string2);
                object = EquipmentModifier.getSpellVariant(string);
                if (((String)object).length() != 0) {
                    stringBuffer.append(" (").append((String)object).append(')');
                }
                if (!(list = EquipmentModifier.getSpellMetafeats(string)).isEmpty()) {
                    stringBuffer.append('/').append(CoreUtility.join(list, "/"));
                }
                stringBuffer.append('/').append(EquipmentModifier.getSpellCaster(string));
                stringBuffer.append('/').append(CoreUtility.ordinal(EquipmentModifier.getSpellCasterLevel(string)));
            }
        } else {
            if (this.namingOption != 1) {
                stringBuffer.append(this.getDisplayName());
            }
            if (this.namingOption != 2 && this.getAssociatedCount() > 0) {
                if (this.namingOption != 1) {
                    stringBuffer.append(" (");
                }
                boolean bl = true;
                for (int i = 0; i < this.getAssociatedCount(); ++i) {
                    if (!bl) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(this.getAssociated(i));
                    bl = false;
                }
                if (this.namingOption != 1) {
                    stringBuffer.append(")");
                }
            }
        }
        return stringBuffer.toString().trim().replace('|', ' ');
    }

    @Override
    protected int getSR(PlayerCharacter playerCharacter) {
        if (this.getSRFormula() == null) {
            return 0;
        }
        if ("%CHOICE".equals(this.getSRFormula()) && this.getAssociatedCount() > 0) {
            return Delta.parseInt(this.getAssociatedObject(0).toString());
        }
        return super.getSR(playerCharacter);
    }

    int getChoice(int n, Equipment equipment, boolean bl) {
        String string = this.getChoiceString();
        if (string.length() == 0) {
            return 1;
        }
        boolean bl2 = string.startsWith("EQBUILDER.");
        if (bl && bl2) {
            return 1;
        }
        List<String> list = new ArrayList<String>();
        ChooserInterface chooserInterface = ChooserFactory.getChooserInstance();
        chooserInterface.setPoolFlag(false);
        chooserInterface.setVisible(false);
        this.addAssociatedTo(list);
        EquipmentChoice equipmentChoice = this.buildEquipmentChoice(n, equipment, bl, bl2, list.size());
        if (!equipmentChoice.isBAdd()) {
            chooserInterface.setPool(0);
        } else {
            chooserInterface.setPool(equipmentChoice.getPool());
        }
        chooserInterface.setAllowsDups(equipmentChoice.isAllowDuplicates());
        chooserInterface.setSelectedListTerminator("|");
        chooserInterface.setTitle("Select " + equipmentChoice.getTitle() + " (" + this.getDisplayName() + ")");
        Globals.sortChooserLists(equipmentChoice.getAvailableList(), list);
        chooserInterface.setAvailableList(equipmentChoice.getAvailableList());
        chooserInterface.setSelectedList(list);
        chooserInterface.setVisible(true);
        list = chooserInterface.getSelectedList();
        this.setChoice(list, equipmentChoice);
        return this.getAssociatedCount();
    }

    void setChoice(String string, EquipmentChoice equipmentChoice) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        this.setChoice(arrayList, equipmentChoice);
    }

    void setChoice(List<String> list, EquipmentChoice equipmentChoice) {
        this.clearAssociated();
        for (int i = 0; i < list.size(); ++i) {
            int n;
            String string = list.get(i);
            if (equipmentChoice.getMinValue() < equipmentChoice.getMaxValue() && (n = string.indexOf(124)) < 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int j = equipmentChoice.getMinValue(); j <= equipmentChoice.getMaxValue(); j += equipmentChoice.getIncValue()) {
                    if (j == 0) continue;
                    arrayList.add(Delta.toString(j));
                }
                ChooserInterface chooserInterface = ChooserFactory.getChooserInstance();
                chooserInterface.setPoolFlag(false);
                chooserInterface.setVisible(false);
                chooserInterface.setTitle("Select modifier (" + string + ")");
                chooserInterface.setAvailableList(arrayList);
                chooserInterface.setSelectedList(new ArrayList());
                chooserInterface.setPool(1);
                chooserInterface.setVisible(true);
                if (chooserInterface.getSelectedList().size() == 0) continue;
                string = string + '|' + (String)chooserInterface.getSelectedList().get(0);
            }
            if (!equipmentChoice.isAllowDuplicates() && this.containsAssociated(string)) continue;
            this.addAssociated(string);
        }
    }

    EquipmentChoice buildEquipmentChoice(int n, Equipment equipment, boolean bl, boolean bl2, int n2) {
        EquipmentChoice equipmentChoice = new EquipmentChoice(bl, n);
        String string = this.getChoiceString();
        if (string.length() == 0) {
            return equipmentChoice;
        }
        equipmentChoice.constructFromChoiceString(string, equipment, n, n2, bl2);
        return equipmentChoice;
    }

    private String replaceCostSpellLevel(String string, String string2) {
        String string3 = "";
        while (string.indexOf("%SPELLLEVEL") >= 0) {
            int n = string.indexOf("%SPELLLEVEL");
            if (string3.length() == 0) {
                int n2 = EquipmentModifier.getSpellLevel(string2);
                string3 = n2 == 0 ? "0.5" : Integer.toString(n2);
            }
            string = string.substring(0, n) + string3 + string.substring(n + 11);
        }
        return string;
    }

    private String replaceCostCasterLevel(String string, String string2) {
        String string3 = "";
        while (string.indexOf("%CASTERLEVEL") >= 0) {
            int n = string.indexOf("%CASTERLEVEL");
            if (string3.length() == 0) {
                PCClass pCClass;
                int n2 = EquipmentModifier.getSpellCasterLevel(string2);
                string3 = Integer.toString(n2);
                String string4 = EquipmentModifier.getSpellCaster(string2);
                if (string4.length() != 0 && (pCClass = Globals.getClassKeyed(string4)) != null) {
                    StringBuffer stringBuffer = new StringBuffer(200);
                    String string5 = pCClass.getItemCreationMultiplier();
                    if (string5.length() != 0) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string5, "+-*/()", true);
                        if (stringTokenizer.countTokens() == 1) {
                            stringBuffer.append(n2).append('*').append(string5);
                        } else {
                            while (stringTokenizer.hasMoreTokens()) {
                                string5 = stringTokenizer.nextToken();
                                if (string5.equals("CL")) {
                                    stringBuffer.append(n2);
                                    continue;
                                }
                                stringBuffer.append(string5);
                            }
                        }
                        string3 = stringBuffer.toString();
                    }
                }
            }
            string = string.substring(0, n) + "(" + string3 + ")" + string.substring(n + 12);
        }
        return string;
    }

    private String replaceCostCharges(String string, String string2) {
        String string3 = "";
        while (string.indexOf("%CHARGES") >= 0) {
            int n = string.indexOf("%CHARGES");
            if (string3.length() == 0) {
                string3 = Integer.toString(this.getSpellCharges(string2));
            }
            string = string.substring(0, n) + string3 + string.substring(n + 8);
        }
        return string;
    }

    private String replaceCostSpellCost(String string, String string2) {
        String string3 = "";
        while (string.indexOf("%SPELLCOST") >= 0) {
            String string4;
            Spell spell;
            int n = string.indexOf("%SPELLCOST");
            if (string3.length() == 0 && (spell = Globals.getSpellKeyed(string4 = EquipmentModifier.getSpellName(string2))) != null) {
                string3 = spell.getCost().toString();
            }
            string = string.substring(0, n) + string3 + string.substring(n + 10);
        }
        return string;
    }

    private String replaceCostChoice(String string, String string2) {
        String string3 = "";
        while (string.indexOf("%CHOICE") >= 0) {
            int n = string.indexOf("%CHOICE");
            if (string3.length() == 0) {
                int n2 = string2.lastIndexOf(124);
                int n3 = 0;
                try {
                    n3 = Delta.parseInt(string2.substring(n2 + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                string3 = Integer.toString(n3);
            }
            string = string.substring(0, n) + string3 + string.substring(n + 7);
        }
        return string;
    }

    private String replaceCostSpellXPCost(String string, String string2) {
        String string3 = "";
        while (string.indexOf("%SPELLXPCOST") >= 0) {
            String string4;
            Spell spell;
            int n = string.indexOf("%SPELLXPCOST");
            if (string3.length() == 0 && (spell = Globals.getSpellKeyed(string4 = EquipmentModifier.getSpellName(string2))) != null) {
                string3 = spell.getXPCost() + "";
            }
            string = string.substring(0, n) + string3 + string.substring(n + 12);
        }
        return string;
    }

    protected String getCost(int n) {
        String string = this.getAssociated(n);
        String string2 = this.cost;
        string2 = this.replaceCostSpellLevel(string2, string);
        string2 = this.replaceCostSpellCost(string2, string);
        string2 = this.replaceCostSpellXPCost(string2, string);
        string2 = this.replaceCostCasterLevel(string2, string);
        string2 = this.replaceCostCharges(string2, string);
        string2 = this.replaceCostChoice(string2, string);
        return string2;
    }

    boolean getCostDouble() {
        if (this.costDouble < 0) {
            if (this.isType("MagicalEnhancement") || this.isType("BaseMaterial")) {
                return false;
            }
            if (this.itemType.contains("MAGIC")) {
                return true;
            }
            for (Prerequisite prerequisite : this.getPreReqList()) {
                if (!"TYPE".equalsIgnoreCase(prerequisite.getKind()) || !prerequisite.getKey().equalsIgnoreCase("EQMODTYPE=MagicalEnhancement") && !prerequisite.getKey().equalsIgnoreCase("EQMODTYPE.MagicalEnhancement")) continue;
                return true;
            }
        }
        return this.costDouble == 1;
    }

    String getProficiency() {
        return this.proficiency;
    }

    void setRemainingCharges(int n) {
        String string;
        String string2;
        if (this.getAssociatedCount() > 0 && (string2 = EquipmentModifier.getSpellInfoString(string = this.getAssociated(0), s_CHARGES)).length() != 0) {
            string2 = "CHARGES[" + string2 + ']';
            int n2 = string.indexOf(string2);
            string = string.substring(0, n2) + string.substring(n2 + string2.length());
            string = string + "CHARGES[" + Integer.toString(n) + ']';
            this.setAssociated(0, string);
        }
    }

    int getRemainingCharges() {
        if (this.getAssociatedCount() > 0) {
            return this.getSpellCharges(this.getAssociated(0));
        }
        return 0;
    }

    int getUsedCharges() {
        return this.maxCharges - this.getRemainingCharges();
    }

    List<String> getVFeatList() {
        String string;
        if (this.vFeatList != null && ((string = this.getChoiceString()).startsWith("FEAT") || string.indexOf("|FEAT") >= 0)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string2 : this.vFeatList) {
                if (string2.equals("%CHOICE")) {
                    for (int i = 0; i < this.getAssociatedCount(); ++i) {
                        arrayList.add(this.getAssociated(i));
                    }
                    continue;
                }
                arrayList.add(string2);
            }
            return arrayList;
        }
        return this.vFeatList;
    }

    int getVisible() {
        return this.equipmentVisible;
    }

    String replaceArmorType(List<String> list) {
        for (int i = 0; i < this.armorType.size(); ++i) {
            int n;
            StringTokenizer stringTokenizer = new StringTokenizer(this.armorType.get(i), "|");
            if (!stringTokenizer.hasMoreTokens() || (n = list.indexOf(stringTokenizer.nextToken())) < 0) continue;
            if (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                list.set(n, string);
                return string;
            }
            list.remove(n);
        }
        return null;
    }

    boolean willIgnore(String string) {
        return this.ignores.contains(string.toUpperCase().trim());
    }

    boolean willReplace(String string) {
        return this.replaces.contains(string.toUpperCase().trim());
    }

    private static String getSpellCaster(String string) {
        return EquipmentModifier.getSpellInfoString(string, "CASTER");
    }

    private static int getSpellCasterLevel(String string) {
        return EquipmentModifier.getSpellInfo(string, "CASTERLEVEL");
    }

    private static int getSpellInfo(String string, String string2) {
        int n = 0;
        String string3 = EquipmentModifier.getSpellInfoString(string, string2);
        if (string3.length() > 0) {
            try {
                n = Delta.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    private static String getSpellInfoString(String string, String string2) {
        int n = string.indexOf(string2 + "[");
        int n2 = string.indexOf(93, n + 1);
        if (n >= 0 && n2 > n) {
            return string.substring(n + string2.length() + 1, n2);
        }
        return "";
    }

    private static int getSpellLevel(String string) {
        return EquipmentModifier.getSpellInfo(string, "SPELLLEVEL");
    }

    private int getSpellCharges(String string) {
        return EquipmentModifier.getSpellInfo(string, s_CHARGES);
    }

    private static List<String> getSpellMetafeats(String string) {
        String string2 = EquipmentModifier.getSpellInfoString(string, "METAFEATS");
        return CoreUtility.split(string2, ',');
    }

    private static String getSpellName(String string) {
        return EquipmentModifier.getSpellInfoString(string, "SPELLNAME");
    }

    private static String getSpellVariant(String string) {
        return EquipmentModifier.getSpellInfoString(string, "VARIANT");
    }

    public BigDecimal addItemCosts(PlayerCharacter playerCharacter, String string, int n, Equipment equipment) {
        double d = 0.0;
        HashSet<String> hashSet = new HashSet<String>();
        for (BonusObj object : this.getBonusList()) {
            String string2;
            boolean bl = true;
            if (!object.getBonusName().equals(string)) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(object.toString().substring(string.length()), "|", false);
            String string3 = stringTokenizer.nextToken();
            stringTokenizer = new StringTokenizer(string3.substring(5), ".", false);
            String string4 = "TYPE";
            while (stringTokenizer.hasMoreTokens() && (bl = equipment.isType(string2 = stringTokenizer.nextToken()))) {
                string4 = string4 + "." + string2;
            }
            if (!bl) continue;
            hashSet.add(string4);
        }
        for (String string5 : hashSet) {
            d += this.bonusTo(playerCharacter, string, string5, equipment);
        }
        return new BigDecimal(d * (double)n);
    }

    public void setFormatCat(int n) {
        this.integerChar.put(IntegerKey.FORMAT_CAT, n);
    }

    public int getFormatCat() {
        Integer n = (Integer)this.integerChar.get(IntegerKey.FORMAT_CAT);
        return n == null ? 2 : n;
    }

    @Override
    public int compareTo(Object object) {
        if (object instanceof EquipmentModifier) {
            return this.getKeyName().compareTo(((PObject)object).getKeyName());
        }
        return this.getKeyName().compareTo(object.toString());
    }
}

