/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.io.BufferedWriter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pcgen.core.Ability;
import pcgen.core.EquipmentChoice;
import pcgen.core.EquipmentCollection;
import pcgen.core.EquipmentList;
import pcgen.core.EquipmentModifier;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.PrereqObject;
import pcgen.core.SettingsHandler;
import pcgen.core.SizeAdjustment;
import pcgen.core.SpecialProperty;
import pcgen.core.VariableContainer;
import pcgen.core.VariableProcessorEq;
import pcgen.core.WeaponEquipment;
import pcgen.core.WeaponProf;
import pcgen.core.bonus.BonusObj;
import pcgen.core.character.WieldCategory;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.IntegerKey;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.core.utils.StringKey;
import pcgen.io.FileAccess;
import pcgen.util.BigDecimalHelper;
import pcgen.util.Delta;
import pcgen.util.JEPResourceChecker;
import pcgen.util.Logging;
import pcgen.util.PJEP;
import pcgen.util.PjepPool;
import pcgen.util.PropertyFactory;
import pcgen.util.enumeration.Load;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Equipment
extends PObject
implements Serializable,
EquipmentCollection,
Comparable<Object>,
VariableContainer {
    private static final long serialVersionUID = 1L;
    private static final String EQMOD_WEIGHT = "_WEIGHTADD";
    private static final String EQMOD_DAMAGE = "_DAMAGE";
    public static final int EQUIPPED_NEITHER = 0;
    public static final String EQUIPPED_NEITHER_STR = PropertyFactory.getString("EquipLocation.Neither");
    public static final int EQUIPPED_PRIMARY = 1;
    public static final String EQUIPPED_PRIMARY_STR = PropertyFactory.getString("EquipLocation.Primary");
    public static final int EQUIPPED_SECONDARY = 2;
    public static final String EQUIPPED_SECONDARY_STR = PropertyFactory.getString("EquipLocation.Secondary");
    public static final int EQUIPPED_BOTH = 3;
    public static final String EQUIPPED_BOTH_STR = PropertyFactory.getString("EquipLocation.Both");
    public static final int EQUIPPED_TWO_HANDS = 4;
    public static final String EQUIPPED_TWO_HANDS_STR = PropertyFactory.getString("EquipLocation.TwoHands");
    public static final int EQUIPPED_TEMPBONUS = 5;
    public static final String EQUIPPED_TEMPBONUS_STR = PropertyFactory.getString("EquipLocation.TempBonus");
    public static final int CARRIED_NEITHER = 6;
    public static final String CARRIED_NEITHER_STR = PropertyFactory.getString("EquipLocation.Carried");
    public static final int CONTAINED = 7;
    public static final String CONTAINED_STR = PropertyFactory.getString("EquipLocation.Contained");
    public static final int NOT_CARRIED = 8;
    public static final String NOT_CARRIED_STR = PropertyFactory.getString("EquipLocation.NotCarried");
    private static final String[] locationStringList = new String[9];
    private static final SortedSet<String> s_equipmentTypes = new TreeSet<String>();
    private BigDecimal baseCost = BigDecimal.ZERO;
    private BigDecimal cost = BigDecimal.ZERO;
    private BigDecimal costMod = BigDecimal.ZERO;
    private BigDecimal weightMod = BigDecimal.ZERO;
    private String baseItem = "";
    private List<EquipmentModifier> eqModifierList = new ArrayList<EquipmentModifier>();
    private List<SpecialProperty> specialPropertyList = new ArrayList<SpecialProperty>();
    private List<String> vFeatList = null;
    private boolean modifiersAllowed = true;
    private boolean modifiersRequired = false;
    private EquipmentCollection d_parent = null;
    private List<Equipment> d_containedEquipment = null;
    private Float carried = Float.valueOf(0.0f);
    private int location = 8;
    private boolean equipped = false;
    private int numberEquipped = 0;
    private Float containerWeightCapacity = Float.valueOf(0.0f);
    private Integer containerReduceWeight = 0;
    private boolean containerConstantWeight = false;
    private boolean d_acceptsChildren = false;
    private Integer acCheck = 0;
    private String fumbleRange = "";
    private Integer eDR = -1;
    private Integer maxDex = 100;
    private Integer spellFailure = 0;
    private WeaponEquipment theWeaponStats = null;
    private boolean isOnlyNaturalWeapon = false;
    private Map<String, Float> d_acceptsTypes = null;
    private Map<String, Float> d_childTypes = null;
    private String containerCapacityString = "";
    private String containerContentsString = "";
    private Map<String, String> qualityMap = new HashMap<String, String>();
    private List<EquipmentModifier> altEqModifierList = new ArrayList<EquipmentModifier>();
    private List<String> altTypeList = null;
    private String appliedBonusName = "";
    private String bonusType = null;
    private String indexedUnderType = "";
    private String longName = "";
    private String wholeItemName = "";
    private String modifiedName = "";
    private String moveString = "";
    private String noteString = "";
    private String profName = "";
    private String size = "";
    private String sizeBase = "";
    private boolean automatic = false;
    private boolean bonusPrimary = true;
    private boolean calculatingCost = false;
    private boolean weightAlreadyUsed = false;
    private double qty = 0.0;
    private double weightInPounds = 0.0;
    private int outputIndex = 0;
    private int outputSubindex = 0;
    private int slots = 1;
    private int baseQuantity = 1;
    private List<String> typeListCachePrimary = null;
    private List<String> typeListCacheSecondary = null;
    private boolean dirty;
    private String cachedNameWithoutCharges;
    private String cachedNameWithCharges;
    private boolean virtualItem = false;

    public Equipment() {
        SizeAdjustment sizeAdjustment = SettingsHandler.getGame().getDefaultSizeAdjustment();
        if (sizeAdjustment != null) {
            this.size = sizeAdjustment.getAbbreviation();
        }
    }

    public void setAppliedName(String string) {
        this.appliedBonusName = string;
    }

    public String getAppliedName() {
        if (this.appliedBonusName.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(" [").append(this.appliedBonusName).append("]");
            return stringBuffer.toString();
        }
        return "";
    }

    public boolean isAmmunition() {
        return this.isType("AMMUNITION");
    }

    public boolean isArmor() {
        return this.isType("ARMOR");
    }

    public boolean isDouble() {
        return this.isType("DOUBLE");
    }

    public boolean isEitherType(String string) {
        return this.isType(string, true) || this.isType(string, false);
    }

    public boolean isExtra() {
        return this.isType("EXTRA");
    }

    public boolean isHeavy() {
        return this.isType("HEAVY");
    }

    public boolean isMedium() {
        return this.isType("MEDIUM");
    }

    public boolean isLight() {
        return this.isType("LIGHT");
    }

    public boolean isMagic() {
        return this.isType("MAGIC");
    }

    public boolean isMelee() {
        return this.isType("MELEE");
    }

    public boolean isMonk() {
        return this.isType("MONK");
    }

    public boolean isNatural() {
        return this.isType("NATURAL");
    }

    public boolean isRanged() {
        return this.isType("RANGED");
    }

    public boolean isShield() {
        return this.isType("SHIELD");
    }

    public boolean isSuit() {
        return this.isType("SUIT");
    }

    public boolean isThrown() {
        return this.isType("THROWN");
    }

    @Override
    public String getType() {
        return this.getType(true);
    }

    @Override
    public boolean isType(String string) {
        return this.isType(string, true);
    }

    public boolean isType(String string, boolean bl) {
        if (!bl && !this.isDouble()) {
            return false;
        }
        List<String> list = this.typeList(bl);
        return list.contains(string.toUpperCase());
    }

    public boolean isUnarmed() {
        return this.isType("UNARMED");
    }

    public boolean isWeapon() {
        return this.isType("WEAPON");
    }

    boolean isMasterwork() {
        return this.isType("MASTERWORK");
    }

    public boolean typeStringContains(String string) {
        return this.isType(string);
    }

    public boolean isProjectile() {
        return this.isRanged() && !this.isThrown();
    }

    @Override
    boolean isTypeHidden(String string) {
        return Globals.isEquipmentTypeHidden(string);
    }

    protected List<String> getMyTypeList() {
        return this.typeList();
    }

    public static SortedSet<String> getEquipmentTypes() {
        return s_equipmentTypes;
    }

    @Override
    public List<BonusObj> getActiveBonuses(PlayerCharacter playerCharacter) {
        ArrayList<BonusObj> arrayList = new ArrayList<BonusObj>();
        for (BonusObj object2 : this.getBonusList()) {
            if (!object2.isApplied()) continue;
            arrayList.add(object2);
        }
        List<EquipmentModifier> list = this.getEqModifierList(true);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EquipmentModifier equipmentModifier = (EquipmentModifier)iterator.next();
            arrayList.addAll(equipmentModifier.getActiveBonuses(this, playerCharacter));
        }
        return arrayList;
    }

    public List<BonusObj> getBonusListOfType(String string, String string2, boolean bl) {
        ArrayList<BonusObj> arrayList = new ArrayList<BonusObj>();
        for (BonusObj object : this.getBonusList()) {
            if (object.getTypeOfBonus().indexOf(string) < 0 || object.getBonusInfo().indexOf(string2) < 0) continue;
            arrayList.add(object);
        }
        List<EquipmentModifier> list = this.getEqModifierList(bl);
        if (!list.isEmpty()) {
            for (EquipmentModifier equipmentModifier : list) {
                arrayList.addAll(equipmentModifier.getBonusListOfType(string, string2));
            }
        }
        return arrayList;
    }

    public void setACCheck(String string) {
        try {
            this.acCheck = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.acCheck = 0;
        }
    }

    public Integer getAcCheck() {
        return this.acCheck;
    }

    public String getFumbleRange() {
        for (EquipmentModifier equipmentModifier : this.getEqModifierList(true)) {
            if (equipmentModifier.getFumbleRange().length() <= 0) continue;
            return equipmentModifier.getFumbleRange();
        }
        for (EquipmentModifier equipmentModifier : this.getEqModifierList(false)) {
            if (equipmentModifier.getFumbleRange().length() <= 0) continue;
            return equipmentModifier.getFumbleRange();
        }
        return this.fumbleRange;
    }

    public void setFumbleRange(String string) {
        this.fumbleRange = string;
    }

    public boolean isAutomatic() {
        return this.automatic;
    }

    public void setAutomatic(boolean bl) {
        this.automatic = bl;
    }

    public void setBaseItem(String string) {
        this.baseItem = string;
    }

    public String getBaseItemName() {
        if (this.baseItem.length() == 0) {
            return this.getKeyName();
        }
        return this.baseItem;
    }

    public void setCost(String string) {
        this.setCost(string, false);
    }

    public void setCost(String string, boolean bl) {
        try {
            this.cost = new BigDecimal(string);
            if (bl) {
                this.baseCost = this.cost;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public BigDecimal getCost(PlayerCharacter playerCharacter) {
        Object object;
        Object object2;
        int n;
        BigDecimal bigDecimal;
        int n2;
        BigDecimal bigDecimal2 = BigDecimal.ZERO;
        if (this.isVirtual()) {
            return bigDecimal2;
        }
        for (EquipmentModifier cloneable2 : this.eqModifierList) {
            n2 = cloneable2.getAssociatedCount();
            if (n2 < 1) {
                n2 = 1;
            }
            bigDecimal = new BigDecimal(this.getVariableValue(cloneable2.getPreCost(), "", true, playerCharacter).toString());
            bigDecimal2 = bigDecimal2.add(bigDecimal.multiply(new BigDecimal(Integer.toString(this.getBaseQty() * n2))));
            bigDecimal2 = bigDecimal2.add(cloneable2.addItemCosts(playerCharacter, "ITEMCOST", this.getBaseQty() * n2, this));
        }
        for (EquipmentModifier equipmentModifier : this.altEqModifierList) {
            n2 = equipmentModifier.getAssociatedCount();
            if (n2 < 1) {
                n2 = 1;
            }
            bigDecimal = new BigDecimal(this.getVariableValue(equipmentModifier.getPreCost(), "", false, playerCharacter).toString());
            bigDecimal2 = bigDecimal2.add(bigDecimal.multiply(new BigDecimal(Integer.toString(this.getBaseQty() * n2))));
            bigDecimal2 = bigDecimal2.add(equipmentModifier.addItemCosts(playerCharacter, "ITEMCOST", n2, this));
        }
        BigDecimal bigDecimal3 = this.cost.add(bigDecimal2);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        BigDecimal bigDecimal4 = BigDecimal.ZERO;
        bigDecimal2 = BigDecimal.ZERO;
        int n3 = 0;
        int n4 = 0;
        this.calculatingCost = true;
        this.weightAlreadyUsed = false;
        for (EquipmentModifier equipmentModifier : this.eqModifierList) {
            Matcher matcher;
            n = equipmentModifier.getAssociatedCount();
            if (n < 1) {
                n = 1;
            }
            object2 = equipmentModifier.getCost();
            Pattern pattern = Pattern.compile("BASECOST");
            if (equipmentModifier.getAssociatedCount() > 0 && !((String)object2).equals(equipmentModifier.getCost(0))) {
                object = BigDecimal.ZERO;
                for (int i = 0; i < equipmentModifier.getAssociatedCount(); ++i) {
                    matcher = pattern.matcher(equipmentModifier.getCost(i));
                    object2 = matcher.replaceAll("(BASECOST/" + this.getBaseQty() + ")");
                    BigDecimal bigDecimal5 = new BigDecimal(this.getVariableValue((String)object2, "", true, playerCharacter).toString());
                    object = ((BigDecimal)object).add(bigDecimal5);
                    if (!equipmentModifier.getCostDouble()) {
                        bigDecimal4 = bigDecimal4.add(bigDecimal5);
                        continue;
                    }
                    arrayList.add(bigDecimal5);
                }
                n = 1;
            } else {
                matcher = pattern.matcher(equipmentModifier.getCost());
                object2 = matcher.replaceAll("(BASECOST/" + this.getBaseQty() + ")");
                object = new BigDecimal(this.getVariableValue((String)object2, "", true, playerCharacter).toString());
                if (!equipmentModifier.getCostDouble()) {
                    bigDecimal4 = bigDecimal4.add((BigDecimal)object);
                } else {
                    arrayList.add(object);
                }
            }
            if (equipmentModifier.isType("BaseMaterial")) {
                object = ((BigDecimal)object).multiply(new BigDecimal(this.getBaseQty()));
            }
            bigDecimal2 = bigDecimal2.add((BigDecimal)object);
            n3 += equipmentModifier.getPlus() * n;
        }
        if (arrayList.size() > 1) {
            Collections.sort(arrayList);
        }
        for (EquipmentModifier equipmentModifier : this.altEqModifierList) {
            n = equipmentModifier.getAssociatedCount();
            if (n < 1) {
                n = 1;
            }
            object = equipmentModifier.getCost();
            object2 = new BigDecimal(this.getVariableValue((String)object, "", false, playerCharacter).toString());
            bigDecimal2 = bigDecimal2.add(((BigDecimal)object2).multiply(new BigDecimal(Integer.toString(this.getBaseQty() * n))));
            n4 += equipmentModifier.getPlus() * n;
        }
        this.calculatingCost = false;
        bigDecimal2 = bigDecimal2.add(this.getCostFromPluses(n3, n4));
        if (!(this.isAmmunition() || this.isArmor() || this.isShield() || this.isWeapon())) {
            if (!this.isMagicLimitedType()) {
                if (!this.ignoresCostDouble()) {
                    bigDecimal2 = bigDecimal2.subtract(bigDecimal4).multiply(new BigDecimal("2"));
                    bigDecimal2 = bigDecimal2.add(bigDecimal4);
                }
            } else {
                for (int i = arrayList.size() - 2; i >= 0; --i) {
                    bigDecimal2 = bigDecimal2.add((BigDecimal)arrayList.get(i));
                }
            }
        }
        return bigDecimal2.add(bigDecimal3).add(this.costMod);
    }

    public void setCostMod(String string) {
        try {
            this.costMod = new BigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.costMod = BigDecimal.ZERO;
        }
    }

    public void setCostMod(BigDecimal bigDecimal) {
        this.costMod = bigDecimal;
    }

    public BigDecimal getCostMod() {
        return this.costMod;
    }

    public EquipmentModifier getEqModifierKeyed(String string, boolean bl) {
        List<EquipmentModifier> list = this.getEqModifierList(bl);
        for (EquipmentModifier equipmentModifier : list) {
            if (!equipmentModifier.getKeyName().equals(string)) continue;
            return equipmentModifier;
        }
        return null;
    }

    public List<EquipmentModifier> getEqModifierList(boolean bl) {
        if (bl) {
            return this.eqModifierList;
        }
        return this.altEqModifierList;
    }

    public void addToEqModifierList(EquipmentModifier equipmentModifier, boolean bl) {
        this.typeListCachePrimary = null;
        this.getEqModifierList(bl).add(equipmentModifier);
        this.setDirty(true);
    }

    public void setHands(int n) {
        this.slots = n;
    }

    public int getHands(PlayerCharacter playerCharacter) {
        return this.getSlots(playerCharacter);
    }

    public static String getLocationName(int n) {
        if (n < 0 || n > locationStringList.length) {
            return locationStringList[0];
        }
        return locationStringList[n];
    }

    public static int getLocationNum(String string) {
        for (int i = 0; i < locationStringList.length; ++i) {
            if (!locationStringList[i].equals(string)) continue;
            return i;
        }
        if (string.equals("None")) {
            return 8;
        }
        if (string.startsWith(CONTAINED_STR)) {
            return 7;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 7;
        }
    }

    public String getInterestingDisplayString(PlayerCharacter playerCharacter) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getSpecialProperties(playerCharacter);
        if (string == null) {
            string = "";
        }
        for (BonusObj bonusObj : this.getActiveBonuses(playerCharacter)) {
            String string2 = bonusObj.toString();
            if (string2.length() <= 0 || string2.startsWith("EQM")) continue;
            if (stringBuffer.length() != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string2);
        }
        if (string.length() != 0) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append('|');
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public void setIsEquipped(boolean bl, PlayerCharacter playerCharacter) {
        this.equipped = bl;
        if (this.equipped) {
            this.activateBonuses(playerCharacter);
        } else {
            this.deactivateBonuses();
        }
    }

    public String getItemNameFromModifiers() {
        String string;
        int n;
        ArrayList<EquipmentModifier> arrayList = new ArrayList<EquipmentModifier>(this.eqModifierList);
        ArrayList<EquipmentModifier> arrayList2 = new ArrayList<EquipmentModifier>(this.altEqModifierList);
        ArrayList<EquipmentModifier> arrayList3 = new ArrayList<EquipmentModifier>();
        List<EquipmentModifier>[] listArray = this.initSplitModList();
        List<EquipmentModifier>[] listArray2 = this.initSplitModList();
        List<EquipmentModifier>[] listArray3 = this.initSplitModList();
        if (this.baseItem.length() == 0) {
            return this.getName();
        }
        Equipment equipment = EquipmentList.getEquipmentKeyed(this.baseItem);
        if (equipment != null) {
            int n2;
            for (EquipmentModifier object2 : equipment.getEqModifierList(true)) {
                n2 = arrayList.indexOf(object2);
                if (n2 < 0) continue;
                arrayList.remove(n2);
            }
            for (EquipmentModifier equipmentModifier : equipment.getEqModifierList(false)) {
                n2 = arrayList2.indexOf(equipmentModifier);
                if (n2 < 0) continue;
                arrayList2.remove(n2);
            }
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            EquipmentModifier equipmentModifier = (EquipmentModifier)arrayList.get(i);
            if (equipmentModifier.getVisible() != 0) continue;
            arrayList.remove(i);
        }
        Equipment.extractListFromCommon(arrayList3, arrayList);
        this.removeCommonFromList(arrayList2, arrayList3, "eqMod expected but not found: ");
        this.suppressMasterwork(arrayList3, arrayList, arrayList2);
        this.splitModListByFormatCat(arrayList3, listArray3);
        this.splitModListByFormatCat(arrayList, listArray);
        this.splitModListByFormatCat(arrayList2, listArray2);
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = this.buildEqModDesc(listArray3[0], listArray[0], listArray2[0]);
        stringBuffer.append(string2);
        if (stringBuffer.length() > 0) {
            stringBuffer.append(' ');
        }
        if ((n = (string = this.getBaseItemName().trim()).indexOf(40)) >= 0) {
            stringBuffer.append(string.substring(0, n - 1).trim());
        } else {
            stringBuffer.append(string);
        }
        String string3 = this.buildEqModDesc(listArray3[1], listArray[1], listArray2[1]);
        if (string3.length() > 0) {
            stringBuffer.append(' ').append(string3);
        }
        if (n >= 0) {
            stringBuffer.append(' ');
            stringBuffer.append(string.substring(n));
        }
        if ((n = stringBuffer.toString().lastIndexOf(41)) >= 0) {
            stringBuffer.setLength(n);
            stringBuffer.append('/');
        } else {
            stringBuffer.append(" (");
        }
        int n3 = Globals.sizeInt(this.getSize(), 4);
        if (Globals.sizeInt(this.getBaseSize(), 4) != n3) {
            stringBuffer.append(SettingsHandler.getGame().getSizeAdjustmentAtIndex(n3).getDisplayName());
            stringBuffer.append('/');
        }
        String string4 = this.buildEqModDesc(listArray3[2], listArray[2], listArray2[2]);
        stringBuffer.append(string4);
        if (stringBuffer.toString().endsWith("/") || stringBuffer.toString().endsWith(";")) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        stringBuffer.append(')');
        n = stringBuffer.toString().indexOf(" ()");
        if (n >= 0) {
            stringBuffer.setLength(n);
        }
        return stringBuffer.toString();
    }

    private void suppressMasterwork(List<EquipmentModifier> list, List<EquipmentModifier> list2, List<EquipmentModifier> list3) {
        EquipmentModifier equipmentModifier3;
        EquipmentModifier equipmentModifier2 = null;
        for (EquipmentModifier equipmentModifier3 : list) {
            if (!"MASTERWORK".equalsIgnoreCase(equipmentModifier3.getDisplayName()) && !equipmentModifier3.isIType("Masterwork")) continue;
            equipmentModifier2 = equipmentModifier3;
            break;
        }
        if (equipmentModifier2 == null) {
            return;
        }
        EquipmentModifier equipmentModifier4 = Equipment.getMagicBonus(this.eqModifierList);
        equipmentModifier3 = null;
        if (this.isDouble()) {
            equipmentModifier3 = Equipment.getMagicBonus(this.altEqModifierList);
        }
        if (equipmentModifier4 != null || equipmentModifier3 != null) {
            list.remove(equipmentModifier2);
        }
    }

    private String buildEqModDesc(List<EquipmentModifier> list, List<EquipmentModifier> list2, List<EquipmentModifier> list3) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Equipment.getNameFromModifiers(list);
        String string2 = Equipment.getNameFromModifiers(list2);
        String string3 = Equipment.getNameFromModifiers(list3);
        if (list2.isEmpty() && list3.isEmpty()) {
            stringBuffer.append(string);
        } else if (!this.isDouble()) {
            stringBuffer.append(string2);
            if (!list2.isEmpty() && !list.isEmpty()) {
                stringBuffer.append('/');
            }
            stringBuffer.append(string);
        } else {
            if (string.length() != 0) {
                stringBuffer.append(string).append(';');
            }
            if (string2.length() != 0) {
                stringBuffer.append(string2);
            } else {
                stringBuffer.append('-');
            }
            stringBuffer.append(';');
            if (string3.length() != 0) {
                stringBuffer.append(string3);
            } else {
                stringBuffer.append('-');
            }
        }
        return stringBuffer.toString();
    }

    public void setLocation(int n) {
        if (n < 0 || n > 8) {
            String string = PropertyFactory.getFormattedString("EquipLocation.Unknown", n);
            ShowMessageDelegate.showMessageDialog(string, "PCGen", MessageType.INFORMATION);
            return;
        }
        if (n == 5) {
            this.location = n;
            this.equipped = true;
        } else if (n >= 0 && n <= 4) {
            this.location = n;
            this.equipped = true;
        } else if (n == 8) {
            this.location = 8;
            this.equipped = false;
        } else {
            this.location = 6;
            this.equipped = false;
        }
    }

    public int getLocation() {
        return this.location;
    }

    public void setLongName(String string) {
        this.longName = string;
    }

    public int getMaxCharges() {
        for (EquipmentModifier equipmentModifier : this.getEqModifierList(true)) {
            int n = equipmentModifier.getMaxCharges();
            if (n <= 0) continue;
            return n;
        }
        return 0;
    }

    public void setMaxDex(String string) {
        try {
            this.maxDex = Delta.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public Integer getMaxDex(PlayerCharacter playerCharacter) {
        int n = this.maxDex + (int)this.bonusTo(playerCharacter, "EQMARMOR", "MAXDEX", true);
        if (n > 100) {
            n = 100;
        }
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    public int getMinCharges() {
        for (EquipmentModifier equipmentModifier : this.getEqModifierList(true)) {
            int n = equipmentModifier.getMinCharges();
            if (n <= 0) continue;
            return n;
        }
        return 0;
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        this.setDirty(true);
    }

    public void setModifiedName(String string) {
        this.modifiedName = string;
        this.setDirty(true);
    }

    public void setModifiersAllowed(boolean bl) {
        this.modifiersAllowed = bl;
    }

    public void setModifiersRequired(boolean bl) {
        this.modifiersRequired = bl;
    }

    public boolean getModifiersRequired() {
        return this.modifiersRequired;
    }

    public void setMoveString(String string) {
        this.moveString = string;
    }

    @Override
    public String getName() {
        return this.toString();
    }

    public void setNote(String string) {
        this.noteString = string;
    }

    public String getNote() {
        return this.noteString;
    }

    public void setNumberCarried(Float f) {
        this.carried = f;
    }

    public void setNumberEquipped(int n) {
        this.numberEquipped = n;
        if (n > 0) {
            this.equipped = true;
        }
    }

    public int getNumberEquipped() {
        return this.numberEquipped;
    }

    public void setOnlyNaturalWeapon(boolean bl) {
        this.isOnlyNaturalWeapon = bl;
    }

    public boolean isOnlyNaturalWeapon() {
        return this.isOnlyNaturalWeapon;
    }

    public void setOutputIndex(int n) {
        this.outputIndex = n;
    }

    public int getOutputIndex() {
        return this.outputIndex;
    }

    public void setOutputSubindex(int n) {
        this.outputSubindex = n;
    }

    public int getOutputSubindex() {
        return this.outputSubindex;
    }

    @Override
    public void setParent(EquipmentCollection equipmentCollection) {
        this.d_parent = equipmentCollection;
    }

    @Override
    public EquipmentCollection getParent() {
        return this.d_parent;
    }

    public String getParentName() {
        Equipment equipment = (Equipment)this.getParent();
        if (equipment != null) {
            return equipment.toString();
        }
        if (this.isEquipped()) {
            return "Equipped";
        }
        if (this.numberCarried().intValue() > 0) {
            return "Carried";
        }
        return "";
    }

    public boolean isPreType(String string) {
        if (string.startsWith(".IF.TYPE=")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(9), ".");
            boolean bl = false;
            String string2 = "";
            int n = string.indexOf(".THEN.");
            if (n < 0) {
                return false;
            }
            String string3 = string.substring(n + 6);
            string = string.substring(0, n);
            n = string3.indexOf(".ELSE.");
            if (n >= 0) {
                string2 = string3.substring(n + 6);
                string3 = string3.substring(0, n);
            }
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (!this.isType(string4, this.bonusPrimary)) continue;
                bl = true;
                break;
            }
            if ((string = bl ? string3 : string2).length() == 0) {
                return true;
            }
        }
        if (string.startsWith("EQMODTYPE=") || string.startsWith("EQMODTYPE.")) {
            string = string.substring(10);
            for (EquipmentModifier equipmentModifier : this.getEqModifierList(this.bonusPrimary)) {
                if (!equipmentModifier.isType(string)) continue;
                return true;
            }
            return false;
        }
        if (string.startsWith("EQMOD=") || string.startsWith("EQMOD.")) {
            return this.getEqModifierKeyed(string = string.substring(6), this.bonusPrimary) != null;
        }
        return this.isType(string, this.bonusPrimary);
    }

    public void setProfName(String string) {
        this.profName = string;
    }

    public String getProfName() {
        return this.profName;
    }

    public void setQty(String string) {
        try {
            this.setQty(Double.parseDouble(string));
        }
        catch (NumberFormatException numberFormatException) {
            this.qty = 0.0;
        }
    }

    public void setQty(Float f) {
        this.setQty(f.doubleValue());
    }

    public Float getQty() {
        return new Float(this.qty);
    }

    public void setRange(String string) {
        if (this.theWeaponStats == null) {
            this.theWeaponStats = new WeaponEquipment(this);
        }
        this.theWeaponStats.setRange(string);
    }

    public Integer getRange(PlayerCharacter playerCharacter) {
        if (this.theWeaponStats != null) {
            return this.theWeaponStats.getRange(playerCharacter);
        }
        return 0;
    }

    public void setRateOfFire(String string) {
        if (this.theWeaponStats == null) {
            this.theWeaponStats = new WeaponEquipment(this);
        }
        this.theWeaponStats.setRateOfFire(string);
    }

    public String getRateOfFire() {
        if (this.theWeaponStats != null) {
            return this.theWeaponStats.getRateOfFire();
        }
        return "";
    }

    public int getRawCritRange() {
        return this.getRawCritRange(true);
    }

    public int getRawCritRange(boolean bl) {
        if (this.theWeaponStats != null) {
            return this.theWeaponStats.getRawCritRange(bl);
        }
        return 0;
    }

    public String getRawSpecialProperties() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (int i = 0; i < this.specialPropertyList.size(); ++i) {
            SpecialProperty specialProperty = this.specialPropertyList.get(i);
            if (!bl) {
                stringBuffer.append(", ");
            }
            bl = false;
            stringBuffer.append(specialProperty.getParsedText());
        }
        return stringBuffer.toString();
    }

    public void setReach(int n) {
        if (this.theWeaponStats == null) {
            this.theWeaponStats = new WeaponEquipment(this);
        }
        this.theWeaponStats.setReach(n);
    }

    public int getReach() {
        if (this.theWeaponStats != null) {
            return this.theWeaponStats.getReach();
        }
        return 0;
    }

    public void setReachMult(int n) {
        if (this.theWeaponStats == null) {
            this.theWeaponStats = new WeaponEquipment(this);
        }
        this.theWeaponStats.setReachMult(n);
    }

    public int getReachMult() {
        if (this.theWeaponStats != null) {
            return this.theWeaponStats.getReachMult();
        }
        return 0;
    }

    public void setRemainingCharges(int n) {
        for (EquipmentModifier equipmentModifier : this.getEqModifierList(true)) {
            if (equipmentModifier.getMinCharges() <= 0) continue;
            equipmentModifier.setRemainingCharges(n);
        }
    }

    public int getRemainingCharges() {
        for (EquipmentModifier equipmentModifier : this.getEqModifierList(true)) {
            if (equipmentModifier.getMinCharges() <= 0) continue;
            return equipmentModifier.getRemainingCharges();
        }
        return -1;
    }

    public String getSimpleName() {
        return this.displayName;
    }

    public void setSize(String string, boolean bl) {
        if (string.length() > 1) {
            string = string.toUpperCase().substring(0, 1);
        }
        this.size = string;
        if (bl) {
            this.sizeBase = string;
        }
    }

    public String getSize() {
        return this.size;
    }

    public void setSlots(int n) {
        this.slots = n;
    }

    public int getSlots(PlayerCharacter playerCharacter) {
        int n = this.slots;
        for (EquipmentModifier equipmentModifier : this.eqModifierList) {
            n += (int)equipmentModifier.bonusTo(playerCharacter, "EQM", "HANDS", this);
            n += (int)equipmentModifier.bonusTo(playerCharacter, "EQM", "SLOTS", this);
        }
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    @Override
    public String getDefaultSourceString() {
        if (this.isType("CUSTOM")) {
            return PropertyFactory.getString("in_custom") + " - " + super.getDefaultSourceString();
        }
        return super.getDefaultSourceString();
    }

    public void clearSpecialProperties() {
        this.specialPropertyList.clear();
    }

    public void addSpecialProperty(SpecialProperty specialProperty) {
        this.specialPropertyList.add(specialProperty);
    }

    public String getSpecialProperties(PlayerCharacter playerCharacter) {
        ArrayList<EquipmentModifier> arrayList = new ArrayList<EquipmentModifier>(this.eqModifierList);
        ArrayList<EquipmentModifier> arrayList2 = new ArrayList<EquipmentModifier>(this.altEqModifierList);
        ArrayList<EquipmentModifier> arrayList3 = new ArrayList<EquipmentModifier>();
        Equipment.extractListFromCommon(arrayList3, arrayList);
        this.removeCommonFromList(arrayList2, arrayList3, "SPROP: eqMod expected but not found: ");
        String string = CoreUtility.commaDelimit(this.getSpecialAbilityTimesList(this.getSpecialAbilityList(arrayList3, playerCharacter)));
        String string2 = CoreUtility.commaDelimit(this.getSpecialAbilityTimesList(this.getSpecialAbilityList(arrayList, playerCharacter)));
        String string3 = CoreUtility.commaDelimit(this.getSpecialAbilityTimesList(this.getSpecialAbilityList(arrayList2, playerCharacter)));
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (int i = 0; i < this.specialPropertyList.size(); ++i) {
            SpecialProperty specialProperty = this.specialPropertyList.get(i);
            String string4 = specialProperty.getParsedText(playerCharacter, this);
            if (string4.equals("")) continue;
            if (!bl) {
                stringBuffer.append(", ");
            }
            bl = false;
            stringBuffer.append(string4);
        }
        if (string.length() != 0) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            bl = false;
            stringBuffer.append(string);
        }
        if (string2.length() != 0) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            bl = false;
            if (this.isDouble()) {
                stringBuffer.append("Head1: ");
            }
            stringBuffer.append(string2);
        }
        if (this.isDouble() && string3.length() != 0) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            bl = false;
            stringBuffer.append("Head2: ").append(string3);
        }
        return stringBuffer.toString();
    }

    public void setSpellFailure(String string) {
        try {
            this.spellFailure = Delta.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public Equipment getUberParent() {
        if (this.getParent() == null) {
            return this;
        }
        Equipment equipment = (Equipment)this.getParent();
        while (equipment.getParent() != null) {
            equipment = (Equipment)equipment.getParent();
        }
        return equipment;
    }

    public int getUsedCharges() {
        for (EquipmentModifier equipmentModifier : this.getEqModifierList(true)) {
            if (equipmentModifier.getMinCharges() <= 0) continue;
            return equipmentModifier.getUsedCharges();
        }
        return -1;
    }

    @Override
    public Float getVariableValue(String string, String string2, PlayerCharacter playerCharacter) {
        return this.getVariableValue(string, string2, this.bonusPrimary, playerCharacter);
    }

    public Float getVariableValue(String string, String string2, boolean bl, PlayerCharacter playerCharacter) {
        VariableProcessorEq variableProcessorEq = new VariableProcessorEq(this, playerCharacter, bl);
        return variableProcessorEq.getVariableValue(null, string, string2, 0);
    }

    public boolean isVisible(EquipmentModifier equipmentModifier) {
        int n = equipmentModifier.getVisible();
        if (n == 2) {
            this.bonusPrimary = true;
            if (equipmentModifier.passesPreReqToGain(this, null)) {
                return true;
            }
            if (this.isDouble()) {
                this.bonusPrimary = false;
                return equipmentModifier.passesPreReqToGain(this, null);
            }
            return false;
        }
        return n == 1;
    }

    public void setWeight(String string) {
        try {
            this.weightInPounds = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public Float getWeight(PlayerCharacter playerCharacter) {
        if (this.isVirtual()) {
            return new Float(0.0);
        }
        return new Float(this.getWeightAsDouble(playerCharacter));
    }

    public double getBaseWeightAsDouble() {
        if (this.isVirtual()) {
            return 0.0;
        }
        double d = this.weightInPounds;
        return d += this.weightMod.doubleValue();
    }

    public double getWeightAsDouble(PlayerCharacter playerCharacter) {
        if (this.isVirtual()) {
            return 0.0;
        }
        double d = this.bonusTo(playerCharacter, "EQM", "WEIGHTMULT", true);
        if (CoreUtility.doublesEqual(d, 0.0)) {
            d = 1.0;
        }
        double d2 = this.weightInPounds * d;
        d = this.bonusTo(playerCharacter, "EQM", "WEIGHTDIV", true);
        if (CoreUtility.doublesEqual(d, 0.0)) {
            d = 1.0;
        }
        d2 /= d;
        d2 += this.bonusTo(playerCharacter, "EQM", "WEIGHTADD", true);
        return d2 += this.weightMod.doubleValue();
    }

    public void setWeightMod(String string) {
        try {
            this.weightMod = new BigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.weightMod = BigDecimal.ZERO;
        }
    }

    public void setDamageMod(String string) {
        if (this.theWeaponStats == null) {
            this.theWeaponStats = new WeaponEquipment(this);
        }
        this.theWeaponStats.setDamageMod(string);
    }

    public String getDamageMod() {
        if (this.theWeaponStats != null) {
            return this.theWeaponStats.getDamageMod();
        }
        return "";
    }

    public void setWield(String string) {
        if (this.theWeaponStats == null) {
            this.theWeaponStats = new WeaponEquipment(this);
        }
        this.theWeaponStats.setWield(string);
    }

    public String getWield() {
        if (this.theWeaponStats != null) {
            return this.theWeaponStats.getWield();
        }
        return "";
    }

    public Integer acCheck(PlayerCharacter playerCharacter) {
        int n = this.acCheck + (int)this.bonusTo(playerCharacter, "EQMARMOR", "ACCHECK", true);
        if (n > 0) {
            n = 0;
        }
        return n;
    }

    @Override
    public boolean acceptsChildren() {
        return this.d_acceptsChildren;
    }

    public void clearAllEqModifiers() {
        if (this.eqModifierList != null) {
            this.eqModifierList.clear();
        }
    }

    public void addEqModifier(String string, boolean bl) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        String string2 = stringTokenizer.nextToken();
        EquipmentModifier equipmentModifier = this.getEqModifierKeyed(string2, bl);
        if (equipmentModifier == null) {
            if (string2.equals(EQMOD_WEIGHT)) {
                if (stringTokenizer.hasMoreTokens()) {
                    this.setWeightMod(stringTokenizer.nextToken().replace(',', '.'));
                }
                return;
            }
            if (string2.equals(EQMOD_DAMAGE)) {
                if (stringTokenizer.hasMoreTokens()) {
                    this.setDamageMod(stringTokenizer.nextToken());
                }
                return;
            }
            equipmentModifier = EquipmentList.getModifierKeyed(string2);
            if (equipmentModifier == null) {
                Logging.errorPrint("Could not find EquipmentModifier: " + string2);
                return;
            }
            if (equipmentModifier.getChoiceString().length() != 0) {
                equipmentModifier = equipmentModifier.clone();
            }
            this.addToEqModifierList(equipmentModifier, bl);
        }
        if (equipmentModifier.getChoiceString().length() != 0) {
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (equipmentModifier.getChoiceString().startsWith("EQBUILDER")) {
                    equipmentModifier.clearAssociated();
                }
                equipmentModifier.addAssociated(string3.replace('=', '|'));
            }
        }
    }

    public void addEqModifier(EquipmentModifier equipmentModifier, boolean bl, PlayerCharacter playerCharacter) {
        this.addEqModifier(equipmentModifier, bl, playerCharacter, null, null);
    }

    public void addEqModifier(EquipmentModifier equipmentModifier, boolean bl, PlayerCharacter playerCharacter, String string, EquipmentChoice equipmentChoice) {
        EquipmentModifier equipmentModifier2;
        EquipmentModifier equipmentModifier3;
        int n;
        boolean bl2 = false;
        if (playerCharacter != null && playerCharacter.isImporting()) {
            bl2 = true;
        }
        if (!bl2 && !this.canAddModifier(equipmentModifier, bl)) {
            return;
        }
        List<EquipmentModifier> list = this.getEqModifierList(bl);
        for (n = list.size() - 1; n >= 0; --n) {
            equipmentModifier3 = list.get(n);
            if (!equipmentModifier.willReplace(equipmentModifier3.getKeyName())) continue;
            list.remove(n);
            if (bl) {
                this.typeListCachePrimary = null;
            } else {
                this.typeListCacheSecondary = null;
            }
            this.setDirty(true);
        }
        if (equipmentModifier.isType("BaseMaterial")) {
            for (n = list.size() - 1; n >= 0; --n) {
                equipmentModifier3 = list.get(n);
                if (!equipmentModifier3.isType("BaseMaterial")) continue;
                list.remove(n);
                if (bl) {
                    this.typeListCachePrimary = null;
                } else {
                    this.typeListCacheSecondary = null;
                }
                this.setDirty(true);
            }
        } else if (equipmentModifier.isType("MagicalEnhancement")) {
            for (n = list.size() - 1; n >= 0; --n) {
                equipmentModifier3 = list.get(n);
                if (!equipmentModifier3.isType("MagicalEnhancement")) continue;
                list.remove(n);
                if (bl) {
                    this.typeListCachePrimary = null;
                    continue;
                }
                this.typeListCacheSecondary = null;
            }
        }
        if ((equipmentModifier2 = this.getEqModifierKeyed(equipmentModifier.getKeyName(), bl)) == null) {
            if (equipmentModifier.getChoiceString().length() != 0) {
                equipmentModifier2 = equipmentModifier.clone();
                if (equipmentModifier2 == null) {
                    return;
                }
            } else {
                equipmentModifier2 = equipmentModifier;
            }
            list.add(equipmentModifier2);
            if (bl) {
                this.typeListCachePrimary = null;
            } else {
                this.typeListCacheSecondary = null;
            }
        }
        if (!bl2) {
            boolean bl3 = false;
            if (string != null && string.length() > 0) {
                if (!equipmentModifier.getChoiceString().startsWith("EQBUILDER.")) {
                    equipmentModifier2.setChoice(string, equipmentChoice);
                    bl3 = equipmentModifier2.getAssociatedCount() == 0;
                }
            } else if (equipmentModifier2.getChoice(1, this, true) == 0) {
                bl3 = true;
            }
            if (bl3) {
                list.remove(equipmentModifier2);
                if (bl) {
                    this.typeListCachePrimary = null;
                } else {
                    this.typeListCacheSecondary = null;
                }
            }
        }
        list = Globals.sortPObjectListByName(list);
        this.setBase(playerCharacter);
    }

    public void addEqModifiers(String string, boolean bl) {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            if (((String)object).equalsIgnoreCase("None")) continue;
            this.addEqModifier((String)object, bl);
        }
        object = this.getEqModifierList(bl);
        object = Globals.sortPObjectListByName(object);
    }

    public void addToAltTypeList(String string) {
        String string2 = string.toUpperCase();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            this.addAltType(string3);
            this.typeListCachePrimary = null;
            this.typeListCacheSecondary = null;
        }
    }

    public void addVFeatList(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            if (this.vFeatList == null) {
                this.vFeatList = new ArrayList<String>();
            }
            this.vFeatList.add(stringTokenizer.nextToken());
        }
    }

    public double bonusTo(PlayerCharacter playerCharacter, String string, String string2, boolean bl) {
        return this.bonusTo(playerCharacter, string, string2, this, bl);
    }

    public double bonusTo(PlayerCharacter playerCharacter, String string, String string2, Object object, boolean bl) {
        List<PrereqObject> list;
        String string3 = new StringBuffer(string.toUpperCase()).append('.').append(string2.toUpperCase()).append('.').toString();
        for (String string4 : this.getBonusMap().keySet()) {
            if (!string4.startsWith(string3)) continue;
            this.putBonusMap(string4, "0");
        }
        double d = 0.0;
        this.bonusPrimary = bl;
        if (bl) {
            super.bonusTo(string, string2, this, playerCharacter);
            list = new ArrayList();
            for (BonusObj object2 : this.getTempBonusList()) {
                if (list.contains(object2)) continue;
                list.add(object2);
            }
            super.bonusTo(string, string2, object, list, playerCharacter);
        }
        if (Globals.checkRule("SYS_35WP")) {
            list = GameMode.getEqSizePenaltyObj().getBonusList();
            super.bonusTo(string, string2, this, list, playerCharacter);
        }
        list = this.getEqModifierList(bl);
        for (EquipmentModifier equipmentModifier : list) {
            if (this.willIgnore(equipmentModifier.getKeyName(), bl)) continue;
            equipmentModifier.bonusTo(playerCharacter, string, string2, this);
        }
        for (String string4 : this.getBonusMap().keySet()) {
            if (!string4.startsWith(string3)) continue;
            d += (double)Float.parseFloat(this.getBonusMap().get(string4));
        }
        return d;
    }

    public int calcPlusForCosting() {
        int n;
        int n2 = 0;
        for (EquipmentModifier equipmentModifier : this.eqModifierList) {
            n = equipmentModifier.getAssociatedCount();
            if (n < 1) {
                n = 1;
            }
            n2 += n * equipmentModifier.getPlus();
        }
        for (EquipmentModifier equipmentModifier : this.altEqModifierList) {
            n = equipmentModifier.getAssociatedCount();
            if (n < 1) {
                n = 1;
            }
            n2 += n * equipmentModifier.getPlus();
        }
        return n2;
    }

    public boolean canAddModifier(EquipmentModifier equipmentModifier, boolean bl) {
        this.bonusPrimary = bl;
        return this.modifiersAllowed && equipmentModifier.passesPreReqToGain(this, null);
    }

    @Override
    public int canContain(PlayerCharacter playerCharacter, Object object) {
        if (object instanceof Equipment) {
            Equipment equipment = (Equipment)object;
            if (this.checkChildWeight(playerCharacter, new Float(equipment.getWeightAsDouble(playerCharacter) * (double)equipment.numberCarried().floatValue()))) {
                if (this.checkContainerCapacity(equipment.eqTypeList(), equipment.numberCarried())) {
                    return 1;
                }
                return 4;
            }
            return 2;
        }
        return 0;
    }

    public void clearChildTypes() {
        this.d_childTypes = null;
    }

    public void clearContainedEquipment() {
        this.d_containedEquipment = null;
    }

    @Override
    public Equipment clone() {
        Equipment equipment = null;
        try {
            equipment = (Equipment)super.clone();
            equipment.seteDR(this.eDR.toString());
            equipment.setACCheck(this.acCheck.toString());
            equipment.setSpellFailure(this.spellFailure.toString());
            equipment.setMaxDex(this.maxDex.toString());
            if (this.theWeaponStats != null) {
                equipment.theWeaponStats = this.theWeaponStats.clone();
                equipment.theWeaponStats.setOwner(equipment);
            }
            equipment.setMoveString(this.moveString());
            equipment.profName = this.profName;
            equipment.carried = this.carried;
            equipment.equipped = this.equipped;
            equipment.location = this.location;
            equipment.slots = this.slots;
            equipment.bonusType = this.bonusType;
            equipment.numberEquipped = this.numberEquipped;
            equipment.qty = this.qty;
            equipment.outputIndex = this.outputIndex;
            equipment.containerWeightCapacity = this.containerWeightCapacity;
            equipment.containerReduceWeight = this.containerReduceWeight;
            equipment.d_acceptsChildren = this.d_acceptsChildren;
            if (this.d_acceptsTypes != null) {
                equipment.d_acceptsTypes = new HashMap<String, Float>(this.d_acceptsTypes);
            }
            equipment.containerConstantWeight = this.containerConstantWeight;
            if (this.d_childTypes != null) {
                equipment.d_childTypes = new HashMap<String, Float>(this.d_childTypes);
            }
            equipment.containerContentsString = this.containerContentsString;
            equipment.containerCapacityString = this.containerCapacityString;
            if (this.d_containedEquipment != null) {
                equipment.d_containedEquipment = new ArrayList<Equipment>(this.d_containedEquipment);
            }
            equipment.eqModifierList = this.cloneEqModList(true);
            equipment.altEqModifierList = this.cloneEqModList(false);
            equipment.modifiersAllowed = this.modifiersAllowed;
            equipment.modifiersRequired = this.modifiersRequired;
            equipment.specialPropertyList = new ArrayList<SpecialProperty>();
            equipment.specialPropertyList.addAll(this.specialPropertyList);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ShowMessageDelegate.showMessageDialog(cloneNotSupportedException.getMessage(), "PCGen", MessageType.ERROR);
        }
        return equipment;
    }

    @Override
    public int compareTo(Object object) {
        Equipment equipment = (Equipment)object;
        return this.getName().compareToIgnoreCase(equipment.getName());
    }

    public boolean containsContainedEquipment(Equipment equipment) {
        if (this.d_containedEquipment == null) {
            return false;
        }
        return this.d_containedEquipment.contains(equipment);
    }

    public Integer eDR(PlayerCharacter playerCharacter) {
        int n = this.eDR + (int)this.bonusTo(playerCharacter, "EQMARMOR", "EDR", true);
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        return object != null && object instanceof Equipment && (object == this || this.getName().equals(((Equipment)object).getName()));
    }

    public String formatSaveLine(char c, char c2) {
        String string;
        Equipment equipment;
        StringBuffer stringBuffer = new StringBuffer(100);
        if (this.baseItem.length() != 0) {
            equipment = EquipmentList.getEquipmentNamed(this.baseItem);
            stringBuffer.append(this.baseItem);
            stringBuffer.append(c).append("NAME").append(c2).append(this.toString(false));
        } else {
            equipment = this;
            stringBuffer.append(this.getBaseItemName());
        }
        if (equipment == null) {
            return stringBuffer.toString();
        }
        if (!this.getKeyName().equals(this.getName())) {
            stringBuffer.append(c).append("KEY").append(c2).append(this.getKeyName());
        }
        if (!this.size.equals(equipment.getSize())) {
            stringBuffer.append(c).append("SIZE").append(c2).append(this.size);
        }
        if ((string = this.getEqModifierString(true)).length() > 0) {
            stringBuffer.append(c).append("EQMOD").append(c2).append(string);
        }
        if ((string = this.getEqModifierString(false)).length() > 0) {
            stringBuffer.append(c).append("ALTEQMOD").append(c2).append(string);
        }
        if ((string = this.getRawSpecialProperties()).length() > 0 && !string.equals(equipment.getRawSpecialProperties())) {
            stringBuffer.append(c).append("SPROP").append(c2).append(string);
        }
        if (!this.costMod.equals(BigDecimal.ZERO)) {
            stringBuffer.append(c).append("COSTMOD").append(c2).append(this.costMod.toString());
        }
        return stringBuffer.toString();
    }

    public boolean hasVFeats() {
        List<Ability> list = this.getVirtualFeatList();
        return list != null && list.size() > 0;
    }

    public boolean hasWield() {
        if (this.theWeaponStats != null) {
            return this.theWeaponStats.hasWield();
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public int indexOfChild(Object object) {
        if (!(object instanceof Equipment)) {
            return -1;
        }
        return this.getContainedEquipmentIndexOf((Equipment)object);
    }

    @Override
    public void insertChild(PlayerCharacter playerCharacter, Object object) {
        Float f;
        if (object == null) {
            return;
        }
        Equipment equipment = (Equipment)object;
        Float f2 = f = equipment.numberCarried();
        String string = this.pickChildType(equipment.eqTypeList(), f);
        if (this.containsChildType(string)) {
            f = new Float(this.getChildType(string).floatValue() + f.floatValue());
        }
        f2 = new Float(this.getChildType("Total").floatValue() + f2.floatValue());
        this.setChildType(string, f);
        this.setChildType("Total", f2);
        this.addContainedEquipment(equipment);
        equipment.setIndexedUnderType(string);
        equipment.setParent(this);
        this.updateContainerContentsString(playerCharacter);
        while (equipment.getParent() != null) {
            equipment = (Equipment)equipment.getParent();
            equipment.updateContainerContentsString(playerCharacter);
        }
    }

    public int itemDepth() {
        if (this.getParent() == null) {
            return 0;
        }
        int n = 1;
        Equipment equipment = (Equipment)this.getParent();
        while (equipment.getParent() != null) {
            equipment = (Equipment)equipment.getParent();
            ++n;
        }
        return n;
    }

    public void load(String string) {
        this.load(string, "\t", ":");
    }

    public void load(String string, String string2, String string3) {
        this.load(string, string2, string3, null);
    }

    public void load(String string, String string2, String string3, PlayerCharacter playerCharacter) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n = string3.length();
        String string4 = this.size;
        this.baseItem = this.getKeyName();
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            if (string5.startsWith("NAME" + string3)) {
                this.setName(string5.substring(4 + n));
                continue;
            }
            if (string5.startsWith("KEY" + string3)) {
                this.setKeyName(string5.substring(3 + n));
                continue;
            }
            if (string5.startsWith("SIZE" + string3)) {
                string4 = string5.substring(4 + n);
                continue;
            }
            if (string5.startsWith("EQMOD" + string3)) {
                this.addEqModifiers(string5.substring(5 + n), true);
                continue;
            }
            if (string5.startsWith("ALTEQMOD" + string3)) {
                this.addEqModifiers(string5.substring(8 + n), false);
                continue;
            }
            if (string5.startsWith("SPROP" + string3)) {
                this.addSpecialProperty(SpecialProperty.createFromLst(string5.substring(5 + n)));
                continue;
            }
            if (string5.startsWith("COSTMOD" + string3)) {
                this.setCostMod(string5.substring(7 + n));
                continue;
            }
            if (!string5.startsWith("WEIGHTMOD" + string3)) continue;
            this.setWeightMod(string5.substring(9 + n));
        }
        this.resizeItem(playerCharacter, string4);
    }

    public String longName() {
        if (this.longName.length() == 0) {
            return this.toString();
        }
        return this.longName;
    }

    public boolean meetsPreReqs(PlayerCharacter playerCharacter) {
        return PrereqHandler.passesAll(this.getPreReqList(), this, playerCharacter);
    }

    public String modifiedName() {
        return this.modifiedName;
    }

    public String moveString() {
        if (this.moveString.length() > 0) {
            Load load = this.isHeavy() ? Load.HEAVY : (this.isMedium() ? Load.MEDIUM : (this.isLight() ? Load.LIGHT : Load.OVERLOAD));
            StringTokenizer stringTokenizer = new StringTokenizer(this.moveString, ",");
            int n = -1;
            int n2 = stringTokenizer.countTokens();
            switch (n2) {
                case 2: {
                    n = 30;
                    break;
                }
                case 3: {
                    n = 60;
                    break;
                }
                default: {
                    n2 = -1;
                }
            }
            if (n2 > 0) {
                StringBuffer stringBuffer = new StringBuffer(this.moveString.length());
                for (int i = 0; i < n2; ++i) {
                    if (i != 0) {
                        stringBuffer.append(',');
                    }
                    stringBuffer.append(Globals.calcEncumberedMove(load, n, true));
                    n -= 10;
                }
                return stringBuffer.toString();
            }
        }
        return this.moveString;
    }

    public String nameItemFromModifiers(PlayerCharacter playerCharacter) {
        String string = this.getItemNameFromModifiers();
        this.cleanTypes(playerCharacter);
        this.setName(string);
        this.setOutputName("");
        return this.getName();
    }

    public Float numberCarried() {
        Equipment equipment;
        if (this.isEquipped() || equipment == null) {
            return this.carried;
        }
        for (equipment = (Equipment)this.getParent(); equipment != null; equipment = (Equipment)equipment.getParent()) {
            if (!equipment.isEquipped() && (equipment.getParent() != null || equipment.numberCarried().intValue() == 0)) continue;
            return this.carried;
        }
        return Float.valueOf(0.0f);
    }

    public String profKey(PlayerCharacter playerCharacter) {
        try {
            if (this.isWeapon()) {
                WeaponProf weaponProf = this.getExpandedWeaponProf(playerCharacter);
                if (weaponProf != null) {
                    return weaponProf.getKeyName();
                }
                Logging.debugPrint("Could not find weapon proficiency with key '" + this.profName + "'.");
            }
            if (this.profName == null || this.profName.length() == 0) {
                return this.getDisplayName();
            }
        }
        catch (RuntimeException runtimeException) {
            Logging.errorPrint("Problem with: " + this.getDisplayName(), runtimeException);
        }
        return this.profName;
    }

    public double qty() {
        return this.qty;
    }

    public void removeChild(PlayerCharacter playerCharacter, Object object) {
        int n = this.indexOfChild(object);
        Equipment equipment = (Equipment)object;
        Float f = equipment.numberCarried();
        this.setChildType("Total", new Float(this.getChildType("Total").floatValue() - f.floatValue()));
        String string = equipment.isIndexedUnderType();
        this.setChildType(string, new Float(this.getChildType(string).floatValue() - f.floatValue()));
        equipment.setParent(null);
        this.removeContainedEquipment(n);
        this.updateContainerContentsString(playerCharacter);
        equipment = this;
        while (equipment.getParent() != null) {
            equipment = (Equipment)equipment.getParent();
            equipment.updateContainerContentsString(playerCharacter);
        }
    }

    @Override
    public void removeChild(PlayerCharacter playerCharacter, int n) {
        this.removeChild(playerCharacter, this.getChild(n));
    }

    public void removeEqModifier(EquipmentModifier equipmentModifier, boolean bl) {
        List<EquipmentModifier> list = this.getEqModifierList(bl);
        EquipmentModifier equipmentModifier2 = this.getEqModifierKeyed(equipmentModifier.getKeyName(), bl);
        if (equipmentModifier2 == null) {
            return;
        }
        if (equipmentModifier2.getAssociatedCount() == 0 || equipmentModifier2.getChoice(0, this, false) == 0) {
            list.remove(equipmentModifier2);
            if (bl) {
                this.typeListCachePrimary = null;
            } else {
                this.typeListCacheSecondary = null;
            }
            this.setDirty(true);
        }
    }

    public void removeEqModifiers(String string, boolean bl) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("None")) continue;
            this.removeEqModifier(string2, bl);
        }
    }

    public void resizeItem(PlayerCharacter playerCharacter, String string) {
        this.setBase(playerCharacter);
        int n = this.sizeInt();
        int n2 = Globals.sizeInt(string);
        if (n2 != n) {
            this.setSize(string);
            Equipment equipment = EquipmentList.getEquipmentKeyed(this.baseItem);
            if (equipment != null) {
                this.setCost(equipment.getCostAdjustedForSize(playerCharacter, string).toString());
                this.setWeight(equipment.getWeightAdjustedForSize(playerCharacter, string).toString());
                this.adjustACForSize(playerCharacter, equipment, string);
                if (equipment.theWeaponStats != null) {
                    this.setDamage(equipment.theWeaponStats.getDamageAdjustedForSize(string));
                    this.setAltDamage(equipment.theWeaponStats.getAltDamageAdjustedForSize(string));
                }
                if (this.containerCapacityString.length() > 0) {
                    double d = 1.0;
                    SizeAdjustment sizeAdjustment = SettingsHandler.getGame().getSizeAdjustmentNamed(string);
                    if (sizeAdjustment != null) {
                        d = sizeAdjustment.getBonusTo(playerCharacter, "ITEMCAPACITY", equipment.typeList(), 1.0);
                    }
                    if (this.containerWeightCapacity.intValue() != -1) {
                        this.containerWeightCapacity = new Float(equipment.containerWeightCapacity.doubleValue() * d);
                    }
                    if (this.getAcceptsTypeCount() > 0) {
                        for (String string2 : equipment.d_acceptsTypes.keySet()) {
                            Float f = equipment.getAcceptsType(string2);
                            if (f.intValue() == -1) continue;
                            f = new Float(f.doubleValue() * d);
                            this.setAcceptsType(string2, f);
                        }
                    }
                    this.updateContainerCapacityString();
                }
            }
            if (this.hasPreReqs()) {
                for (Prerequisite prerequisite : this.getPreReqList()) {
                    int n3;
                    if (!"SIZE".equalsIgnoreCase(prerequisite.getKind()) || (n2 += (n3 = Globals.sizeInt(prerequisite.getOperand())) - n) < 0 || n2 > SettingsHandler.getGame().getSizeAdjustmentListSize() - 1) continue;
                    prerequisite.setOperand(SettingsHandler.getGame().getSizeAdjustmentAtIndex(n2).getAbbreviation());
                }
            }
        }
    }

    public void seteDR(String string) {
        try {
            this.eDR = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.eDR = 0;
        }
    }

    public int sizeInt() {
        return Globals.sizeInt(this.getSize());
    }

    public Integer spellFailure(PlayerCharacter playerCharacter) {
        int n = this.spellFailure + (int)this.bonusTo(playerCharacter, "EQMARMOR", "SPELLFAILURE", true);
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean bl) {
        if (this.isDirty() || this.cachedNameWithCharges == null && this.cachedNameWithoutCharges == null) {
            StringBuffer stringBuffer = new StringBuffer(this.displayName);
            if (this.modifiedName.length() > 0) {
                stringBuffer.append(" (").append(this.modifiedName).append(")");
            }
            this.cachedNameWithoutCharges = stringBuffer.toString();
            if (bl && this.getRemainingCharges() > this.getMinCharges() && this.getRemainingCharges() < this.getMaxCharges()) {
                stringBuffer.append("(").append(this.getRemainingCharges()).append(")");
            }
            this.cachedNameWithCharges = stringBuffer.toString();
            this.setDirty(false);
        }
        if (bl) {
            return this.cachedNameWithCharges;
        }
        return this.cachedNameWithoutCharges;
    }

    private boolean isDirty() {
        return this.dirty;
    }

    private void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public String typeIndex(int n) {
        List<String> list = this.typeList();
        if (n < 0 || n >= list.size()) {
            return "";
        }
        return list.get(n);
    }

    public List<String> typeList() {
        return this.typeList(true);
    }

    public void updateContainerContentsString() {
        this.containerContentsString = "";
        StringBuffer stringBuffer = new StringBuffer(this.getChildCount() * 20);
        if (this.acceptsChildren() && this.getBaseContainedWeight(true).floatValue() >= 0.0f) {
            stringBuffer.append(Globals.getGameModeUnitSet().displayWeightInUnitSet(this.getBaseContainedWeight(true).doubleValue())).append(Globals.getGameModeUnitSet().getWeightUnit());
        } else {
            stringBuffer.append("0.0 ");
            stringBuffer.append(Globals.getGameModeUnitSet().getWeightUnit());
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            Equipment equipment = (Equipment)this.getChild(i);
            if (!(equipment.getQty().floatValue() > 0.0f)) continue;
            stringBuffer.append(", ");
            stringBuffer.append(BigDecimalHelper.trimZeros(equipment.getQty().toString()));
            stringBuffer.append(" ");
            stringBuffer.append(equipment);
        }
        this.containerContentsString = stringBuffer.toString();
    }

    public void updateContainerContentsString(PlayerCharacter playerCharacter) {
        this.containerContentsString = "";
        StringBuffer stringBuffer = new StringBuffer(this.getChildCount() * 20);
        if (playerCharacter != null && this.acceptsChildren() && this.getContainedWeight(playerCharacter, true).floatValue() >= 0.0f) {
            stringBuffer.append(Globals.getGameModeUnitSet().displayWeightInUnitSet(this.getContainedWeight(playerCharacter, true).doubleValue())).append(Globals.getGameModeUnitSet().getWeightUnit());
        } else {
            stringBuffer.append("0.0 ");
            stringBuffer.append(Globals.getGameModeUnitSet().getWeightUnit());
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            Equipment equipment = (Equipment)this.getChild(i);
            if (!(equipment.getQty().floatValue() > 0.0f)) continue;
            stringBuffer.append(", ");
            stringBuffer.append(BigDecimalHelper.trimZeros(equipment.getQty().toString()));
            stringBuffer.append(" ");
            stringBuffer.append(equipment.getOutputName());
        }
        this.containerContentsString = stringBuffer.toString();
    }

    @Override
    protected void doGlobalTypeUpdate(String string) {
        s_equipmentTypes.add(string);
    }

    private void setDefaultCrit(PlayerCharacter playerCharacter) {
        if (this.isWeapon()) {
            if (this.getCritRange(playerCharacter).length() == 0) {
                this.setCritRange("1");
            }
            if (this.getCritMult().length() == 0) {
                this.setCritMult(2);
            }
        }
    }

    public void setQty(double d) {
        this.qty = d;
    }

    static void clearEquipmentTypes() {
        s_equipmentTypes.clear();
    }

    boolean getModifiersAllowed() {
        return this.modifiersAllowed;
    }

    String getType(boolean bl) {
        List<String> list = this.typeList(bl);
        int n = list.size();
        StringBuffer stringBuffer = new StringBuffer(n * 5);
        for (String string : list) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    boolean equalTo(Object object) {
        return super.equals(object);
    }

    String rawProfName() {
        return this.profName;
    }

    boolean save(BufferedWriter bufferedWriter) {
        FileAccess.write(bufferedWriter, "BASEITEM:" + this.formatSaveLine('\t', ':'));
        FileAccess.newLine(bufferedWriter);
        return true;
    }

    private void setAcceptsType(String string, Float f) {
        if (this.d_acceptsTypes == null) {
            this.d_acceptsTypes = new HashMap<String, Float>();
        }
        this.d_acceptsTypes.put(string.toUpperCase(), f);
    }

    private Float getAcceptsType(String string) {
        if (this.d_acceptsTypes == null) {
            return null;
        }
        return this.d_acceptsTypes.get(string.toUpperCase());
    }

    private int getAcceptsTypeCount() {
        if (this.d_acceptsTypes == null) {
            return 0;
        }
        return this.d_acceptsTypes.size();
    }

    private int getAltTypeCount() {
        if (this.altTypeList == null) {
            return 0;
        }
        return this.altTypeList.size();
    }

    private void setBase(PlayerCharacter playerCharacter) {
        String string;
        Comparable<Object> comparable;
        Comparable<Object> comparable2;
        if (this.baseItem.length() == 0) {
            this.baseItem = this.getKeyName();
        }
        if (this.profName.length() == 0 && (comparable2 = EquipmentList.getEquipmentKeyed(this.baseItem)) != null) {
            this.profName = comparable2.rawProfName();
            if (this.profName.length() == 0) {
                this.profName = comparable2.getName();
            }
        }
        comparable2 = null;
        Object object = this.eqModifierList.iterator();
        while (object.hasNext()) {
            comparable = object.next();
            string = ((EquipmentModifier)comparable).getProficiency();
            if (string.length() == 0) continue;
            comparable2 = comparable;
            break;
        }
        if (comparable2 == null) {
            object = this.altEqModifierList.iterator();
            while (object.hasNext()) {
                comparable = (EquipmentModifier)object.next();
                string = ((EquipmentModifier)comparable).getProficiency();
                if (string.length() == 0) continue;
                comparable2 = comparable;
                break;
            }
        }
        if (comparable2 != null && (object = CoreUtility.split(((EquipmentModifier)comparable2).getProficiency(), '.')).size() == 2) {
            WeaponProf weaponProf;
            comparable = new StringBuffer(this.profName);
            if (this.profName.endsWith(")")) {
                ((StringBuffer)comparable).setLength(((StringBuffer)comparable).length() - 1);
                ((StringBuffer)comparable).append('/');
            } else {
                ((StringBuffer)comparable).append(" (");
            }
            if (!((StringBuffer)comparable).toString().endsWith((String)object.get(1) + '/')) {
                ((StringBuffer)comparable).append((String)object.get(1));
            } else {
                ((StringBuffer)comparable).setLength(((StringBuffer)comparable).length() - 1);
            }
            ((StringBuffer)comparable).append(')');
            this.profName = ((StringBuffer)comparable).toString();
            int n = this.profName.indexOf("[Hands]");
            if (n >= 0) {
                this.profName = this.profName.substring(0, n) + this.profName.substring(n + 7);
            }
            if ((weaponProf = Globals.getWeaponProfKeyed(this.profName)) == null) {
                weaponProf = new WeaponProf();
                weaponProf.setName(this.profName);
                weaponProf.setKeyName(this.profName);
                weaponProf.setTypeInfo((String)object.get(0));
                this.setDefaultCrit(playerCharacter);
                Globals.addWeaponProf(weaponProf);
            }
        }
        if (this.getSize().length() == 0) {
            this.setSize("M");
        }
    }

    BigDecimal getBaseCost() {
        return this.baseCost;
    }

    private String getBaseSize() {
        return this.sizeBase;
    }

    private Float getChildType(String string) {
        if (this.d_childTypes == null) {
            return null;
        }
        return this.d_childTypes.get(string);
    }

    private int getContainedEquipmentIndexOf(Equipment equipment) {
        if (this.d_containedEquipment == null) {
            return -1;
        }
        return this.d_containedEquipment.indexOf(equipment);
    }

    private BigDecimal getCostAdjustedForSize(PlayerCharacter playerCharacter, String string) {
        BigDecimal bigDecimal = this.getBaseCost();
        SizeAdjustment sizeAdjustment = SettingsHandler.getGame().getSizeAdjustmentNamed(string);
        SizeAdjustment sizeAdjustment2 = SettingsHandler.getGame().getSizeAdjustmentNamed(this.getBaseSize());
        if (sizeAdjustment == null || sizeAdjustment2 == null) {
            return bigDecimal;
        }
        double d = sizeAdjustment.getBonusTo(playerCharacter, "ITEMCOST", this.typeList(), 1.0);
        double d2 = sizeAdjustment2.getBonusTo(playerCharacter, "ITEMCOST", this.typeList(), 1.0);
        double d3 = d / d2;
        bigDecimal = bigDecimal.multiply(new BigDecimal(d3));
        return bigDecimal;
    }

    private String getEqModifierString(boolean bl) {
        List<EquipmentModifier> list = this.getEqModifierList(bl);
        StringBuffer stringBuffer = new StringBuffer(list.size() * 10);
        for (EquipmentModifier equipmentModifier : list) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(equipmentModifier.getKeyName());
            for (int i = 0; i < equipmentModifier.getAssociatedCount(); ++i) {
                String string = equipmentModifier.getAssociated(i);
                stringBuffer.append('|').append(string.replace('|', '='));
            }
        }
        if (bl && this.weightMod.compareTo(BigDecimal.ZERO) != 0) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(EQMOD_WEIGHT).append('|').append(this.weightMod.toString().replace('.', ','));
        }
        if (this.theWeaponStats != null && this.theWeaponStats.getDamageMod().length() != 0) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(EQMOD_DAMAGE).append('|').append(this.theWeaponStats.getDamageMod().replace('.', ','));
        }
        return stringBuffer.toString();
    }

    private void setIndexedUnderType(String string) {
        this.indexedUnderType = string;
    }

    private String isIndexedUnderType() {
        return this.indexedUnderType;
    }

    private static EquipmentModifier getMagicBonus(List<EquipmentModifier> list) {
        for (EquipmentModifier equipmentModifier : list) {
            if (!equipmentModifier.isType("MagicalEnhancement") && !equipmentModifier.isIType("Magic")) continue;
            return equipmentModifier;
        }
        return null;
    }

    private static String getNameFromModifiers(List<EquipmentModifier> list) {
        ArrayList<EquipmentModifier> arrayList = new ArrayList<EquipmentModifier>(list);
        Globals.sortPObjectList(arrayList);
        StringBuffer stringBuffer = new StringBuffer(70);
        for (EquipmentModifier equipmentModifier : arrayList) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append('/');
            }
            stringBuffer.append(equipmentModifier.getEquipNamePortion());
        }
        return stringBuffer.toString();
    }

    private void setSize(String string) {
        this.setSize(string, false);
    }

    private List<String> getSpecialAbilityList(List<EquipmentModifier> list, PlayerCharacter playerCharacter) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (EquipmentModifier equipmentModifier : list) {
            arrayList.addAll(equipmentModifier.getSpecialProperties(this, playerCharacter));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal getCostFromPluses(int n, int n2) {
        if ((n != 0 || n2 != 0) && JEPResourceChecker.getMissingResourceCount() == 0) {
            PJEP pJEP = null;
            try {
                String string;
                String string2;
                pJEP = PjepPool.getInstance().aquire();
                pJEP.addVariable("PLUS", n);
                pJEP.addVariable("ALTPLUS", n2);
                pJEP.addVariable("BASECOST", this.getBaseCost().doubleValue());
                if (this.isAmmunition()) {
                    pJEP.addVariable("BASEQTY", this.getBaseQty());
                }
                BigDecimal bigDecimal = null;
                List<String> list = this.typeList();
                for (int i = 0; i < list.size(); ++i) {
                    string2 = list.get(i);
                    string = SettingsHandler.getGame().getPlusCalculation(string2);
                    if (string == null) continue;
                    BigDecimal bigDecimal2 = this.evaluateCost(pJEP, string);
                    if (bigDecimal != null && bigDecimal2.compareTo(bigDecimal) <= 1) continue;
                    bigDecimal = bigDecimal2;
                }
                if (bigDecimal != null) {
                    BigDecimal bigDecimal3 = bigDecimal;
                    return bigDecimal3;
                }
                string2 = "ANY";
                string = SettingsHandler.getGame().getPlusCalculation(string2);
                if (string != null) {
                    BigDecimal bigDecimal4 = this.evaluateCost(pJEP, string);
                    return bigDecimal4;
                }
            }
            finally {
                PjepPool.getInstance().release(pJEP);
            }
        }
        return BigDecimal.ZERO;
    }

    private boolean isMagicLimitedType() {
        boolean bl = false;
        if (this.isType("HEADGEAR") || this.isType("EYEGEAR") || this.isType("CAPE") || this.isType("AMULET") || this.isSuit() || this.isType("ROBE") || this.isType("SHIRT") || this.isType("BRACER") || this.isType("GLOVE") || this.isType("RING") || this.isType("BELT") || this.isType("BOOT")) {
            bl = true;
        }
        return bl;
    }

    private List<String> getSpecialAbilityTimesList(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int[] nArray = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (!arrayList.contains(string)) {
                arrayList.add(string);
                nArray[i] = 1;
                continue;
            }
            for (int j = 0; j < arrayList.size(); ++j) {
                String string2 = (String)arrayList.get(j);
                if (!string2.equals(string)) continue;
                int n = j;
                nArray[n] = nArray[n] + 1;
            }
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            if (nArray[i] > 1) {
                string = string + " (" + nArray[i] + ")";
            }
            arrayList2.add(string);
        }
        return arrayList2;
    }

    private Float getWeightAdjustedForSize(PlayerCharacter playerCharacter, String string) {
        if (this.isVirtual()) {
            return new Float(0.0);
        }
        SizeAdjustment sizeAdjustment = SettingsHandler.getGame().getSizeAdjustmentNamed(string);
        SizeAdjustment sizeAdjustment2 = SettingsHandler.getGame().getSizeAdjustmentNamed(this.getSize());
        if (sizeAdjustment == null || sizeAdjustment2 == null) {
            return new Float(this.getBaseWeightAsDouble());
        }
        double d = sizeAdjustment.getBonusTo(playerCharacter, "ITEMWEIGHT", this.typeList(), 1.0) / sizeAdjustment2.getBonusTo(playerCharacter, "ITEMWEIGHT", this.typeList(), 1.0);
        return new Float(this.getBaseWeightAsDouble() * d);
    }

    private boolean acceptsType(String string) {
        if (this.d_acceptsTypes == null) {
            return false;
        }
        return this.d_acceptsTypes.containsKey(string.toUpperCase());
    }

    private void addAltType(String string) {
        if (this.altTypeList == null) {
            this.altTypeList = new ArrayList<String>(1);
        }
        this.altTypeList.add(string);
        this.typeListCachePrimary = null;
        this.typeListCacheSecondary = null;
    }

    private void addContainedEquipment(Equipment equipment) {
        if (this.d_containedEquipment == null) {
            this.d_containedEquipment = new ArrayList<Equipment>();
        }
        this.d_containedEquipment.add(equipment);
    }

    private List<Ability> addEqModList(boolean bl, List<Ability> list) {
        List<EquipmentModifier> list2 = this.getEqModifierList(bl);
        List<Ability> list3 = list;
        if (list2.size() != 0) {
            for (EquipmentModifier equipmentModifier : list2) {
                list3.addAll(equipmentModifier.getVirtualFeatList());
            }
        }
        return list3;
    }

    private void adjustACForSize(PlayerCharacter playerCharacter, Equipment equipment, String string) {
        if (this.getBonusList() != null && this.isArmor()) {
            int n;
            String string2;
            BonusObj bonusObj;
            int n2;
            double d = 1.0;
            SizeAdjustment sizeAdjustment = SettingsHandler.getGame().getSizeAdjustmentNamed(string);
            SizeAdjustment sizeAdjustment2 = SettingsHandler.getGame().getSizeAdjustmentNamed(equipment.getSize());
            if (sizeAdjustment != null && sizeAdjustment2 != null) {
                d = sizeAdjustment.getBonusTo(playerCharacter, "ACVALUE", equipment.typeList(), 1.0) / sizeAdjustment2.getBonusTo(playerCharacter, "ACVALUE", equipment.typeList(), 1.0);
            }
            List<BonusObj> list = equipment.getBonusList();
            List<BonusObj> list2 = this.getBonusList();
            for (n2 = list2.size() - 1; n2 >= 0; --n2) {
                bonusObj = list2.get(n2);
                string2 = bonusObj.toString();
                if (!string2.startsWith("COMBAT|AC|") || (n = string2.indexOf(124, 10)) <= 10) continue;
                this.removeBonusList(bonusObj);
            }
            for (n2 = 0; n2 < list.size(); ++n2) {
                bonusObj = list.get(n2);
                string2 = bonusObj.toString();
                if (!string2.startsWith("COMBAT|AC|") || (n = string2.indexOf(124, 10)) <= 10) continue;
                Integer n3 = Integer.valueOf(string2.substring(10, n));
                n3 = new Float(n3.doubleValue() * d).intValue();
                string2 = string2.substring(0, 10) + n3.toString() + string2.substring(n);
                this.addBonusList(string2);
            }
        }
    }

    private boolean checkChildWeight(PlayerCharacter playerCharacter, Float f) {
        if (this.containerWeightCapacity.intValue() == -1) {
            return true;
        }
        return f.floatValue() + this.getContainedWeight(playerCharacter).floatValue() <= this.containerWeightCapacity.floatValue();
    }

    private boolean checkContainerCapacity(SortedSet<String> sortedSet, Float f) {
        if (this.acceptsType("Any") && this.getAcceptsType("Any").intValue() == -1) {
            return true;
        }
        return !"".equals(this.pickChildType(sortedSet, f));
    }

    private List<EquipmentModifier> cloneEqModList(boolean bl) {
        ArrayList<EquipmentModifier> arrayList = new ArrayList<EquipmentModifier>();
        for (EquipmentModifier equipmentModifier : this.getEqModifierList(bl)) {
            if (equipmentModifier.getChoiceString().length() != 0) {
                equipmentModifier = equipmentModifier.clone();
            }
            arrayList.add(equipmentModifier);
        }
        return arrayList;
    }

    private boolean containsChildType(String string) {
        if (this.d_childTypes == null) {
            return false;
        }
        return this.d_childTypes.containsKey(string);
    }

    private SortedSet<String> eqTypeList() {
        return new TreeSet<String>(this.typeList());
    }

    private static void extractListFromCommon(List<EquipmentModifier> list, List<EquipmentModifier> list2) {
        for (int i = list2.size() - 1; i >= 0; --i) {
            EquipmentModifier equipmentModifier = list2.get(i);
            if (!equipmentModifier.getAssignToAll()) continue;
            list.add(0, equipmentModifier);
            list2.remove(i);
        }
    }

    private void cleanTypes(PlayerCharacter playerCharacter) {
        String string = super.getType();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        StringBuffer stringBuffer = new StringBuffer(string.length());
        stringBuffer.append(".CLEAR");
        while (stringTokenizer.hasMoreTokens()) {
            SizeAdjustment sizeAdjustment;
            int n;
            String string2 = stringTokenizer.nextToken();
            for (n = 0; n <= SettingsHandler.getGame().getSizeAdjustmentListSize() - 1 && !string2.equalsIgnoreCase(SettingsHandler.getGame().getSizeAdjustmentAtIndex(n).getDisplayName()); ++n) {
            }
            if ("Standard".equalsIgnoreCase(string2) || n < SettingsHandler.getGame().getSizeAdjustmentListSize() && (!(sizeAdjustment = SettingsHandler.getGame().getSizeAdjustmentAtIndex(n)).isDefaultSize() || !stringBuffer.toString().toUpperCase().endsWith("ARMOR"))) continue;
            if ("Magic".equalsIgnoreCase(string2)) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.insert(0, '.');
                }
                stringBuffer.insert(0, string2);
                continue;
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(string2);
        }
        this.setTypeInfo(stringBuffer.toString());
        this.setDefaultCrit(playerCharacter);
    }

    private BigDecimal evaluateCost(PJEP pJEP, String string) {
        Object object;
        pJEP.parseExpression(string);
        if (!pJEP.hasError() && (object = pJEP.getValueAsObject()) != null) {
            return new BigDecimal(object.toString());
        }
        Logging.errorPrint("Bad equipment cost expression: " + string);
        return BigDecimal.ZERO;
    }

    private boolean ignoresCostDouble() {
        boolean bl = false;
        if (this.isType("MANTLE") || this.isType("POTION") || this.isType("SCROLL") || this.isType("STAFF") || this.isType("WAND")) {
            bl = true;
        }
        return bl;
    }

    private String pickChildType(SortedSet<String> sortedSet, Float f) {
        String string = "";
        Float f2 = this.getAcceptsType("TOTAL");
        if (f2 == null) {
            f2 = Float.valueOf(0.0f);
        }
        if (this.getChildType("Total") == null) {
            this.setChildType("Total", Float.valueOf(0.0f));
        }
        if (this.getChildType("Total").floatValue() + f.floatValue() <= f2.floatValue()) {
            for (String string2 : sortedSet) {
                if (!"".equals(string)) break;
                if (!this.acceptsType(string2)) continue;
                if (this.containsChildType(string2) && this.getChildType(string2).floatValue() + f.floatValue() <= this.getAcceptsType(string2).floatValue()) {
                    string = string2;
                    continue;
                }
                if (!(f.floatValue() <= this.getAcceptsType(string2).floatValue())) continue;
                string = string2;
            }
            if ("".equals(string) && this.acceptsType("Any")) {
                if (!this.containsChildType("Any")) {
                    this.setChildType("Any", Float.valueOf(0.0f));
                }
                if (this.getChildType("Any").floatValue() + f.floatValue() <= this.getAcceptsType("Any").floatValue()) {
                    string = "Any";
                }
            }
        }
        return string;
    }

    private void removeCommonFromList(List<EquipmentModifier> list, List<EquipmentModifier> list2, String string) {
        for (int i = list.size() - 1; i >= 0; --i) {
            EquipmentModifier equipmentModifier = list.get(i);
            if (!equipmentModifier.getAssignToAll()) continue;
            int n = list2.indexOf(equipmentModifier);
            if (n >= 0) {
                list.remove(i);
                continue;
            }
            Logging.errorPrint(string + equipmentModifier.getDisplayName());
        }
    }

    private List<EquipmentModifier>[] initSplitModList() {
        List[] listArray = new List[3];
        for (int i = 0; i < listArray.length; ++i) {
            listArray[i] = new ArrayList();
        }
        return listArray;
    }

    private void splitModListByFormatCat(List<EquipmentModifier> list, List<EquipmentModifier>[] listArray) {
        for (EquipmentModifier equipmentModifier : list) {
            listArray[equipmentModifier.getFormatCat()].add(equipmentModifier);
        }
    }

    private void removeContainedEquipment(int n) {
        this.d_containedEquipment.remove(n);
    }

    private void removeEqModifier(String string, boolean bl) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        String string2 = stringTokenizer.nextToken();
        EquipmentModifier equipmentModifier = this.getEqModifierKeyed(string2, bl);
        if (equipmentModifier == null) {
            return;
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().replace('=', '|');
            for (int i = equipmentModifier.getAssociatedCount() - 1; i >= 0; --i) {
                String string4 = equipmentModifier.getAssociated(i);
                if (!string4.startsWith(string3)) continue;
                equipmentModifier.removeAssociated(i);
            }
        }
        if (equipmentModifier.getAssociatedCount() == 0) {
            this.removeEqModifier(equipmentModifier, bl);
        }
    }

    private void removeUnqualified(boolean bl) {
        List<EquipmentModifier> list = this.getEqModifierList(bl);
        for (int i = list.size() - 1; i >= 0; --i) {
            EquipmentModifier equipmentModifier = list.get(i);
            if (equipmentModifier.passesPreReqToGain(this, null)) continue;
            Logging.errorPrint("reUnq:Removing: " + equipmentModifier.getDisplayName());
            Logging.errorPrint("reUnq:preReqs: " + equipmentModifier.preReqStrings());
        }
    }

    @Override
    public final void addMyType(String string) {
        this.typeListCachePrimary = null;
        this.typeListCacheSecondary = null;
        super.addMyType(string);
    }

    @Override
    protected void clearMyType() {
        this.typeListCachePrimary = null;
        this.typeListCacheSecondary = null;
        super.clearMyType();
    }

    @Override
    protected void removeMyType(String string) {
        this.typeListCachePrimary = null;
        this.typeListCacheSecondary = null;
        super.removeMyType(string);
    }

    private List<String> typeList(boolean bl) {
        ArrayList<String> arrayList;
        if (bl && this.typeListCachePrimary != null) {
            return this.typeListCachePrimary;
        }
        if (!bl && this.typeListCacheSecondary != null) {
            return this.typeListCacheSecondary;
        }
        if (bl || this.getAltTypeCount() == 0) {
            arrayList = new ArrayList<String>(this.getTypeList(false));
        } else {
            if (!this.isDouble()) {
                return new ArrayList<String>();
            }
            arrayList = new ArrayList(this.getAltTypeCount());
            if (this.altTypeList != null) {
                arrayList.addAll(this.altTypeList);
            }
        }
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        EquipmentModifier equipmentModifier = this.getEqModifierKeyed("ADDTYPE", bl);
        if (equipmentModifier != null) {
            for (int i = 0; i < equipmentModifier.getAssociatedCount(); ++i) {
                Object object = equipmentModifier.getAssociated(i);
                if (arrayList.contains(object = ((String)object).toUpperCase())) continue;
                arrayList2.add(object);
            }
        }
        List<EquipmentModifier> list = this.getEqModifierList(bl);
        for (EquipmentModifier equipmentModifier2 : list) {
            int n;
            if (this.willIgnore(equipmentModifier2.getKeyName(), bl)) continue;
            String string = equipmentModifier2.replaceArmorType(arrayList);
            if (string != null && (n = arrayList2.indexOf(string)) >= 0) {
                arrayList2.remove(n);
            }
            List<String> list2 = equipmentModifier2.getItemType();
            for (String string2 : list2) {
                string2 = string2.toUpperCase();
                if (arrayList.contains("BOTH") && arrayList.contains("MELEE") && ("RANGED".equals(string2) || "THROWN".equals(string2)) || arrayList.contains(string2) || arrayList2.contains(string2)) continue;
                arrayList2.add(string2);
            }
        }
        arrayList.addAll(arrayList2);
        int n = arrayList.indexOf("MAGIC");
        if (n > 0) {
            arrayList.remove(n);
            arrayList.add(0, "MAGIC");
        }
        if (bl) {
            this.typeListCachePrimary = arrayList;
        } else {
            this.typeListCacheSecondary = arrayList;
        }
        return arrayList;
    }

    private void updateContainerCapacityString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (this.containerWeightCapacity.intValue() != -1) {
            stringBuffer.append(this.containerWeightCapacity).append(' ').append(Globals.getGameModeUnitSet().getWeightUnit());
            bl = true;
        }
        if (this.getAcceptsTypeCount() > 0) {
            for (String string : this.d_acceptsTypes.keySet()) {
                if (bl) {
                    stringBuffer.append(", ");
                    bl = false;
                }
                if (this.getAcceptsType(string).intValue() != -1) {
                    stringBuffer.append(this.getAcceptsType(string).floatValue()).append(' ');
                    stringBuffer.append(string);
                    bl = true;
                    continue;
                }
                if ("TOTAL".equals(string)) continue;
                bl = true;
                stringBuffer.append(string);
            }
        }
        this.containerCapacityString = stringBuffer.toString();
    }

    private boolean willIgnore(String string, boolean bl) {
        for (EquipmentModifier equipmentModifier : this.getEqModifierList(bl)) {
            if (!equipmentModifier.willIgnore(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void activateBonuses(PlayerCharacter playerCharacter) {
        for (BonusObj bonusObj : this.getBonusList()) {
            bonusObj.setApplied(false);
            if (bonusObj.passesPreReqToGain(this, playerCharacter)) {
                bonusObj.setApplied(true);
                continue;
            }
            bonusObj.setApplied(false);
        }
    }

    boolean isCalculatingCost() {
        return this.calculatingCost;
    }

    boolean isWeightAlreadyUsed() {
        return this.weightAlreadyUsed;
    }

    double getWeightInPounds() {
        if (this.isVirtual()) {
            return 0.0;
        }
        return this.weightInPounds;
    }

    void setWeightAlreadyUsed(boolean bl) {
        this.weightAlreadyUsed = bl;
    }

    int getSlots() {
        return this.slots;
    }

    Integer getSpellFailure() {
        return this.spellFailure;
    }

    Integer getRange() {
        if (this.theWeaponStats != null) {
            return this.theWeaponStats.getRange();
        }
        return 0;
    }

    public final String getNonHeadedName() {
        if (this.wholeItemName == null || this.wholeItemName.length() == 0) {
            return this.getName();
        }
        return this.wholeItemName;
    }

    public final String getWholeItemName() {
        return this.wholeItemName;
    }

    public final void setWholeItemName(String string) {
        this.wholeItemName = string;
    }

    public final void setBaseQty(String string) {
        try {
            this.baseQuantity = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.baseQuantity = 0;
            Logging.errorPrint("Badly formed BaseQty string: " + string);
        }
    }

    public final int getBaseQty() {
        return this.baseQuantity;
    }

    public String createKeyForAutoResize(String string) {
        if (string.length() < 1) {
            return this.getKeyName();
        }
        SizeAdjustment sizeAdjustment = SettingsHandler.getGame().getSizeAdjustmentNamed(string);
        if (sizeAdjustment == null) {
            return this.getKeyName();
        }
        string = sizeAdjustment.getDisplayName();
        string = string.toUpperCase().substring(0, 1);
        String string2 = this.getKeyName();
        if (string2.startsWith("AUTOSIZE")) {
            int n = "AUTOSIZE".length();
            String string3 = string2.substring(n, n + 1).toUpperCase();
            if (string3.equals(string)) {
                return string2;
            }
            string2 = string2.substring(n + 1);
        }
        return "AUTOSIZE" + string + string2;
    }

    public String createNameForAutoResize(String string) {
        if (string.length() < 1) {
            return this.getName();
        }
        SizeAdjustment sizeAdjustment = SettingsHandler.getGame().getSizeAdjustmentNamed(string);
        if (sizeAdjustment == null) {
            return this.getName();
        }
        string = sizeAdjustment.getDisplayName();
        string.toUpperCase();
        String string2 = this.getName();
        String string3 = string2.toUpperCase();
        String string4 = this.getSize();
        sizeAdjustment = SettingsHandler.getGame().getSizeAdjustmentNamed(string4);
        string4 = sizeAdjustment == null ? "Medium" : sizeAdjustment.getDisplayName();
        String string5 = string4.toUpperCase();
        int n = string3.indexOf(string5);
        int n2 = n + string5.length();
        if (n > -1 && (string3.substring(n - 1).startsWith("(") || string3.substring(n - 1).startsWith("/")) && (string3.substring(n2).startsWith(")") || string3.substring(n2).startsWith("/"))) {
            return string2.substring(0, n) + string + string2.substring(n2);
        }
        return string2 + " (" + string + ")";
    }

    public void setQuality(String string, String string2) {
        this.qualityMap.put(string, string2);
    }

    public String getQuality(String string) {
        return this.qualityMap.get(string);
    }

    public String getQuality(int n) {
        for (String string : this.qualityMap.keySet()) {
            if (--n != 0) continue;
            return string + ": " + this.qualityMap.get(string);
        }
        return "";
    }

    public Map<String, String> getQualityMap() {
        return this.qualityMap;
    }

    public String getQualityString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (String string : this.qualityMap.keySet()) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string).append(": ").append(this.qualityMap.get(string));
            bl = false;
        }
        return stringBuffer.toString();
    }

    public void makeVirtual() {
        this.virtualItem = true;
    }

    private boolean isVirtual() {
        return this.virtualItem;
    }

    public void setCritMult(int n) {
        if (this.theWeaponStats == null) {
            this.theWeaponStats = new WeaponEquipment(this);
        }
        this.theWeaponStats.setCritMult(n);
    }

    public String getCritMult() {
        if (this.theWeaponStats != null) {
            return this.theWeaponStats.getCritMult();
        }
        return "";
    }

    public int getRawCritMult() {
        if (this.theWeaponStats != null) {
            return this.theWeaponStats.getRawCritMult();
        }
        return 0;
    }

    public void setAltCritMult(int n) {
        if (this.theWeaponStats == null) {
            this.theWeaponStats = new WeaponEquipment(this);
        }
        this.theWeaponStats.setAltCritMult(n);
    }

    public String getAltCritMult() {
        if (this.theWeaponStats != null) {
            return this.theWeaponStats.getAltCritMult();
        }
        return "";
    }

    public int getRawAltCritMult() {
        if (this.theWeaponStats != null) {
            return this.theWeaponStats.getRawAltCritMult();
        }
        return 0;
    }

    public int getCritMultiplier() {
        if (this.theWeaponStats != null) {
            return this.theWeaponStats.getCritMultiplier();
        }
        return 0;
    }

    public int getAltCritMultiplier() {
        if (this.theWeaponStats != null) {
            return this.theWeaponStats.getAltCritMultiplier();
        }
        return 0;
    }

    public boolean isFinessable(PlayerCharacter playerCharacter) {
        if (this.isType("Finesseable")) {
            return true;
        }
        WieldCategory wieldCategory = this.getEffectiveWieldCategory(playerCharacter);
        return wieldCategory.isFinessable();
    }

    public boolean isWeaponLightForPC(PlayerCharacter playerCharacter) {
        if (playerCharacter == null || !this.isWeapon()) {
            return false;
        }
        WieldCategory wieldCategory = this.getEffectiveWieldCategory(playerCharacter);
        return wieldCategory.getName().equals("Light");
    }

    public boolean isWeaponOneHanded(PlayerCharacter playerCharacter) {
        if (playerCharacter == null || !this.isWeapon()) {
            return false;
        }
        WieldCategory wieldCategory = this.getEffectiveWieldCategory(playerCharacter);
        return wieldCategory.getHands() == 1;
    }

    public boolean isWeaponOutsizedForPC(PlayerCharacter playerCharacter) {
        if (playerCharacter == null || !this.isWeapon()) {
            return true;
        }
        WieldCategory wieldCategory = this.getEffectiveWieldCategory(playerCharacter);
        return wieldCategory.getHands() > 2 || wieldCategory.getHands() < 0;
    }

    public boolean isWeaponTooLargeForPC(PlayerCharacter playerCharacter) {
        if (playerCharacter == null || !this.isWeapon()) {
            return false;
        }
        WieldCategory wieldCategory = this.getEffectiveWieldCategory(playerCharacter);
        return wieldCategory.getHands() > 2;
    }

    public boolean isWeaponTwoHanded(PlayerCharacter playerCharacter) {
        if (playerCharacter == null || !this.isWeapon()) {
            return false;
        }
        WieldCategory wieldCategory = this.getEffectiveWieldCategory(playerCharacter);
        return wieldCategory.getHands() == 2;
    }

    public WieldCategory getEffectiveWieldCategory(PlayerCharacter playerCharacter) {
        int n;
        int n2;
        WieldCategory wieldCategory = null;
        WeaponProf weaponProf = this.getExpandedWeaponProf(playerCharacter);
        wieldCategory = WieldCategory.findByName(this.getWield());
        if (this.hasWield() && !Globals.checkRule("SIZEOBJ")) {
            wieldCategory = wieldCategory.adjustForSize(playerCharacter, this);
        } else {
            n2 = 0;
            n = playerCharacter.sizeInt();
            if (weaponProf != null) {
                n = (int)((double)n + playerCharacter.getTotalBonusTo("WEAPONPROF=" + weaponProf.getKeyName(), "PCSIZE"));
            }
            wieldCategory = (n2 = wieldCategory != null && Globals.checkRule("SIZEOBJ") ? wieldCategory.getObjectSizeInt(this) - n : this.sizeInt() - n) > 1 ? WieldCategory.findByName("TooLarge") : (n2 == 1 ? WieldCategory.findByName("TwoHanded") : (n2 == 0 ? WieldCategory.findByName("OneHanded") : WieldCategory.findByName("Light")));
        }
        n2 = 0;
        if (weaponProf != null) {
            n = weaponProf.getHands();
            if (n == -1) {
                n = playerCharacter.sizeInt() > this.sizeInt() ? 1 : 2;
            }
            while (wieldCategory.getHands() < n) {
                wieldCategory = wieldCategory.getWieldCategoryStep(1);
            }
            String string = weaponProf.getKeyName();
            n2 += (int)playerCharacter.getTotalBonusTo("WEAPONPROF=" + string, "WIELDCATEGORY");
        }
        if ((n2 += (int)this.bonusTo(playerCharacter, "WEAPON", "WIELDCATEGORY", true)) == 0) {
            return wieldCategory;
        }
        return wieldCategory.getWieldCategoryStep(n2);
    }

    public WeaponProf getExpandedWeaponProf(PlayerCharacter playerCharacter) {
        int n;
        String string = this.profName;
        if (string.length() == 0) {
            string = this.getName();
        }
        if ((n = string.indexOf("[Hands]")) >= 0) {
            String string2 = string.substring(0, n) + "Exotic" + string.substring(n + 7);
            String string3 = string.substring(0, n) + "Martial" + string.substring(n + 7);
            WeaponProf weaponProf = Globals.getWeaponProfKeyed(string2);
            WeaponProf weaponProf2 = Globals.getWeaponProfKeyed(string3);
            if (weaponProf2 != null && weaponProf != null) {
                if (playerCharacter.hasWeaponProfKeyed(string2)) {
                    return weaponProf;
                }
                return weaponProf2;
            }
        }
        return Globals.getWeaponProfKeyed(string);
    }

    public final void setNumPages(int n) {
        this.integerChar.put(IntegerKey.NUM_PAGES, n);
    }

    public final int getNumPages() {
        Integer n = (Integer)this.integerChar.get(IntegerKey.NUM_PAGES);
        return n == null ? 0 : n;
    }

    public final void setPageUsage(String string) {
        this.stringChar.put(StringKey.PAGE_USAGE, string);
    }

    public final String getPageUsage() {
        String string = (String)this.stringChar.get(StringKey.PAGE_USAGE);
        return string == null ? "" : string;
    }

    public Integer getACBonus(PlayerCharacter playerCharacter) {
        int n = (int)this.bonusTo(playerCharacter, "COMBAT", "AC", true);
        return n += (int)this.bonusTo(playerCharacter, "EQMARMOR", "ACBONUS", true);
    }

    public Integer getACMod(PlayerCharacter playerCharacter) {
        int n = (int)this.bonusTo(playerCharacter, "EQMARMOR", "AC", true) + (int)this.bonusTo(playerCharacter, "COMBAT", "AC", true);
        return n;
    }

    public void setCritRange(String string) {
        if (this.theWeaponStats == null) {
            this.theWeaponStats = new WeaponEquipment(this);
        }
        this.theWeaponStats.setCritRange(string);
    }

    public String getCritRange(PlayerCharacter playerCharacter) {
        if (this.theWeaponStats != null) {
            return this.theWeaponStats.getCritRange(playerCharacter);
        }
        return "";
    }

    public int getCritRangeAdd(PlayerCharacter playerCharacter, boolean bl) {
        if (this.theWeaponStats != null) {
            return this.theWeaponStats.getCritRangeAdd(playerCharacter, bl);
        }
        return 0;
    }

    public int getCritRangeDouble(PlayerCharacter playerCharacter, boolean bl) {
        if (this.theWeaponStats != null) {
            return this.theWeaponStats.getCritRangeDouble(playerCharacter, bl);
        }
        return 0;
    }

    public void setDamage(String string) {
        if (this.theWeaponStats == null) {
            this.theWeaponStats = new WeaponEquipment(this);
        }
        this.theWeaponStats.setDamage(string);
    }

    public String getDamage(PlayerCharacter playerCharacter) {
        if (this.theWeaponStats != null) {
            return this.theWeaponStats.getDamage(playerCharacter);
        }
        return "";
    }

    public void setAltCritRange(String string) {
        if (this.theWeaponStats == null) {
            this.theWeaponStats = new WeaponEquipment(this);
        }
        this.theWeaponStats.setAltCritRange(string);
    }

    public String getAltCritRange(PlayerCharacter playerCharacter) {
        if (this.theWeaponStats != null) {
            return this.theWeaponStats.getAltCritRange(playerCharacter);
        }
        return "";
    }

    public void setAltDamage(String string) {
        if (this.theWeaponStats == null) {
            this.theWeaponStats = new WeaponEquipment(this);
        }
        this.theWeaponStats.setAltDamage(string);
    }

    public String getAltDamage(PlayerCharacter playerCharacter) {
        if (this.theWeaponStats != null) {
            this.theWeaponStats.getAltDamage(playerCharacter);
        }
        return "";
    }

    public void setAttacksProgress(boolean bl) {
        if (this.theWeaponStats == null) {
            this.theWeaponStats = new WeaponEquipment(this);
        }
        this.theWeaponStats.setAttacksProgress(bl);
    }

    public boolean isAttacksProgress() {
        if (this.theWeaponStats != null) {
            return this.theWeaponStats.isAttacksProgress();
        }
        return false;
    }

    public int getBonusToDamage(PlayerCharacter playerCharacter, boolean bl) {
        if (this.theWeaponStats != null) {
            return this.theWeaponStats.getBonusToDamage(playerCharacter, bl);
        }
        return 0;
    }

    public int getBonusToHit(PlayerCharacter playerCharacter, boolean bl) {
        if (this.theWeaponStats != null) {
            return this.theWeaponStats.getBonusToHit(playerCharacter, bl);
        }
        return 0;
    }

    public List<String> getRangeList(boolean bl, PlayerCharacter playerCharacter) {
        if (this.theWeaponStats != null) {
            return this.theWeaponStats.getRangeList(bl, playerCharacter);
        }
        return new ArrayList<String>();
    }

    public void setCarried(Float f) {
        this.carried = f;
    }

    public Float getCarried() {
        return this.carried;
    }

    public boolean isEquipped() {
        return this.equipped;
    }

    public Object getChild(int n) {
        return this.getContainedEquipment(n);
    }

    @Override
    public int getChildCount() {
        return this.getContainedEquipmentCount();
    }

    public void setChildType(String string, Float f) {
        if (this.d_childTypes == null) {
            this.d_childTypes = new HashMap<String, Float>();
        }
        this.d_childTypes.put(string, f);
    }

    public Equipment getContainedByIndex(int n) {
        ArrayList<Equipment> arrayList = new ArrayList<Equipment>(this.getContents());
        if (arrayList.size() > 0 && n <= arrayList.size()) {
            return (Equipment)arrayList.get(n);
        }
        return null;
    }

    public Equipment getContainedEquipment(int n) {
        return this.d_containedEquipment.get(n);
    }

    public int getContainedEquipmentCount() {
        if (this.d_containedEquipment == null) {
            return 0;
        }
        return this.d_containedEquipment.size();
    }

    public double getContainedValue(PlayerCharacter playerCharacter) {
        double d = 0.0;
        if (this.getChildCount() == 0) {
            return d;
        }
        for (int i = 0; i < this.getContainedEquipmentCount(); ++i) {
            Equipment equipment = this.getContainedEquipment(i);
            if (equipment.getContainedEquipmentCount() > 0) {
                d += equipment.getContainedValue(playerCharacter);
                continue;
            }
            d += (double)equipment.getCost(playerCharacter).floatValue();
        }
        return d;
    }

    public Float getContainedWeight(PlayerCharacter playerCharacter) {
        return this.getContainedWeight(playerCharacter, false);
    }

    public Float getBaseContainedWeight() {
        return this.getBaseContainedWeight(false);
    }

    public Float getBaseContainedWeight(boolean bl) {
        Float f = Float.valueOf(0.0f);
        if (this.containerConstantWeight && !bl || this.getChildCount() == 0) {
            return f;
        }
        for (int i = 0; i < this.getContainedEquipmentCount(); ++i) {
            Equipment equipment = this.getContainedEquipment(i);
            f = equipment.getContainedEquipmentCount() > 0 ? new Float((double)f.floatValue() + equipment.getBaseWeightAsDouble() + (double)equipment.getBaseContainedWeight().floatValue()) : new Float((double)f.floatValue() + equipment.getBaseWeightAsDouble() * (double)equipment.getCarried().floatValue());
        }
        if (this.containerReduceWeight > 0) {
            f = new Float(f.floatValue() * (this.containerReduceWeight.floatValue() / 100.0f));
        }
        return f;
    }

    public Float getContainedWeight(PlayerCharacter playerCharacter, boolean bl) {
        Float f = Float.valueOf(0.0f);
        if (this.containerConstantWeight && !bl || this.getChildCount() == 0) {
            return f;
        }
        for (int i = 0; i < this.getContainedEquipmentCount(); ++i) {
            Equipment equipment = this.getContainedEquipment(i);
            f = equipment.getContainedEquipmentCount() > 0 ? new Float((double)f.floatValue() + equipment.getWeightAsDouble(playerCharacter) + (double)equipment.getContainedWeight(playerCharacter).floatValue()) : new Float((double)f.floatValue() + equipment.getWeightAsDouble(playerCharacter) * (double)equipment.getCarried().floatValue());
        }
        if (this.containerReduceWeight > 0) {
            f = new Float(f.floatValue() * (this.containerReduceWeight.floatValue() / 100.0f));
        }
        return f;
    }

    public String getContainerByType(String string, String string2) {
        ArrayList<Equipment> arrayList = new ArrayList<Equipment>(this.getContents());
        int n = -1;
        int n2 = 0;
        for (int i = string.length() - 1; i > 0; --i) {
            if (string.charAt(i) >= '0' && string.charAt(i) <= '9') {
                if (n == -1) {
                    n = 0;
                }
                n = Integer.parseInt(string.substring(i));
                ++n2;
                continue;
            }
            i = 0;
        }
        if (n2 > 0) {
            string = string.substring(0, string.length() - n2);
        }
        for (Equipment equipment : arrayList) {
            if (equipment.isType(string)) continue;
            arrayList.remove(equipment);
        }
        if (n < arrayList.size()) {
            if ("SPROP".equals(string2)) {
                return ((Equipment)arrayList.get(n)).getRawSpecialProperties();
            }
            return ((Equipment)arrayList.get(n)).getName();
        }
        return " ";
    }

    public String getContainerContentsString() {
        return this.containerContentsString;
    }

    public Collection<Equipment> getContents() {
        ArrayList<Equipment> arrayList = new ArrayList<Equipment>();
        for (int i = 0; i < this.getContainedEquipmentCount(); ++i) {
            Equipment equipment = this.getContainedEquipment(i);
            if (!(equipment.getCarried().floatValue() > 0.0f)) continue;
            arrayList.add(equipment);
        }
        return arrayList;
    }

    public void setContainer(String string) {
        this.setContainer(null, string);
    }

    public void setContainer(PlayerCharacter playerCharacter, String string) {
        Object object;
        String string2;
        boolean bl = true;
        Float f = Float.valueOf(0.0f);
        this.d_acceptsChildren = true;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2 != null && string2.charAt(0) == '*') {
                this.containerConstantWeight = true;
                string2 = string2.substring(1);
            }
            if (string2 != null && string2.indexOf(37) > 0) {
                int n = string2.indexOf(37);
                object = string2.substring(0, n);
                string2 = string2.substring(n + 1);
                try {
                    this.containerReduceWeight = Integer.valueOf((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    Logging.errorPrint("Error in CONTAINS line: " + string);
                    this.containerReduceWeight = 0;
                }
            }
            try {
                this.containerWeightCapacity = new Float(string2);
            }
            catch (NumberFormatException numberFormatException) {
                Logging.errorPrint("Error in CONTAINS line: " + string);
                this.containerWeightCapacity = Float.valueOf(-1.0f);
            }
        } else {
            this.containerWeightCapacity = Float.valueOf(-1.0f);
        }
        if (!stringTokenizer.hasMoreTokens()) {
            bl = false;
            this.setAcceptsType("Any", Float.valueOf(-1.0f));
        }
        while (stringTokenizer.hasMoreTokens()) {
            Float f2;
            object = new StringTokenizer(stringTokenizer.nextToken(), "=");
            string2 = ((StringTokenizer)object).nextToken();
            if (((StringTokenizer)object).hasMoreTokens()) {
                f2 = new Float(((StringTokenizer)object).nextToken());
                if (bl) {
                    f = new Float(f.floatValue() + f2.floatValue());
                }
            } else {
                bl = false;
                f2 = Float.valueOf(-1.0f);
            }
            if (!"Any".equals(string2) && !"Total".equals(string2)) {
                this.setAcceptsType(string2, f2);
                continue;
            }
            this.setAcceptsType(string2, f2);
        }
        if (!this.acceptsType("Total")) {
            if (!bl) {
                f = Float.valueOf(-1.0f);
            }
            this.setAcceptsType("Total", f);
        }
        this.updateContainerCapacityString();
        this.updateContainerContentsString(playerCharacter);
    }

    public String getContainerCapacityString() {
        return this.containerCapacityString;
    }

    public boolean isContainer() {
        return this.acceptsChildren();
    }

    static {
        Equipment.locationStringList[0] = EQUIPPED_NEITHER_STR;
        Equipment.locationStringList[1] = EQUIPPED_PRIMARY_STR;
        Equipment.locationStringList[2] = EQUIPPED_SECONDARY_STR;
        Equipment.locationStringList[3] = EQUIPPED_BOTH_STR;
        Equipment.locationStringList[4] = EQUIPPED_TWO_HANDS_STR;
        Equipment.locationStringList[5] = EQUIPPED_TEMPBONUS_STR;
        Equipment.locationStringList[6] = CARRIED_NEITHER_STR;
        Equipment.locationStringList[7] = CONTAINED_STR;
        Equipment.locationStringList[8] = NOT_CARRIED_STR;
    }
}

