/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.utils.IntegerKey;
import pcgen.core.utils.ListKey;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.core.utils.StringKey;
import pcgen.persistence.lst.CampaignSourceEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Campaign
extends PObject {
    private Map<String, String> publisherMap = new HashMap<String, String>();
    private Properties options = new Properties();
    private boolean isD20;
    private boolean isLicensed;
    private boolean isLoaded;
    private boolean isOGL;
    private boolean isMature;
    private boolean showInMenu;

    public Campaign() {
        this.listChar.initializeListFor(ListKey.GAME_MODE);
        this.listChar.initializeListFor(ListKey.LICENSE);
        this.listChar.initializeListFor(ListKey.LINE);
        this.listChar.initializeListFor(ListKey.SECTION_15);
        this.listChar.initializeListFor(ListKey.FILE_BIO_SET);
        this.listChar.initializeListFor(ListKey.FILE_CLASS);
        this.listChar.initializeListFor(ListKey.FILE_CLASS_SKILL);
        this.listChar.initializeListFor(ListKey.FILE_CLASS_SPELL);
        this.listChar.initializeListFor(ListKey.FILE_COMPANION_MOD);
        this.listChar.initializeListFor(ListKey.FILE_COVER);
        this.listChar.initializeListFor(ListKey.FILE_DEITY);
        this.listChar.initializeListFor(ListKey.FILE_DOMAIN);
        this.listChar.initializeListFor(ListKey.FILE_EQUIP);
        this.listChar.initializeListFor(ListKey.FILE_EQUIP_MOD);
        this.listChar.initializeListFor(ListKey.FILE_ABILITY);
        this.listChar.initializeListFor(ListKey.FILE_FEAT);
        this.listChar.initializeListFor(ListKey.FILE_KIT);
        this.listChar.initializeListFor(ListKey.FILE_LANGUAGE);
        this.listChar.initializeListFor(ListKey.FILE_LST_EXCLUDE);
        this.listChar.initializeListFor(ListKey.FILE_PCC);
        this.listChar.initializeListFor(ListKey.FILE_RACE);
        this.listChar.initializeListFor(ListKey.FILE_REQ_SKILL);
        this.listChar.initializeListFor(ListKey.FILE_SKILL);
        this.listChar.initializeListFor(ListKey.FILE_SPELL);
        this.listChar.initializeListFor(ListKey.FILE_TEMPLATE);
        this.listChar.initializeListFor(ListKey.FILE_WEAPON_PROF);
    }

    public void addAllAbilityFiles(List<CampaignSourceEntry> list) {
        this.listChar.addAllToListFor(ListKey.FILE_ABILITY, list);
    }

    public void addAllBioSetFiles(List<CampaignSourceEntry> list) {
        this.listChar.addAllToListFor(ListKey.FILE_BIO_SET, list);
    }

    public void addAllClassFiles(List<CampaignSourceEntry> list) {
        this.listChar.addAllToListFor(ListKey.FILE_CLASS, list);
    }

    public void addAllClassSkillFiles(List<CampaignSourceEntry> list) {
        this.listChar.addAllToListFor(ListKey.FILE_CLASS_SKILL, list);
    }

    public void addAllClassSpellFiles(List<CampaignSourceEntry> list) {
        this.listChar.addAllToListFor(ListKey.FILE_CLASS_SPELL, list);
    }

    public void addAllCompanionModFiles(List<CampaignSourceEntry> list) {
        this.listChar.addAllToListFor(ListKey.FILE_COMPANION_MOD, list);
    }

    public void addAllCoverFiles(List<CampaignSourceEntry> list) {
        this.listChar.addAllToListFor(ListKey.FILE_COVER, list);
    }

    public void addAllDeityFiles(List<CampaignSourceEntry> list) {
        this.listChar.addAllToListFor(ListKey.FILE_DEITY, list);
    }

    public void addAllDomainFiles(List<CampaignSourceEntry> list) {
        this.listChar.addAllToListFor(ListKey.FILE_DOMAIN, list);
    }

    public void addAllEquipFiles(List<CampaignSourceEntry> list) {
        this.listChar.addAllToListFor(ListKey.FILE_EQUIP, list);
    }

    public void addAllEquipModFiles(List<CampaignSourceEntry> list) {
        this.listChar.addAllToListFor(ListKey.FILE_EQUIP_MOD, list);
    }

    public void addAllFeatFiles(List<CampaignSourceEntry> list) {
        this.listChar.addAllToListFor(ListKey.FILE_FEAT, list);
    }

    public void addAllKitFiles(List<CampaignSourceEntry> list) {
        this.listChar.addAllToListFor(ListKey.FILE_KIT, list);
    }

    public void addAllLanguageFiles(List<CampaignSourceEntry> list) {
        this.listChar.addAllToListFor(ListKey.FILE_LANGUAGE, list);
    }

    public void addAllLstExcludeFiles(List<CampaignSourceEntry> list) {
        this.listChar.addAllToListFor(ListKey.FILE_LST_EXCLUDE, list);
    }

    public void addAllPccFiles(List<URI> list) {
        this.listChar.addAllToListFor(ListKey.FILE_PCC, list);
    }

    public void addAllRaceFiles(List<CampaignSourceEntry> list) {
        this.listChar.addAllToListFor(ListKey.FILE_RACE, list);
    }

    public void addAllReqSkillFiles(List<String> list) {
        this.listChar.addAllToListFor(ListKey.FILE_REQ_SKILL, list);
    }

    public void addAllSkillFiles(List<CampaignSourceEntry> list) {
        this.listChar.addAllToListFor(ListKey.FILE_SKILL, list);
    }

    public void addAllSpellFiles(List<CampaignSourceEntry> list) {
        this.listChar.addAllToListFor(ListKey.FILE_SPELL, list);
    }

    public void addAllTemplateFiles(List<CampaignSourceEntry> list) {
        this.listChar.addAllToListFor(ListKey.FILE_TEMPLATE, list);
    }

    public void addAllWeaponProfFiles(List<CampaignSourceEntry> list) {
        this.listChar.addAllToListFor(ListKey.FILE_WEAPON_PROF, list);
    }

    public void addAbilityFile(CampaignSourceEntry campaignSourceEntry) {
        this.listChar.addToListFor(ListKey.FILE_ABILITY, campaignSourceEntry);
    }

    public void addBioSetFile(CampaignSourceEntry campaignSourceEntry) {
        this.listChar.addToListFor(ListKey.FILE_BIO_SET, campaignSourceEntry);
    }

    public void addClassFile(CampaignSourceEntry campaignSourceEntry) {
        this.listChar.addToListFor(ListKey.FILE_CLASS, campaignSourceEntry);
    }

    public void addClassSkillFile(CampaignSourceEntry campaignSourceEntry) {
        this.listChar.addToListFor(ListKey.FILE_CLASS_SKILL, campaignSourceEntry);
    }

    public void addClassSpellFile(CampaignSourceEntry campaignSourceEntry) {
        this.listChar.addToListFor(ListKey.FILE_CLASS_SPELL, campaignSourceEntry);
    }

    public void addCompanionModFile(CampaignSourceEntry campaignSourceEntry) {
        this.listChar.addToListFor(ListKey.FILE_COMPANION_MOD, campaignSourceEntry);
    }

    public void addCoverFile(CampaignSourceEntry campaignSourceEntry) {
        this.listChar.addToListFor(ListKey.FILE_COVER, campaignSourceEntry);
    }

    public void addDeityFile(CampaignSourceEntry campaignSourceEntry) {
        this.listChar.addToListFor(ListKey.FILE_DEITY, campaignSourceEntry);
    }

    public void addDomainFile(CampaignSourceEntry campaignSourceEntry) {
        this.listChar.addToListFor(ListKey.FILE_DOMAIN, campaignSourceEntry);
    }

    public void addEquipFile(CampaignSourceEntry campaignSourceEntry) {
        this.listChar.addToListFor(ListKey.FILE_EQUIP, campaignSourceEntry);
    }

    public void addEquipModFile(CampaignSourceEntry campaignSourceEntry) {
        this.listChar.addToListFor(ListKey.FILE_EQUIP_MOD, campaignSourceEntry);
    }

    public void addFeatFile(CampaignSourceEntry campaignSourceEntry) {
        this.listChar.addToListFor(ListKey.FILE_FEAT, campaignSourceEntry);
    }

    public void addKitFile(CampaignSourceEntry campaignSourceEntry) {
        this.listChar.addToListFor(ListKey.FILE_KIT, campaignSourceEntry);
    }

    public void addLanguageFile(CampaignSourceEntry campaignSourceEntry) {
        this.listChar.addToListFor(ListKey.FILE_LANGUAGE, campaignSourceEntry);
    }

    public void addLicense(String string) {
        if (string.equals(".CLEAR")) {
            this.listChar.removeListFor(ListKey.LICENSE);
            this.listChar.initializeListFor(ListKey.LICENSE);
        } else {
            this.listChar.addToListFor(ListKey.LICENSE, string);
        }
    }

    public void addLicenseFile(URI uRI) {
        this.listChar.addToListFor(ListKey.LICENSE_FILE, uRI);
    }

    public void addLine(String string) {
        if (string.equals(".CLEAR")) {
            this.listChar.removeListFor(ListKey.LINE);
            this.listChar.initializeListFor(ListKey.LINE);
        } else {
            this.listChar.addToListFor(ListKey.LINE, string);
        }
    }

    public void addLstExcludeFile(CampaignSourceEntry campaignSourceEntry) {
        this.listChar.addToListFor(ListKey.FILE_LST_EXCLUDE, campaignSourceEntry);
    }

    public void addPccFile(URI uRI) {
        this.listChar.addToListFor(ListKey.FILE_PCC, uRI);
    }

    public void addRaceFile(CampaignSourceEntry campaignSourceEntry) {
        this.listChar.addToListFor(ListKey.FILE_RACE, campaignSourceEntry);
    }

    public void addReqSkillFile(String string) {
        this.listChar.addToListFor(ListKey.FILE_REQ_SKILL, string);
    }

    public void addSection15(String string) {
        if (string.equals(".CLEAR")) {
            this.listChar.removeListFor(ListKey.SECTION_15);
            this.listChar.initializeListFor(ListKey.SECTION_15);
        } else {
            this.listChar.addToListFor(ListKey.SECTION_15, string);
        }
    }

    public void addSkillFile(CampaignSourceEntry campaignSourceEntry) {
        this.listChar.addToListFor(ListKey.FILE_SKILL, campaignSourceEntry);
    }

    public void addSpellFile(CampaignSourceEntry campaignSourceEntry) {
        this.listChar.addToListFor(ListKey.FILE_SPELL, campaignSourceEntry);
    }

    public void addTemplateFile(CampaignSourceEntry campaignSourceEntry) {
        this.listChar.addToListFor(ListKey.FILE_TEMPLATE, campaignSourceEntry);
    }

    public void addWeaponProfFile(CampaignSourceEntry campaignSourceEntry) {
        this.listChar.addToListFor(ListKey.FILE_WEAPON_PROF, campaignSourceEntry);
    }

    public List<CampaignSourceEntry> getAbilityFiles() {
        return this.getListFor(ListKey.FILE_ABILITY);
    }

    public List<CampaignSourceEntry> getBioSetFiles() {
        return this.getListFor(ListKey.FILE_BIO_SET);
    }

    public String getBookType() {
        String string = (String)this.stringChar.get(StringKey.BOOK_TYPE);
        return string == null ? "" : string;
    }

    public List<CampaignSourceEntry> getClassFiles() {
        return this.getListFor(ListKey.FILE_CLASS);
    }

    public List<CampaignSourceEntry> getClassSkillFiles() {
        return this.getListFor(ListKey.FILE_CLASS_SKILL);
    }

    public List<CampaignSourceEntry> getClassSpellFiles() {
        return this.getListFor(ListKey.FILE_CLASS_SPELL);
    }

    public List<CampaignSourceEntry> getCompanionModFiles() {
        return this.getListFor(ListKey.FILE_COMPANION_MOD);
    }

    public List<CampaignSourceEntry> getCoverFiles() {
        return this.getListFor(ListKey.FILE_COVER);
    }

    public List<CampaignSourceEntry> getDeityFiles() {
        return this.getListFor(ListKey.FILE_DEITY);
    }

    public String getDestination() {
        String string = (String)this.stringChar.get(StringKey.DESTINATION);
        return string == null ? "" : string;
    }

    public List<CampaignSourceEntry> getDomainFiles() {
        return this.getListFor(ListKey.FILE_DOMAIN);
    }

    public List<CampaignSourceEntry> getEquipFiles() {
        return this.getListFor(ListKey.FILE_EQUIP);
    }

    public List<CampaignSourceEntry> getEquipModFiles() {
        return this.getListFor(ListKey.FILE_EQUIP_MOD);
    }

    public List<CampaignSourceEntry> getFeatFiles() {
        return this.getListFor(ListKey.FILE_FEAT);
    }

    public List<String> getGameModes() {
        return this.getListFor(ListKey.GAME_MODE);
    }

    public String getGameModeString() {
        StringBuffer stringBuffer = new StringBuffer();
        List<String> list = this.getListFor(ListKey.GAME_MODE);
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            stringBuffer.append(string);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public String getGenre() {
        String string = (String)this.stringChar.get(StringKey.GENRE);
        return string == null ? "" : string;
    }

    public String getHelp() {
        String string = (String)this.stringChar.get(StringKey.HELP);
        return string == null ? "" : string;
    }

    public String getInfoText() {
        String string = (String)this.stringChar.get(StringKey.INFO_TEXT);
        return string == null ? "" : string;
    }

    public List<CampaignSourceEntry> getKitFiles() {
        return this.getListFor(ListKey.FILE_KIT);
    }

    public List<CampaignSourceEntry> getLanguageFiles() {
        return this.getListFor(ListKey.FILE_LANGUAGE);
    }

    public List<String> getLicenses() {
        return this.getListFor(ListKey.LICENSE);
    }

    public String getLicenseString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.getListFor(ListKey.LICENSE)) {
            stringBuffer.append(string).append("<br>");
        }
        return stringBuffer.toString();
    }

    public List<URI> getLicenseFiles() {
        return this.getListFor(ListKey.LICENSE_FILE);
    }

    public List<String> getLines() {
        return this.getListFor(ListKey.LINE);
    }

    public List<CampaignSourceEntry> getLstExcludeFiles() {
        return this.getListFor(ListKey.FILE_LST_EXCLUDE);
    }

    public List<URI> getPccFiles() {
        return this.getListFor(ListKey.FILE_PCC);
    }

    public String getPubNameLong() {
        String string = (String)this.stringChar.get(StringKey.PUB_NAME_LONG);
        return string == null ? "" : string;
    }

    public String getPubNameShort() {
        String string = (String)this.stringChar.get(StringKey.PUB_NAME_SHORT);
        return string == null ? "" : string;
    }

    public String getPubNameWeb() {
        String string = (String)this.stringChar.get(StringKey.PUB_NAME_WEB);
        return string == null ? "" : string;
    }

    public List<CampaignSourceEntry> getRaceFiles() {
        return this.getListFor(ListKey.FILE_RACE);
    }

    public int getRank() {
        Integer n = (Integer)this.integerChar.get(IntegerKey.RANK);
        return n == null ? 9 : n;
    }

    public List<String> getReqSkillFiles() {
        return this.getListFor(ListKey.FILE_REQ_SKILL);
    }

    public List<String> getSection15s() {
        return this.getListFor(ListKey.SECTION_15);
    }

    public String getSection15String() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.getListFor(ListKey.SECTION_15)) {
            stringBuffer.append(string).append("<br>");
        }
        return stringBuffer.toString();
    }

    public String getSetting() {
        String string = (String)this.stringChar.get(StringKey.SETTING);
        return string == null ? "" : string;
    }

    public List<CampaignSourceEntry> getSkillFiles() {
        return this.getListFor(ListKey.FILE_SKILL);
    }

    public List<CampaignSourceEntry> getSpellFiles() {
        return this.getListFor(ListKey.FILE_SPELL);
    }

    public List<CampaignSourceEntry> getTemplateFiles() {
        return this.getListFor(ListKey.FILE_TEMPLATE);
    }

    public List<CampaignSourceEntry> getWeaponProfFiles() {
        return this.getListFor(ListKey.FILE_WEAPON_PROF);
    }

    public boolean isGameMode(String string) {
        return this.listChar.containsInList(ListKey.GAME_MODE, string);
    }

    public boolean isGameMode(List<String> list) {
        for (String string : list) {
            if (!this.listChar.containsInList(ListKey.GAME_MODE, string)) continue;
            return true;
        }
        return false;
    }

    public void setBookType(String string) {
        this.stringChar.put(StringKey.BOOK_TYPE, string);
    }

    public void setDestination(String string) {
        this.stringChar.put(StringKey.DESTINATION, string);
    }

    public void setGameMode(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        this.listChar.removeListFor(ListKey.GAME_MODE);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (this.isGameMode(string2)) continue;
            this.listChar.addToListFor(ListKey.GAME_MODE, string2);
        }
    }

    public void setGenre(String string) {
        this.stringChar.put(StringKey.GENRE, string);
    }

    public void setHelp(String string) {
        this.stringChar.put(StringKey.HELP, string);
    }

    public void setInfoText(String string) {
        this.stringChar.put(StringKey.INFO_TEXT, string);
    }

    public void setPubNameLong(String string) {
        this.addPublisher("LONG:" + string);
        this.stringChar.put(StringKey.PUB_NAME_LONG, string);
    }

    public void setPubNameShort(String string) {
        this.addPublisher("SHORT:" + string);
        this.stringChar.put(StringKey.PUB_NAME_SHORT, string);
    }

    public void setPubNameWeb(String string) {
        this.addPublisher("WEB:" + string);
        this.stringChar.put(StringKey.PUB_NAME_WEB, string);
    }

    public void setRank(int n) {
        this.integerChar.put(IntegerKey.RANK, n);
    }

    public void setSetting(String string) {
        this.stringChar.put(StringKey.SETTING, string);
    }

    public boolean isD20() {
        return this.isD20;
    }

    public void setIsD20(boolean bl) {
        this.isD20 = bl;
    }

    public void setIsLicensed(boolean bl) {
        this.isLicensed = bl;
    }

    public void setIsLoaded(boolean bl) {
        this.isLoaded = bl;
    }

    public void setIsOGL(boolean bl) {
        this.isOGL = bl;
    }

    public void setIsMature(boolean bl) {
        this.isMature = bl;
    }

    public boolean isLicensed() {
        return this.isLicensed;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public boolean isOGL() {
        return this.isOGL;
    }

    public boolean isMature() {
        return this.isMature;
    }

    public void setOptions(Properties properties) {
        this.options = properties;
    }

    public Properties getOptions() {
        return this.options;
    }

    public List<String> getOptionsList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.options != null) {
            Enumeration<?> enumeration = this.options.propertyNames();
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement().toString());
            }
        }
        return arrayList;
    }

    public Map<String, String> getPublisherMap() {
        return this.publisherMap;
    }

    public String getPublisherWithKey(String string) {
        String string2 = this.publisherMap.get(string);
        return string2 != null ? string2 : "";
    }

    public void setShowInMenu(boolean bl) {
        this.showInMenu = bl;
    }

    @Override
    public Campaign getSourceCampaign() {
        return this;
    }

    public void addPublisher(String string) {
        String string2 = string.startsWith("PUBNAME") ? string.substring(7) : string;
        String string3 = string2.substring(0, string2.indexOf(":"));
        this.publisherMap.put(string3, string2.substring(string2.indexOf(":") + 1));
    }

    public boolean canShowInMenu() {
        return this.showInMenu;
    }

    public List<Campaign> getSubCampaigns() {
        List<URI> list = this.getPccFiles();
        ArrayList<Campaign> arrayList = new ArrayList<Campaign>(list.size());
        for (URI uRI : list) {
            Campaign campaign = Globals.getCampaignByURI(uRI, true);
            arrayList.add(campaign);
        }
        return arrayList;
    }

    @Override
    public Campaign clone() {
        Campaign campaign = null;
        try {
            campaign = (Campaign)super.clone();
            campaign.options = (Properties)this.options.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ShowMessageDelegate.showMessageDialog(cloneNotSupportedException.getMessage(), "PCGen", MessageType.ERROR);
        }
        return campaign;
    }
}

