/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.AbilityInfo;
import pcgen.core.Categorisable;
import pcgen.core.EquipmentUtilities;
import pcgen.core.Globals;
import pcgen.core.KitUtilities;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.core.utils.ListKey;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbilityUtilities {
    private AbilityUtilities() {
    }

    private static void addChoicesToAbility(Ability ability, List<String> list) {
        for (String string : list) {
            if (!ability.canAddAssociation(string)) continue;
            ability.addAssociated(string);
        }
    }

    public static Ability addCloneOfAbilityToListwithChoices(Ability ability, List<String> list, List<Ability> list2) {
        Ability ability2 = null;
        if (ability != null && (ability.isMultiples() || AbilityUtilities.getAbilityFromList(list2, ability) == null)) {
            ability2 = ability.clone();
            if (list != null) {
                AbilityUtilities.addChoicesToAbility(ability2, list);
            }
            list2.add(ability2);
        }
        return ability2;
    }

    public static Ability addCloneOfGlobalAbilityToListWithChoices(List<Ability> list, String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        EquipmentUtilities.getUndecoratedName(string2, arrayList);
        Ability ability = AbilityUtilities.getAbilityFromList(list, "FEAT", string2, Ability.Nature.ANY);
        if (ability == null && (ability = AbilityUtilities.cloneGlobalAbility(string, string2)) != null) {
            list.add(ability);
        }
        if (ability != null) {
            AbilityUtilities.addChoicesToAbility(ability, arrayList);
        }
        return ability;
    }

    public static Ability addCloneOfGlobalAbilityToListWithChoices(List<Ability> list, AbilityCategory abilityCategory, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        EquipmentUtilities.getUndecoratedName(string, arrayList);
        Ability ability = AbilityUtilities.getAbilityFromList(list, abilityCategory.getAbilityCategory(), string, Ability.Nature.ANY);
        if (ability == null && (ability = AbilityUtilities.cloneGlobalAbility(abilityCategory.getAbilityCategory(), string)) != null) {
            list.add(ability);
        }
        if (ability != null) {
            AbilityUtilities.addChoicesToAbility(ability, arrayList);
        }
        return ability;
    }

    public static Ability addVirtualAbility(Ability ability, List<String> list, List<Ability> list2, PCLevelInfo pCLevelInfo) {
        if (ability == null) {
            return null;
        }
        Ability ability2 = AbilityUtilities.addCloneOfAbilityToListwithChoices(ability, list, list2);
        if (ability2 != null) {
            ability2.setFeatType(Ability.Nature.VIRTUAL);
            ability2.clearPreReq();
            if (pCLevelInfo != null) {
                pCLevelInfo.addObject(ability2);
            }
        }
        return ability2;
    }

    public static Ability addVirtualAbility(String string, String string2, List<Ability> list, PCLevelInfo pCLevelInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = EquipmentUtilities.getUndecoratedName(string2, arrayList);
        Ability ability = Globals.getAbilityKeyed(string, string3);
        return AbilityUtilities.addVirtualAbility(ability, arrayList, list, pCLevelInfo);
    }

    public static boolean areSameAbility(Categorisable categorisable, Categorisable categorisable2) {
        if (categorisable == null || categorisable2 == null) {
            return false;
        }
        boolean bl = AbilityUtilities.getIsMultiples(categorisable);
        boolean bl2 = AbilityUtilities.getIsMultiples(categorisable2);
        boolean bl3 = false;
        if (bl && bl2) {
            String string;
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            String string2 = EquipmentUtilities.getUndecoratedName(categorisable.getKeyName(), arrayList);
            bl3 = string2.compareToIgnoreCase(string = EquipmentUtilities.getUndecoratedName(categorisable2.getKeyName(), arrayList2)) == 0;
        } else {
            if (bl || bl2) {
                return false;
            }
            bl3 = categorisable.getKeyName().compareToIgnoreCase(categorisable2.getKeyName()) == 0;
        }
        return bl3 && categorisable.getCategory().compareToIgnoreCase(categorisable2.getCategory()) == 0;
    }

    public static boolean areSameAbility(Categorisable categorisable, String string) {
        if (categorisable == null || string == null) {
            return false;
        }
        AbilityInfo abilityInfo = new AbilityInfo(categorisable.getCategory(), string);
        return AbilityUtilities.areSameAbility(categorisable, abilityInfo);
    }

    public static boolean areSameAbility(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null) {
            return false;
        }
        AbilityInfo abilityInfo = new AbilityInfo(string, string2);
        return AbilityUtilities.areSameAbility((Categorisable)abilityInfo, string3);
    }

    private static Ability cloneGlobalAbility(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = EquipmentUtilities.getUndecoratedName(string2, arrayList);
        Ability ability = Globals.getAbilityKeyed(string, string2);
        if (ability == null && string3.length() != 0) {
            ability = Globals.getAbilityKeyed(string, string3);
        }
        if (ability == null) {
            Logging.errorPrint("Attempted to add unknown feat: " + string2);
        } else {
            ability = ability.clone();
            if (arrayList.size() > 0) {
                AbilityUtilities.addChoicesToAbility(ability, arrayList);
            }
        }
        return ability;
    }

    public static int finaliseAbility(Ability ability, String string, PlayerCharacter playerCharacter, boolean n, boolean bl, AbilityCategory abilityCategory) {
        int n2;
        int n3;
        double d = (double)ability.getAssociatedCount() * ability.getCost(playerCharacter);
        boolean bl2 = false;
        if (bl && (n != 0 || ability.isMultiples())) {
            if ("".equals(string) || string == null) {
                bl2 = ability.modChoices(playerCharacter, n != 0, abilityCategory);
            } else if (n != 0) {
                if (ability.canAddAssociation(string)) {
                    ability.addAssociated(string);
                }
            } else {
                ability.removeAssociated(string);
            }
        }
        ability.modifyChoice(playerCharacter);
        if (n != 0) {
            List<String> list = ability.getSafeListFor(ListKey.KITS);
            for (n3 = 0; n3 < list.size(); ++n3) {
                KitUtilities.makeKitSelections(0, list.get(n3), 1, playerCharacter);
            }
        }
        boolean bl3 = false;
        int n4 = ability.isMultiples() && bl ? (ability.getAssociatedCount() > 0 ? 1 : 0) : (n3 = n);
        if (n3 == 0) {
            bl3 = playerCharacter.removeRealAbility(abilityCategory, ability);
            playerCharacter.removeNaturalWeapons(ability);
            for (n2 = 0; n2 < ability.templatesAdded().size(); ++n2) {
                playerCharacter.removeTemplate(playerCharacter.getTemplateKeyed(ability.templatesAdded().get(n2)));
            }
            ability.subAddsForLevel(-9, playerCharacter);
        }
        if (bl && !bl2) {
            if (n == 0 && !ability.isMultiples() && bl3) {
                if (abilityCategory == AbilityCategory.FEAT) {
                    d += ability.getCost(playerCharacter);
                }
            } else if (n != 0 && !ability.isMultiples()) {
                d -= ability.getCost(playerCharacter);
            } else {
                n2 = ability.getAssociatedCount();
                for (Ability ability2 : playerCharacter.getRealAbilitiesList(AbilityCategory.FEAT)) {
                    if (!ability2.getKeyName().equalsIgnoreCase(ability.getKeyName())) continue;
                    n2 = ability2.getAssociatedCount();
                }
                d -= (double)n2 * ability.getCost(playerCharacter);
            }
            if (abilityCategory == AbilityCategory.FEAT) {
                playerCharacter.adjustAbilities(abilityCategory, BigDecimal.valueOf(d));
            }
        }
        playerCharacter.setAutomaticAbilitiesStable(null, false);
        playerCharacter.adjustMoveRates();
        if (n != 0 && !playerCharacter.isImporting()) {
            ability.globalChecks(false, playerCharacter);
            ability.checkRemovals(playerCharacter);
        }
        return n3 != 0 ? 1 : 0;
    }

    public static Ability getAbilityFromList(List<Ability> list, Categorisable categorisable) {
        return AbilityUtilities.getAbilityFromList(list, categorisable, Ability.Nature.ANY);
    }

    public static Ability getAbilityFromList(List<Ability> list, Categorisable categorisable, Ability.Nature nature) {
        if (list.isEmpty()) {
            return null;
        }
        for (Ability ability : list) {
            if (!AbilityUtilities.areSameAbility((Categorisable)ability, categorisable) || nature != Ability.Nature.ANY && ability.getFeatType() != nature) continue;
            return ability;
        }
        return null;
    }

    public static Ability getAbilityFromList(List<Ability> list, String string, String string2, Ability.Nature nature) {
        AbilityInfo abilityInfo = new AbilityInfo(string, string2);
        return AbilityUtilities.getAbilityFromList(list, abilityInfo, nature);
    }

    private static boolean getIsMultiples(Categorisable categorisable) {
        if (categorisable instanceof Ability) {
            return ((Ability)categorisable).isMultiples();
        }
        if (categorisable instanceof AbilityInfo) {
            Ability ability = ((AbilityInfo)categorisable).getAbility();
            if (ability == null) {
                return false;
            }
            return ability.isMultiples();
        }
        return false;
    }

    public static int modAbility(PlayerCharacter playerCharacter, PCLevelInfo pCLevelInfo, Ability ability, String string, boolean bl, AbilityCategory abilityCategory) {
        if (ability == null) {
            Logging.errorPrint("Can't process null Ability");
            return bl ? 1 : 0;
        }
        if (playerCharacter.isNotImporting()) {
            playerCharacter.getSpellList();
        }
        List<Ability> list = playerCharacter.getRealAbilitiesList(abilityCategory);
        Ability ability2 = AbilityUtilities.getAbilityFromList(list, ability);
        if (bl && ability2 == null) {
            ability2 = ability.clone();
            playerCharacter.addAbility(abilityCategory, ability2, pCLevelInfo);
            ability2.getTemplates(playerCharacter.isImporting(), playerCharacter);
        }
        if (ability2 == null) {
            Logging.errorPrint("Can't process ability " + ability + " not present in character.");
            return bl ? 1 : 0;
        }
        return AbilityUtilities.finaliseAbility(ability2, string, playerCharacter, bl, true, abilityCategory);
    }

    public static int modFeat(PlayerCharacter playerCharacter, PCLevelInfo pCLevelInfo, String string, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = !bl2;
        if (!playerCharacter.isImporting()) {
            playerCharacter.getSpellList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = string;
        String string3 = EquipmentUtilities.getUndecoratedName(string, arrayList);
        String string4 = arrayList.size() > 0 ? arrayList.get(0) : "";
        Ability ability = playerCharacter.getRealFeatKeyed(string2);
        if (ability == null) {
            ability = playerCharacter.getRealFeatKeyed(string3);
            if (!bl3 && ability != null && string4.length() != 0) {
                bl3 = true;
            }
        }
        if (ability == null && bl) {
            ability = Globals.getAbilityKeyed("FEAT", string3);
            if (ability == null && (ability = Globals.getAbilityKeyed("FEAT", string2)) != null) {
                string4 = "";
            }
            if (ability == null) {
                Logging.errorPrint("Feat not found: " + string2);
                return bl ? 1 : 0;
            }
            ability = ability.clone();
            playerCharacter.addFeat(ability, pCLevelInfo);
            ability.getTemplates(playerCharacter.isImporting(), playerCharacter);
        }
        if (ability == null) {
            return bl ? 1 : 0;
        }
        return AbilityUtilities.finaliseAbility(ability, string4, playerCharacter, bl, bl3, AbilityCategory.FEAT);
    }

    static void modFeatsFromList(PlayerCharacter playerCharacter, PCLevelInfo pCLevelInfo, String string, boolean bl, boolean bl2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string2 = stringTokenizer.nextToken();
            Ability ability = playerCharacter.getFeatNamed(string2);
            StringTokenizer stringTokenizer2 = null;
            if (ability != null) continue;
            ability = Globals.getAbilityKeyed("FEAT", string2);
            if (ability == null) {
                stringTokenizer2 = new StringTokenizer(string2, "()", true);
                object = stringTokenizer2.nextToken();
                int n = ((String)object).length() + 1;
                int n2 = string2.lastIndexOf(41);
                stringTokenizer2 = n <= string2.length() ? (n2 >= n ? new StringTokenizer(string2.substring(n, n2), ",") : new StringTokenizer(string2.substring(n), ",")) : null;
                string2 = ((String)object).replace('(', ' ').replace(')', ' ').trim();
            } else {
                object = playerCharacter.getFeatKeyed(ability.getKeyName());
                if (object != null) {
                    ability = object;
                } else {
                    ability = ability.clone();
                    playerCharacter.addFeat(ability, pCLevelInfo);
                }
            }
            if (ability == null) {
                if (!bl) {
                    return;
                }
                ability = Globals.getAbilityKeyed("FEAT", string2);
                if (ability == null) {
                    Logging.errorPrint("Feat not found in PlayerCharacter.modFeatsFromList: " + string2);
                    return;
                }
                ability = ability.clone();
                playerCharacter.addFeat(ability, pCLevelInfo);
            }
            if (stringTokenizer2 != null && stringTokenizer2.hasMoreTokens()) {
                while (stringTokenizer2.hasMoreTokens()) {
                    string2 = stringTokenizer2.nextToken();
                    if ("DEITYWEAPON".equals(string2)) {
                        object = null;
                        if (playerCharacter.getDeity() != null) {
                            object = Globals.getWeaponProfKeyed(playerCharacter.getDeity().getFavoredWeapon());
                        }
                        if (object == null) continue;
                        if (bl) {
                            ability.addAssociated(((PObject)object).getKeyName());
                            continue;
                        }
                        ability.removeAssociated(((PObject)object).getKeyName());
                        continue;
                    }
                    if (bl) {
                        ability.addAssociated(string2);
                        continue;
                    }
                    ability.removeAssociated(string2);
                }
                continue;
            }
            if (!bl2 && !ability.isMultiples()) {
                if (bl) {
                    playerCharacter.adjustFeats(ability.getCost(playerCharacter));
                } else {
                    playerCharacter.adjustFeats(-ability.getCost(playerCharacter));
                }
            }
            AbilityUtilities.modFeat(playerCharacter, pCLevelInfo, string2, bl, bl2);
        }
        playerCharacter.setAutomaticAbilitiesStable(null, false);
    }

    public static Ability retrieveAbilityKeyed(String string, String string2) {
        Ability ability = Globals.getAbilityKeyed(string, string2);
        if (ability != null) {
            return ability;
        }
        String string3 = EquipmentUtilities.removeChoicesFromName(string2);
        ability = Globals.getAbilityKeyed(string, string3);
        if (ability != null) {
            return ability;
        }
        return null;
    }
}

