/*
 * Decompiled with CFR 0.152.
 */
package gmgen.util;

import gmgen.util.OperatingSystem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import pcgen.core.Globals;

public final class MiscUtilities {
    private static Properties localization = new Properties();

    private MiscUtilities() {
    }

    public static boolean isAbsolutePath(String string) {
        if (MiscUtilities.isURL(string)) {
            return true;
        }
        if (string.startsWith("~/") || string.startsWith("~" + File.separator) || string.equals("~")) {
            return true;
        }
        if (OperatingSystem.isDOSDerived()) {
            if (string.length() == 2 && string.charAt(1) == ':') {
                return true;
            }
            if (string.length() > 2 && string.charAt(1) == ':' && string.charAt(2) == '\\') {
                return true;
            }
            if (string.startsWith("\\\\")) {
                return true;
            }
        } else if (OperatingSystem.isUnix() && string.length() > 0 && string.charAt(0) == '/') {
            return true;
        }
        return false;
    }

    public static final String getLocalization(String string, Object[] objectArray) {
        if (string == null) {
            return null;
        }
        if (objectArray == null) {
            return localization.getProperty(string);
        }
        String string2 = localization.getProperty(string);
        if (string2 == null) {
            return null;
        }
        return MessageFormat.format(string2, objectArray);
    }

    public static Cursor setBusyCursor(Component component) {
        Cursor cursor = component.getCursor();
        component.setCursor(Cursor.getPredefinedCursor(3));
        return cursor;
    }

    public static void setCursor(Component component, Cursor cursor) {
        component.setCursor(cursor);
    }

    public static String getParentOfPath(String string) {
        int n = Math.max(0, string.length() - 2);
        int n2 = string.lastIndexOf(File.separatorChar, n);
        if (n2 == -1) {
            n2 = string.lastIndexOf(47, n);
        }
        if (n2 == -1) {
            n2 = string.lastIndexOf(58);
        }
        return string.substring(0, n2 + 1);
    }

    public static boolean isURL(String string) {
        int n = Math.max(string.indexOf(File.separatorChar), string.indexOf(47));
        if (n == 0) {
            return false;
        }
        if (n == 2) {
            return false;
        }
        int n2 = string.indexOf(58);
        if (n2 <= 1) {
            return false;
        }
        return n == -1 || n2 <= n;
    }

    public static String buildToVersion(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = 0;
        if (stringTokenizer.hasMoreTokens()) {
            n = Integer.parseInt(stringTokenizer.nextToken());
        }
        int n2 = 0;
        if (stringTokenizer.hasMoreTokens()) {
            n2 = Integer.parseInt(stringTokenizer.nextToken());
        }
        int n3 = 0;
        if (stringTokenizer.hasMoreTokens()) {
            n3 = Integer.parseInt(stringTokenizer.nextToken());
        }
        int n4 = 0;
        if (stringTokenizer.hasMoreTokens()) {
            n4 = Integer.parseInt(stringTokenizer.nextToken());
        }
        int n5 = 0;
        if (stringTokenizer.hasMoreTokens()) {
            n5 = Integer.parseInt(stringTokenizer.nextToken());
        }
        return "" + n + "." + n2 + (n3 != 99 ? "pre" + n3 : (n4 != 99 ? "rc" + n4 : (n5 != 0 ? "." + n5 : "final")));
    }

    public static String canonPath(String string) {
        String string2 = string;
        if (string2.startsWith("file://")) {
            string2 = string2.substring("file://".length());
        } else if (string2.startsWith("file:")) {
            string2 = string2.substring("file:".length());
        } else if (MiscUtilities.isURL(string2)) {
            return string2;
        }
        if (File.separatorChar == '\\') {
            string2 = string2.replace('/', '\\');
        }
        if (string2.startsWith("~" + File.separator)) {
            string2 = string2.substring(2);
            String string3 = System.getProperty("user.home");
            if (string3.endsWith(File.separator)) {
                return string3 + string2;
            }
            return string3 + File.separator + string2;
        }
        if (string2.equals("~")) {
            return System.getProperty("user.home");
        }
        return string2;
    }

    public static String classToFile(String string) {
        return string.replace('.', '/').concat(".class");
    }

    public static int compareStrings(String string, String string2, boolean bl) {
        char[] cArray = string.toCharArray();
        char[] cArray2 = string2.toCharArray();
        int n = Math.min(cArray.length, cArray2.length);
        int n2 = 0;
        for (int i = 0; n2 < n && i < n; ++n2, ++i) {
            char c = cArray[n2];
            char c2 = cArray2[i];
            if (Character.isDigit(c) && Character.isDigit(c2) && c != '0' && c2 != '0') {
                int n3;
                int n4 = i + 1;
                for (n3 = n2 + 1; n3 < cArray.length && Character.isDigit(cArray[n3]); ++n3) {
                }
                while (n4 < cArray2.length && Character.isDigit(cArray2[n4])) {
                    ++n4;
                }
                int n5 = n3 - n2;
                int n6 = n4 - i;
                if (n5 > n6) {
                    return 1;
                }
                if (n5 < n6) {
                    return -1;
                }
                for (int j = 0; j < n5; ++j) {
                    c = cArray[n2 + j];
                    c2 = cArray2[i + j];
                    if (c == c2) continue;
                    return c - c2;
                }
                n2 = n3 - 1;
                i = n4 - 1;
                continue;
            }
            if (bl) {
                c = Character.toLowerCase(c);
                c2 = Character.toLowerCase(c2);
            }
            if (c == c2) continue;
            return c - c2;
        }
        return cArray.length - cArray2.length;
    }

    public static String constructPath(String string, String string2) {
        if (MiscUtilities.isAbsolutePath(string2)) {
            return MiscUtilities.canonPath(string2);
        }
        if (OperatingSystem.isDOSDerived()) {
            if (string2.length() == 2 && string2.charAt(1) == ':') {
                return string2;
            }
            if (string2.length() > 2 && string2.charAt(1) == ':' && string2.charAt(2) != '\\') {
                return MiscUtilities.canonPath(string2.substring(0, 2) + '\\' + string2.substring(2));
            }
        }
        String string3 = ".." + File.separator;
        String string4 = "." + File.separator;
        String string5 = string == null ? Globals.getDefaultPath() : string;
        String string6 = string2;
        while (true) {
            if (string6.equals(".")) {
                return string5;
            }
            if (string6.equals("..")) {
                return MiscUtilities.getParentOfPath(string5);
            }
            if (string6.startsWith(string3) || string6.startsWith("../")) {
                string5 = MiscUtilities.getParentOfPath(string5);
                string6 = string6.substring(3);
                continue;
            }
            if (!string6.startsWith(string4)) break;
            string6 = string6.substring(2);
        }
        if (OperatingSystem.isDOSDerived() && string6.startsWith("\\")) {
            string5 = string5.substring(0, 2);
        }
        if (!string6.endsWith("\\") && !string6.endsWith("/")) {
            string5 = string5 + File.separator;
        }
        return string5 + string6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File file, File file2) throws IOException {
        Object object;
        if (!file.exists()) {
            throw new IOException("FileCopy: no such source file: " + file.getPath());
        }
        if (!file.isFile()) {
            throw new IOException("FileCopy: can't copy directory: " + file.getPath());
        }
        if (!file.canRead()) {
            throw new IOException("FileCopy: source file is unreadable: " + file.getPath());
        }
        if (file2.isDirectory()) {
            file2 = new File(file2, file.getName());
        }
        if (file2.exists()) {
            if (!file2.canWrite()) {
                throw new IOException("FileCopy: destination file is unwriteable: " + file2.getPath());
            }
            int n = JOptionPane.showConfirmDialog(null, "Overwrite existing file " + file2.getPath(), "File Exists", 0, 3);
            if (n != 0) {
                throw new IOException("FileCopy: existing file was not overwritten.");
            }
        } else {
            String string = file2.getParent();
            if (string == null) {
                string = Globals.getDefaultPath();
            }
            if (!((File)(object = new File(string))).exists()) {
                throw new IOException("FileCopy: destination directory doesn't exist: " + string);
            }
            if (((File)object).isFile()) {
                throw new IOException("FileCopy: destination is not a directory: " + string);
            }
            if (!((File)object).canWrite()) {
                throw new IOException("FileCopy: destination directory is unwriteable: " + string);
            }
        }
        FileInputStream fileInputStream = null;
        object = null;
        try {
            int n;
            fileInputStream = new FileInputStream(file);
            object = new FileOutputStream(file2);
            byte[] byArray = new byte[4096];
            while ((n = fileInputStream.read(byArray)) != -1) {
                ((FileOutputStream)object).write(byArray, 0, n);
            }
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (object != null) {
                try {
                    ((FileOutputStream)object).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String fileToClass(String string) {
        char[] cArray = string.toCharArray();
        for (int i = cArray.length - 6; i >= 0; --i) {
            if (cArray[i] != '/') continue;
            cArray[i] = 46;
        }
        return new String(cArray, 0, cArray.length - 6);
    }

    public static String colorToHex(Color color) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int n = color.getRGB();
        char[] cArray2 = new char[7];
        cArray2[0] = 35;
        for (int i = 6; i >= 1; --i) {
            cArray2[i] = cArray[n & 0xF];
            n >>>= 4;
        }
        return new String(cArray2);
    }
}

