/*
 * Decompiled with CFR 0.152.
 */
package gmgen.pluginmgr;

import gmgen.pluginmgr.GMBComponent;
import gmgen.pluginmgr.GMBMessage;
import gmgen.pluginmgr.messages.ComponentAddedMessage;
import gmgen.pluginmgr.messages.ComponentRemovedMessage;
import java.util.ArrayList;
import java.util.List;
import pcgen.util.Logging;

public class GMBus {
    private static List<GMBComponent> components = new ArrayList<GMBComponent>();
    private static GMBComponent[] copyComponents;

    private GMBus() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GMBComponent[] getComponents() {
        List<GMBComponent> list = components;
        synchronized (list) {
            if (copyComponents == null) {
                copyComponents = components.toArray(new GMBComponent[components.size()]);
            }
            return copyComponents;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToBus(GMBComponent gMBComponent) {
        List<GMBComponent> list = components;
        synchronized (list) {
            components.add(gMBComponent);
            GMBus.send(new ComponentAddedMessage(gMBComponent));
            copyComponents = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFromBus(GMBComponent gMBComponent) {
        List<GMBComponent> list = components;
        synchronized (list) {
            components.remove(gMBComponent);
            GMBus.send(new ComponentRemovedMessage(gMBComponent));
            copyComponents = null;
        }
    }

    public static void send(GMBMessage gMBMessage) {
        Logging.debugPrint(gMBMessage.toString());
        for (GMBComponent gMBComponent : GMBus.getComponents()) {
            try {
                if (gMBComponent == gMBMessage.getSource()) continue;
                gMBComponent.handleMessage(gMBMessage);
                if (!gMBMessage.isVetoed()) continue;
                break;
            }
            catch (Throwable throwable) {
                Logging.errorPrint("Exception while sending message on GMBus:" + throwable.getMessage(), throwable);
            }
        }
        gMBMessage.getSource().handleMessage(gMBMessage);
    }
}

