/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;
import pcgen.util.Delta;

public class HitDiceToken
extends Token {
    public static final String TOKENNAME = "HITDICE";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String string, PlayerCharacter playerCharacter, ExportHandler exportHandler) {
        String string2 = "";
        if (TOKENNAME.equals(string)) {
            string2 = HitDiceToken.getHitDiceToken(playerCharacter);
        } else if ("HITDICE.SHORT".equals(string)) {
            string2 = HitDiceToken.getShortToken(playerCharacter);
        }
        return string2;
    }

    public static String getHitDiceToken(PlayerCharacter playerCharacter) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        if (playerCharacter.getRace().hitDice(playerCharacter) > 0) {
            stringBuffer.append("(");
            stringBuffer.append(Integer.toString(playerCharacter.getRace().hitDice(playerCharacter)));
            stringBuffer.append("d");
            stringBuffer.append(Integer.toString(playerCharacter.getRace().getHitDiceSize(playerCharacter)));
            stringBuffer.append(")");
            string = "+";
        }
        for (PCClass pCClass : playerCharacter.getClassList()) {
            LinkedHashMap<Integer, Integer> linkedHashMap = new LinkedHashMap<Integer, Integer>();
            for (int i = 0; i < pCClass.getLevel(); ++i) {
                int n = pCClass.getLevelHitDie(playerCharacter, i + 1);
                Integer n2 = (Integer)((HashMap)linkedHashMap).get(n);
                if (n2 == null) {
                    linkedHashMap.put(n, 1);
                    continue;
                }
                linkedHashMap.put(n, n2 + 1);
            }
            Set set = ((HashMap)linkedHashMap).keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                Integer n3 = (Integer)((HashMap)linkedHashMap).get(n);
                stringBuffer.append(string);
                stringBuffer.append("(");
                stringBuffer.append(n3).append("d").append(n);
                stringBuffer.append(")");
                string = "+";
            }
        }
        int n = (int)playerCharacter.getStatBonusTo("HP", "BONUS");
        int n4 = playerCharacter.getRace().hitDice(playerCharacter);
        int n5 = 0;
        n5 = playerCharacter.isMonsterDefault() ? playerCharacter.totalNonMonsterLevels() : playerCharacter.getTotalLevels();
        n *= n4 + n5;
        if ((n += (int)playerCharacter.getTotalBonusTo("HP", "CURRENTMAX")) != 0) {
            stringBuffer.append(Delta.toString((int)n));
        }
        return stringBuffer.toString();
    }

    public static String getShortToken(PlayerCharacter playerCharacter) {
        int n = playerCharacter.getRace().hitDice(playerCharacter);
        for (PCClass pCClass : playerCharacter.getClassList()) {
            LinkedHashMap<Integer, Integer> linkedHashMap = new LinkedHashMap<Integer, Integer>();
            for (int i = 0; i < pCClass.getLevel(); ++i) {
                int n2 = pCClass.getLevelHitDie(playerCharacter, i + 1);
                Integer n3 = (Integer)((HashMap)linkedHashMap).get(n2);
                if (n3 == null) {
                    linkedHashMap.put(n2, 1);
                    continue;
                }
                linkedHashMap.put(n2, n3 + 1);
            }
            Set set = ((HashMap)linkedHashMap).keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                int n4 = (Integer)iterator.next();
                n += ((Integer)((HashMap)linkedHashMap).get(n4)).intValue();
            }
        }
        return String.valueOf(n);
    }
}

