/*
 * Decompiled with CFR 0.152.
 */
package pauker.program.gui.swing;

import java.awt.Dimension;
import java.util.ResourceBundle;
import javax.swing.JTable;
import pauker.program.Lesson;
import tools.PreferredSizesTableModel;

public class StatisticTableModel
extends PreferredSizesTableModel {
    private Lesson lesson;
    private ResourceBundle strings;

    public StatisticTableModel(Lesson lesson, JTable statisticTable, Dimension maxDimension) {
        super(statisticTable, maxDimension);
        this.lesson = lesson;
        this.strings = ResourceBundle.getBundle("pauker/Strings");
        this.addColumn(this.strings.getString("Status"));
        this.addColumn(this.strings.getString("Quantity"));
        this.addColumn(this.strings.getString("Expired"));
        this.initSizes();
    }

    public void updateExpiredCells() {
        for (int i = 3; i < this.lesson.getNumberOfLongTermBatches(); ++i) {
            this.fireTableCellUpdated(i, 2);
        }
    }

    public void setLesson(Lesson lesson) {
        this.lesson = lesson;
        this.fireTableDataChanged();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public int getRowCount() {
        if (this.lesson == null) {
            return 0;
        }
        return this.lesson.getNumberOfLongTermBatches() + 2;
    }

    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                if (row == 0) {
                    return this.strings.getString("Not_learned");
                }
                if (row == this.lesson.getNumberOfLongTermBatches() + 1) {
                    return this.strings.getString("Summary");
                }
                return this.strings.getString("Batch") + ' ' + row;
            }
            case 1: {
                if (row == 0) {
                    return this.lesson.getUnlearnedBatch().getNumberOfCards();
                }
                if (row == this.lesson.getNumberOfLongTermBatches() + 1) {
                    return this.lesson.getNumberOfCards();
                }
                return this.lesson.getLongTermBatch(row - 1).getNumberOfCards();
            }
            case 2: {
                if (row == 0) {
                    return "";
                }
                if (row == this.lesson.getNumberOfLongTermBatches() + 1) {
                    return this.lesson.getNumberOfExpiredCards();
                }
                return this.lesson.getLongTermBatch(row - 1).getNumberOfExpiredCards();
            }
        }
        return "xxx";
    }
}

