/*
 * Decompiled with CFR 0.152.
 */
package pauker.program.gui.swing;

import edu.stanford.ejalbert.BrowserLauncher;
import edu.stanford.ejalbert.exception.BrowserLaunchingInitializingException;
import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import java.util.zip.GZIPOutputStream;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import pauker.program.Batch;
import pauker.program.Card;
import pauker.program.CardSide;
import pauker.program.Lesson;
import pauker.program.LongTermBatch;
import pauker.program.Pauker;
import pauker.program.SearchEngine;
import pauker.program.SearchHit;
import pauker.program.SummaryBatch;
import pauker.program.gui.swing.AboutDialog;
import pauker.program.gui.swing.BatchListCellRenderer;
import pauker.program.gui.swing.BatchListModel;
import pauker.program.gui.swing.DonateDialog;
import pauker.program.gui.swing.EditCardDialog;
import pauker.program.gui.swing.EditCardPanel;
import pauker.program.gui.swing.FileChooserAccessory;
import pauker.program.gui.swing.FontDialog;
import pauker.program.gui.swing.ImportDialog;
import pauker.program.gui.swing.NewCardDialog;
import pauker.program.gui.swing.OpenFileDialog;
import pauker.program.gui.swing.PaukerFileView;
import pauker.program.gui.swing.SearchDialog;
import pauker.program.gui.swing.SettingsDialog;
import pauker.program.gui.swing.StatisticPanel;
import pauker.program.gui.swing.UpdateLayoutList;
import tools.PathNodeDiff;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaukerFrame
extends JFrame
implements DocumentListener,
PropertyChangeListener {
    public static final Color red = new Color(255, 180, 180);
    public static final Color yellow = new Color(255, 255, 180);
    public static final Color green = new Color(180, 255, 180);
    public static final Color blue = new Color(180, 180, 255);
    public static final Font defaultFont = new Font("Dialog", 0, 12);
    public static final ResourceBundle strings = ResourceBundle.getBundle("pauker/Strings");
    private static final int MAX_RECENT_FILES = 4;
    private boolean somethingHasChanged;
    private boolean recentFilesHaveChanged;
    private static boolean modalDialogVisible;
    private FileFilter xmlFileFilter;
    private FileFilter csvFileFilter;
    private Toolkit defautToolkit;
    private static final String preferencesPathName = "/org/pauker";
    private Pauker.RepeatingStrategy repeatingStrategy;
    private Pauker.PutbackStrategy putBackStrategy;
    private int ustmTime;
    private int stmTime;
    private boolean matchCase;
    private boolean lineWrapping;
    private int splitOrientation;
    private int searchLimit;
    private boolean playRingTone;
    private List<String> recentFiles;
    private String lastAccessedDirectory;
    private boolean showTimer;
    private Font frontSideFont;
    private Color frontSideForeground;
    private Color frontSideBackground;
    private Font reverseSideFont;
    private Color reverseSideForeground;
    private Color reverseSideBackground;
    private boolean repeatByTyping;
    private boolean keepNewCardDialogOpen;
    private String titleString;
    private String currentTitle;
    private String currentFileName;
    private OpenFileDialog openFileDialog;
    private JFileChooser saveFileChooser;
    private String stmTimeString;
    private int currentUSTMTime;
    private int currentSTMTime;
    private AudioClip ringTone;
    private Timer ustmTimer = new Timer(1000, new ActionListener(){

        public void actionPerformed(ActionEvent evt) {
            PaukerFrame.this.currentUSTMTime++;
            if (PaukerFrame.this.currentUSTMTime < PaukerFrame.this.getUstmTime()) {
                PaukerFrame.this.ustmTimerProgressBar.setValue(100 * PaukerFrame.this.currentUSTMTime / PaukerFrame.this.getUstmTime());
                PaukerFrame.this.ustmTimerProgressBar.setString(PaukerFrame.this.currentUSTMTime + " / " + PaukerFrame.this.getUstmTime() + " " + strings.getString("Seconds"));
            } else {
                PaukerFrame.this.ustmTimer.stop();
                PaukerFrame.this.ustmTimerProgressBar.setValue(0);
                PaukerFrame.this.ustmTimerProgressBar.setString("");
                if (Pauker.getLearningPhase() == Pauker.LearningPhase.WAITING_FOR_USTM) {
                    PaukerFrame.this.setState(0);
                    PaukerFrame.this.toFront();
                    PaukerFrame.this.defautToolkit.beep();
                    if (PaukerFrame.this.isPlayRingTone()) {
                        PaukerFrame.this.ringTone.play();
                    }
                    PaukerFrame.this.repeatUSTMCards();
                }
            }
        }
    });
    private Timer stmTimer = new Timer(1000, new ActionListener(){

        public void actionPerformed(ActionEvent evt) {
            PaukerFrame.this.currentSTMTime++;
            if (PaukerFrame.this.currentSTMTime < PaukerFrame.this.getStmTime()) {
                PaukerFrame.this.stmTimerProgressBar.setValue(100 * PaukerFrame.this.currentSTMTime / PaukerFrame.this.getStmTime());
                String currentTimeString = PaukerFrame.getMinSecString(PaukerFrame.this.currentSTMTime);
                PaukerFrame.this.stmTimerProgressBar.setString(currentTimeString + " / " + PaukerFrame.this.stmTimeString + " " + strings.getString("Minutes"));
                if (Pauker.getLearningPhase() == Pauker.LearningPhase.WAITING_FOR_STM) {
                    PaukerFrame.this.setTitle(currentTimeString + " " + PaukerFrame.this.currentTitle);
                }
            } else {
                PaukerFrame.this.stmTimer.stop();
                PaukerFrame.this.stmTimerProgressBar.setValue(0);
                PaukerFrame.this.stmTimerProgressBar.setString("");
                if (Pauker.getLearningPhase() == Pauker.LearningPhase.WAITING_FOR_STM) {
                    PaukerFrame.this.setState(0);
                    PaukerFrame.this.toFront();
                    PaukerFrame.this.defautToolkit.beep();
                    if (PaukerFrame.this.isPlayRingTone()) {
                        PaukerFrame.this.ringTone.play();
                    }
                    PaukerFrame.this.repeatSTMCards();
                }
            }
        }
    });
    private Timer expirationTimer = new Timer(60000, new ActionListener(){

        public void actionPerformed(ActionEvent evt) {
            PaukerFrame.this.currentLesson.refreshExpiration();
            PaukerFrame.this.statisticPanel.setLesson(PaukerFrame.this.currentLesson);
            if (Pauker.getLearningPhase() == Pauker.LearningPhase.NOTHING) {
                PaukerFrame.this.repeatCardsButton.setEnabled(PaukerFrame.this.currentLesson.getNumberOfExpiredCards() > 0);
            }
        }
    });
    private Lesson currentLesson;
    private Card currentCard;
    private HelpBroker helpbroker;
    private TitledBorder batchPanelBorder;
    private BatchListModel batchListModel;
    private BatchListCellRenderer batchListCellRenderer;
    private Batch loadedBatch;
    private SearchDialog searchDialog;
    private NewCardDialog newCardDialog;
    private Document aboutDocument;
    private boolean settingAboutText;
    private SearchEngine searchEngine;
    private int searchPatternLength;
    private Random random;
    private JPanel USTMLearningPanel;
    private JMenuItem aboutLessonMenuItem;
    private JPanel aboutPanel;
    private JMenuItem aboutProgramMenuItem;
    private JScrollPane aboutScrollPane;
    private JTextArea aboutTextArea;
    private JButton addCardButton;
    private JMenuItem addCardsMenuitem;
    private JMenuItem ascendingBackMenuItem;
    private JMenuItem ascendingBatchMenuItem;
    private JMenuItem ascendingExpiredMenuItem;
    private JMenuItem ascendingFrontMenuItem;
    private JMenuItem ascendingLearnedMenuItem;
    private JMenu ascendingMenu;
    private JMenuItem ascendingRepeatMenuItem;
    private UpdateLayoutList batchList;
    private JPanel batchListPanel;
    private JScrollPane batchListScrollPane;
    private JPanel batchPanel;
    private JPanel buttonPanel;
    private JButton cancelLearningButton;
    private JButton cancelRepeatingButton;
    private JPanel cancelRepeatingPanel;
    private JPanel cardPanel;
    private JPanel cardsButtonPanel;
    private JMenuItem configureMenuItem;
    private JMenuItem descendingBackMenuItem;
    private JMenuItem descendingBatchMenuItem;
    private JMenuItem descendingExpiredMenuItem;
    private JMenuItem descendingFrontMenuItem;
    private JMenuItem descendingLearnedMenuItem;
    private JMenu descendingMenu;
    private JMenuItem descendingRepeatMenuItem;
    private JLabel didYouKnowLabel;
    private JMenuItem donateMenuItem;
    private JButton downButton;
    private JButton editCardButton;
    private JButton editTypingErrorButton;
    private JButton editWhileMemorizingButton;
    private JButton editWhileRepeatingButton;
    private JMenuItem exitMenuItem;
    private JLabel explanationLabel;
    private JMenu extraMenu;
    private JMenu fileMenu;
    private JMenuItem flipCardSidesMenuItem;
    private JButton fontButton;
    private JButton forgetButton;
    private JPanel fullTimerPanel;
    private JMenu helpMenu;
    private JMenuItem helpMenuItem;
    private JMenuItem hideToolBarMenuItem;
    private JButton ignoreErrorButton;
    private JMenuItem importMenuItem;
    private JLabel infoLabel;
    private JLabel inputLabel;
    private JPanel inputPanel;
    private JScrollPane inputScrollPane;
    private JTextArea inputTextArea;
    private JLabel insertReverseSideLabel;
    private JButton instantRepeatButton;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JButton learnNewCardsButton;
    private JPanel learningCardPanel;
    private JLabel learningLabel;
    private JPanel learningMenuHeaderPanel;
    private JButton learningMethodButton;
    private JPanel learningPanel;
    private JPopupMenu learningPopupMenu;
    private JPanel learningStatusPanel;
    private JPanel lessonPanel;
    private JMenuBar mainMenuBar;
    private JButton moveBackButton;
    private JButton newButton;
    private JMenuItem newMenuItem;
    private JButton nextNewCardButton;
    private JPanel noTimerPanel;
    private JButton openButton;
    private JMenuItem openMenuItem;
    private JPanel overviewPanel;
    private JToggleButton pauseLearningToggleButton;
    private JPanel questionButtonPanel;
    private JLabel questionLabel;
    private JPanel questionPanel;
    private JButton randomizeButton;
    private JMenu recentFilesMenu;
    private JMenuItem remeberMenuItem;
    private JButton removeCardButton;
    private JButton removeRepeatingButton;
    private JButton removeUstmButton;
    private JButton repeatCardsButton;
    private JButton repeatSTMButton;
    private JButton repeatUSTMButton;
    private JPanel repeatingAskPanel;
    private JPanel repeatingButtonCardPanel;
    private JLabel repeatingCardFrontSideLabel;
    private JPanel repeatingCardPanel;
    private JLabel repeatingCardReverseSideLabel;
    private JPanel repeatingFrontSidePanel;
    private JScrollPane repeatingFrontSideScrollPane;
    private JTextArea repeatingFrontSideTextArea;
    private JLabel repeatingHintLabel;
    private JPanel repeatingInsertPanel;
    private JScrollPane repeatingInsertScrollPane;
    private JTextArea repeatingInsertTextArea;
    private JButton repeatingNoButton;
    private JPanel repeatingPanel;
    private JPanel repeatingReverseSidePanel;
    private JScrollPane repeatingReverseSideScrollPane;
    private JTextArea repeatingReverseSideTextArea;
    private JPanel repeatingShowPanel;
    private JSplitPane repeatingSplitPane;
    private JButton repeatingYesButton;
    private JMenuItem resetMenuItem;
    private JLabel reverseLabel;
    private JPanel reversePanel;
    private JScrollPane reverseScrollPane;
    private JTextArea reverseTextArea;
    private JMenuItem saveAsMenuItem;
    private JButton saveButton;
    private JMenuItem saveMenuItem;
    private JButton searchButton;
    private JSeparator separator1;
    private JSeparator separator2;
    private JSeparator separator4;
    private JButton showMeButton;
    private JPanel showMeButtonPanel;
    private JCheckBox showTimerCheckBox;
    private JCheckBoxMenuItem showToolBarMenuItem;
    private JButton sortButton;
    private JLabel sortingLabel;
    private JPanel sortingMenuHeaderPanel;
    private JPopupMenu sortingPopupMenu;
    private JSplitPane splitPane;
    private StatisticPanel statisticPanel;
    private JLabel stmTimerLabel;
    private JProgressBar stmTimerProgressBar;
    private JButton switchRepeatingLayoutButton;
    private JButton switchUSTMLayoutButton;
    private JPanel timerCardPanel;
    private JPanel timerGridPanel1;
    private JPanel timerGridPanel2;
    private JPanel timerPanel;
    private JToolBar toolBar;
    private JPopupMenu toolBarPopupMenu;
    private JLabel transitionExplanationLabel;
    private JButton transitionOKButton;
    private JPanel transitionPanel;
    private JLabel transitoinIconLabel;
    private JMenuItem typeMenuItem;
    private JPanel typingErrorPanel;
    private JSplitPane typingErrorSplitPane;
    private JButton typingOKButton;
    private JPanel typingOKPanel;
    private JButton upButton;
    private JLabel ustmFrontSideLabel;
    private JPanel ustmFrontSidePanel;
    private JScrollPane ustmFrontSideScrollPane;
    private JTextArea ustmFrontSideTextArea;
    private JLabel ustmReverseSideLabel;
    private JPanel ustmReverseSidePanel;
    private JScrollPane ustmReverseSideScrollPane;
    private JTextArea ustmReverseSideTextArea;
    private JSplitPane ustmSplitPane;
    private JLabel ustmTimerLabel;
    private JProgressBar ustmTimerProgressBar;
    private JLabel waitForSTMLabel;
    private JPanel waitForSTMPanel;
    private JLabel waitForUSTMLabel;
    private JPanel waitForUSTMPanel;

    private static String getMinSecString(int seconds) {
        int minuntes = seconds / 60;
        int remainingSeconds = seconds - minuntes * 60;
        return minuntes + ":" + (remainingSeconds < 10 ? "0" : "") + remainingSeconds;
    }

    public PaukerFrame() {
        String recentFile;
        KeyboardFocusManager currentKeyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        currentKeyboardFocusManager.addPropertyChangeListener(this);
        this.currentLesson = new Lesson();
        this.searchEngine = new SearchEngine();
        this.recentFiles = new ArrayList<String>();
        Preferences preferences = Preferences.userRoot().node(preferencesPathName);
        for (int i = 0; i < 4 && (recentFile = preferences.get("RECENT_FILE_" + i, null)) != null; ++i) {
            this.recentFiles.add(recentFile);
            this.recentFilesHaveChanged = true;
        }
        this.lastAccessedDirectory = preferences.get("LAST_DIRECTORY", "");
        this.showTimer = preferences.getBoolean("SHOW_TIMER", true);
        this.repeatingStrategy = Pauker.RepeatingStrategy.values()[preferences.getInt("REPEATING_STRATEGY", Pauker.RepeatingStrategy.OLDEST_FIRST.ordinal())];
        this.putBackStrategy = Pauker.PutbackStrategy.values()[preferences.getInt("PUTBACK_STRATEGY", Pauker.PutbackStrategy.ON_TOP.ordinal())];
        this.ustmTime = preferences.getInt("USTM_TIME", 18);
        this.stmTime = preferences.getInt("STM_TIME", 720);
        this.matchCase = preferences.getBoolean("MATCH_CASE", true);
        this.lineWrapping = preferences.getBoolean("LINE_WRAPPING", false);
        this.splitOrientation = preferences.getInt("SPLIT_ORIENTATION", 1);
        this.searchLimit = preferences.getInt("SEARCH_LIMIT", 1);
        this.searchEngine.setSearchLimit(this.searchLimit);
        this.playRingTone = preferences.getBoolean("PLAY_RINGTONE", true);
        int dividerLocation = preferences.getInt("MAIN_DIVIDER_LOCATION", -1);
        String frontSideFontFamily = preferences.get("FRONTSIDE_FONT_FAMILY", "Default");
        int frontSideFontStyle = preferences.getInt("FRONTSIDE_FONT_STYLE", 0);
        int frontSizeFontSize = preferences.getInt("FRONTSIDE_FONT_SIZE", 12);
        this.frontSideFont = new Font(frontSideFontFamily, frontSideFontStyle, frontSizeFontSize);
        int frontSideForegroundRGB = preferences.getInt("FRONTSIDE_FOREGROUND", Color.BLACK.getRGB());
        this.frontSideForeground = new Color(frontSideForegroundRGB);
        int frontSideBackgroundRGB = preferences.getInt("FRONTSIDE_BACKGROUND", Color.WHITE.getRGB());
        this.frontSideBackground = new Color(frontSideBackgroundRGB);
        String reverseSideFontFamily = preferences.get("REVERSESIDE_FONT_FAMILY", "Default");
        int reverseSideFontStyle = preferences.getInt("REVERSESIDE_FONT_STYLE", 0);
        int reverseSizeFontSize = preferences.getInt("REVERSESIDE_FONT_SIZE", 12);
        this.reverseSideFont = new Font(reverseSideFontFamily, reverseSideFontStyle, reverseSizeFontSize);
        int reverseSideForegroundRGB = preferences.getInt("REVERSESIDE_FOREGROUND", Color.BLACK.getRGB());
        this.reverseSideForeground = new Color(reverseSideForegroundRGB);
        int reverseSideBackgroundRGB = preferences.getInt("REVERSESIDE_BACKGROUND", Color.WHITE.getRGB());
        this.reverseSideBackground = new Color(reverseSideBackgroundRGB);
        this.repeatByTyping = preferences.getBoolean("REPEAT_BY_TYPING", false);
        this.keepNewCardDialogOpen = preferences.getBoolean("KEEP_NEW_CARD_WINDOW_OPEN", false);
        String toolbarConstraints = preferences.get("TOOLBAR_CONSTRAINTS", "North");
        boolean toolbarVisible = preferences.getBoolean("TOOLBAR_VISIBLE", true);
        this.titleString = strings.getString("ProgramTitle");
        String versionString = strings.getString("Pauker_Version");
        this.titleString = MessageFormat.format(this.titleString, versionString);
        this.ringTone = Applet.newAudioClip(this.getClass().getResource("/pauker/sounds/phone.wav"));
        this.defautToolkit = Toolkit.getDefaultToolkit();
        this.initComponents();
        if (toolbarConstraints.equals("North")) {
            this.getContentPane().add((Component)this.toolBar, "North");
        } else if (toolbarConstraints.equals("West")) {
            this.toolBar.setOrientation(1);
            this.getContentPane().add((Component)this.toolBar, "West");
        } else if (toolbarConstraints.equals("South")) {
            this.getContentPane().add((Component)this.toolBar, "South");
        } else if (toolbarConstraints.equals("East")) {
            this.toolBar.setOrientation(1);
            this.getContentPane().add((Component)this.toolBar, "East");
        }
        this.showToolBarMenuItem.setSelected(toolbarVisible);
        this.batchListCellRenderer = new BatchListCellRenderer(this, this.batchList.getSelectionBackground());
        this.batchListModel = new BatchListModel();
        this.batchList.setCellRenderer(this.batchListCellRenderer);
        this.batchList.setModel(this.batchListModel);
        this.setIconImage(new ImageIcon(this.getClass().getResource("/pauker/icons/icon.png")).getImage());
        this.currentTitle = this.titleString;
        this.fileMenu.setMnemonic(strings.getString("File_Mnemonic").charAt(0));
        this.extraMenu.setMnemonic(strings.getString("Extra_Mnemonic").charAt(0));
        this.helpMenu.setMnemonic(strings.getString("Help_Mnemonic").charAt(0));
        this.setFocusTraversalPolicy(new MyFocusTraversalPolicy());
        this.statisticPanel.setPaukerFrame(this);
        this.showTimerCheckBox.setSelected(this.showTimer);
        this.showPanel(this.cardPanel, "overviewPanel");
        this.showPanel(this.lessonPanel, "aboutPanel");
        this.batchPanelBorder = (TitledBorder)this.batchPanel.getBorder();
        this.setLineWrap(this.lineWrapping);
        Dimension smallDimension = new Dimension(10, 10);
        this.aboutPanel.setPreferredSize(smallDimension);
        this.batchListPanel.setPreferredSize(smallDimension);
        Dimension statisticPanelSize = this.statisticPanel.getSize();
        statisticPanelSize.width = 10;
        this.statisticPanel.setMinimumSize(statisticPanelSize);
        this.aboutDocument = this.aboutTextArea.getDocument();
        this.aboutDocument.addDocumentListener(this);
        this.xmlFileFilter = new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String path = file.getPath().toLowerCase();
                return path.endsWith(".xml.gz") || path.endsWith(".pau.gz") || path.endsWith(".pau");
            }

            public String getDescription() {
                return strings.getString("PaukerFileFilter_Description");
            }
        };
        this.csvFileFilter = new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getPath().toLowerCase().endsWith(".csv");
            }

            public String getDescription() {
                return strings.getString("CSVFileFilter_Description");
            }
        };
        this.openFileDialog = new OpenFileDialog(this, this.xmlFileFilter, this.csvFileFilter);
        this.saveFileChooser = new JFileChooser();
        this.saveFileChooser.addChoosableFileFilter(this.xmlFileFilter);
        this.saveFileChooser.addChoosableFileFilter(this.csvFileFilter);
        this.saveFileChooser.setFileFilter(this.xmlFileFilter);
        FileChooserAccessory fileChooserAccessory = new FileChooserAccessory();
        this.saveFileChooser.setAccessory(fileChooserAccessory);
        this.saveFileChooser.addPropertyChangeListener(fileChooserAccessory);
        this.saveFileChooser.setFileView(new PaukerFileView());
        try {
            URL helpSetURL = HelpSet.findHelpSet(this.getClass().getClassLoader(), "pauker/help/HelpSet.hs");
            HelpSet helpSet = new HelpSet(this.getClass().getClassLoader(), helpSetURL);
            this.helpbroker = helpSet.createHelpBroker();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        AbstractAction focusTypingOKButtonAction = new AbstractAction(){

            public void actionPerformed(ActionEvent event) {
                PaukerFrame.this.typingOKButton.requestFocusInWindow();
            }
        };
        KeyStroke tabKeyStroke = KeyStroke.getKeyStroke(9, 0);
        InputMap inputMap = this.repeatingInsertTextArea.getInputMap();
        inputMap.put(tabKeyStroke, "tabAction");
        ActionMap actionMap = this.repeatingInsertTextArea.getActionMap();
        actionMap.put("tabAction", focusTypingOKButtonAction);
        Dimension preferredStatisticSize = this.statisticPanel.getPreferredSize();
        this.statisticPanel.setMinimumSize(preferredStatisticSize);
        Dimension newSize = new Dimension(preferredStatisticSize);
        newSize.height = 220;
        this.statisticPanel.setPreferredSize(newSize);
        this.expirationTimer.start();
        this.pack();
        if (dividerLocation != -1) {
            int minimumDividerLocation = this.splitPane.getMinimumDividerLocation();
            int maximumDividerLocation = this.splitPane.getMaximumDividerLocation();
            if (0 < dividerLocation && dividerLocation < minimumDividerLocation) {
                this.splitPane.setDividerLocation(minimumDividerLocation);
            } else if (maximumDividerLocation < dividerLocation) {
                this.splitPane.setDividerLocation(maximumDividerLocation);
            } else {
                this.splitPane.setDividerLocation(dividerLocation);
            }
        }
    }

    public int getSplitOrientation() {
        return this.splitOrientation;
    }

    public void setSplitOrientation(int splitOrientation) {
        this.splitOrientation = splitOrientation;
    }

    public boolean isLineWrapping() {
        return this.lineWrapping;
    }

    public void setLineWrapping(boolean lineWrapping) {
        this.lineWrapping = lineWrapping;
    }

    public static void openUrlInBrowser(String url) {
        try {
            List<Object> browserList = Arrays.asList("FireFox", "Konqueror", "Mozilla", "Opera");
            BrowserLauncher launcher = new BrowserLauncher();
            launcher.openURLinBrowser(browserList, url);
        }
        catch (BrowserLaunchingInitializingException ex) {
            ex.printStackTrace();
        }
        catch (UnsupportedOperatingSystemException ex) {
            ex.printStackTrace();
        }
    }

    public static void lazyStringChange(JTextField textField, String newText) {
        if (!textField.getText().equals(newText)) {
            textField.setText(newText);
        }
    }

    public static void lazyStringChange(JLabel label, String newText) {
        if (!label.getText().equals(newText)) {
            label.setText(newText);
        }
    }

    public Lesson getCurrentLesson() {
        return this.currentLesson;
    }

    public static void fillTextAreaWithCardSide(CardSide cardSide, JTextComponent textComponent, boolean resetCaret) {
        Color oldBackgroundColor;
        Color backgroundColor;
        Color oldForegroundColor;
        textComponent.setText(cardSide.getText());
        if (resetCaret) {
            textComponent.setCaretPosition(0);
        }
        PaukerFrame.setFontAndOrientation(cardSide, textComponent);
        Color foregroundColor = cardSide.getForegroundColor();
        if (foregroundColor == null) {
            foregroundColor = Color.black;
        }
        if (!(oldForegroundColor = textComponent.getForeground()).equals(foregroundColor)) {
            textComponent.setForeground(foregroundColor);
        }
        if ((backgroundColor = cardSide.getBackgroundColor()) == null) {
            backgroundColor = Color.white;
        }
        if (!(oldBackgroundColor = textComponent.getBackground()).equals(backgroundColor)) {
            textComponent.setBackground(backgroundColor);
        }
    }

    private static void setFontAndOrientation(CardSide cardSide, JTextComponent textComponent) {
        ComponentOrientation oldOrientation;
        ComponentOrientation orientation;
        Font oldFont;
        Font font = cardSide.getFont();
        if (font == null) {
            font = defaultFont;
        }
        if (!(oldFont = textComponent.getFont()).equals(font)) {
            textComponent.setFont(font);
        }
        if ((orientation = cardSide.getOrientation()) == null) {
            orientation = ComponentOrientation.LEFT_TO_RIGHT;
        }
        if (!(oldOrientation = textComponent.getComponentOrientation()).equals(orientation)) {
            textComponent.setComponentOrientation(orientation);
        }
    }

    public void addCard(Card newCard) {
        this.currentLesson.addCard(newCard);
        this.statisticPanel.setLesson(this.currentLesson);
        if (this.batchList.isShowing() && (this.loadedBatch == this.currentLesson.getSummaryBatch() || this.loadedBatch == this.currentLesson.getUnlearnedBatch())) {
            this.batchListModel.cardAdded();
            this.updateBatchListButtons();
            this.batchList.ensureIndexIsVisible(this.batchListModel.getSize() - 1);
        }
        this.searchEngine.index(newCard);
        this.learnNewCardsButton.setEnabled(true);
        this.searchButton.setEnabled(true);
        boolean hasSeveralCards = this.loadedBatch.getNumberOfCards() > 0;
        this.sortButton.setEnabled(hasSeveralCards);
        this.randomizeButton.setEnabled(hasSeveralCards);
        this.somethingHasChanged();
    }

    public void somethingHasChanged() {
        if (!this.somethingHasChanged) {
            this.somethingHasChanged = true;
            this.currentTitle = '*' + this.currentTitle;
            this.setTitle(this.currentTitle);
            if (Pauker.getLearningPhase() == Pauker.LearningPhase.NOTHING) {
                this.saveButton.setEnabled(true);
                this.saveMenuItem.setEnabled(true);
            }
        }
    }

    public boolean search(String pattern, Card.Element cardSide, boolean matchCase, boolean forward) {
        this.searchPatternLength = pattern.length();
        boolean patternFound = this.loadedBatch.search(pattern, matchCase, cardSide);
        if (patternFound) {
            this.scrollToCurrentSearchHit();
        }
        this.batchPanel.repaint();
        return patternFound;
    }

    public int getSearchPatternLength() {
        return this.searchPatternLength;
    }

    public SearchHit getCurrentSearchHit() {
        if (this.loadedBatch == null) {
            return null;
        }
        return this.loadedBatch.getCurrentSearchHit();
    }

    public boolean continueSearch(boolean forward) {
        if (this.loadedBatch.continueSearch(forward)) {
            this.scrollToCurrentSearchHit();
            this.batchPanel.repaint();
            return true;
        }
        return false;
    }

    private void scrollToCurrentSearchHit() {
        SearchHit currentSearchHit = this.loadedBatch.getCurrentSearchHit();
        if (currentSearchHit != null) {
            Card card = currentSearchHit.getCard();
            int index = this.loadedBatch.indexOf(card);
            this.batchList.ensureIndexIsVisible(index);
        }
    }

    public void setSearchCardSide(Card.Element cardSide) {
        if (this.loadedBatch.setSearchCardSide(cardSide)) {
            this.scrollToCurrentSearchHit();
            this.batchPanel.repaint();
        }
    }

    public void setMatchCase(boolean matchCase) {
        if (this.loadedBatch.setMatchCase(matchCase)) {
            this.scrollToCurrentSearchHit();
            this.batchPanel.repaint();
        }
    }

    public void stopSearching() {
        if (this.loadedBatch != null) {
            this.loadedBatch.stopSearching();
            this.batchPanel.repaint();
        }
    }

    public void loadBatch(Batch batch) {
        this.showPanel(this.lessonPanel, "batchPanel");
        if (batch == this.currentLesson.getSummaryBatch()) {
            this.batchPanelBorder.setTitle(strings.getString("Summary"));
        } else if (batch == this.currentLesson.getUnlearnedBatch()) {
            this.batchPanelBorder.setTitle(strings.getString("Not_learned"));
        } else if (batch instanceof LongTermBatch) {
            LongTermBatch longTermBatch = (LongTermBatch)batch;
            int batchNumber = longTermBatch.getBatchNumber();
            String title = strings.getString("Batch") + ' ' + (batchNumber + 1);
            this.batchPanelBorder.setTitle(title);
        } else {
            throw new RuntimeException("unknown batch type: " + batch);
        }
        this.batchPanel.repaint();
        if (this.loadedBatch != null) {
            String searchPattern = this.loadedBatch.getSearchPattern();
            if (searchPattern == null || searchPattern.length() == 0) {
                batch.stopSearching();
            } else {
                boolean matchCase = this.loadedBatch.getMatchCase();
                Card.Element searchSide = this.loadedBatch.getSearchSide();
                batch.search(searchPattern, matchCase, searchSide);
            }
        }
        this.loadedBatch = batch;
        this.batchListModel.setBatch(batch);
        this.batchList.clearSelection();
        this.updateBatchListButtons();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.textChanged(documentEvent);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.textChanged(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.textChanged(documentEvent);
    }

    private void initComponents() {
        this.sortingMenuHeaderPanel = new JPanel();
        this.sortingLabel = new JLabel();
        this.sortingPopupMenu = new JPopupMenu();
        this.jSeparator1 = new JSeparator();
        this.ascendingMenu = new JMenu();
        this.ascendingFrontMenuItem = new JMenuItem();
        this.ascendingBackMenuItem = new JMenuItem();
        this.ascendingBatchMenuItem = new JMenuItem();
        this.ascendingLearnedMenuItem = new JMenuItem();
        this.ascendingExpiredMenuItem = new JMenuItem();
        this.ascendingRepeatMenuItem = new JMenuItem();
        this.descendingMenu = new JMenu();
        this.descendingFrontMenuItem = new JMenuItem();
        this.descendingBackMenuItem = new JMenuItem();
        this.descendingBatchMenuItem = new JMenuItem();
        this.descendingLearnedMenuItem = new JMenuItem();
        this.descendingExpiredMenuItem = new JMenuItem();
        this.descendingRepeatMenuItem = new JMenuItem();
        this.learningMenuHeaderPanel = new JPanel();
        this.learningLabel = new JLabel();
        this.learningPopupMenu = new JPopupMenu();
        this.jSeparator5 = new JSeparator();
        this.remeberMenuItem = new JMenuItem();
        this.typeMenuItem = new JMenuItem();
        this.questionPanel = new JPanel();
        this.questionLabel = new JLabel();
        this.explanationLabel = new JLabel();
        this.toolBarPopupMenu = new JPopupMenu();
        this.hideToolBarMenuItem = new JMenuItem();
        this.toolBar = new JToolBar();
        this.newButton = new JButton();
        this.openButton = new JButton();
        this.saveButton = new JButton();
        this.splitPane = new JSplitPane();
        this.statisticPanel = new StatisticPanel();
        this.cardPanel = new JPanel();
        this.overviewPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.addCardButton = new JButton();
        this.learnNewCardsButton = new JButton();
        this.repeatCardsButton = new JButton();
        this.lessonPanel = new JPanel();
        this.aboutPanel = new JPanel();
        this.aboutScrollPane = new JScrollPane();
        this.aboutTextArea = new JTextArea();
        this.batchPanel = new JPanel();
        this.cardsButtonPanel = new JPanel();
        this.editCardButton = new JButton();
        this.fontButton = new JButton();
        this.learningMethodButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.sortButton = new JButton();
        this.randomizeButton = new JButton();
        this.instantRepeatButton = new JButton();
        this.forgetButton = new JButton();
        this.removeCardButton = new JButton();
        this.searchButton = new JButton();
        this.batchListPanel = new JPanel();
        this.batchListScrollPane = new JScrollPane();
        this.batchList = new UpdateLayoutList();
        this.learningPanel = new JPanel();
        this.learningCardPanel = new JPanel();
        this.USTMLearningPanel = new JPanel();
        this.ustmSplitPane = new JSplitPane();
        this.ustmFrontSidePanel = new JPanel();
        this.ustmFrontSideLabel = new JLabel();
        this.ustmFrontSideScrollPane = new JScrollPane();
        this.ustmFrontSideTextArea = new JTextArea();
        this.ustmReverseSidePanel = new JPanel();
        this.ustmReverseSideLabel = new JLabel();
        this.ustmReverseSideScrollPane = new JScrollPane();
        this.ustmReverseSideTextArea = new JTextArea();
        this.jSeparator2 = new JSeparator();
        this.editWhileMemorizingButton = new JButton();
        this.switchUSTMLayoutButton = new JButton();
        this.removeUstmButton = new JButton();
        this.nextNewCardButton = new JButton();
        this.repeatingPanel = new JPanel();
        this.repeatingSplitPane = new JSplitPane();
        this.repeatingFrontSidePanel = new JPanel();
        this.repeatingCardFrontSideLabel = new JLabel();
        this.repeatingFrontSideScrollPane = new JScrollPane();
        this.repeatingFrontSideTextArea = new JTextArea();
        this.repeatingReverseSidePanel = new JPanel();
        this.repeatingCardReverseSideLabel = new JLabel();
        this.repeatingCardPanel = new JPanel();
        this.repeatingAskPanel = new JPanel();
        this.repeatingHintLabel = new JLabel();
        this.repeatingShowPanel = new JPanel();
        this.repeatingReverseSideScrollPane = new JScrollPane();
        this.repeatingReverseSideTextArea = new JTextArea();
        this.repeatingInsertPanel = new JPanel();
        this.repeatingInsertScrollPane = new JScrollPane();
        this.repeatingInsertTextArea = new JTextArea();
        this.jSeparator3 = new JSeparator();
        this.editWhileRepeatingButton = new JButton();
        this.switchRepeatingLayoutButton = new JButton();
        this.removeRepeatingButton = new JButton();
        this.repeatingButtonCardPanel = new JPanel();
        this.questionButtonPanel = new JPanel();
        this.didYouKnowLabel = new JLabel();
        this.repeatingYesButton = new JButton();
        this.repeatingNoButton = new JButton();
        this.showMeButtonPanel = new JPanel();
        this.showMeButton = new JButton();
        this.typingOKPanel = new JPanel();
        this.insertReverseSideLabel = new JLabel();
        this.typingOKButton = new JButton();
        this.waitForUSTMPanel = new JPanel();
        this.waitForUSTMLabel = new JLabel();
        this.repeatUSTMButton = new JButton();
        this.waitForSTMPanel = new JPanel();
        this.waitForSTMLabel = new JLabel();
        this.repeatSTMButton = new JButton();
        this.transitionPanel = new JPanel();
        this.transitoinIconLabel = new JLabel();
        this.transitionExplanationLabel = new JLabel();
        this.transitionOKButton = new JButton();
        this.typingErrorPanel = new JPanel();
        this.infoLabel = new JLabel();
        this.typingErrorSplitPane = new JSplitPane();
        this.inputPanel = new JPanel();
        this.inputLabel = new JLabel();
        this.inputScrollPane = new JScrollPane();
        this.inputTextArea = new JTextArea();
        this.reversePanel = new JPanel();
        this.reverseLabel = new JLabel();
        this.reverseScrollPane = new JScrollPane();
        this.reverseTextArea = new JTextArea();
        this.editTypingErrorButton = new JButton();
        this.moveBackButton = new JButton();
        this.ignoreErrorButton = new JButton();
        this.learningStatusPanel = new JPanel();
        this.timerPanel = new JPanel();
        this.pauseLearningToggleButton = new JToggleButton();
        this.cancelLearningButton = new JButton();
        this.showTimerCheckBox = new JCheckBox();
        this.timerCardPanel = new JPanel();
        this.fullTimerPanel = new JPanel();
        this.timerGridPanel1 = new JPanel();
        this.ustmTimerLabel = new JLabel();
        this.stmTimerLabel = new JLabel();
        this.timerGridPanel2 = new JPanel();
        this.ustmTimerProgressBar = new JProgressBar();
        this.stmTimerProgressBar = new JProgressBar();
        this.noTimerPanel = new JPanel();
        this.cancelRepeatingPanel = new JPanel();
        this.cancelRepeatingButton = new JButton();
        this.mainMenuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.newMenuItem = new JMenuItem();
        this.openMenuItem = new JMenuItem();
        this.importMenuItem = new JMenuItem();
        this.recentFilesMenu = new JMenu();
        this.separator1 = new JSeparator();
        this.saveMenuItem = new JMenuItem();
        this.saveAsMenuItem = new JMenuItem();
        this.separator4 = new JSeparator();
        this.resetMenuItem = new JMenuItem();
        this.flipCardSidesMenuItem = new JMenuItem();
        this.separator2 = new JSeparator();
        this.exitMenuItem = new JMenuItem();
        this.extraMenu = new JMenu();
        this.addCardsMenuitem = new JMenuItem();
        this.configureMenuItem = new JMenuItem();
        this.showToolBarMenuItem = new JCheckBoxMenuItem();
        this.helpMenu = new JMenu();
        this.helpMenuItem = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.aboutLessonMenuItem = new JMenuItem();
        this.aboutProgramMenuItem = new JMenuItem();
        this.donateMenuItem = new JMenuItem();
        this.sortingMenuHeaderPanel.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("pauker/Strings");
        this.sortingLabel.setText(bundle.getString("Sorting"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 10, 2, 10);
        this.sortingMenuHeaderPanel.add((Component)this.sortingLabel, gridBagConstraints);
        this.sortingPopupMenu.add(this.sortingMenuHeaderPanel);
        this.sortingPopupMenu.setName("sortingPopupMenu");
        this.sortingPopupMenu.add(this.jSeparator1);
        this.ascendingMenu.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/ascending.png")));
        this.ascendingMenu.setText(bundle.getString("Sort_Ascending"));
        this.ascendingFrontMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/frontSide.png")));
        this.ascendingFrontMenuItem.setText(bundle.getString("By_FrontSide"));
        this.ascendingFrontMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.ascendingFrontMenuItemActionPerformed(evt);
            }
        });
        this.ascendingMenu.add(this.ascendingFrontMenuItem);
        this.ascendingBackMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/reverseSide.png")));
        this.ascendingBackMenuItem.setText(bundle.getString("By_ReverseSide"));
        this.ascendingBackMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.ascendingBackMenuItemActionPerformed(evt);
            }
        });
        this.ascendingMenu.add(this.ascendingBackMenuItem);
        this.ascendingBatchMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/batchAscending.png")));
        this.ascendingBatchMenuItem.setText(bundle.getString("By_Batchnumber"));
        this.ascendingBatchMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.ascendingBatchMenuItemActionPerformed(evt);
            }
        });
        this.ascendingMenu.add(this.ascendingBatchMenuItem);
        this.ascendingLearnedMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/icon.png")));
        this.ascendingLearnedMenuItem.setText(bundle.getString("By_LearnedDate"));
        this.ascendingLearnedMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.ascendingLearnedMenuItemActionPerformed(evt);
            }
        });
        this.ascendingMenu.add(this.ascendingLearnedMenuItem);
        this.ascendingExpiredMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/expired.png")));
        this.ascendingExpiredMenuItem.setText(bundle.getString("By_Expiration"));
        this.ascendingExpiredMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.ascendingExpiredMenuItemActionPerformed(evt);
            }
        });
        this.ascendingMenu.add(this.ascendingExpiredMenuItem);
        this.ascendingRepeatMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/brain_and_key.png")));
        this.ascendingRepeatMenuItem.setText(bundle.getString("By_Repeating_Method"));
        this.ascendingRepeatMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.ascendingRepeatMenuItemActionPerformed(evt);
            }
        });
        this.ascendingMenu.add(this.ascendingRepeatMenuItem);
        this.sortingPopupMenu.add(this.ascendingMenu);
        this.descendingMenu.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/descending.png")));
        this.descendingMenu.setText(bundle.getString("Sort_Descending"));
        this.descendingMenu.setName("descendingMenu");
        this.descendingFrontMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/frontSide.png")));
        this.descendingFrontMenuItem.setText(bundle.getString("By_FrontSide"));
        this.descendingFrontMenuItem.setName("descendingFrontMenuItem");
        this.descendingFrontMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.descendingFrontMenuItemActionPerformed(evt);
            }
        });
        this.descendingMenu.add(this.descendingFrontMenuItem);
        this.descendingBackMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/reverseSide.png")));
        this.descendingBackMenuItem.setText(bundle.getString("By_ReverseSide"));
        this.descendingBackMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.descendingBackMenuItemActionPerformed(evt);
            }
        });
        this.descendingMenu.add(this.descendingBackMenuItem);
        this.descendingBatchMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/batchDescending.png")));
        this.descendingBatchMenuItem.setText(bundle.getString("By_Batchnumber"));
        this.descendingBatchMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.descendingBatchMenuItemActionPerformed(evt);
            }
        });
        this.descendingMenu.add(this.descendingBatchMenuItem);
        this.descendingLearnedMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/icon.png")));
        this.descendingLearnedMenuItem.setText(bundle.getString("By_LearnedDate"));
        this.descendingLearnedMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.descendingLearnedMenuItemActionPerformed(evt);
            }
        });
        this.descendingMenu.add(this.descendingLearnedMenuItem);
        this.descendingExpiredMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/expired.png")));
        this.descendingExpiredMenuItem.setText(bundle.getString("By_Expiration"));
        this.descendingExpiredMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.descendingExpiredMenuItemActionPerformed(evt);
            }
        });
        this.descendingMenu.add(this.descendingExpiredMenuItem);
        this.descendingRepeatMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/brain_and_key.png")));
        this.descendingRepeatMenuItem.setText(bundle.getString("By_Repeating_Method"));
        this.descendingRepeatMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.descendingRepeatMenuItemActionPerformed(evt);
            }
        });
        this.descendingMenu.add(this.descendingRepeatMenuItem);
        this.sortingPopupMenu.add(this.descendingMenu);
        this.learningMenuHeaderPanel.setLayout(new GridBagLayout());
        this.learningLabel.setText(bundle.getString("Repeating_Method"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 10, 2, 10);
        this.learningMenuHeaderPanel.add((Component)this.learningLabel, gridBagConstraints);
        this.learningPopupMenu.add(this.learningMenuHeaderPanel);
        this.learningPopupMenu.add(this.jSeparator5);
        this.remeberMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/smallbrain.png")));
        this.remeberMenuItem.setText(bundle.getString("Repeat_By_Remembering"));
        this.remeberMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.remeberMenuItemActionPerformed(evt);
            }
        });
        this.learningPopupMenu.add(this.remeberMenuItem);
        this.typeMenuItem.setText(bundle.getString("Repeat_By_Typing"));
        this.typeMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/key_enter.png")));
        this.typeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.typeMenuItemActionPerformed(evt);
            }
        });
        this.learningPopupMenu.add(this.typeMenuItem);
        this.questionPanel.setLayout(new GridBagLayout());
        this.questionLabel.setText("Question");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.questionPanel.add((Component)this.questionLabel, gridBagConstraints);
        this.explanationLabel.setFont(this.explanationLabel.getFont().deriveFont(this.explanationLabel.getFont().getStyle() & 0xFFFFFFFE, this.explanationLabel.getFont().getSize() - 1));
        this.explanationLabel.setText("Explanation");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.questionPanel.add((Component)this.explanationLabel, gridBagConstraints);
        this.hideToolBarMenuItem.setText(bundle.getString("Hide_ToolBar"));
        this.hideToolBarMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.hideToolBarMenuItemActionPerformed(evt);
            }
        });
        this.toolBarPopupMenu.add(this.hideToolBarMenuItem);
        this.setDefaultCloseOperation(0);
        this.setTitle(this.titleString);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PaukerFrame.this.exitForm(evt);
            }

            public void windowOpened(WindowEvent evt) {
                PaukerFrame.this.formWindowOpened(evt);
            }
        });
        this.toolBar.setComponentPopupMenu(this.toolBarPopupMenu);
        this.toolBar.setName(bundle.getString("Pauker_Toolbar"));
        this.newButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/filenew_big.png")));
        this.newButton.setToolTipText(bundle.getString("JPauker.newMenuItem.text"));
        this.newButton.setFocusPainted(false);
        this.newButton.setMargin(new Insets(2, 2, 2, 2));
        this.newButton.setName("newButton");
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.newButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.newButton);
        this.openButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/fileopen_big.png")));
        this.openButton.setToolTipText(bundle.getString("JPauker.openMenuItem.text"));
        this.openButton.setFocusPainted(false);
        this.openButton.setMargin(new Insets(2, 2, 2, 2));
        this.openButton.setName("openButton");
        this.openButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.openButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.openButton);
        this.saveButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/filesave_big.png")));
        this.saveButton.setToolTipText(bundle.getString("JPauker.saveMenuItem.text"));
        this.saveButton.setEnabled(false);
        this.saveButton.setFocusPainted(false);
        this.saveButton.setMargin(new Insets(2, 2, 2, 2));
        this.saveButton.setName("saveButton");
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.saveButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.saveButton);
        this.getContentPane().add((Component)this.toolBar, "North");
        this.splitPane.setOrientation(0);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setName("splitPane");
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setLeftComponent(this.statisticPanel);
        this.cardPanel.setLayout(new CardLayout());
        this.overviewPanel.setLayout(new GridBagLayout());
        this.buttonPanel.setLayout(new GridBagLayout());
        this.addCardButton.setFont(this.addCardButton.getFont().deriveFont(this.addCardButton.getFont().getStyle() & 0xFFFFFFFE, this.addCardButton.getFont().getSize() - 1));
        this.addCardButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/newCard.gif")));
        this.addCardButton.setText(bundle.getString("Add_Card"));
        this.addCardButton.setFocusPainted(false);
        this.addCardButton.setHorizontalTextPosition(0);
        this.addCardButton.setMargin(new Insets(0, 0, 0, 0));
        this.addCardButton.setName("addCardButton");
        this.addCardButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/newCard_Animated.gif")));
        this.addCardButton.setRolloverSelectedIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/newCard_Animated.gif")));
        this.addCardButton.setSelectedIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/newCard_Animated.gif")));
        this.addCardButton.setVerticalTextPosition(3);
        this.addCardButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.addCardButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.buttonPanel.add((Component)this.addCardButton, gridBagConstraints);
        this.learnNewCardsButton.setFont(this.learnNewCardsButton.getFont().deriveFont(this.learnNewCardsButton.getFont().getStyle() & 0xFFFFFFFE, this.learnNewCardsButton.getFont().getSize() - 1));
        this.learnNewCardsButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/learn.png")));
        this.learnNewCardsButton.setText(bundle.getString("Learn_New_Cards"));
        this.learnNewCardsButton.setEnabled(false);
        this.learnNewCardsButton.setFocusPainted(false);
        this.learnNewCardsButton.setHorizontalTextPosition(0);
        this.learnNewCardsButton.setName("learnNewCardsButton");
        this.learnNewCardsButton.setVerticalTextPosition(3);
        this.learnNewCardsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.learnNewCardsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.buttonPanel.add((Component)this.learnNewCardsButton, gridBagConstraints);
        this.repeatCardsButton.setFont(this.repeatCardsButton.getFont().deriveFont(this.repeatCardsButton.getFont().getStyle() & 0xFFFFFFFE, this.repeatCardsButton.getFont().getSize() - 1));
        this.repeatCardsButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/repeat.png")));
        this.repeatCardsButton.setText(bundle.getString("Repeat_Expired_Cards"));
        this.repeatCardsButton.setEnabled(false);
        this.repeatCardsButton.setFocusPainted(false);
        this.repeatCardsButton.setHorizontalTextPosition(0);
        this.repeatCardsButton.setName("repeatCardsButton");
        this.repeatCardsButton.setVerticalTextPosition(3);
        this.repeatCardsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.repeatCardsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.buttonPanel.add((Component)this.repeatCardsButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 5, 5, 0);
        this.overviewPanel.add((Component)this.buttonPanel, gridBagConstraints);
        this.lessonPanel.setLayout(new CardLayout());
        this.aboutPanel.setLayout(new GridLayout(1, 0));
        this.aboutPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("Lesson_Description")));
        this.aboutScrollPane.setViewportView(this.aboutTextArea);
        this.aboutPanel.add(this.aboutScrollPane);
        this.lessonPanel.add((Component)this.aboutPanel, "aboutPanel");
        this.batchPanel.setLayout(new GridBagLayout());
        this.batchPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("Summary")));
        this.batchPanel.setName("batchPanel");
        this.cardsButtonPanel.setLayout(new GridBagLayout());
        this.editCardButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/edit.png")));
        this.editCardButton.setToolTipText(bundle.getString("Edit_Card"));
        this.editCardButton.setEnabled(false);
        this.editCardButton.setFocusPainted(false);
        this.editCardButton.setMargin(new Insets(0, 0, 0, 0));
        this.editCardButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.editCardButtonActionPerformed(evt);
            }
        });
        this.cardsButtonPanel.add((Component)this.editCardButton, new GridBagConstraints());
        this.fontButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/fonts.png")));
        this.fontButton.setToolTipText(bundle.getString("Set_Font"));
        this.fontButton.setEnabled(false);
        this.fontButton.setMargin(new Insets(0, 0, 0, 0));
        this.fontButton.setName("fontButton");
        this.fontButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.fontButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.cardsButtonPanel.add((Component)this.fontButton, gridBagConstraints);
        this.learningMethodButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/brain_and_key.png")));
        this.learningMethodButton.setToolTipText(bundle.getString("Repeating_Method"));
        this.learningMethodButton.setEnabled(false);
        this.learningMethodButton.setMargin(new Insets(0, 0, 0, 0));
        this.learningMethodButton.setName("learningMethodButton");
        this.learningMethodButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                PaukerFrame.this.learningMethodButtonMousePressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.cardsButtonPanel.add((Component)this.learningMethodButton, gridBagConstraints);
        this.upButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/up.png")));
        this.upButton.setToolTipText(bundle.getString("Move_Cards_Up"));
        this.upButton.setEnabled(false);
        this.upButton.setMargin(new Insets(0, 0, 0, 0));
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.upButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 7, 0, 0);
        this.cardsButtonPanel.add((Component)this.upButton, gridBagConstraints);
        this.downButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/down.png")));
        this.downButton.setToolTipText(bundle.getString("Move_Cards_Down"));
        this.downButton.setEnabled(false);
        this.downButton.setMargin(new Insets(0, 0, 0, 0));
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.downButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.cardsButtonPanel.add((Component)this.downButton, gridBagConstraints);
        this.sortButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/ascending.png")));
        this.sortButton.setToolTipText(bundle.getString("Sorting"));
        this.sortButton.setEnabled(false);
        this.sortButton.setMargin(new Insets(0, 0, 0, 0));
        this.sortButton.setName("sortButton");
        this.sortButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                PaukerFrame.this.sortButtonMousePressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.cardsButtonPanel.add((Component)this.sortButton, gridBagConstraints);
        this.randomizeButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/random.png")));
        this.randomizeButton.setToolTipText(bundle.getString("Mix_Batch"));
        this.randomizeButton.setEnabled(false);
        this.randomizeButton.setMargin(new Insets(0, 0, 0, 0));
        this.randomizeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.randomizeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.cardsButtonPanel.add((Component)this.randomizeButton, gridBagConstraints);
        this.instantRepeatButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/keduca.png")));
        this.instantRepeatButton.setToolTipText(bundle.getString("Instant_Repeating"));
        this.instantRepeatButton.setEnabled(false);
        this.instantRepeatButton.setMargin(new Insets(0, 0, 0, 0));
        this.instantRepeatButton.setName("instantRepeatButton");
        this.instantRepeatButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.instantRepeatButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 7, 0, 0);
        this.cardsButtonPanel.add((Component)this.instantRepeatButton, gridBagConstraints);
        this.forgetButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/back.png")));
        this.forgetButton.setToolTipText(bundle.getString("Move_Cards_Back_To_Unlearned_Batch"));
        this.forgetButton.setEnabled(false);
        this.forgetButton.setMargin(new Insets(0, 0, 0, 0));
        this.forgetButton.setName("forgetButton");
        this.forgetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.forgetButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.cardsButtonPanel.add((Component)this.forgetButton, gridBagConstraints);
        this.removeCardButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/16x16/remove.png")));
        this.removeCardButton.setToolTipText(bundle.getString("Remove_Card"));
        this.removeCardButton.setEnabled(false);
        this.removeCardButton.setFocusPainted(false);
        this.removeCardButton.setMargin(new Insets(0, 0, 0, 0));
        this.removeCardButton.setName("removeCardButton");
        this.removeCardButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.removeCardButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.cardsButtonPanel.add((Component)this.removeCardButton, gridBagConstraints);
        this.searchButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/filefind.png")));
        this.searchButton.setToolTipText(bundle.getString("Search"));
        this.searchButton.setEnabled(false);
        this.searchButton.setMargin(new Insets(0, 0, 0, 0));
        this.searchButton.setName("searchButton");
        this.searchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.searchButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 7, 0, 0);
        this.cardsButtonPanel.add((Component)this.searchButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.batchPanel.add((Component)this.cardsButtonPanel, gridBagConstraints);
        this.batchListPanel.setLayout(new GridLayout(1, 0));
        this.batchList.setName("batchList");
        this.batchList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PaukerFrame.this.batchListMouseClicked(evt);
            }
        });
        this.batchList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                PaukerFrame.this.batchListValueChanged(evt);
            }
        });
        this.batchListScrollPane.setViewportView(this.batchList);
        this.batchListPanel.add(this.batchListScrollPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.batchPanel.add((Component)this.batchListPanel, gridBagConstraints);
        this.lessonPanel.add((Component)this.batchPanel, "batchPanel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.overviewPanel.add((Component)this.lessonPanel, gridBagConstraints);
        this.cardPanel.add((Component)this.overviewPanel, "overviewPanel");
        this.learningPanel.setLayout(new GridBagLayout());
        this.learningCardPanel.setLayout(new CardLayout());
        this.USTMLearningPanel.setLayout(new GridBagLayout());
        this.USTMLearningPanel.setBorder(BorderFactory.createTitledBorder(null, bundle.getString("Try_To_Memorize_Card"), 0, 0, new Font("Dialog", 0, 11), new Color(255, 12, 145)));
        this.ustmSplitPane.setResizeWeight(0.5);
        this.ustmSplitPane.setContinuousLayout(true);
        this.ustmFrontSidePanel.setLayout(new GridBagLayout());
        this.ustmFrontSideLabel.setHorizontalAlignment(0);
        this.ustmFrontSideLabel.setText(bundle.getString("Card_Frontside"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.ustmFrontSidePanel.add((Component)this.ustmFrontSideLabel, gridBagConstraints);
        this.ustmFrontSideTextArea.setBackground(Color.lightGray);
        this.ustmFrontSideTextArea.setEditable(false);
        this.ustmFrontSideTextArea.setRows(5);
        this.ustmFrontSideTextArea.setWrapStyleWord(true);
        this.ustmFrontSideScrollPane.setViewportView(this.ustmFrontSideTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.ustmFrontSidePanel.add((Component)this.ustmFrontSideScrollPane, gridBagConstraints);
        this.ustmSplitPane.setLeftComponent(this.ustmFrontSidePanel);
        this.ustmReverseSidePanel.setLayout(new GridBagLayout());
        this.ustmReverseSideLabel.setHorizontalAlignment(0);
        this.ustmReverseSideLabel.setText(bundle.getString("Card_ReverseSide"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.ustmReverseSidePanel.add((Component)this.ustmReverseSideLabel, gridBagConstraints);
        this.ustmReverseSideTextArea.setBackground(Color.lightGray);
        this.ustmReverseSideTextArea.setEditable(false);
        this.ustmReverseSideTextArea.setRows(5);
        this.ustmReverseSideTextArea.setWrapStyleWord(true);
        this.ustmReverseSideScrollPane.setViewportView(this.ustmReverseSideTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.ustmReverseSidePanel.add((Component)this.ustmReverseSideScrollPane, gridBagConstraints);
        this.ustmSplitPane.setRightComponent(this.ustmReverseSidePanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.USTMLearningPanel.add((Component)this.ustmSplitPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.USTMLearningPanel.add((Component)this.jSeparator2, gridBagConstraints);
        this.editWhileMemorizingButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/edit.png")));
        this.editWhileMemorizingButton.setToolTipText(bundle.getString("Edit_Card"));
        this.editWhileMemorizingButton.setMargin(new Insets(0, 0, 0, 0));
        this.editWhileMemorizingButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.editWhileMemorizingButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.USTMLearningPanel.add((Component)this.editWhileMemorizingButton, gridBagConstraints);
        this.switchUSTMLayoutButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/view_top_bottom_16.png")));
        this.switchUSTMLayoutButton.setMargin(new Insets(0, 0, 0, 0));
        this.switchUSTMLayoutButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.switchUSTMLayoutButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.USTMLearningPanel.add((Component)this.switchUSTMLayoutButton, gridBagConstraints);
        this.removeUstmButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/16x16/remove.png")));
        this.removeUstmButton.setToolTipText(bundle.getString("Remove_Card"));
        this.removeUstmButton.setMargin(new Insets(0, 0, 0, 0));
        this.removeUstmButton.setName("removeUstmButton");
        this.removeUstmButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.removeUstmButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.USTMLearningPanel.add((Component)this.removeUstmButton, gridBagConstraints);
        this.nextNewCardButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/forward.png")));
        this.nextNewCardButton.setText(bundle.getString("Next_Card"));
        this.nextNewCardButton.setHorizontalTextPosition(10);
        this.nextNewCardButton.setName("nextNewCardButton");
        this.nextNewCardButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.nextNewCardButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.USTMLearningPanel.add((Component)this.nextNewCardButton, gridBagConstraints);
        this.learningCardPanel.add((Component)this.USTMLearningPanel, "USTMLearningPanel");
        this.repeatingPanel.setLayout(new GridBagLayout());
        this.repeatingPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("Repeat_Cards")));
        this.repeatingSplitPane.setResizeWeight(0.5);
        this.repeatingSplitPane.setContinuousLayout(true);
        this.repeatingFrontSidePanel.setLayout(new GridBagLayout());
        this.repeatingCardFrontSideLabel.setText(bundle.getString("Card_Frontside"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.repeatingFrontSidePanel.add((Component)this.repeatingCardFrontSideLabel, gridBagConstraints);
        this.repeatingFrontSideTextArea.setBackground(Color.lightGray);
        this.repeatingFrontSideTextArea.setEditable(false);
        this.repeatingFrontSideTextArea.setWrapStyleWord(true);
        this.repeatingFrontSideTextArea.setName("repeatingFrontSideTextArea");
        this.repeatingFrontSideScrollPane.setViewportView(this.repeatingFrontSideTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.repeatingFrontSidePanel.add((Component)this.repeatingFrontSideScrollPane, gridBagConstraints);
        this.repeatingSplitPane.setLeftComponent(this.repeatingFrontSidePanel);
        this.repeatingReverseSidePanel.setLayout(new GridBagLayout());
        this.repeatingCardReverseSideLabel.setHorizontalAlignment(0);
        this.repeatingCardReverseSideLabel.setText(bundle.getString("Card_ReverseSide"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.repeatingReverseSidePanel.add((Component)this.repeatingCardReverseSideLabel, gridBagConstraints);
        this.repeatingCardPanel.setLayout(new CardLayout());
        this.repeatingAskPanel.setLayout(new GridBagLayout());
        this.repeatingHintLabel.setForeground(new Color(255, 12, 145));
        this.repeatingHintLabel.setText(bundle.getString("Try_To_Remember_The_Reverse_Side"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.repeatingAskPanel.add((Component)this.repeatingHintLabel, gridBagConstraints);
        this.repeatingCardPanel.add((Component)this.repeatingAskPanel, "repeatingAskPanel");
        this.repeatingShowPanel.setLayout(new GridBagLayout());
        this.repeatingReverseSideTextArea.setBackground(Color.lightGray);
        this.repeatingReverseSideTextArea.setEditable(false);
        this.repeatingReverseSideTextArea.setWrapStyleWord(true);
        this.repeatingReverseSideScrollPane.setViewportView(this.repeatingReverseSideTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.repeatingShowPanel.add((Component)this.repeatingReverseSideScrollPane, gridBagConstraints);
        this.repeatingCardPanel.add((Component)this.repeatingShowPanel, "repeatingShowPanel");
        this.repeatingInsertPanel.setLayout(new GridBagLayout());
        this.repeatingInsertTextArea.setWrapStyleWord(true);
        this.repeatingInsertTextArea.setName("repeatingInsertTextArea");
        this.repeatingInsertScrollPane.setViewportView(this.repeatingInsertTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.repeatingInsertPanel.add((Component)this.repeatingInsertScrollPane, gridBagConstraints);
        this.repeatingCardPanel.add((Component)this.repeatingInsertPanel, "repeatingInsertPanel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.repeatingReverseSidePanel.add((Component)this.repeatingCardPanel, gridBagConstraints);
        this.repeatingSplitPane.setRightComponent(this.repeatingReverseSidePanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.repeatingPanel.add((Component)this.repeatingSplitPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.repeatingPanel.add((Component)this.jSeparator3, gridBagConstraints);
        this.editWhileRepeatingButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/edit.png")));
        this.editWhileRepeatingButton.setToolTipText(bundle.getString("Edit_Card"));
        this.editWhileRepeatingButton.setMargin(new Insets(0, 0, 0, 0));
        this.editWhileRepeatingButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.editWhileRepeatingButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.repeatingPanel.add((Component)this.editWhileRepeatingButton, gridBagConstraints);
        this.switchRepeatingLayoutButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/view_top_bottom_16.png")));
        this.switchRepeatingLayoutButton.setMargin(new Insets(0, 0, 0, 0));
        this.switchRepeatingLayoutButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.switchRepeatingLayoutButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.repeatingPanel.add((Component)this.switchRepeatingLayoutButton, gridBagConstraints);
        this.removeRepeatingButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/16x16/remove.png")));
        this.removeRepeatingButton.setToolTipText(bundle.getString("Remove_Card"));
        this.removeRepeatingButton.setMargin(new Insets(0, 0, 0, 0));
        this.removeRepeatingButton.setName("removeRepeatingButton");
        this.removeRepeatingButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.removeRepeatingButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.repeatingPanel.add((Component)this.removeRepeatingButton, gridBagConstraints);
        this.repeatingButtonCardPanel.setLayout(new CardLayout());
        this.questionButtonPanel.setLayout(new GridBagLayout());
        this.didYouKnowLabel.setText(bundle.getString("Did_You_Know_It"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.questionButtonPanel.add((Component)this.didYouKnowLabel, gridBagConstraints);
        this.repeatingYesButton.setText(bundle.getString("Yes"));
        this.repeatingYesButton.setName("repeatingYesButton");
        this.repeatingYesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.repeatingYesButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.questionButtonPanel.add((Component)this.repeatingYesButton, gridBagConstraints);
        this.repeatingNoButton.setText(bundle.getString("No"));
        this.repeatingNoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.repeatingNoButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.questionButtonPanel.add((Component)this.repeatingNoButton, gridBagConstraints);
        this.repeatingButtonCardPanel.add((Component)this.questionButtonPanel, "questionButtonPanel");
        this.showMeButtonPanel.setLayout(new GridBagLayout());
        this.showMeButton.setText(bundle.getString("Show_Me"));
        this.showMeButton.setName("showMeButton");
        this.showMeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.showMeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.showMeButtonPanel.add((Component)this.showMeButton, gridBagConstraints);
        this.repeatingButtonCardPanel.add((Component)this.showMeButtonPanel, "showMeButtonPanel");
        this.typingOKPanel.setLayout(new GridBagLayout());
        this.insertReverseSideLabel.setForeground(Color.red);
        this.insertReverseSideLabel.setText(bundle.getString("Insert_Reverse_Side"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.typingOKPanel.add((Component)this.insertReverseSideLabel, gridBagConstraints);
        this.typingOKButton.setText(bundle.getString("OK"));
        this.typingOKButton.setName("typingOKButton");
        this.typingOKButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.typingOKButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 10, 0, 5);
        this.typingOKPanel.add((Component)this.typingOKButton, gridBagConstraints);
        this.repeatingButtonCardPanel.add((Component)this.typingOKPanel, "typingOKPanel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.repeatingPanel.add((Component)this.repeatingButtonCardPanel, gridBagConstraints);
        this.learningCardPanel.add((Component)this.repeatingPanel, "repeatingPanel");
        this.waitForUSTMPanel.setLayout(new GridBagLayout());
        this.waitForUSTMPanel.setBorder(BorderFactory.createEtchedBorder());
        this.waitForUSTMLabel.setHorizontalAlignment(0);
        this.waitForUSTMLabel.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/animated-hourglass.gif")));
        this.waitForUSTMLabel.setText(bundle.getString("USTM_Time_Is_Still_Running"));
        this.waitForUSTMLabel.setHorizontalTextPosition(0);
        this.waitForUSTMLabel.setVerticalTextPosition(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.waitForUSTMPanel.add((Component)this.waitForUSTMLabel, gridBagConstraints);
        this.repeatUSTMButton.setText(bundle.getString("Do_Not_Care_Hurry_Up"));
        this.repeatUSTMButton.setName("repeatUSTMButton");
        this.repeatUSTMButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.repeatUSTMButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(25, 0, 10, 0);
        this.waitForUSTMPanel.add((Component)this.repeatUSTMButton, gridBagConstraints);
        this.learningCardPanel.add((Component)this.waitForUSTMPanel, "waitForUSTMPanel");
        this.waitForSTMPanel.setLayout(new GridBagLayout());
        this.waitForSTMPanel.setBorder(BorderFactory.createEtchedBorder());
        this.waitForSTMLabel.setHorizontalAlignment(0);
        this.waitForSTMLabel.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/animated-hourglass.gif")));
        this.waitForSTMLabel.setText(bundle.getString("STM_Time_Is_Still_Running"));
        this.waitForSTMLabel.setHorizontalTextPosition(0);
        this.waitForSTMLabel.setVerticalTextPosition(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.waitForSTMPanel.add((Component)this.waitForSTMLabel, gridBagConstraints);
        this.repeatSTMButton.setText(bundle.getString("Do_Not_Care_Hurry_Up"));
        this.repeatSTMButton.setName("repeatSTMButton");
        this.repeatSTMButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.repeatSTMButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(25, 0, 10, 0);
        this.waitForSTMPanel.add((Component)this.repeatSTMButton, gridBagConstraints);
        this.learningCardPanel.add((Component)this.waitForSTMPanel, "waitForSTMPanel");
        this.transitionPanel.setLayout(new GridBagLayout());
        this.transitionPanel.setBorder(BorderFactory.createEtchedBorder());
        this.transitoinIconLabel.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/brain.gif")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.transitionPanel.add((Component)this.transitoinIconLabel, gridBagConstraints);
        this.transitionExplanationLabel.setText(bundle.getString("Transition_Explanation"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        this.transitionPanel.add((Component)this.transitionExplanationLabel, gridBagConstraints);
        this.transitionOKButton.setText(bundle.getString("OK"));
        this.transitionOKButton.setName("transitionOKButton");
        this.transitionOKButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.transitionOKButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        this.transitionPanel.add((Component)this.transitionOKButton, gridBagConstraints);
        this.learningCardPanel.add((Component)this.transitionPanel, "transitionPanel");
        this.typingErrorPanel.setLayout(new GridBagLayout());
        this.typingErrorPanel.setBorder(BorderFactory.createEtchedBorder());
        this.infoLabel.setForeground(Color.red);
        this.infoLabel.setText(bundle.getString("Mistyped_Answer"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.typingErrorPanel.add((Component)this.infoLabel, gridBagConstraints);
        this.typingErrorSplitPane.setResizeWeight(0.5);
        this.typingErrorSplitPane.setContinuousLayout(true);
        this.inputPanel.setLayout(new GridBagLayout());
        this.inputLabel.setText(bundle.getString("Your_Input"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.inputPanel.add((Component)this.inputLabel, gridBagConstraints);
        this.inputTextArea.setEditable(false);
        this.inputScrollPane.setViewportView(this.inputTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.inputPanel.add((Component)this.inputScrollPane, gridBagConstraints);
        this.typingErrorSplitPane.setLeftComponent(this.inputPanel);
        this.reversePanel.setLayout(new GridBagLayout());
        this.reverseLabel.setText(bundle.getString("Reverse_Side"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.reversePanel.add((Component)this.reverseLabel, gridBagConstraints);
        this.reverseTextArea.setEditable(false);
        this.reverseScrollPane.setViewportView(this.reverseTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.reversePanel.add((Component)this.reverseScrollPane, gridBagConstraints);
        this.typingErrorSplitPane.setRightComponent(this.reversePanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.typingErrorPanel.add((Component)this.typingErrorSplitPane, gridBagConstraints);
        this.editTypingErrorButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/edit.png")));
        this.editTypingErrorButton.setMargin(new Insets(0, 0, 0, 0));
        this.editTypingErrorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.editTypingErrorButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.typingErrorPanel.add((Component)this.editTypingErrorButton, gridBagConstraints);
        this.moveBackButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/back.png")));
        this.moveBackButton.setText(bundle.getString("Acknowledge_Error"));
        this.moveBackButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.moveBackButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.typingErrorPanel.add((Component)this.moveBackButton, gridBagConstraints);
        this.ignoreErrorButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/forward.png")));
        this.ignoreErrorButton.setText(bundle.getString("Ignore_Error"));
        this.ignoreErrorButton.setHorizontalTextPosition(10);
        this.ignoreErrorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.ignoreErrorButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.typingErrorPanel.add((Component)this.ignoreErrorButton, gridBagConstraints);
        this.learningCardPanel.add((Component)this.typingErrorPanel, "typingErrorPanel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.learningPanel.add((Component)this.learningCardPanel, gridBagConstraints);
        this.learningStatusPanel.setLayout(new CardLayout());
        this.timerPanel.setLayout(new GridBagLayout());
        this.timerPanel.setBorder(BorderFactory.createEtchedBorder());
        this.pauseLearningToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/player_pause.png")));
        this.pauseLearningToggleButton.setToolTipText(bundle.getString("Pause_Learning"));
        this.pauseLearningToggleButton.setMargin(new Insets(0, 0, 0, 0));
        this.pauseLearningToggleButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                PaukerFrame.this.pauseLearningToggleButtonItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.timerPanel.add((Component)this.pauseLearningToggleButton, gridBagConstraints);
        this.cancelLearningButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/player_stop.png")));
        this.cancelLearningButton.setToolTipText(bundle.getString("Cancel_Learning"));
        this.cancelLearningButton.setMargin(new Insets(0, 0, 0, 0));
        this.cancelLearningButton.setName("cancelLearningButton");
        this.cancelLearningButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.cancelLearningButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.timerPanel.add((Component)this.cancelLearningButton, gridBagConstraints);
        this.showTimerCheckBox.setFont(this.showTimerCheckBox.getFont().deriveFont(this.showTimerCheckBox.getFont().getStyle() & 0xFFFFFFFE, this.showTimerCheckBox.getFont().getSize() - 1));
        this.showTimerCheckBox.setText(bundle.getString("Show_Timer"));
        this.showTimerCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                PaukerFrame.this.showTimerCheckBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.timerPanel.add((Component)this.showTimerCheckBox, gridBagConstraints);
        this.timerCardPanel.setLayout(new CardLayout());
        this.fullTimerPanel.setLayout(new GridLayout(2, 0));
        this.timerGridPanel1.setLayout(new GridLayout(1, 0, 5, 0));
        this.ustmTimerLabel.setFont(this.ustmTimerLabel.getFont().deriveFont(this.ustmTimerLabel.getFont().getStyle() & 0xFFFFFFFE, this.ustmTimerLabel.getFont().getSize() - 1));
        this.ustmTimerLabel.setHorizontalAlignment(0);
        this.ustmTimerLabel.setText(bundle.getString("Ultra_Shortterm_Memory"));
        this.timerGridPanel1.add(this.ustmTimerLabel);
        this.stmTimerLabel.setFont(this.stmTimerLabel.getFont().deriveFont(this.stmTimerLabel.getFont().getStyle() & 0xFFFFFFFE, this.stmTimerLabel.getFont().getSize() - 1));
        this.stmTimerLabel.setHorizontalAlignment(0);
        this.stmTimerLabel.setText(bundle.getString("Shortterm_Memory"));
        this.timerGridPanel1.add(this.stmTimerLabel);
        this.fullTimerPanel.add(this.timerGridPanel1);
        this.timerGridPanel2.setLayout(new GridLayout(1, 0, 5, 0));
        this.ustmTimerProgressBar.setFont(this.ustmTimerProgressBar.getFont().deriveFont(this.ustmTimerProgressBar.getFont().getStyle() & 0xFFFFFFFE, this.ustmTimerProgressBar.getFont().getSize() - 1));
        this.ustmTimerProgressBar.setStringPainted(true);
        this.timerGridPanel2.add(this.ustmTimerProgressBar);
        this.stmTimerProgressBar.setFont(this.stmTimerProgressBar.getFont().deriveFont(this.stmTimerProgressBar.getFont().getStyle() & 0xFFFFFFFE, this.stmTimerProgressBar.getFont().getSize() - 1));
        this.stmTimerProgressBar.setStringPainted(true);
        this.timerGridPanel2.add(this.stmTimerProgressBar);
        this.fullTimerPanel.add(this.timerGridPanel2);
        this.timerCardPanel.add((Component)this.fullTimerPanel, "fullTimerPanel");
        this.timerCardPanel.add((Component)this.noTimerPanel, "noTimerPanel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.timerPanel.add((Component)this.timerCardPanel, gridBagConstraints);
        this.learningStatusPanel.add((Component)this.timerPanel, "timerPanel");
        this.cancelRepeatingPanel.setLayout(new GridBagLayout());
        this.cancelRepeatingPanel.setBorder(BorderFactory.createEtchedBorder());
        this.cancelRepeatingButton.setText(bundle.getString("Cancel_Repeating"));
        this.cancelRepeatingButton.setName("cancelRepeatingButton");
        this.cancelRepeatingButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.cancelRepeatingButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        this.cancelRepeatingPanel.add((Component)this.cancelRepeatingButton, gridBagConstraints);
        this.learningStatusPanel.add((Component)this.cancelRepeatingPanel, "cancelRepeatingPanel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.learningPanel.add((Component)this.learningStatusPanel, gridBagConstraints);
        this.cardPanel.add((Component)this.learningPanel, "learningPanel");
        this.splitPane.setRightComponent(this.cardPanel);
        this.getContentPane().add((Component)this.splitPane, "Center");
        this.fileMenu.setText(bundle.getString("JPauker.fileMenu.text"));
        this.fileMenu.setName("fileMenu");
        this.newMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.newMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/filenew.png")));
        this.newMenuItem.setText(bundle.getString("JPauker.newMenuItem.text"));
        this.newMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.newMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.newMenuItem);
        this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.openMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/fileopen.png")));
        this.openMenuItem.setText(bundle.getString("JPauker.openMenuItem.text"));
        this.openMenuItem.setName("openMenuItem");
        this.openMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.openMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.importMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/fileimport.png")));
        this.importMenuItem.setText(bundle.getString("Text_Import_Menu"));
        this.importMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.importMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.importMenuItem);
        this.recentFilesMenu.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/bookmark.png")));
        this.recentFilesMenu.setText(bundle.getString("Recent_Files"));
        this.recentFilesMenu.setName("recentFilesMenu");
        this.recentFilesMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                PaukerFrame.this.recentFilesMenuMenuSelected(evt);
            }
        });
        this.fileMenu.add(this.recentFilesMenu);
        this.fileMenu.add(this.separator1);
        this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/filesave.png")));
        this.saveMenuItem.setText(bundle.getString("JPauker.saveMenuItem.text"));
        this.saveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.saveMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveMenuItem);
        this.saveAsMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/filesaveas.png")));
        this.saveAsMenuItem.setText(bundle.getString("JPauker.saveAsMenuItem.text"));
        this.saveAsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.saveAsMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveAsMenuItem);
        this.fileMenu.add(this.separator4);
        this.resetMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/back.png")));
        this.resetMenuItem.setText(bundle.getString("Reset_Lesson_Menu"));
        this.resetMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.resetMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.resetMenuItem);
        this.flipCardSidesMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/reload.png")));
        this.flipCardSidesMenuItem.setText(bundle.getString("Flip_Card_Sides_Menu"));
        this.flipCardSidesMenuItem.setName("flipCardSidesMenuItem");
        this.flipCardSidesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.flipCardSidesMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.flipCardSidesMenuItem);
        this.fileMenu.add(this.separator2);
        this.exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.exitMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/exit.gif")));
        this.exitMenuItem.setText(bundle.getString("JPauker.exitMenuItem.text"));
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.mainMenuBar.add(this.fileMenu);
        this.extraMenu.setText(bundle.getString("Extra"));
        this.extraMenu.setName("extraMenu");
        this.addCardsMenuitem.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/filenew.png")));
        this.addCardsMenuitem.setText(bundle.getString("AddMenuItem"));
        this.addCardsMenuitem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.addCardsMenuitemActionPerformed(evt);
            }
        });
        this.extraMenu.add(this.addCardsMenuitem);
        this.configureMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/configure.png")));
        this.configureMenuItem.setText(bundle.getString("Configure_Pauker"));
        this.configureMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.configureMenuItemActionPerformed(evt);
            }
        });
        this.extraMenu.add(this.configureMenuItem);
        this.showToolBarMenuItem.setSelected(true);
        this.showToolBarMenuItem.setText(bundle.getString("Show_ToolBar"));
        this.showToolBarMenuItem.setName("showToolBarMenuItem");
        this.showToolBarMenuItem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                PaukerFrame.this.showToolBarMenuItemItemStateChanged(evt);
            }
        });
        this.extraMenu.add(this.showToolBarMenuItem);
        this.mainMenuBar.add(this.extraMenu);
        this.helpMenu.setText(bundle.getString("Help"));
        this.helpMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.helpMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/help.png")));
        this.helpMenuItem.setText(bundle.getString("Contents"));
        this.helpMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.helpMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.helpMenuItem);
        this.helpMenu.add(this.jSeparator4);
        this.aboutLessonMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/info.png")));
        this.aboutLessonMenuItem.setText(bundle.getString("About_Lesson_MenuItem"));
        this.aboutLessonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.aboutLessonMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutLessonMenuItem);
        this.aboutProgramMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/info.png")));
        this.aboutProgramMenuItem.setText(bundle.getString("AboutMenuItem"));
        this.aboutProgramMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.aboutProgramMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutProgramMenuItem);
        this.donateMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/khelpcenter.png")));
        this.donateMenuItem.setText(bundle.getString("Donate_Ellipsis"));
        this.donateMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PaukerFrame.this.donateMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.donateMenuItem);
        this.mainMenuBar.add(this.helpMenu);
        this.setJMenuBar(this.mainMenuBar);
    }

    private void showToolBarMenuItemItemStateChanged(ItemEvent evt) {
        this.toolBar.setVisible(this.showToolBarMenuItem.isSelected());
    }

    private void hideToolBarMenuItemActionPerformed(ActionEvent evt) {
        this.showToolBarMenuItem.setSelected(false);
        String message = strings.getString("Info_Show_Toolbar");
        message = MessageFormat.format(message, strings.getString("Extra"), strings.getString("Show_ToolBar"));
        JOptionPane.showMessageDialog(this, message, strings.getString("Information"), 1);
    }

    private void removeRepeatingButtonActionPerformed(ActionEvent evt) {
        if (!this.canRemoveCard()) {
            return;
        }
        this.currentLesson.getSummaryBatch().removeCard(this.currentCard);
        this.removeCurrentCard();
        this.searchEngine.removeCard(this.currentCard);
        this.statisticPanel.setLesson(this.currentLesson);
        if (Pauker.getLearningPhase() == Pauker.LearningPhase.REPEATING_USTM && this.currentLesson.getUltraShortTermList().size() == 0 && this.currentLesson.getShortTermList().size() == 0) {
            if (this.currentLesson.getUnlearnedBatch().getNumberOfCards() == 0) {
                this.stopLearning();
            } else {
                this.learnNewCards();
            }
        } else {
            this.repeatedCardMoved();
        }
        this.somethingHasChanged();
    }

    private void removeCurrentCard() {
        switch (Pauker.getLearningPhase()) {
            case REPEATING_USTM: {
                this.currentLesson.getUltraShortTermList().remove(this.currentCard);
                break;
            }
            case REPEATING_STM: {
                this.currentLesson.getShortTermList().remove(this.currentCard);
                break;
            }
            case REPEATING_LTM: {
                int longTermBatchNumber = this.currentCard.getLongTermBatchNumber();
                LongTermBatch longTermBatch = this.currentLesson.getLongTermBatch(longTermBatchNumber);
                longTermBatch.removeCard(this.currentCard);
                break;
            }
            default: {
                throw new RuntimeException("unsupported learning phase \"" + (Object)((Object)Pauker.getLearningPhase()) + "\" -> can't find batch of card!");
            }
        }
    }

    private void removeUstmButtonActionPerformed(ActionEvent evt) {
        if (!this.canRemoveCard()) {
            return;
        }
        this.currentLesson.getSummaryBatch().removeCard(this.currentCard);
        this.currentLesson.getUnlearnedBatch().removeCard(this.currentCard);
        this.searchEngine.removeCard(this.currentCard);
        if (this.currentLesson.getUltraShortTermList().size() > 0 || this.currentLesson.getUnlearnedBatch().getNumberOfCards() > 0) {
            this.showNextUnlearnedCard();
        } else {
            this.stopLearning();
        }
        this.statisticPanel.setLesson(this.currentLesson);
        this.somethingHasChanged();
    }

    private void stopLearning() {
        this.pauseLearningToggleButton.setSelected(false);
        Pauker.setLearningPhase(Pauker.LearningPhase.NOTHING);
        this.ustmTimer.stop();
        this.stmTimer.stop();
        this.resetGUI();
    }

    private void donateMenuItemActionPerformed(ActionEvent evt) {
        DonateDialog donateDialog = new DonateDialog(this);
        donateDialog.setVisible(true);
    }

    private void batchListMouseClicked(MouseEvent evt) {
        Card selectedCard;
        EditCardDialog dialog;
        int selectedIndex;
        if (evt.getClickCount() == 2 && (selectedIndex = this.batchList.locationToIndex(evt.getPoint())) != -1 && (dialog = new EditCardDialog(this, selectedCard = (Card)this.batchListModel.get(selectedIndex), this.searchEngine)).okPressed()) {
            this.cardChanged(selectedIndex);
        }
    }

    private void batchListValueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        this.updateBatchListButtons();
    }

    private void updateBatchListButtons() {
        int cardsLeft = this.loadedBatch.getNumberOfCards();
        boolean hasSeveralCards = cardsLeft > 1;
        int[] selectedIndices = this.batchList.getSelectedIndices();
        boolean cardsSelected = selectedIndices.length > 0;
        this.editCardButton.setEnabled(selectedIndices.length == 1);
        this.fontButton.setEnabled(cardsSelected);
        this.learningMethodButton.setEnabled(cardsSelected);
        this.upButton.setEnabled(cardsSelected && selectedIndices[0] != 0);
        this.downButton.setEnabled(cardsSelected && selectedIndices[selectedIndices.length - 1] != this.batchListModel.getSize() - 1);
        this.sortButton.setEnabled(hasSeveralCards);
        this.randomizeButton.setEnabled(hasSeveralCards);
        this.instantRepeatButton.setEnabled(cardsSelected);
        this.forgetButton.setEnabled(cardsSelected && this.loadedBatch != this.currentLesson.getUnlearnedBatch());
        this.removeCardButton.setEnabled(cardsSelected);
        this.searchButton.setEnabled(cardsLeft > 0);
    }

    private void pauseLearningToggleButtonItemStateChanged(ItemEvent evt) {
        if (this.pauseLearningToggleButton.isSelected()) {
            this.ustmTimer.stop();
            this.stmTimer.stop();
            this.nextNewCardButton.setEnabled(false);
            this.repeatingYesButton.setEnabled(false);
            this.repeatingNoButton.setEnabled(false);
            this.showMeButton.setEnabled(false);
            this.typingOKButton.setEnabled(false);
        } else {
            if (this.currentSTMTime < this.stmTime) {
                this.stmTimer.start();
            }
            if (this.currentUSTMTime < this.ustmTime) {
                this.ustmTimer.start();
            }
            this.nextNewCardButton.setEnabled(true);
            this.repeatingYesButton.setEnabled(true);
            this.repeatingNoButton.setEnabled(true);
            this.showMeButton.setEnabled(true);
            this.typingOKButton.setEnabled(true);
        }
    }

    private void importMenuItemActionPerformed(ActionEvent evt) {
        ImportDialog dialog = new ImportDialog(this);
        dialog.setVisible(true);
    }

    private void switchRepeatingLayoutButtonActionPerformed(ActionEvent evt) {
        this.switchLayout(this.switchRepeatingLayoutButton, this.repeatingSplitPane, this.repeatingFrontSideTextArea, this.repeatingReverseSideTextArea);
    }

    private void switchUSTMLayoutButtonActionPerformed(ActionEvent evt) {
        this.switchLayout(this.switchUSTMLayoutButton, this.ustmSplitPane, this.ustmFrontSideTextArea, this.ustmReverseSideTextArea);
    }

    private void editTypingErrorButtonActionPerformed(ActionEvent evt) {
        EditCardDialog dialog = new EditCardDialog(this, this.currentCard, this.searchEngine);
        if (dialog.okPressed()) {
            JOptionPane.showMessageDialog(this, strings.getString("Typing_Error_Still_Shown"), strings.getString("Information"), 1);
        }
    }

    private void fontButtonActionPerformed(ActionEvent evt) {
        int mostUsedFontStlye;
        int[] selectedIndices;
        HashMap fontFamilyCounter = new HashMap();
        int boldCounter = 0;
        int nonBoldCounter = 0;
        int italicCounter = 0;
        int nonItalicCounter = 0;
        HashMap foregroundCounter = new HashMap();
        HashMap backgroundCounter = new HashMap();
        Object commonFontName = null;
        float fontSizeSum = 0.0f;
        for (int selectedIndex : selectedIndices = this.batchList.getSelectedIndices()) {
            Card card = (Card)this.batchListModel.getElementAt(selectedIndex);
            CardSide frontSide = card.getFrontSide();
            CardSide reverseSide = card.getReverseSide();
            fontSizeSum += card.getAverageFontSize();
            this.increaseCounter(fontFamilyCounter, frontSide.getFontFamily());
            this.increaseCounter(fontFamilyCounter, reverseSide.getFontFamily());
            int frontSideFontStlye = frontSide.getFontStyle();
            if ((frontSideFontStlye & 1) != 0) {
                ++boldCounter;
            } else {
                ++nonBoldCounter;
            }
            if ((frontSideFontStlye & 2) != 0) {
                ++italicCounter;
            } else {
                ++nonItalicCounter;
            }
            int reverseSideFontStlye = reverseSide.getFontStyle();
            if ((reverseSideFontStlye & 1) != 0) {
                ++boldCounter;
            } else {
                ++nonBoldCounter;
            }
            if ((reverseSideFontStlye & 2) != 0) {
                ++italicCounter;
            } else {
                ++nonItalicCounter;
            }
            this.increaseCounter(foregroundCounter, frontSide.getForegroundColor());
            this.increaseCounter(foregroundCounter, reverseSide.getForegroundColor());
            this.increaseCounter(backgroundCounter, frontSide.getBackgroundColor());
            this.increaseCounter(backgroundCounter, reverseSide.getBackgroundColor());
        }
        String mostUsedFontFamily = (String)this.getLargestKey(fontFamilyCounter);
        int averageFontSize = (int)(fontSizeSum / (float)selectedIndices.length);
        int n = mostUsedFontStlye = boldCounter > nonBoldCounter ? 1 : 0;
        if (italicCounter > nonItalicCounter) {
            mostUsedFontStlye |= 2;
        }
        Font initialFont = new Font(mostUsedFontFamily, mostUsedFontStlye, averageFontSize);
        Color initialForegroud = (Color)this.getLargestKey(foregroundCounter);
        Color initialBackgroud = (Color)this.getLargestKey(backgroundCounter);
        FontDialog dialog = new FontDialog((Frame)this, initialFont, initialForegroud, initialBackgroud);
        dialog.setVisible(true);
        if (dialog.okButtonPressed()) {
            Font font = dialog.getFont();
            Card.Element side = dialog.getSide();
            Color foregroundColor = dialog.getForegroundColor();
            Color backgroundColor = dialog.getBackgroundColor();
            for (int selectedIndex : selectedIndices) {
                Card card = this.loadedBatch.getCard(selectedIndex);
                switch (side) {
                    case FRONT_SIDE: {
                        CardSide frontSide = card.getFrontSide();
                        frontSide.setFont(font);
                        frontSide.setForegroundColor(foregroundColor);
                        frontSide.setBackgroundColor(backgroundColor);
                        break;
                    }
                    case REVERSE_SIDE: {
                        CardSide reverseSide = card.getReverseSide();
                        reverseSide.setFont(font);
                        reverseSide.setForegroundColor(foregroundColor);
                        reverseSide.setBackgroundColor(backgroundColor);
                        break;
                    }
                    case BOTH_SIDES: {
                        CardSide frontSide = card.getFrontSide();
                        frontSide.setFont(font);
                        frontSide.setForegroundColor(foregroundColor);
                        frontSide.setBackgroundColor(backgroundColor);
                        CardSide reverseSide = card.getReverseSide();
                        reverseSide.setFont(font);
                        reverseSide.setForegroundColor(foregroundColor);
                        reverseSide.setBackgroundColor(backgroundColor);
                        break;
                    }
                    default: {
                        System.out.println("WARNING: PaukerFrame.fontButtonActionPerformed() unknown side " + (Object)((Object)side));
                    }
                }
                this.batchListModel.cardsChanged(selectedIndex, selectedIndex);
            }
            this.somethingHasChanged();
        }
    }

    private <T> void increaseCounter(Map<T, Integer> map, T key) {
        if (map.containsKey(key)) {
            Integer counter = map.get(key);
            Integer newCounter = counter + 1;
            map.put(key, newCounter);
        } else {
            map.put(key, 1);
        }
    }

    private <T> T getLargestKey(Map<T, Integer> map) {
        T maxKey = null;
        int maxInteger = 0;
        Set<T> keySet = map.keySet();
        for (T key : keySet) {
            int intValue = map.get(key);
            if (maxInteger >= intValue) continue;
            maxKey = key;
            maxInteger = intValue;
        }
        return maxKey;
    }

    private void ignoreErrorButtonActionPerformed(ActionEvent evt) {
        this.pushCurrentCard();
    }

    private void moveBackButtonActionPerformed(ActionEvent evt) {
        this.dropCurrentCard();
    }

    private void addCardsMenuitemActionPerformed(ActionEvent evt) {
        this.showNewCardDialog();
    }

    private void learningMethodButtonMousePressed(MouseEvent evt) {
        if (this.learningMethodButton.isEnabled()) {
            this.learningPopupMenu.show(this.learningMethodButton, evt.getX(), evt.getY());
        }
    }

    private void sortButtonMousePressed(MouseEvent evt) {
        if (this.sortButton.isEnabled()) {
            this.sortingPopupMenu.show(this.sortButton, evt.getX(), evt.getY());
        }
    }

    private void instantRepeatButtonActionPerformed(ActionEvent evt) {
        int[] selectedIndices = this.batchList.getSelectedIndices();
        Object[] options = new Object[]{strings.getString("Repeat_Cards_Instantly"), strings.getString("No")};
        this.questionLabel.setText(strings.getString("Instant_Repeating_Question"));
        this.explanationLabel.setText(strings.getString("Instant_Repeating_Explanation"));
        int result = JOptionPane.showOptionDialog(this, this.questionPanel, strings.getString("Question"), -1, 3, null, options, options[0]);
        if (result != 0) {
            return;
        }
        this.currentLesson.instantRepeatCards(this.loadedBatch, selectedIndices);
        this.statisticPanel.setLesson(this.currentLesson);
        this.loadBatch(this.loadedBatch);
        if (this.loadedBatch == this.currentLesson.getSummaryBatch()) {
            System.out.println("summary batch loaded -> restore previous selection");
            for (int index : selectedIndices) {
                this.batchList.addSelectionInterval(index, index);
            }
        }
        this.scrollToCurrentSearchHit();
        this.learnNewCardsButton.setEnabled(this.currentLesson.getUnlearnedBatch().getNumberOfCards() > 0);
        this.repeatCardsButton.setEnabled(true);
        this.somethingHasChanged();
    }

    private void typeMenuItemActionPerformed(ActionEvent evt) {
        this.setRepeatByTyping(true);
    }

    private void remeberMenuItemActionPerformed(ActionEvent evt) {
        this.setRepeatByTyping(false);
    }

    private void descendingRepeatMenuItemActionPerformed(ActionEvent evt) {
        this.sortBatch(Card.Element.REPEATING_MODE, false);
    }

    private void ascendingRepeatMenuItemActionPerformed(ActionEvent evt) {
        this.sortBatch(Card.Element.REPEATING_MODE, true);
    }

    private void descendingExpiredMenuItemActionPerformed(ActionEvent evt) {
        this.sortBatch(Card.Element.EXPIRED_DATE, false);
    }

    private void ascendingExpiredMenuItemActionPerformed(ActionEvent evt) {
        this.sortBatch(Card.Element.EXPIRED_DATE, true);
    }

    private void descendingLearnedMenuItemActionPerformed(ActionEvent evt) {
        this.sortBatch(Card.Element.LEARNED_DATE, false);
    }

    private void ascendingLearnedMenuItemActionPerformed(ActionEvent evt) {
        this.sortBatch(Card.Element.LEARNED_DATE, true);
    }

    private void descendingBatchMenuItemActionPerformed(ActionEvent evt) {
        this.sortBatch(Card.Element.BATCH_NUMBER, false);
    }

    private void ascendingBatchMenuItemActionPerformed(ActionEvent evt) {
        this.sortBatch(Card.Element.BATCH_NUMBER, true);
    }

    private void descendingBackMenuItemActionPerformed(ActionEvent evt) {
        this.sortBatch(Card.Element.REVERSE_SIDE, false);
    }

    private void descendingFrontMenuItemActionPerformed(ActionEvent evt) {
        this.sortBatch(Card.Element.FRONT_SIDE, false);
    }

    private void ascendingBackMenuItemActionPerformed(ActionEvent evt) {
        this.sortBatch(Card.Element.REVERSE_SIDE, true);
    }

    private void ascendingFrontMenuItemActionPerformed(ActionEvent evt) {
        this.sortBatch(Card.Element.FRONT_SIDE, true);
    }

    private void typingOKButtonActionPerformed(ActionEvent evt) {
        CardSide reverseSide = this.currentCard.getReverseSide();
        String reverseSideText = reverseSide.getText();
        String insertedText = this.repeatingInsertTextArea.getText();
        boolean correctInput = this.matchCase ? insertedText.equals(reverseSideText) : insertedText.equalsIgnoreCase(reverseSideText);
        if (correctInput) {
            this.pushCurrentCard();
        } else {
            PathNodeDiff diff = new PathNodeDiff(reverseSideText, insertedText, this.matchCase);
            Font reverseSideFont = reverseSide.getFont();
            this.highlightSide(diff.getStringAScript(), reverseSide.getText(), reverseSideFont, this.reverseTextArea, Color.green);
            this.highlightSide(diff.getStringBScript(), insertedText, reverseSideFont, this.inputTextArea, Color.red);
            this.updateSplitPane(this.typingErrorSplitPane, this.inputTextArea, this.reverseTextArea);
            this.showPanel(this.learningCardPanel, "typingErrorPanel");
            this.getRootPane().setDefaultButton(null);
            this.moveBackButton.requestFocusInWindow();
        }
    }

    private void highlightSide(List<Integer> script, String text, Font font, JTextArea textArea, Color color) {
        StringBuilder stringBuilder = new StringBuilder(text);
        int insertions = 0;
        for (Integer integer : script) {
            int index = integer;
            if (text.charAt(index) != '\n') continue;
            stringBuilder.insert(index + insertions++, "\u21b5");
        }
        textArea.setText(stringBuilder.toString());
        textArea.setFont(font);
        DefaultHighlighter.DefaultHighlightPainter highlightPainter = new DefaultHighlighter.DefaultHighlightPainter(color);
        Highlighter highlighter = textArea.getHighlighter();
        try {
            insertions = 0;
            for (Integer integer : script) {
                int index = integer;
                if (text.charAt(index) == '\n') {
                    highlighter.addHighlight(index + insertions, index + insertions + 2, highlightPainter);
                    ++insertions;
                    continue;
                }
                highlighter.addHighlight(index + insertions, index + insertions + 1, highlightPainter);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void searchButtonActionPerformed(ActionEvent evt) {
        if (this.searchDialog == null) {
            this.searchDialog = new SearchDialog(this, this.batchPanel);
        }
        this.searchDialog.setVisible(true);
    }

    private void formWindowOpened(WindowEvent evt) {
        this.loadedBatch = this.currentLesson.getSummaryBatch();
    }

    private void editWhileRepeatingButtonActionPerformed(ActionEvent evt) {
        EditCardDialog dialog = new EditCardDialog(this, this.currentCard, this.searchEngine);
        if (dialog.okPressed()) {
            PaukerFrame.fillTextAreaWithCardSide(this.currentCard.getFrontSide(), this.repeatingFrontSideTextArea, false);
            PaukerFrame.fillTextAreaWithCardSide(this.currentCard.getReverseSide(), this.repeatingReverseSideTextArea, false);
        }
    }

    private void editWhileMemorizingButtonActionPerformed(ActionEvent evt) {
        EditCardDialog dialog = new EditCardDialog(this, this.currentCard, this.searchEngine);
        if (dialog.okPressed()) {
            PaukerFrame.fillTextAreaWithCardSide(this.currentCard.getFrontSide(), this.ustmFrontSideTextArea, false);
            PaukerFrame.fillTextAreaWithCardSide(this.currentCard.getReverseSide(), this.ustmReverseSideTextArea, false);
        }
    }

    private void helpMenuItemActionPerformed(ActionEvent evt) {
        this.helpbroker.setCurrentID("Pauker");
        this.helpbroker.setSize(new Dimension(1200, 800));
        this.helpbroker.setDisplayed(true);
    }

    private void forgetButtonActionPerformed(ActionEvent evt) {
        int[] selectedIndices = this.batchList.getSelectedIndices();
        Object[] options = new Object[]{null, strings.getString("No")};
        String warningMessage = null;
        if (selectedIndices.length > 1) {
            warningMessage = strings.getString("Move_Cards_Back_Question");
            options[0] = strings.getString("Move_Cards_Back");
        } else {
            warningMessage = strings.getString("Move_Card_Back_Question");
            options[0] = strings.getString("Move_Card_Back");
        }
        this.questionLabel.setText(warningMessage);
        this.explanationLabel.setText(strings.getString("Move_Cards_Back_Explanation"));
        int result = JOptionPane.showOptionDialog(this, this.questionPanel, strings.getString("Question"), -1, 3, null, options, options[0]);
        if (result != 0) {
            return;
        }
        this.currentLesson.forgetCards(this.loadedBatch, selectedIndices);
        this.statisticPanel.setLesson(this.currentLesson);
        this.loadBatch(this.loadedBatch);
        if (this.loadedBatch == this.currentLesson.getSummaryBatch()) {
            System.out.println("summary batch loaded -> restore previous selection");
            for (int index : selectedIndices) {
                this.batchList.addSelectionInterval(index, index);
            }
        }
        this.scrollToCurrentSearchHit();
        this.learnNewCardsButton.setEnabled(true);
        this.repeatCardsButton.setEnabled(this.currentLesson.getNumberOfExpiredCards() > 0);
        this.somethingHasChanged();
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        this.moveCards(-1);
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        this.moveCards(1);
    }

    private void transitionOKButtonActionPerformed(ActionEvent evt) {
        this.showPanel(this.learningCardPanel, "repeatingPanel");
        Card firstStmCard = this.currentLesson.getShortTermList().get(0);
        this.repeatCard(firstStmCard);
    }

    private void configureMenuItemActionPerformed(ActionEvent evt) {
        SettingsDialog settingsDialog = new SettingsDialog(this);
        settingsDialog.setVisible(true);
        if (settingsDialog.okPressed()) {
            this.repeatingStrategy = settingsDialog.getRepeatingStrategy();
            this.putBackStrategy = settingsDialog.getPutBackStrategy();
            this.ustmTime = settingsDialog.getUSTMTime();
            this.stmTime = settingsDialog.getSTMTime();
            this.matchCase = settingsDialog.getMatchCase();
            int numberOfCards = this.loadedBatch.getNumberOfCards();
            this.batchListModel.cardsChanged(0, numberOfCards - 1);
            this.lineWrapping = settingsDialog.getLineWrapping();
            this.setLineWrap(this.lineWrapping);
            this.searchLimit = settingsDialog.getSearchLimit();
            this.searchEngine.setSearchLimit(this.searchLimit);
            this.playRingTone = settingsDialog.getPlayRingTone();
        }
    }

    private void showTimerCheckBoxItemStateChanged(ItemEvent evt) {
        if (this.showTimerCheckBox.isSelected()) {
            this.showPanel(this.timerCardPanel, "fullTimerPanel");
        } else {
            this.showPanel(this.timerCardPanel, "noTimerPanel");
        }
    }

    private void randomizeButtonActionPerformed(ActionEvent evt) {
        int[] selectedIndices = this.batchList.getSelectedIndices();
        int[] newSelectedIndices = this.loadedBatch.shuffle(selectedIndices);
        this.batchListModel.setBatch(this.loadedBatch);
        this.batchListModel.cardsChanged(0, this.loadedBatch.getNumberOfCards() - 1);
        this.batchList.clearSelection();
        for (int index : newSelectedIndices) {
            this.batchList.addSelectionInterval(index, index);
        }
        SearchHit currentSearchHit = this.loadedBatch.getCurrentSearchHit();
        if (currentSearchHit != null) {
            this.scrollToCurrentSearchHit();
        } else if (newSelectedIndices.length != 0) {
            Arrays.sort(newSelectedIndices);
            int firstIndex = newSelectedIndices[0];
            this.batchList.ensureIndexIsVisible(firstIndex);
        }
        this.somethingHasChanged();
    }

    private void flipCardSidesMenuItemActionPerformed(ActionEvent evt) {
        if (this.currentLesson.getNumberOfCards() == 0) {
            JOptionPane.showMessageDialog(this, strings.getString("No_Cards_To_Flip_Hint"), strings.getString("Information"), 1);
            return;
        }
        Object[] options = new Object[]{strings.getString("Flip_Card_Sides"), strings.getString("Cancel")};
        this.questionLabel.setText(strings.getString("Flip_Cards_Question"));
        this.explanationLabel.setText(strings.getString("Flip_Cards_Explanation"));
        int result = JOptionPane.showOptionDialog(this, this.questionPanel, strings.getString("Warning"), -1, 3, null, options, options[0]);
        if (result != 0) {
            return;
        }
        this.currentLesson.flip();
        this.statisticPanel.setLesson(this.currentLesson);
        this.statisticPanel.selectSummary();
        this.loadBatch(this.currentLesson.getSummaryBatch());
        this.learnNewCardsButton.setEnabled(this.currentLesson.getUnlearnedBatch().getNumberOfCards() > 0);
        this.repeatCardsButton.setEnabled(this.currentLesson.getNumberOfExpiredCards() > 0);
        this.searchEngine.init();
        this.searchEngine.index(this.currentLesson);
        this.somethingHasChanged();
    }

    private void aboutLessonMenuItemActionPerformed(ActionEvent evt) {
        this.showPanel(this.lessonPanel, "aboutPanel");
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        this.saveFile(this.currentFileName, false);
    }

    private void openButtonActionPerformed(ActionEvent evt) {
        this.openAction();
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        this.newAction();
    }

    private void repeatSTMButtonActionPerformed(ActionEvent evt) {
        this.repeatSTMCards();
    }

    private void repeatUSTMButtonActionPerformed(ActionEvent evt) {
        this.repeatUSTMCards();
    }

    private void cancelRepeatingButtonActionPerformed(ActionEvent evt) {
        this.resetGUI();
    }

    private void resetMenuItemActionPerformed(ActionEvent evt) {
        if (this.currentLesson.getNumberOfCards() == 0) {
            JOptionPane.showMessageDialog(this, strings.getString("No_Cards_To_Reset_Hint"), strings.getString("Information"), 1);
            return;
        }
        if (this.currentLesson.getNumberOfLongTermBatches() < 4) {
            JOptionPane.showMessageDialog(this, strings.getString("No_High_Cards_To_Reset_Hint"), strings.getString("Information"), 1);
            return;
        }
        Object[] options = new Object[]{strings.getString("Reset_Lesson"), strings.getString("Cancel")};
        this.questionLabel.setText(strings.getString("Reset_Lesson_Question"));
        this.explanationLabel.setText(strings.getString("Reset_Lesson_Explanation"));
        int result = JOptionPane.showOptionDialog(this, this.questionPanel, strings.getString("Warning"), -1, 2, null, options, options[0]);
        if (result != 0) {
            return;
        }
        this.currentLesson.reset();
        this.statisticPanel.setLesson(this.currentLesson);
        this.statisticPanel.selectSummary();
        this.loadBatch(this.currentLesson.getSummaryBatch());
        this.learnNewCardsButton.setEnabled(this.currentLesson.getUnlearnedBatch().getNumberOfCards() > 0);
        this.repeatCardsButton.setEnabled(false);
        this.somethingHasChanged();
    }

    private void repeatingNoButtonActionPerformed(ActionEvent evt) {
        this.dropCurrentCard();
    }

    private void repeatingYesButtonActionPerformed(ActionEvent evt) {
        this.pushCurrentCard();
    }

    private void showMeButtonActionPerformed(ActionEvent evt) {
        this.showPanel(this.repeatingCardPanel, "repeatingShowPanel");
        this.showPanel(this.repeatingButtonCardPanel, "questionButtonPanel");
        this.getRootPane().setDefaultButton(null);
        this.repeatingYesButton.requestFocusInWindow();
    }

    private void nextNewCardButtonActionPerformed(ActionEvent evt) {
        this.currentLesson.getUltraShortTermList().add(this.currentCard);
        this.currentLesson.getUnlearnedBatch().removeCard(this.currentCard);
        this.statisticPanel.setLesson(this.currentLesson);
        if (this.currentUSTMTime == this.ustmTime) {
            this.repeatUSTMCards();
            return;
        }
        this.showNextUnlearnedCard();
    }

    private void cancelLearningButtonActionPerformed(ActionEvent evt) {
        if (this.currentLesson.getUltraShortTermList().size() + this.currentLesson.getShortTermList().size() > 0) {
            Object[] options = new Object[]{strings.getString("Cancel_Learning"), strings.getString("Continue_Learning")};
            this.questionLabel.setText(strings.getString("Cancel_Learning_Question"));
            this.explanationLabel.setText(strings.getString("Cancel_Learning_Explanation"));
            int result = JOptionPane.showOptionDialog(this, this.questionPanel, strings.getString("Warning"), -1, 2, null, options, options[0]);
            if (result != 0) {
                return;
            }
        }
        this.pauseLearningToggleButton.setSelected(false);
        Pauker.setLearningPhase(Pauker.LearningPhase.NOTHING);
        this.ustmTimer.stop();
        this.stmTimer.stop();
        Batch unlearnedBatch = this.currentLesson.getUnlearnedBatch();
        List<Card> shortTermList = this.currentLesson.getShortTermList();
        for (int i = shortTermList.size() - 1; i >= 0; --i) {
            unlearnedBatch.addCard(shortTermList.remove(i));
        }
        List<Card> ultraShortTermList = this.currentLesson.getUltraShortTermList();
        for (int i = ultraShortTermList.size() - 1; i >= 0; --i) {
            unlearnedBatch.addCard(ultraShortTermList.remove(i));
        }
        this.resetGUI();
    }

    private void recentFilesMenuMenuSelected(MenuEvent evt) {
        if (this.recentFilesHaveChanged) {
            this.recentFilesMenu.removeAll();
            for (String recentFile : this.recentFiles) {
                JMenuItem newMenuItem = new JMenuItem(recentFile);
                newMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent event) {
                        PaukerFrame.this.openRecentFile(event);
                    }
                });
                this.recentFilesMenu.add(newMenuItem);
            }
            this.recentFilesHaveChanged = false;
        }
    }

    private void repeatCardsButtonActionPerformed(ActionEvent evt) {
        Pauker.setLearningPhase(Pauker.LearningPhase.REPEATING_LTM);
        this.fileMenu.setEnabled(false);
        this.extraMenu.setEnabled(false);
        this.helpMenu.setEnabled(false);
        this.newButton.setEnabled(false);
        this.openButton.setEnabled(false);
        this.saveButton.setEnabled(false);
        this.showPanel(this.cardPanel, "learningPanel");
        this.showPanel(this.learningCardPanel, "repeatingPanel");
        this.showPanel(this.learningStatusPanel, "cancelRepeatingPanel");
        this.statisticPanel.setMouseSensitive(false);
        this.repeatExpiredCard();
    }

    private void learnNewCardsButtonActionPerformed(ActionEvent evt) {
        this.ustmTimerProgressBar.setValue(0);
        this.ustmTimerProgressBar.setString("0 / " + this.ustmTime + " " + strings.getString("Seconds"));
        this.stmTimeString = PaukerFrame.getMinSecString(this.stmTime);
        this.stmTimerProgressBar.setValue(0);
        this.stmTimerProgressBar.setString("0:00 / " + this.stmTimeString + " " + strings.getString("Minutes"));
        this.fileMenu.setEnabled(false);
        this.extraMenu.setEnabled(false);
        this.helpMenu.setEnabled(false);
        this.newButton.setEnabled(false);
        this.openButton.setEnabled(false);
        this.saveButton.setEnabled(false);
        Pauker.setLearningPhase(Pauker.LearningPhase.FILLING_USTM);
        this.statisticPanel.setMouseSensitive(false);
        this.showPanel(this.cardPanel, "learningPanel");
        this.showPanel(this.learningStatusPanel, "timerPanel");
        this.currentSTMTime = 0;
        this.stmTimer.start();
        this.learnNewCards();
    }

    private void removeCardButtonActionPerformed(ActionEvent evt) {
        Card card;
        int i;
        int[] selectedIndices = this.batchList.getSelectedIndices();
        String questionString = null;
        Object[] options = new Object[]{null, strings.getString("Cancel")};
        if (selectedIndices.length == 1) {
            questionString = strings.getString("Confirm_Card_Removal");
            options[0] = strings.getString("Remove_Card");
        } else {
            questionString = strings.getString("Confirm_Cards_Removal");
            options[0] = strings.getString("Remove_Cards");
        }
        int result = JOptionPane.showOptionDialog(this, questionString, strings.getString("Question"), -1, 3, null, options, options[0]);
        if (result != 0) {
            return;
        }
        SummaryBatch summaryBatch = this.currentLesson.getSummaryBatch();
        if (this.loadedBatch == summaryBatch) {
            for (i = selectedIndices.length - 1; i >= 0; --i) {
                card = summaryBatch.removeCard(selectedIndices[i]);
                this.searchEngine.removeCard(card);
            }
        } else {
            for (i = selectedIndices.length - 1; i >= 0; --i) {
                card = this.loadedBatch.removeCard(selectedIndices[i]);
                this.searchEngine.removeCard(card);
                summaryBatch.removeCard(card);
            }
        }
        this.batchListModel.setBatch(this.loadedBatch);
        this.batchList.clearSelection();
        this.currentLesson.trim();
        this.statisticPanel.setLesson(this.currentLesson);
        int cardsLeft = this.loadedBatch.getNumberOfCards();
        this.editCardButton.setEnabled(false);
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
        boolean hasSeveralCards = cardsLeft > 1;
        this.sortButton.setEnabled(hasSeveralCards);
        this.randomizeButton.setEnabled(hasSeveralCards);
        this.searchButton.setEnabled(cardsLeft > 0);
        this.forgetButton.setEnabled(false);
        this.instantRepeatButton.setEnabled(false);
        this.removeCardButton.setEnabled(false);
        this.learnNewCardsButton.setEnabled(this.currentLesson.getUnlearnedBatch().getNumberOfCards() > 0);
        this.somethingHasChanged();
    }

    private void editCardButtonActionPerformed(ActionEvent evt) {
        int selectedIndex = this.batchList.getSelectedIndex();
        Card selectedCard = (Card)this.batchListModel.get(selectedIndex);
        EditCardDialog dialog = new EditCardDialog(this, selectedCard, this.searchEngine);
        if (dialog.okPressed()) {
            this.cardChanged(selectedIndex);
        }
    }

    private void addCardButtonActionPerformed(ActionEvent evt) {
        this.showNewCardDialog();
    }

    private void aboutProgramMenuItemActionPerformed(ActionEvent evt) {
        AboutDialog aboutDialog = new AboutDialog(this);
        aboutDialog.setVisible(true);
    }

    private void openMenuItemActionPerformed(ActionEvent evt) {
        this.openAction();
    }

    private void newMenuItemActionPerformed(ActionEvent evt) {
        if (Pauker.getLearningPhase() == Pauker.LearningPhase.NOTHING) {
            this.newAction();
        }
    }

    private void saveAsMenuItemActionPerformed(ActionEvent evt) {
        this.saveFileAs();
    }

    private void saveMenuItemActionPerformed(ActionEvent evt) {
        this.saveFile(this.currentFileName, false);
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        this.exitProgram();
    }

    private void exitForm(WindowEvent evt) {
        if (!modalDialogVisible) {
            this.exitProgram();
        }
    }

    private boolean canRemoveCard() {
        Object[] options = new Object[]{strings.getString("Remove_Card"), strings.getString("Cancel")};
        String questionString = strings.getString("Confirm_Card_Removal");
        int result = JOptionPane.showOptionDialog(this, questionString, strings.getString("Question"), -1, 3, null, options, options[0]);
        return result == 0;
    }

    private void showNextUnlearnedCard() {
        Batch unlearnedBatch = this.currentLesson.getUnlearnedBatch();
        if (unlearnedBatch.getNumberOfCards() > 0) {
            this.currentCard = unlearnedBatch.getCard(0);
            PaukerFrame.fillTextAreaWithCardSide(this.currentCard.getFrontSide(), this.ustmFrontSideTextArea, false);
            PaukerFrame.fillTextAreaWithCardSide(this.currentCard.getReverseSide(), this.ustmReverseSideTextArea, false);
            if (unlearnedBatch.getNumberOfCards() == 1) {
                this.nextNewCardButton.setText(strings.getString("Repeat"));
            }
            this.updateSplitPane(this.ustmSplitPane, this.ustmFrontSideTextArea, this.ustmReverseSideTextArea);
        } else {
            this.showPanel(this.learningCardPanel, "waitForUSTMPanel");
            this.getRootPane().setDefaultButton(null);
            this.repeatUSTMButton.requestFocusInWindow();
            Pauker.setLearningPhase(Pauker.LearningPhase.WAITING_FOR_USTM);
        }
    }

    private void exitProgram() {
        int i;
        switch (Pauker.getLearningPhase()) {
            case REPEATING_USTM: 
            case REPEATING_STM: 
            case WAITING_FOR_USTM: 
            case WAITING_FOR_STM: {
                modalDialogVisible = true;
                JOptionPane.showMessageDialog(this, strings.getString("Exit_Warning_Message"), strings.getString("Warning"), 2);
                modalDialogVisible = false;
                return;
            }
        }
        if (!this.unsavedChangesOK()) {
            return;
        }
        BorderLayout borderLayout = (BorderLayout)this.getContentPane().getLayout();
        Object toolBarConstraints = borderLayout.getConstraints(this.toolBar);
        Preferences preferences = Preferences.userRoot().node(preferencesPathName);
        for (i = 0; i < this.recentFiles.size(); ++i) {
            String recentFile = this.recentFiles.get(i);
            preferences.put("RECENT_FILE_" + i, recentFile);
        }
        for (i = this.recentFiles.size(); i < 4; ++i) {
            preferences.remove("RECENT_FILE_" + i);
        }
        preferences.put("LAST_DIRECTORY", this.lastAccessedDirectory);
        preferences.putBoolean("SHOW_TIMER", this.showTimer);
        preferences.putInt("REPEATING_STRATEGY", this.repeatingStrategy.ordinal());
        preferences.putInt("PUTBACK_STRATEGY", this.putBackStrategy.ordinal());
        preferences.putInt("USTM_TIME", this.ustmTime);
        preferences.putInt("STM_TIME", this.stmTime);
        preferences.putBoolean("MATCH_CASE", this.matchCase);
        preferences.putBoolean("LINE_WRAPPING", this.lineWrapping);
        preferences.putInt("SPLIT_ORIENTATION", this.splitOrientation);
        preferences.putInt("SEARCH_LIMIT", this.searchLimit);
        preferences.putBoolean("PLAY_RINGTONE", this.playRingTone);
        preferences.putInt("MAIN_DIVIDER_LOCATION", this.splitPane.getDividerLocation());
        if (toolBarConstraints == null) {
            preferences.remove("TOOLBAR_CONSTRAINTS");
        } else {
            preferences.put("TOOLBAR_CONSTRAINTS", toolBarConstraints.toString());
        }
        preferences.putBoolean("TOOLBAR_VISIBLE", this.toolBar.isVisible());
        if (this.newCardDialog != null) {
            EditCardPanel editCardPanel = this.newCardDialog.getEditCardPanel();
            JTextComponent textComponent = editCardPanel.getFrontSideTextComponent();
            Font font = textComponent.getFont();
            preferences.put("FRONTSIDE_FONT_FAMILY", font.getFamily());
            preferences.putInt("FRONTSIDE_FONT_STYLE", font.getStyle());
            preferences.putInt("FRONTSIDE_FONT_SIZE", font.getSize());
            preferences.putInt("FRONTSIDE_FOREGROUND", textComponent.getForeground().getRGB());
            preferences.putInt("FRONTSIDE_BACKGROUND", textComponent.getBackground().getRGB());
            textComponent = editCardPanel.getReverseSideTextComponent();
            font = textComponent.getFont();
            preferences.put("REVERSESIDE_FONT_FAMILY", font.getFamily());
            preferences.putInt("REVERSESIDE_FONT_STYLE", font.getStyle());
            preferences.putInt("REVERSESIDE_FONT_SIZE", font.getSize());
            preferences.putInt("REVERSESIDE_FOREGROUND", textComponent.getForeground().getRGB());
            preferences.putInt("REVERSESIDE_BACKGROUND", textComponent.getBackground().getRGB());
            preferences.putBoolean("REPEAT_BY_TYPING", editCardPanel.getRepeatByTyping());
            preferences.putBoolean("KEEP_NEW_CARD_WINDOW_OPEN", this.keepNewCardDialogOpen);
        }
        System.exit(0);
    }

    public static void main(final String[] args) {
        String javaVendor = System.getProperty("java.vendor");
        String javaVersion = System.getProperty("java.version");
        System.out.println("Java vendor: \"" + javaVendor + "\"");
        System.out.println("Java version: \"" + javaVersion + "\"");
        StringTokenizer tokenizer = new StringTokenizer(javaVersion, ".");
        int majorVersion = Integer.parseInt(tokenizer.nextToken());
        int minorVersion = Integer.parseInt(tokenizer.nextToken());
        if (majorVersion <= 1 && minorVersion <= 4) {
            System.out.println("***************************************************");
            System.out.println(strings.getString("Error_Java_Version"));
            System.out.println("***************************************************");
            System.exit(-1);
        }
        String osName = System.getProperty("os.name");
        System.out.println("Operating system: \"" + osName + "\"");
        if (osName.equals("Mac OS X")) {
            System.out.println("using Mac OS X screen menu bar...");
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        String userLanguage = System.getProperty("user.language");
        String userCountry = System.getProperty("user.country");
        System.out.println("User language: \"" + userLanguage + "\"");
        System.out.println("User country: \"" + userCountry + "\"");
        String language = Locale.getDefault().getLanguage();
        if (language.equals("nl") || language.equals("eo") || language.equals("pl")) {
            PaukerFrame.translateUI("FileChooser.detailsViewButtonToolTipText");
            PaukerFrame.translateUI("FileChooser.fileNameLabelText");
            PaukerFrame.translateUI("FileChooser.filesOfTypeLabelText");
            PaukerFrame.translateUI("FileChooser.homeFolderToolTipText");
            PaukerFrame.translateUI("FileChooser.listViewButtonToolTipText");
            PaukerFrame.translateUI("FileChooser.lookInLabelText");
            PaukerFrame.translateUI("FileChooser.newFolderToolTipText");
            PaukerFrame.translateUI("FileChooser.upFolderToolTipText");
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                PaukerFrame paukerFrame = new PaukerFrame();
                paukerFrame.setVisible(true);
                if (args.length > 0) {
                    String path = args[0];
                    if (args[0].equals("-open") && args.length > 1) {
                        path = args[1];
                    }
                    File file = new File(path);
                    paukerFrame.openFiles(new File[]{file}, null, false);
                }
            }
        });
    }

    private static void translateUI(String key) {
        UIManager.put(key, strings.getString(key));
    }

    private void textChanged(DocumentEvent documentEvent) {
        Document eventSource = documentEvent.getDocument();
        if (eventSource == this.aboutDocument) {
            this.currentLesson.setDescription(this.aboutTextArea.getText());
            if (!this.settingAboutText) {
                this.somethingHasChanged();
            }
        }
    }

    private void showPanel(JPanel panel, String card) {
        CardLayout layoutManager = (CardLayout)panel.getLayout();
        layoutManager.show(panel, card);
    }

    private void switchLayout(JButton button, JSplitPane splitPane, JTextArea frontSideTextArea, JTextArea reverseSideTextArea) {
        if (this.splitOrientation == 1) {
            this.splitOrientation = 0;
            button.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/view_left_right_16.png")));
            button.setToolTipText(strings.getString("Cardsides_Left_Right"));
        } else {
            this.splitOrientation = 1;
            button.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/view_top_bottom_16.png")));
            button.setToolTipText(strings.getString("Cardsides_Top_Down"));
        }
        this.updateSplitPane(splitPane, frontSideTextArea, reverseSideTextArea);
    }

    private void setRepeatByTyping(boolean repeatByTyping) {
        for (int index : this.batchList.getSelectedIndices()) {
            Card card = this.loadedBatch.getCard(index);
            card.setRepeatByTyping(repeatByTyping);
            this.batchListModel.cardsChanged(index, index);
        }
        this.somethingHasChanged();
    }

    private void sortBatch(Card.Element element, boolean ascending) {
        int[] selectedIndices = this.batchList.getSelectedIndices();
        int[] newIndices = this.loadedBatch.sortCards(element, ascending);
        this.batchListModel.setBatch(this.loadedBatch);
        this.batchListModel.cardsChanged(0, this.loadedBatch.getNumberOfCards() - 1);
        this.batchList.clearSelection();
        for (int i : selectedIndices) {
            int index = newIndices[i];
            this.batchList.addSelectionInterval(index, index);
        }
        if (selectedIndices.length > 0) {
            this.batchList.ensureIndexIsVisible(newIndices[selectedIndices[0]]);
        }
        this.somethingHasChanged();
    }

    private void moveCards(int offset) {
        int[] selectedIndices = this.batchList.getSelectedIndices();
        this.loadedBatch.moveCards(selectedIndices, offset);
        this.batchListModel.setBatch(this.loadedBatch);
        int firstIndex = selectedIndices[0];
        int lastIndex = selectedIndices[selectedIndices.length - 1];
        int movedFirstIndex = firstIndex + offset;
        int movedLastIndex = lastIndex + offset;
        if (offset > 0) {
            this.batchListModel.cardsChanged(firstIndex, movedLastIndex);
        } else {
            this.batchListModel.cardsChanged(movedFirstIndex, lastIndex);
        }
        this.batchList.clearSelection();
        for (int i : selectedIndices) {
            int index = i + offset;
            this.batchList.addSelectionInterval(index, index);
        }
        Rectangle rectangle = this.batchList.getCellBounds(movedFirstIndex, movedLastIndex);
        this.batchList.scrollRectToVisible(rectangle);
        this.somethingHasChanged();
    }

    private void setLineWrap(boolean lineWrap) {
        this.ustmFrontSideTextArea.setLineWrap(lineWrap);
        this.ustmReverseSideTextArea.setLineWrap(lineWrap);
        this.repeatingFrontSideTextArea.setLineWrap(lineWrap);
        this.repeatingReverseSideTextArea.setLineWrap(lineWrap);
        this.repeatingInsertTextArea.setLineWrap(lineWrap);
        this.batchList.setLineWrapping(lineWrap);
        this.batchListCellRenderer.setLineWrap(lineWrap);
    }

    private void resetGUI() {
        Pauker.setLearningPhase(Pauker.LearningPhase.NOTHING);
        this.currentLesson.trim();
        this.setTitle(this.currentTitle);
        this.getRootPane().setDefaultButton(null);
        this.statisticPanel.setLesson(this.currentLesson);
        this.statisticPanel.clearSelection();
        this.statisticPanel.setMouseSensitive(true);
        this.fileMenu.setEnabled(true);
        this.extraMenu.setEnabled(true);
        this.helpMenu.setEnabled(true);
        this.newButton.setEnabled(true);
        this.openButton.setEnabled(true);
        this.saveButton.setEnabled(this.somethingHasChanged);
        this.saveMenuItem.setEnabled(this.somethingHasChanged);
        this.learnNewCardsButton.setEnabled(this.currentLesson.getUnlearnedBatch().getNumberOfCards() > 0);
        this.repeatCardsButton.setEnabled(this.currentLesson.getNumberOfExpiredCards() > 0);
        this.showPanel(this.cardPanel, "overviewPanel");
        this.showPanel(this.lessonPanel, "aboutPanel");
    }

    private void repeatCard(Card card) {
        this.currentCard = card;
        switch (Pauker.getLearningPhase()) {
            case REPEATING_USTM: {
                this.statisticPanel.selectUltraShortTermBatch();
                break;
            }
            case REPEATING_STM: {
                this.statisticPanel.selectShortTermBatch();
                break;
            }
            case REPEATING_LTM: {
                int longTermBatchNumber = card.getLongTermBatchNumber();
                this.statisticPanel.selectLongTermBatch(longTermBatchNumber);
                break;
            }
            default: {
                throw new RuntimeException("unsupported learning phase \"" + (Object)((Object)Pauker.getLearningPhase()) + "\" -> could not set selection in statistics!");
            }
        }
        PaukerFrame.fillTextAreaWithCardSide(this.currentCard.getFrontSide(), this.repeatingFrontSideTextArea, false);
        CardSide reverseSide = this.currentCard.getReverseSide();
        this.showPanel(this.learningCardPanel, "repeatingPanel");
        this.getRootPane().setDefaultButton(null);
        PaukerFrame.fillTextAreaWithCardSide(reverseSide, this.repeatingReverseSideTextArea, false);
        if (this.currentCard.isRepeatedByTyping()) {
            this.showPanel(this.repeatingCardPanel, "repeatingInsertPanel");
            this.showPanel(this.repeatingButtonCardPanel, "typingOKPanel");
            PaukerFrame.setFontAndOrientation(reverseSide, this.repeatingInsertTextArea);
            this.repeatingInsertTextArea.setText("");
            this.repeatingInsertTextArea.requestFocusInWindow();
            this.repeatingInsertTextArea.setForeground(Color.BLACK);
            this.getRootPane().setDefaultButton(this.typingOKButton);
        } else {
            this.showPanel(this.repeatingCardPanel, "repeatingAskPanel");
            this.showPanel(this.repeatingButtonCardPanel, "showMeButtonPanel");
            this.showMeButton.requestFocusInWindow();
        }
        this.updateSplitPane(this.repeatingSplitPane, this.repeatingFrontSideTextArea, this.repeatingReverseSideTextArea);
    }

    private void dropCurrentCard() {
        Batch unlearnedBatch = this.currentLesson.getUnlearnedBatch();
        switch (this.putBackStrategy) {
            case ON_TOP: {
                unlearnedBatch.addCard(0, this.currentCard);
                break;
            }
            case AT_BOTTOM: {
                unlearnedBatch.addCard(this.currentCard);
                break;
            }
            case ANYWHERE: {
                int randomIndex = this.nextRandom(unlearnedBatch.getNumberOfCards());
                unlearnedBatch.addCard(randomIndex, this.currentCard);
            }
        }
        this.removeCurrentCard();
        this.statisticPanel.setLesson(this.currentLesson);
        if (Pauker.getLearningPhase() == Pauker.LearningPhase.REPEATING_LTM) {
            this.somethingHasChanged();
        }
        this.repeatedCardMoved();
    }

    private void openRecentFile(ActionEvent actionEvent) {
        if (!this.unsavedChangesOK()) {
            return;
        }
        JMenuItem menuItem = (JMenuItem)actionEvent.getSource();
        String path = menuItem.getText();
        File file = new File(path);
        this.openFiles(new File[]{file}, null, false);
    }

    private boolean unsavedChangesOK() {
        if (!this.somethingHasChanged) {
            return true;
        }
        Object[] options = new Object[]{strings.getString("Save"), strings.getString("DontSave"), strings.getString("Cancel")};
        modalDialogVisible = true;
        this.questionLabel.setText(strings.getString("Unsaved_Changes_Question"));
        this.explanationLabel.setText(strings.getString("Unsaved_Changes_Explanation"));
        int result = JOptionPane.showOptionDialog(this, this.questionPanel, strings.getString("Question"), -1, 3, null, options, options[0]);
        modalDialogVisible = false;
        switch (result) {
            case 0: {
                return this.saveFile(this.currentFileName, false);
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    private void repeatExpiredCard() {
        switch (this.repeatingStrategy) {
            case OLDEST_FIRST: {
                for (int i = this.currentLesson.getNumberOfLongTermBatches() - 1; i >= 0; --i) {
                    if (!this.expiredCardRepeated(i)) continue;
                    return;
                }
                break;
            }
            case NEWEST_FIRST: {
                int numberOfBatches = this.currentLesson.getNumberOfLongTermBatches();
                for (int i = 0; i < numberOfBatches; ++i) {
                    if (!this.expiredCardRepeated(i)) continue;
                    return;
                }
                break;
            }
            case RANDOM_ORDER: {
                Card expiredCard = this.currentLesson.getRandomExpiredCard();
                if (expiredCard == null) break;
                this.repeatCard(expiredCard);
                return;
            }
        }
        this.resetGUI();
    }

    private boolean expiredCardRepeated(int longTermBatchIndex) {
        LongTermBatch longTermBatch = this.currentLesson.getLongTermBatch(longTermBatchIndex);
        if (longTermBatch.getNumberOfExpiredCards() > 0) {
            Card expiredCard = longTermBatch.getOldestExpiredCard();
            this.repeatCard(expiredCard);
            return true;
        }
        return false;
    }

    private void learnNewCards() {
        this.statisticPanel.selectUnlearnedBatch();
        Batch unlearnedBatch = this.currentLesson.getUnlearnedBatch();
        if (unlearnedBatch.getNumberOfCards() == 1) {
            this.nextNewCardButton.setText(strings.getString("Repeat"));
        } else {
            this.nextNewCardButton.setText(strings.getString("Next_Card"));
        }
        this.currentCard = unlearnedBatch.getCard(0);
        PaukerFrame.fillTextAreaWithCardSide(this.currentCard.getFrontSide(), this.ustmFrontSideTextArea, false);
        PaukerFrame.fillTextAreaWithCardSide(this.currentCard.getReverseSide(), this.ustmReverseSideTextArea, false);
        if (this.splitOrientation == 1) {
            this.switchUSTMLayoutButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/view_top_bottom_16.png")));
            this.switchUSTMLayoutButton.setToolTipText(strings.getString("Cardsides_Top_Down"));
        } else {
            this.switchUSTMLayoutButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/view_left_right_16.png")));
            this.switchUSTMLayoutButton.setToolTipText(strings.getString("Cardsides_Left_Right"));
        }
        this.updateSplitPane(this.ustmSplitPane, this.ustmFrontSideTextArea, this.ustmReverseSideTextArea);
        this.showPanel(this.learningCardPanel, "USTMLearningPanel");
        this.getRootPane().setDefaultButton(null);
        this.nextNewCardButton.requestFocusInWindow();
        this.currentUSTMTime = 0;
        this.ustmTimer.start();
    }

    private void updateSplitPane(JSplitPane splitPane, JTextArea frontSideTextArea, JTextArea reverseSideTextArea) {
        int lines;
        if (splitPane.getOrientation() != this.splitOrientation) {
            if (splitPane.getOrientation() == 1) {
                splitPane.setOrientation(0);
            } else {
                splitPane.setOrientation(1);
            }
        }
        frontSideTextArea.setRows((lines = frontSideTextArea.getLineCount()) == 0 ? 1 : lines);
        lines = reverseSideTextArea.getLineCount();
        reverseSideTextArea.setRows(lines == 0 ? 1 : lines);
        splitPane.resetToPreferredSizes();
    }

    private void repeatUSTMCards() {
        Pauker.setLearningPhase(Pauker.LearningPhase.REPEATING_USTM);
        this.ustmTimer.stop();
        this.ustmTimerProgressBar.setValue(0);
        this.ustmTimerProgressBar.setString("");
        if (this.splitOrientation == 1) {
            this.switchRepeatingLayoutButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/view_top_bottom_16.png")));
            this.switchRepeatingLayoutButton.setToolTipText(strings.getString("Cardsides_Top_Down"));
        } else {
            this.switchRepeatingLayoutButton.setIcon(new ImageIcon(this.getClass().getResource("/pauker/icons/view_left_right_16.png")));
            this.switchRepeatingLayoutButton.setToolTipText(strings.getString("Cardsides_Left_Right"));
        }
        Card firstUstmCard = this.currentLesson.getUltraShortTermList().get(0);
        this.repeatCard(firstUstmCard);
    }

    private void repeatSTMCards() {
        Pauker.setLearningPhase(Pauker.LearningPhase.REPEATING_STM);
        this.ustmTimer.stop();
        this.ustmTimerProgressBar.setValue(0);
        this.ustmTimerProgressBar.setString("");
        this.stmTimer.stop();
        this.stmTimerProgressBar.setValue(0);
        this.stmTimerProgressBar.setString("");
        this.setTitle(this.currentTitle);
        this.showPanel(this.learningCardPanel, "transitionPanel");
        this.getRootPane().setDefaultButton(null);
        this.transitionOKButton.requestFocusInWindow();
    }

    private void cardChanged(int selectedIndex) {
        this.loadedBatch.repeatSearch();
        this.batchListModel.cardsChanged(selectedIndex, selectedIndex);
        this.batchList.ensureIndexIsVisible(selectedIndex);
        this.somethingHasChanged();
    }

    private void pushCurrentCard() {
        switch (Pauker.getLearningPhase()) {
            case REPEATING_USTM: {
                this.currentLesson.getUltraShortTermList().remove(this.currentCard);
                this.currentLesson.getShortTermList().add(this.currentCard);
                break;
            }
            case REPEATING_STM: {
                this.currentLesson.getShortTermList().remove(this.currentCard);
                if (this.currentLesson.getNumberOfLongTermBatches() == 0) {
                    this.currentLesson.addLongTermBatch();
                }
                LongTermBatch longTermBatch = this.currentLesson.getLongTermBatch(0);
                longTermBatch.addCard(this.currentCard);
                this.currentCard.setLearned(true);
                break;
            }
            case REPEATING_LTM: {
                int longTermBatchNumber = this.currentCard.getLongTermBatchNumber();
                int nextLongTermBatchNumber = longTermBatchNumber + 1;
                LongTermBatch longTermBatch = this.currentLesson.getLongTermBatch(longTermBatchNumber);
                longTermBatch.removeCard(this.currentCard);
                if (this.currentLesson.getNumberOfLongTermBatches() == nextLongTermBatchNumber) {
                    this.currentLesson.addLongTermBatch();
                }
                LongTermBatch nextLongTermBatch = this.currentLesson.getLongTermBatch(nextLongTermBatchNumber);
                nextLongTermBatch.addCard(this.currentCard);
                this.currentCard.updateLernedTimeStamp();
                break;
            }
            default: {
                throw new RuntimeException("unsupported learning phase \"" + (Object)((Object)Pauker.getLearningPhase()) + "\" -> can't find batch of card!");
            }
        }
        this.statisticPanel.setLesson(this.currentLesson);
        if (Pauker.getLearningPhase() != Pauker.LearningPhase.REPEATING_USTM) {
            this.somethingHasChanged();
        }
        this.repeatedCardMoved();
    }

    private void repeatedCardMoved() {
        switch (Pauker.getLearningPhase()) {
            case REPEATING_USTM: {
                List<Card> ustmList = this.currentLesson.getUltraShortTermList();
                if (ustmList.size() > 0) {
                    Card firstUstmCard = ustmList.get(0);
                    this.repeatCard(firstUstmCard);
                    break;
                }
                if (this.currentSTMTime == this.stmTime) {
                    this.repeatSTMCards();
                    break;
                }
                if (this.currentLesson.getUnlearnedBatch().getNumberOfCards() == 0) {
                    this.showPanel(this.learningCardPanel, "waitForSTMPanel");
                    this.getRootPane().setDefaultButton(null);
                    this.repeatSTMButton.requestFocusInWindow();
                    Pauker.setLearningPhase(Pauker.LearningPhase.WAITING_FOR_STM);
                    break;
                }
                this.learnNewCards();
                break;
            }
            case REPEATING_STM: {
                List<Card> stmList = this.currentLesson.getShortTermList();
                if (stmList.size() > 0) {
                    Card firstStmCard = stmList.get(0);
                    this.repeatCard(firstStmCard);
                    break;
                }
                Pauker.setLearningPhase(Pauker.LearningPhase.NOTHING);
                this.resetGUI();
                break;
            }
            case REPEATING_LTM: {
                this.repeatExpiredCard();
            }
        }
    }

    private void openAction() {
        if (!this.unsavedChangesOK()) {
            return;
        }
        if (this.lastAccessedDirectory != null) {
            this.openFileDialog.setCurrentDirectory(new File(this.lastAccessedDirectory));
        }
        this.openFileDialog.reset();
        this.openFileDialog.showOpenDialog(this);
    }

    public boolean openFiles(File[] files, String encoding, boolean merging) {
        String path = null;
        try {
            if (merging) {
                int i;
                Lesson[] newLessons = new Lesson[files.length];
                for (i = 0; i < files.length; ++i) {
                    path = files[i].getPath();
                    newLessons[i] = Pauker.openLesson(path, encoding);
                }
                System.out.println("all lessons opened");
                for (i = 0; i < newLessons.length; ++i) {
                    Lesson newLesson = newLessons[i];
                    if (newLesson.getNumberOfCards() == 0) {
                        System.out.println(files[i] + " contains no cards!");
                        continue;
                    }
                    this.somethingHasChanged();
                    this.currentLesson.merge(newLesson);
                }
                System.out.println("all lessons merged");
            } else {
                path = files[0].getPath();
                Lesson newLesson = Pauker.openLesson(path, encoding);
                int lastSeparatorIndex = path.lastIndexOf(File.separatorChar);
                if (lastSeparatorIndex != -1) {
                    this.lastAccessedDirectory = path.substring(0, lastSeparatorIndex);
                }
                this.currentLesson = newLesson;
                this.currentFileName = path;
                this.addToRecentFiles(this.currentFileName);
                this.somethingHasChanged = false;
                this.currentTitle = path.substring(lastSeparatorIndex + 1) + " (" + this.titleString + ")";
                this.setTitle(this.currentTitle);
                this.saveButton.setEnabled(false);
                this.saveMenuItem.setEnabled(false);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String errorMessage = strings.getString("Error_Opening_File");
            errorMessage = MessageFormat.format(errorMessage, path);
            JOptionPane.showMessageDialog(this, errorMessage, strings.getString("Error"), 0);
            this.recentFiles.remove(path);
            this.recentFilesHaveChanged = true;
            return false;
        }
        this.currentLesson.refreshExpiration();
        this.statisticPanel.setLesson(this.currentLesson);
        this.learnNewCardsButton.setEnabled(this.currentLesson.getUnlearnedBatch().getNumberOfCards() > 0);
        this.repeatCardsButton.setEnabled(this.currentLesson.getNumberOfExpiredCards() > 0);
        this.settingAboutText = true;
        this.aboutTextArea.setText(this.currentLesson.getDescription());
        this.aboutTextArea.setCaretPosition(0);
        this.settingAboutText = false;
        this.showPanel(this.lessonPanel, "aboutPanel");
        this.statisticPanel.setPreferredSize(null);
        Dimension preferredStatisticSize = this.statisticPanel.getPreferredSize();
        Dimension newSize = new Dimension(preferredStatisticSize);
        newSize.height = 220;
        this.statisticPanel.setPreferredSize(newSize);
        this.pack();
        this.searchEngine.init();
        this.searchEngine.index(this.currentLesson);
        return true;
    }

    private void addToRecentFiles(String path) {
        boolean entryExists = false;
        int existingIndex = 0;
        for (int i = 0; i < this.recentFiles.size(); ++i) {
            if (!path.equals(this.recentFiles.get(i))) continue;
            entryExists = true;
            existingIndex = i;
            break;
        }
        if (entryExists) {
            this.recentFiles.add(0, this.recentFiles.remove(existingIndex));
        } else {
            this.recentFiles.add(0, path);
            int size = this.recentFiles.size();
            if (size > 4) {
                this.recentFiles.remove(size - 1);
            }
        }
        this.recentFilesHaveChanged = true;
    }

    private void newAction() {
        if (!this.unsavedChangesOK()) {
            return;
        }
        this.currentLesson = new Lesson();
        this.currentFileName = null;
        this.statisticPanel.setLesson(this.currentLesson);
        this.settingAboutText = true;
        this.aboutTextArea.setText(this.currentLesson.getDescription());
        this.aboutTextArea.setCaretPosition(0);
        this.settingAboutText = false;
        this.showPanel(this.lessonPanel, "aboutPanel");
        this.learnNewCardsButton.setEnabled(false);
        this.repeatCardsButton.setEnabled(false);
        this.currentTitle = this.titleString;
        this.setTitle(this.currentTitle);
        this.somethingHasChanged = false;
        this.saveButton.setEnabled(false);
        this.saveMenuItem.setEnabled(false);
        this.searchEngine.init();
    }

    private boolean saveFile(String fileName, boolean checkOverwrite) {
        if (fileName == null) {
            return this.saveFileAs();
        }
        try {
            FileFilter fileFilter = this.saveFileChooser.getFileFilter();
            if (fileFilter == this.csvFileFilter) {
                if (!fileName.toLowerCase().endsWith(".csv")) {
                    fileName = fileName + ".csv";
                }
                if (checkOverwrite && !this.overWritingOK(fileName)) {
                    return false;
                }
                String csvData = Pauker.lessonToCSV(this.currentLesson);
                FileOutputStream fileOutputStream = new FileOutputStream(fileName);
                fileOutputStream.write(csvData.getBytes("UTF-8"));
                fileOutputStream.flush();
                fileOutputStream.close();
                int lastSeparatorIndex = fileName.lastIndexOf(File.separatorChar);
                if (lastSeparatorIndex != -1) {
                    this.lastAccessedDirectory = fileName.substring(0, lastSeparatorIndex);
                }
                return true;
            }
            if (!fileName.endsWith(".pau.gz") && !fileName.endsWith(".xml.gz")) {
                if (fileName.endsWith(".pkr")) {
                    fileName = fileName.substring(0, fileName.length() - 4);
                } else if (fileName.endsWith(".pau")) {
                    fileName = fileName.substring(0, fileName.length() - 4);
                }
                fileName = fileName + ".pau.gz";
            }
            if (checkOverwrite && !this.overWritingOK(fileName)) {
                return false;
            }
            String xmlData = Pauker.lessonToXML(this.currentLesson);
            FileOutputStream fileOutputStream = new FileOutputStream(fileName);
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(fileOutputStream);
            gzipOutputStream.write(xmlData.getBytes("UTF-8"));
            gzipOutputStream.finish();
            gzipOutputStream.flush();
            gzipOutputStream.close();
            fileOutputStream.flush();
            fileOutputStream.close();
            this.currentFileName = fileName;
            this.addToRecentFiles(this.currentFileName);
            int lastSeparatorIndex = this.currentFileName.lastIndexOf(File.separatorChar);
            if (lastSeparatorIndex != -1) {
                this.lastAccessedDirectory = fileName.substring(0, lastSeparatorIndex);
            }
            this.currentTitle = this.currentFileName.substring(lastSeparatorIndex + 1) + " (" + this.titleString + ")";
            this.setTitle(this.currentTitle);
            this.somethingHasChanged = false;
            this.saveButton.setEnabled(false);
            this.saveMenuItem.setEnabled(false);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this, exception, strings.getString("Error"), 0);
            return false;
        }
    }

    private boolean overWritingOK(String fileName) {
        File testFile = new File(fileName);
        if (testFile.exists()) {
            Object[] options = new Object[]{strings.getString("Overwrite"), strings.getString("Cancel")};
            String warningMessage = strings.getString("File_Exists_Explanation");
            warningMessage = MessageFormat.format(warningMessage, testFile.getName());
            this.questionLabel.setText(strings.getString("File_Exists_Question"));
            this.explanationLabel.setText(warningMessage);
            int result = JOptionPane.showOptionDialog(this, this.questionPanel, strings.getString("Warning"), -1, 2, null, options, options[0]);
            if (result != 0) {
                return false;
            }
        }
        return true;
    }

    private boolean saveFileAs() {
        if (this.lastAccessedDirectory != null) {
            this.saveFileChooser.setCurrentDirectory(new File(this.lastAccessedDirectory));
            this.saveFileChooser.setSelectedFile(null);
        }
        this.saveFileChooser.setFileFilter(this.xmlFileFilter);
        int returnValue = this.saveFileChooser.showSaveDialog(this);
        if (returnValue == 0) {
            return this.saveFile(this.saveFileChooser.getSelectedFile().getPath(), true);
        }
        return false;
    }

    private void showNewCardDialog() {
        if ((this.loadedBatch == this.currentLesson.getSummaryBatch() || this.loadedBatch == this.currentLesson.getUnlearnedBatch()) && this.batchListModel.getSize() > 100) {
            this.showPanel(this.lessonPanel, "aboutPanel");
        }
        if (this.newCardDialog == null) {
            this.newCardDialog = new NewCardDialog(this, this.searchEngine, this.keepNewCardDialogOpen);
            EditCardPanel editCardPanel = this.newCardDialog.getEditCardPanel();
            JTextComponent textComponent = editCardPanel.getFrontSideTextComponent();
            textComponent.setFont(this.frontSideFont);
            textComponent.setForeground(this.frontSideForeground);
            textComponent.setBackground(this.frontSideBackground);
            textComponent = editCardPanel.getReverseSideTextComponent();
            textComponent.setFont(this.reverseSideFont);
            textComponent.setForeground(this.reverseSideForeground);
            textComponent.setBackground(this.reverseSideBackground);
            editCardPanel.setRepeatByTyping(this.repeatByTyping);
        } else {
            this.newCardDialog.reset();
            this.newCardDialog.setOrientation(this.splitOrientation);
        }
        this.newCardDialog.setVisible(true);
        this.keepNewCardDialogOpen = this.newCardDialog.getKeepOpen();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        JButton button;
        JRootPane rootPane;
        Object newFocusOwner;
        String propertyName = propertyChangeEvent.getPropertyName();
        if ("focusOwner".equals(propertyName) && (newFocusOwner = propertyChangeEvent.getNewValue()) instanceof JButton && (rootPane = (button = (JButton)newFocusOwner).getRootPane()) != null) {
            rootPane.setDefaultButton(button);
        }
    }

    public boolean isMatchCase() {
        return this.matchCase;
    }

    public boolean isPlayRingTone() {
        return this.playRingTone;
    }

    public Pauker.PutbackStrategy getPutBackStrategy() {
        return this.putBackStrategy;
    }

    public Pauker.RepeatingStrategy getRepeatingStrategy() {
        return this.repeatingStrategy;
    }

    public int getSearchLimit() {
        return this.searchLimit;
    }

    public int getStmTime() {
        return this.stmTime;
    }

    public int getUstmTime() {
        return this.ustmTime;
    }

    public FileFilter getXmlFileFilter() {
        return this.xmlFileFilter;
    }

    private int nextRandom(int exclusiveMaxValue) {
        if (exclusiveMaxValue == 0) {
            return 0;
        }
        if (this.random == null) {
            this.random = new Random();
        }
        return this.random.nextInt(exclusiveMaxValue);
    }

    private class MyFocusTraversalPolicy
    extends LayoutFocusTraversalPolicy {
        private MyFocusTraversalPolicy() {
        }

        public Component getComponentAfter(Container container, Component component) {
            if (component.equals(PaukerFrame.this.repeatingYesButton)) {
                return PaukerFrame.this.repeatingNoButton;
            }
            if (component.equals(PaukerFrame.this.repeatingNoButton)) {
                return PaukerFrame.this.repeatingYesButton;
            }
            if (component.equals(PaukerFrame.this.moveBackButton)) {
                return PaukerFrame.this.ignoreErrorButton;
            }
            if (component.equals(PaukerFrame.this.ignoreErrorButton)) {
                return PaukerFrame.this.moveBackButton;
            }
            return super.getComponentAfter(container, component);
        }

        public Component getComponentBefore(Container container, Component component) {
            if (component.equals(PaukerFrame.this.repeatingYesButton)) {
                return PaukerFrame.this.repeatingNoButton;
            }
            if (component.equals(PaukerFrame.this.repeatingNoButton)) {
                return PaukerFrame.this.repeatingYesButton;
            }
            if (component.equals(PaukerFrame.this.moveBackButton)) {
                return PaukerFrame.this.ignoreErrorButton;
            }
            if (component.equals(PaukerFrame.this.ignoreErrorButton)) {
                return PaukerFrame.this.moveBackButton;
            }
            return super.getComponentBefore(container, component);
        }
    }
}

