/*
 * Decompiled with CFR 0.152.
 */
package pauker.program.gui.swing;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ResourceBundle;
import java.util.SortedMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import pauker.program.gui.swing.FileChooserAccessory;
import pauker.program.gui.swing.PaukerFileView;
import pauker.program.gui.swing.PaukerFrame;

public class OpenFileDialog
extends JDialog
implements PropertyChangeListener {
    private FileFilter xmlFileFilter;
    private FileFilter csvFileFilter;
    private PaukerFrame paukerFrame;
    private CardLayout cardlayout;
    private FileChooserAccessory fileChooserAccessory;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JPanel comboBoxPanel;
    private JPanel emptyPanel;
    private JComboBox encodingComboBox;
    private JPanel encodingPanel;
    private JFileChooser fileChooser;
    private JCheckBox mergingCheckBox;
    private JButton openButton;

    public OpenFileDialog(PaukerFrame paukerFrame, FileFilter xmlFileFilter, FileFilter csvFileFilter) {
        super((Frame)paukerFrame, true);
        this.paukerFrame = paukerFrame;
        this.xmlFileFilter = xmlFileFilter;
        this.csvFileFilter = csvFileFilter;
        this.initComponents();
        this.cardlayout = (CardLayout)this.encodingPanel.getLayout();
        this.fileChooserAccessory = new FileChooserAccessory();
        this.fileChooser.setAccessory(this.fileChooserAccessory);
        this.fileChooser.addChoosableFileFilter(xmlFileFilter);
        this.fileChooser.addChoosableFileFilter(csvFileFilter);
        this.fileChooser.addPropertyChangeListener(this);
        AbstractAction okAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (!e.getActionCommand().equals("CancelSelection") && OpenFileDialog.this.fileChooser.getSelectedFile() != null) {
                    OpenFileDialog.this.openSelectedFiles();
                }
            }
        };
        this.fileChooser.addActionListener(okAction);
        SortedMap<String, Charset> charSets = Charset.availableCharsets();
        for (String charsetName : charSets.keySet()) {
            this.encodingComboBox.addItem(charsetName);
        }
        this.encodingComboBox.setSelectedItem("UTF-8");
        this.pack();
    }

    public void setCurrentDirectory(File directory) {
        this.fileChooser.setCurrentDirectory(directory);
    }

    public void reset() {
        this.fileChooser.setSelectedFile(null);
        this.fileChooser.setFileFilter(this.xmlFileFilter);
    }

    public void showOpenDialog(Component parent) {
        this.mergingCheckBox.setSelected(false);
        this.fileChooser.rescanCurrentDirectory();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
        this.dispose();
    }

    private void initComponents() {
        this.fileChooser = new JFileChooser();
        this.buttonPanel = new JPanel();
        this.encodingPanel = new JPanel();
        this.comboBoxPanel = new JPanel();
        this.encodingComboBox = new JComboBox();
        this.emptyPanel = new JPanel();
        this.mergingCheckBox = new JCheckBox();
        this.openButton = new JButton();
        this.cancelButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("pauker/Strings");
        this.setTitle(bundle.getString("Open"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                OpenFileDialog.this.closeDialog(evt);
            }
        });
        this.fileChooser.setControlButtonsAreShown(false);
        this.fileChooser.setFileFilter(this.xmlFileFilter);
        this.fileChooser.setFileView(new PaukerFileView());
        this.fileChooser.setName("fileChooser");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.fileChooser, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.encodingPanel.setLayout(new CardLayout());
        this.comboBoxPanel.setLayout(new GridBagLayout());
        this.comboBoxPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("Encoding")));
        this.encodingComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OpenFileDialog.this.encodingComboBoxActionPerformed(evt);
            }
        });
        this.comboBoxPanel.add((Component)this.encodingComboBox, new GridBagConstraints());
        this.encodingPanel.add((Component)this.comboBoxPanel, "comboBoxPanel");
        this.encodingPanel.add((Component)this.emptyPanel, "emptyPanel");
        this.buttonPanel.add((Component)this.encodingPanel, new GridBagConstraints());
        this.mergingCheckBox.setText(bundle.getString("Merge_Lesson"));
        this.mergingCheckBox.setName("mergingCheckBox");
        this.mergingCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                OpenFileDialog.this.mergingCheckBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.buttonPanel.add((Component)this.mergingCheckBox, gridBagConstraints);
        this.openButton.setText(bundle.getString("Open"));
        this.openButton.setEnabled(false);
        this.openButton.setName("openButton");
        this.openButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OpenFileDialog.this.openButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.buttonPanel.add((Component)this.openButton, gridBagConstraints);
        this.cancelButton.setText(bundle.getString("Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OpenFileDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.buttonPanel.add((Component)this.cancelButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.pack();
    }

    private void encodingComboBoxActionPerformed(ActionEvent evt) {
        String selectedEncoding = (String)this.encodingComboBox.getSelectedItem();
        this.fileChooserAccessory.setEncoding(selectedEncoding);
    }

    private void mergingCheckBoxItemStateChanged(ItemEvent evt) {
        if (this.mergingCheckBox.isSelected()) {
            File selectedFile = this.fileChooser.getSelectedFile();
            this.fileChooser.setMultiSelectionEnabled(true);
            if (selectedFile != null) {
                this.fileChooser.setSelectedFiles(new File[]{selectedFile});
            }
        } else {
            File[] selectedFiles = this.fileChooser.getSelectedFiles();
            this.fileChooser.setMultiSelectionEnabled(false);
            if (selectedFiles.length > 0) {
                this.fileChooser.setSelectedFile(selectedFiles[0]);
            }
        }
    }

    private void openButtonActionPerformed(ActionEvent evt) {
        this.openSelectedFiles();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
    }

    private void openSelectedFiles() {
        File[] selectedFiles = null;
        if (this.mergingCheckBox.isSelected()) {
            selectedFiles = this.fileChooser.getSelectedFiles();
        } else {
            File selectedFile = this.fileChooser.getSelectedFile();
            if (!selectedFile.exists()) {
                System.out.println(selectedFile + " doesn't exist!");
                return;
            }
            selectedFiles = new File[]{selectedFile};
        }
        if (selectedFiles == null || selectedFiles.length == 0) {
            System.out.println("no files selected!");
        } else if (this.paukerFrame.openFiles(selectedFiles, this.getEncoding(), this.mergingCheckBox.isSelected())) {
            this.setVisible(false);
        }
    }

    private String getEncoding() {
        return (String)this.encodingComboBox.getSelectedItem();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String property = propertyChangeEvent.getPropertyName();
        if (property.equals("fileFilterChanged")) {
            FileFilter newFilter = this.fileChooser.getFileFilter();
            if (newFilter == this.csvFileFilter) {
                this.cardlayout.show(this.encodingPanel, "comboBoxPanel");
            } else {
                this.cardlayout.show(this.encodingPanel, "emptyPanel");
            }
        } else if (property.equals("SelectedFileChangedProperty")) {
            File selectedFile = this.fileChooser.getSelectedFile();
            if (selectedFile == null || !selectedFile.exists()) {
                this.openButton.setEnabled(false);
            } else {
                this.openButton.setEnabled(true);
            }
            this.fileChooserAccessory.propertyChange(propertyChangeEvent);
        }
    }
}

