/*
 * Decompiled with CFR 0.152.
 */
package pauker.program.gui.swing;

import java.util.ArrayList;
import java.util.List;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyUndoManager
extends UndoManager {
    public List<String> getUndoPresentations() {
        ArrayList<String> presentationNames = new ArrayList<String>();
        for (UndoableEdit edit : this.edits) {
            if (!edit.canUndo()) continue;
            presentationNames.add(edit.getPresentationName());
        }
        return presentationNames;
    }

    public void undoTo(int index) {
        int numberOfEdits = this.edits.size();
        int undoIndex = 0;
        for (int i = numberOfEdits - 1; i >= 0; --i) {
            UndoableEdit edit = (UndoableEdit)this.edits.get(i);
            if (!edit.canUndo()) continue;
            if (undoIndex == index) {
                this.undoTo(edit);
                break;
            }
            ++undoIndex;
        }
    }

    public List<String> getRedoPresentations() {
        ArrayList<String> presentationNames = new ArrayList<String>();
        for (UndoableEdit edit : this.edits) {
            if (!edit.canRedo()) continue;
            presentationNames.add(edit.getPresentationName());
        }
        return presentationNames;
    }

    public void redoTo(int index) {
        int numberOfEdits = this.edits.size();
        int redoIndex = 0;
        for (int i = 0; i < numberOfEdits; ++i) {
            UndoableEdit edit = (UndoableEdit)this.edits.get(i);
            if (!edit.canRedo()) continue;
            if (redoIndex == index) {
                this.redoTo(edit);
                break;
            }
            ++redoIndex;
        }
    }
}

