/*
 * Decompiled with CFR 0.152.
 */
package pauker.program.gui.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;

public class LineLabeler
extends JPanel
implements DocumentListener {
    private static final int MARGIN = 5;
    private JTextComponent textComponent;
    private FontMetrics fontMetrics;
    private int labelWidth;
    private String frontSideString;
    private String reverseSideString;

    public LineLabeler(JTextComponent textComponent, String frontSideString, String reverseSideString) {
        this.textComponent = textComponent;
        this.frontSideString = frontSideString;
        this.reverseSideString = reverseSideString;
        textComponent.getDocument().addDocumentListener(this);
        this.setFont(textComponent.getFont());
        this.setBackground(new Color(230, 163, 4));
        this.fontMetrics = this.getFontMetrics(this.getFont());
        this.labelWidth = this.fontMetrics.stringWidth(frontSideString);
        this.labelWidth = 10 + Math.max(this.labelWidth, this.fontMetrics.stringWidth(reverseSideString));
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Document document = this.textComponent.getDocument();
        Element rootElement = document.getDefaultRootElement();
        String label = null;
        try {
            int numberOfLines = rootElement.getElementCount();
            for (int i = 0; i < numberOfLines; ++i) {
                label = i % 2 == 0 ? this.frontSideString : this.reverseSideString;
                int width = this.fontMetrics.stringWidth(label);
                int x = (this.labelWidth - width) / 2;
                Element referenceLine = rootElement.getElement(i);
                int startOffset = referenceLine.getStartOffset();
                Rectangle rectangle = this.textComponent.modelToView(startOffset);
                int y = 0;
                if (rectangle != null) {
                    y = rectangle.y + this.fontMetrics.getAscent();
                }
                g.drawString(label, x, y);
                if (i % 2 == 0) continue;
                int yOffset = rectangle.y + rectangle.height;
                g.drawLine(0, yOffset, this.labelWidth, yOffset);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.labelWidth, this.textComponent.getHeight());
    }

    public void insertUpdate(DocumentEvent e) {
        this.repaint();
    }

    public void removeUpdate(DocumentEvent e) {
        this.repaint();
    }

    public void changedUpdate(DocumentEvent e) {
        this.repaint();
    }
}

