/*
 * Decompiled with CFR 0.152.
 */
package pauker.program.gui.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import pauker.program.Batch;
import pauker.program.Lesson;
import pauker.program.LongTermBatch;
import pauker.program.gui.swing.PaukerFrame;

public class GraphicalStatisticPanel
extends JPanel {
    private static final int barWidth = 30;
    private static final int topInset = 10;
    private static final int bottomInset = 10;
    private String summaryString;
    private String notLearnedString;
    private String ustmString;
    private String stmString;
    private String batchString;
    private final Color[] colors = new Color[4];
    private final int[] heights = new int[4];
    private BasicStroke bigStroke;
    private GridBagConstraints normalConstraints;
    private GridBagConstraints lastConstraints;
    private Font labelFont = new Font("Dialog", 0, 10);
    private GridBagLayout layout;
    private int height = 0;
    private int croppedHeight = 0;
    private Lesson lesson;
    private ResourceBundle strings;
    private int lastNumberOfLongTermBatches = 0;
    private JLabel[] longTermLabels;
    private BatchType selectedBatchType;
    private BatchType highlightedBatchType;
    private int selectedLongTermBatchNumber;
    private int highlightedLongTermBatchNumber;
    private PaukerFrame paukerFrame;
    private boolean mouseSensitive;
    private JLabel descriptionLabel;
    private JPanel longTermBatchesPanel;
    private JLabel notLearnedLabel;
    private JLabel stmLabel;
    private JLabel summaryLabel;
    private JLabel ustmLabel;

    public GraphicalStatisticPanel() {
        this.initComponents();
        this.layout = (GridBagLayout)this.longTermBatchesPanel.getLayout();
        this.normalConstraints = new GridBagConstraints();
        this.normalConstraints.anchor = 15;
        this.normalConstraints.insets = new Insets(0, 15, 0, 0);
        this.normalConstraints.weighty = 1.0;
        this.lastConstraints = new GridBagConstraints();
        this.lastConstraints.anchor = 16;
        this.lastConstraints.insets = new Insets(0, 15, 0, 15);
        this.lastConstraints.weightx = 1.0;
        this.lastConstraints.weighty = 1.0;
        this.longTermLabels = new JLabel[0];
        this.strings = ResourceBundle.getBundle("pauker/Strings");
        this.summaryString = this.strings.getString("SummaryLabel");
        this.notLearnedString = this.strings.getString("NotLearnedLabel");
        this.ustmString = this.strings.getString("USTM_Label");
        this.stmString = this.strings.getString("STM_Label");
        this.batchString = this.strings.getString("BatchLabel");
        this.bigStroke = new BasicStroke(2.0f, 1, 1);
        this.setLesson(new Lesson());
        this.mouseSensitive = true;
    }

    public void setPaukerFrame(PaukerFrame paukerFrame) {
        this.paukerFrame = paukerFrame;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int maxCards = this.lesson.getNumberOfCards();
        if (maxCards == 0) {
            return;
        }
        this.height = this.summaryLabel.getLocation().y;
        this.croppedHeight = this.height - 10 - 10;
        Graphics2D graphics = (Graphics2D)g;
        int numberOfUnlearnedCards = this.lesson.getUnlearnedBatch().getNumberOfCards();
        int numberOfUstmCards = this.lesson.getUltraShortTermList().size();
        int numberOfStmCards = this.lesson.getShortTermList().size();
        int numberOfAllStmCards = numberOfUstmCards + numberOfStmCards;
        int numberOfExpiredCards = this.lesson.getNumberOfExpiredCards();
        int numberOfLearnedCards = maxCards - numberOfUnlearnedCards - numberOfAllStmCards - numberOfExpiredCards;
        int numberOfBars = 0;
        int heightSum = 0;
        if (numberOfUnlearnedCards != 0) {
            this.colors[0] = PaukerFrame.red;
            this.heights[0] = this.croppedHeight * numberOfUnlearnedCards / maxCards;
            heightSum = this.heights[0];
            ++numberOfBars;
        }
        if (numberOfAllStmCards != 0) {
            this.colors[numberOfBars] = PaukerFrame.yellow;
            this.heights[numberOfBars] = this.croppedHeight * numberOfAllStmCards / maxCards;
            heightSum += this.heights[numberOfBars];
            ++numberOfBars;
        }
        if (numberOfLearnedCards != 0) {
            this.colors[numberOfBars] = PaukerFrame.green;
            this.heights[numberOfBars] = this.croppedHeight * numberOfLearnedCards / maxCards;
            heightSum += this.heights[numberOfBars];
            ++numberOfBars;
        }
        if (numberOfExpiredCards != 0) {
            this.colors[numberOfBars] = PaukerFrame.blue;
            this.heights[numberOfBars] = this.croppedHeight - heightSum;
            ++numberOfBars;
        }
        this.paintBar(graphics, this.summaryLabel, numberOfBars, this.selectedBatchType == BatchType.SUMMARY, this.highlightedBatchType == BatchType.SUMMARY);
        if (numberOfUnlearnedCards > 0) {
            this.colors[0] = PaukerFrame.red;
            this.heights[0] = this.getHeight(maxCards, numberOfUnlearnedCards);
            this.paintBar(graphics, this.notLearnedLabel, 1, this.selectedBatchType == BatchType.UNLEARNED, this.highlightedBatchType == BatchType.UNLEARNED);
        }
        if (numberOfUstmCards > 0) {
            this.colors[0] = PaukerFrame.yellow;
            this.heights[0] = this.getHeight(maxCards, numberOfUstmCards);
            this.paintBar(graphics, this.ustmLabel, 1, this.selectedBatchType == BatchType.ULTRA_SHORT_TERM, this.highlightedBatchType == BatchType.ULTRA_SHORT_TERM);
        }
        if (numberOfStmCards > 0) {
            this.colors[0] = PaukerFrame.yellow;
            this.heights[0] = this.getHeight(maxCards, numberOfStmCards);
            this.paintBar(graphics, this.stmLabel, 1, this.selectedBatchType == BatchType.SHORT_TERM, this.highlightedBatchType == BatchType.SHORT_TERM);
        }
        List<LongTermBatch> longTermBatches = this.lesson.getLongTermBatches();
        int size = longTermBatches.size();
        for (int i = 0; i < size; ++i) {
            LongTermBatch longTermBatch = longTermBatches.get(i);
            int numberOfCards = longTermBatch.getNumberOfCards();
            if (numberOfCards == 0) continue;
            JLabel label = (JLabel)this.longTermBatchesPanel.getComponent(i);
            numberOfExpiredCards = longTermBatch.getNumberOfExpiredCards();
            numberOfLearnedCards = numberOfCards - numberOfExpiredCards;
            heightSum = 0;
            if (numberOfLearnedCards != 0) {
                this.colors[0] = PaukerFrame.green;
                this.heights[0] = this.getHeight(maxCards, numberOfLearnedCards);
                ++heightSum;
            }
            if (numberOfExpiredCards != 0) {
                this.colors[heightSum] = PaukerFrame.blue;
                this.heights[heightSum] = this.getHeight(maxCards, numberOfExpiredCards);
                ++heightSum;
            }
            this.paintBar(graphics, label, heightSum, this.selectedBatchType == BatchType.LONG_TERM && this.selectedLongTermBatchNumber == i, this.highlightedBatchType == BatchType.LONG_TERM && this.highlightedLongTermBatchNumber == i);
        }
    }

    private int getHeight(int maxCards, int numberOfCards) {
        int result = this.croppedHeight * numberOfCards / maxCards;
        if (result == 0) {
            result = 1;
        }
        return result;
    }

    private void paintBar(Graphics2D graphics, JLabel label, int numberOfBars, boolean selected, boolean highlighted) {
        int barHeight;
        int i;
        Point labelLocation = label.getLocation();
        Dimension labelSize = label.getSize();
        int barLocationX = labelLocation.x + (labelSize.width - 30) / 2;
        if (label.getParent() == this.longTermBatchesPanel) {
            barLocationX += this.longTermBatchesPanel.getLocation().x;
        }
        int partBottom = this.height - 10;
        for (i = 0; i < numberOfBars; ++i) {
            barHeight = this.heights[i];
            Color color = this.colors[i];
            int barLocationY = partBottom - barHeight;
            graphics.setPaint(color);
            graphics.fillRect(barLocationX, barLocationY, 30, barHeight);
            partBottom = barLocationY;
        }
        partBottom = this.height - 10 - this.heights[0];
        for (i = 1; i < numberOfBars; ++i) {
            barHeight = this.heights[i];
            int bottomHeight = this.heights[i - 1];
            Color color = this.colors[i];
            Color bottomColor = this.colors[i - 1];
            int transitionOffset = 0;
            transitionOffset = i == 1 ? Math.min(bottomHeight, 5) : Math.min(bottomHeight / 2, 5);
            transitionOffset = i == numberOfBars - 1 ? Math.min(barHeight, transitionOffset) : Math.min(barHeight / 2, transitionOffset);
            if (transitionOffset != 0) {
                int top = partBottom - transitionOffset;
                int bottom = partBottom + transitionOffset;
                GradientPaint gradientPaint = new GradientPaint(barLocationX, top, color, barLocationX, bottom, bottomColor);
                graphics.setPaint(gradientPaint);
                graphics.fillRect(barLocationX, top, 30, bottom - top);
            }
            partBottom -= barHeight;
        }
        int barHeight2 = 0;
        for (int i2 = 0; i2 < numberOfBars; ++i2) {
            barHeight2 += this.heights[i2];
        }
        int barLocationY = this.height - 10 - barHeight2;
        if (highlighted) {
            graphics.setPaint(Color.yellow);
            graphics.setStroke(this.bigStroke);
            graphics.drawRect(barLocationX, barLocationY, 30, barHeight2);
        } else if (selected) {
            graphics.setPaint(Color.red);
            graphics.setStroke(this.bigStroke);
            graphics.drawRect(barLocationX, barLocationY, 30, barHeight2);
        } else {
            graphics.setPaint(Color.lightGray);
            graphics.draw3DRect(barLocationX, barLocationY, 30, barHeight2, true);
        }
    }

    public void setLesson(Lesson lesson) {
        JLabel[] newlabels;
        this.lesson = lesson;
        int numberOfCards = lesson.getNumberOfCards();
        int numberOfExpiredCards = lesson.getNumberOfExpiredCards();
        int numberOfUnlearnedCards = lesson.getUnlearnedBatch().getNumberOfCards();
        int ustmCards = lesson.getUltraShortTermList().size();
        int stmCards = lesson.getShortTermList().size();
        int learnedCards = numberOfCards - numberOfUnlearnedCards - ustmCards - stmCards - numberOfExpiredCards;
        String string = MessageFormat.format(this.summaryString, numberOfExpiredCards, learnedCards, numberOfCards);
        PaukerFrame.lazyStringChange(this.summaryLabel, string);
        string = MessageFormat.format(this.notLearnedString, numberOfUnlearnedCards);
        PaukerFrame.lazyStringChange(this.notLearnedLabel, string);
        string = MessageFormat.format(this.ustmString, ustmCards);
        PaukerFrame.lazyStringChange(this.ustmLabel, string);
        string = MessageFormat.format(this.stmString, stmCards);
        PaukerFrame.lazyStringChange(this.stmLabel, string);
        int numberOfLongTermBatches = lesson.getNumberOfLongTermBatches();
        int diff = numberOfLongTermBatches - this.lastNumberOfLongTermBatches;
        if (diff > 0) {
            newlabels = new JLabel[numberOfLongTermBatches];
            System.arraycopy(this.longTermLabels, 0, newlabels, 0, this.longTermLabels.length);
            this.longTermLabels = newlabels;
            if (this.lastNumberOfLongTermBatches > 0) {
                Component lastLabel = this.longTermBatchesPanel.getComponent(this.lastNumberOfLongTermBatches - 1);
                this.layout.setConstraints(lastLabel, this.normalConstraints);
            }
            for (int i = this.lastNumberOfLongTermBatches; i < numberOfLongTermBatches; ++i) {
                JLabel label = new JLabel();
                label.setFont(this.labelFont);
                if (i == numberOfLongTermBatches - 1) {
                    this.longTermBatchesPanel.add((Component)label, this.lastConstraints);
                } else {
                    this.longTermBatchesPanel.add((Component)label, this.normalConstraints);
                }
                this.longTermLabels[i] = label;
            }
            this.longTermBatchesPanel.validate();
        } else if (diff < 0) {
            newlabels = new JLabel[numberOfLongTermBatches];
            System.arraycopy(this.longTermLabels, 0, newlabels, 0, numberOfLongTermBatches);
            this.longTermLabels = newlabels;
            for (int i = this.lastNumberOfLongTermBatches - 1; i >= numberOfLongTermBatches; --i) {
                this.longTermBatchesPanel.remove(i);
            }
            if (numberOfLongTermBatches > 0) {
                Component lastLabel = this.longTermBatchesPanel.getComponent(numberOfLongTermBatches - 1);
                this.layout.setConstraints(lastLabel, this.lastConstraints);
            }
            this.longTermBatchesPanel.validate();
        }
        this.lastNumberOfLongTermBatches = numberOfLongTermBatches;
        for (int i = 0; i < numberOfLongTermBatches; ++i) {
            JLabel label = (JLabel)this.longTermBatchesPanel.getComponent(i);
            label.setName("longTermBatchLabel" + i);
            LongTermBatch longTermBatch = lesson.getLongTermBatch(i);
            numberOfCards = longTermBatch.getNumberOfCards();
            numberOfExpiredCards = longTermBatch.getNumberOfExpiredCards();
            string = MessageFormat.format(this.batchString, i + 1, numberOfExpiredCards, numberOfCards - numberOfExpiredCards, numberOfCards);
            PaukerFrame.lazyStringChange(label, string);
        }
        this.repaint();
    }

    public void clearSelection() {
        this.selectedBatchType = BatchType.NONE;
        this.repaint();
    }

    public void selectSummary() {
        this.selectedBatchType = BatchType.SUMMARY;
        this.repaint();
    }

    public void selectUnlearnedBatch() {
        this.selectedBatchType = BatchType.UNLEARNED;
        this.repaint();
    }

    public void selectUltraShortTermBatch() {
        this.selectedBatchType = BatchType.ULTRA_SHORT_TERM;
        this.repaint();
    }

    public void selectShortTermBatch() {
        this.selectedBatchType = BatchType.SHORT_TERM;
        this.repaint();
    }

    public void selectLongTermBatch(int selectedLongTermBatchNumber) {
        this.selectedBatchType = BatchType.LONG_TERM;
        this.selectedLongTermBatchNumber = selectedLongTermBatchNumber;
        this.repaint();
    }

    public void setMouseSensitive(boolean mouseSensitive) {
        this.mouseSensitive = mouseSensitive;
    }

    private void initComponents() {
        this.descriptionLabel = new JLabel();
        this.summaryLabel = new JLabel();
        this.notLearnedLabel = new JLabel();
        this.ustmLabel = new JLabel();
        this.stmLabel = new JLabel();
        this.longTermBatchesPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setDebugGraphicsOptions(-1);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent evt) {
                GraphicalStatisticPanel.this.formMouseMoved(evt);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                GraphicalStatisticPanel.this.formMouseClicked(evt);
            }

            public void mouseExited(MouseEvent evt) {
                GraphicalStatisticPanel.this.formMouseExited(evt);
            }
        });
        this.descriptionLabel.setFont(new Font("Dialog", 0, 10));
        ResourceBundle bundle = ResourceBundle.getBundle("pauker/Strings");
        this.descriptionLabel.setText(bundle.getString("Description_Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(50, 5, 0, 0);
        this.add((Component)this.descriptionLabel, gridBagConstraints);
        this.summaryLabel.setFont(new Font("Dialog", 0, 10));
        this.summaryLabel.setText(bundle.getString("SummaryLabel"));
        this.summaryLabel.setName("summaryLabel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(50, 15, 0, 0);
        this.add((Component)this.summaryLabel, gridBagConstraints);
        this.notLearnedLabel.setFont(new Font("Dialog", 0, 10));
        this.notLearnedLabel.setText(bundle.getString("NotLearnedLabel"));
        this.notLearnedLabel.setName("notLearnedLabel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(50, 15, 0, 0);
        this.add((Component)this.notLearnedLabel, gridBagConstraints);
        this.ustmLabel.setFont(new Font("Dialog", 0, 10));
        this.ustmLabel.setText(bundle.getString("USTM_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(50, 15, 0, 0);
        this.add((Component)this.ustmLabel, gridBagConstraints);
        this.stmLabel.setFont(new Font("Dialog", 0, 10));
        this.stmLabel.setText(bundle.getString("STM_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(50, 15, 0, 0);
        this.add((Component)this.stmLabel, gridBagConstraints);
        this.longTermBatchesPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(50, 0, 0, 0);
        this.add((Component)this.longTermBatchesPanel, gridBagConstraints);
    }

    private void formMouseClicked(MouseEvent evt) {
        if (!this.mouseSensitive) {
            return;
        }
        Point clickedPoint = evt.getPoint();
        Batch selectedBatch = null;
        if (this.pointIsOverLabel(clickedPoint, this.summaryLabel)) {
            if (this.lesson.getNumberOfCards() == 0) {
                return;
            }
            this.selectedBatchType = BatchType.SUMMARY;
            selectedBatch = this.lesson.getSummaryBatch();
        } else if (this.pointIsOverLabel(clickedPoint, this.notLearnedLabel)) {
            if (this.lesson.getUnlearnedBatch().getNumberOfCards() == 0) {
                return;
            }
            this.selectedBatchType = BatchType.UNLEARNED;
            selectedBatch = this.lesson.getUnlearnedBatch();
        } else {
            int length = this.longTermLabels.length;
            for (int i = 0; i < length; ++i) {
                JLabel longTermLabel = this.longTermLabels[i];
                if (!this.pointIsOverLabel(clickedPoint, longTermLabel)) continue;
                if (this.lesson.getLongTermBatch(i).getNumberOfCards() == 0) {
                    return;
                }
                this.selectedBatchType = BatchType.LONG_TERM;
                this.selectedLongTermBatchNumber = i;
                selectedBatch = this.lesson.getLongTermBatch(i);
                break;
            }
        }
        if (selectedBatch != null && selectedBatch.getNumberOfCards() > 0) {
            this.paukerFrame.loadBatch(selectedBatch);
            this.repaint();
        }
    }

    private void formMouseExited(MouseEvent evt) {
        if (!this.mouseSensitive) {
            return;
        }
        this.highlightedBatchType = BatchType.NONE;
        this.repaint();
    }

    private void formMouseMoved(MouseEvent evt) {
        if (!this.mouseSensitive) {
            return;
        }
        Point clickedPoint = evt.getPoint();
        BatchType oldHighlightedBatchType = this.highlightedBatchType;
        int oldHighlightedLongTermBatchNumber = this.highlightedLongTermBatchNumber;
        this.highlightedBatchType = BatchType.NONE;
        if (this.pointIsOverLabel(clickedPoint, this.summaryLabel)) {
            if (this.lesson.getNumberOfCards() == 0) {
                return;
            }
            this.highlightedBatchType = BatchType.SUMMARY;
        } else if (this.pointIsOverLabel(clickedPoint, this.notLearnedLabel)) {
            if (this.lesson.getUnlearnedBatch().getNumberOfCards() == 0) {
                return;
            }
            this.highlightedBatchType = BatchType.UNLEARNED;
        } else {
            int length = this.longTermLabels.length;
            for (int i = 0; i < length; ++i) {
                JLabel longTermLabel = this.longTermLabels[i];
                if (!this.pointIsOverLabel(clickedPoint, longTermLabel)) continue;
                if (this.lesson.getLongTermBatch(i).getNumberOfCards() == 0) {
                    return;
                }
                this.highlightedBatchType = BatchType.LONG_TERM;
                this.highlightedLongTermBatchNumber = i;
                break;
            }
        }
        if (oldHighlightedBatchType != this.highlightedBatchType || this.highlightedBatchType == BatchType.LONG_TERM && oldHighlightedLongTermBatchNumber != this.highlightedLongTermBatchNumber) {
            this.repaint();
        }
    }

    private boolean pointIsOverLabel(Point point, JLabel label) {
        Point labelLocation = label.getLocation();
        if (label.getParent() == this.longTermBatchesPanel) {
            labelLocation.x += this.longTermBatchesPanel.getLocation().x;
        }
        return point.x > labelLocation.x && point.x < labelLocation.x + label.getSize().width;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BatchType {
        NONE,
        SUMMARY,
        UNLEARNED,
        ULTRA_SHORT_TERM,
        SHORT_TERM,
        LONG_TERM;

    }
}

